/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.resourcegroups;

import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.awscore.client.handler.AwsSyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.awscore.internal.protocol.json.AwsJsonProtocol;
import software.amazon.awssdk.awscore.protocol.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.awscore.protocol.json.AwsJsonProtocolMetadata;
import software.amazon.awssdk.core.ApiName;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.client.handler.SyncClientHandler;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.http.JsonResponseHandler;
import software.amazon.awssdk.core.internal.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.protocol.json.JsonClientMetadata;
import software.amazon.awssdk.core.protocol.json.JsonErrorResponseMetadata;
import software.amazon.awssdk.core.protocol.json.JsonErrorShapeMetadata;
import software.amazon.awssdk.core.protocol.json.JsonOperationMetadata;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.resourcegroups.ResourceGroupsClient;
import software.amazon.awssdk.services.resourcegroups.model.BadRequestException;
import software.amazon.awssdk.services.resourcegroups.model.CreateGroupRequest;
import software.amazon.awssdk.services.resourcegroups.model.CreateGroupResponse;
import software.amazon.awssdk.services.resourcegroups.model.DeleteGroupRequest;
import software.amazon.awssdk.services.resourcegroups.model.DeleteGroupResponse;
import software.amazon.awssdk.services.resourcegroups.model.ForbiddenException;
import software.amazon.awssdk.services.resourcegroups.model.GetGroupQueryRequest;
import software.amazon.awssdk.services.resourcegroups.model.GetGroupQueryResponse;
import software.amazon.awssdk.services.resourcegroups.model.GetGroupRequest;
import software.amazon.awssdk.services.resourcegroups.model.GetGroupResponse;
import software.amazon.awssdk.services.resourcegroups.model.GetTagsRequest;
import software.amazon.awssdk.services.resourcegroups.model.GetTagsResponse;
import software.amazon.awssdk.services.resourcegroups.model.InternalServerErrorException;
import software.amazon.awssdk.services.resourcegroups.model.ListGroupResourcesRequest;
import software.amazon.awssdk.services.resourcegroups.model.ListGroupResourcesResponse;
import software.amazon.awssdk.services.resourcegroups.model.ListGroupsRequest;
import software.amazon.awssdk.services.resourcegroups.model.ListGroupsResponse;
import software.amazon.awssdk.services.resourcegroups.model.MethodNotAllowedException;
import software.amazon.awssdk.services.resourcegroups.model.NotFoundException;
import software.amazon.awssdk.services.resourcegroups.model.ResourceGroupsException;
import software.amazon.awssdk.services.resourcegroups.model.ResourceGroupsRequest;
import software.amazon.awssdk.services.resourcegroups.model.SearchResourcesRequest;
import software.amazon.awssdk.services.resourcegroups.model.SearchResourcesResponse;
import software.amazon.awssdk.services.resourcegroups.model.TagRequest;
import software.amazon.awssdk.services.resourcegroups.model.TagResponse;
import software.amazon.awssdk.services.resourcegroups.model.TooManyRequestsException;
import software.amazon.awssdk.services.resourcegroups.model.UnauthorizedException;
import software.amazon.awssdk.services.resourcegroups.model.UntagRequest;
import software.amazon.awssdk.services.resourcegroups.model.UntagResponse;
import software.amazon.awssdk.services.resourcegroups.model.UpdateGroupQueryRequest;
import software.amazon.awssdk.services.resourcegroups.model.UpdateGroupQueryResponse;
import software.amazon.awssdk.services.resourcegroups.model.UpdateGroupRequest;
import software.amazon.awssdk.services.resourcegroups.model.UpdateGroupResponse;
import software.amazon.awssdk.services.resourcegroups.paginators.ListGroupResourcesIterable;
import software.amazon.awssdk.services.resourcegroups.paginators.ListGroupsIterable;
import software.amazon.awssdk.services.resourcegroups.paginators.SearchResourcesIterable;
import software.amazon.awssdk.services.resourcegroups.transform.CreateGroupRequestMarshaller;
import software.amazon.awssdk.services.resourcegroups.transform.CreateGroupResponseUnmarshaller;
import software.amazon.awssdk.services.resourcegroups.transform.DeleteGroupRequestMarshaller;
import software.amazon.awssdk.services.resourcegroups.transform.DeleteGroupResponseUnmarshaller;
import software.amazon.awssdk.services.resourcegroups.transform.GetGroupQueryRequestMarshaller;
import software.amazon.awssdk.services.resourcegroups.transform.GetGroupQueryResponseUnmarshaller;
import software.amazon.awssdk.services.resourcegroups.transform.GetGroupRequestMarshaller;
import software.amazon.awssdk.services.resourcegroups.transform.GetGroupResponseUnmarshaller;
import software.amazon.awssdk.services.resourcegroups.transform.GetTagsRequestMarshaller;
import software.amazon.awssdk.services.resourcegroups.transform.GetTagsResponseUnmarshaller;
import software.amazon.awssdk.services.resourcegroups.transform.ListGroupResourcesRequestMarshaller;
import software.amazon.awssdk.services.resourcegroups.transform.ListGroupResourcesResponseUnmarshaller;
import software.amazon.awssdk.services.resourcegroups.transform.ListGroupsRequestMarshaller;
import software.amazon.awssdk.services.resourcegroups.transform.ListGroupsResponseUnmarshaller;
import software.amazon.awssdk.services.resourcegroups.transform.SearchResourcesRequestMarshaller;
import software.amazon.awssdk.services.resourcegroups.transform.SearchResourcesResponseUnmarshaller;
import software.amazon.awssdk.services.resourcegroups.transform.TagRequestMarshaller;
import software.amazon.awssdk.services.resourcegroups.transform.TagResponseUnmarshaller;
import software.amazon.awssdk.services.resourcegroups.transform.UntagRequestMarshaller;
import software.amazon.awssdk.services.resourcegroups.transform.UntagResponseUnmarshaller;
import software.amazon.awssdk.services.resourcegroups.transform.UpdateGroupQueryRequestMarshaller;
import software.amazon.awssdk.services.resourcegroups.transform.UpdateGroupQueryResponseUnmarshaller;
import software.amazon.awssdk.services.resourcegroups.transform.UpdateGroupRequestMarshaller;
import software.amazon.awssdk.services.resourcegroups.transform.UpdateGroupResponseUnmarshaller;

@SdkInternalApi
final class DefaultResourceGroupsClient
implements ResourceGroupsClient {
    private final SyncClientHandler clientHandler;
    private final AwsJsonProtocolFactory protocolFactory;
    private final SdkClientConfiguration clientConfiguration;

    protected DefaultResourceGroupsClient(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsSyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration;
        this.protocolFactory = this.init(false);
    }

    public final String serviceName() {
        return "resource-groups";
    }

    @Override
    public CreateGroupResponse createGroup(CreateGroupRequest createGroupRequest) throws BadRequestException, ForbiddenException, MethodNotAllowedException, TooManyRequestsException, InternalServerErrorException, AwsServiceException, SdkClientException, ResourceGroupsException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new CreateGroupResponseUnmarshaller());
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory);
        return (CreateGroupResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createGroupRequest).withMarshaller((Marshaller)new CreateGroupRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public DeleteGroupResponse deleteGroup(DeleteGroupRequest deleteGroupRequest) throws BadRequestException, ForbiddenException, NotFoundException, MethodNotAllowedException, TooManyRequestsException, InternalServerErrorException, AwsServiceException, SdkClientException, ResourceGroupsException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DeleteGroupResponseUnmarshaller());
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory);
        return (DeleteGroupResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteGroupRequest).withMarshaller((Marshaller)new DeleteGroupRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public GetGroupResponse getGroup(GetGroupRequest getGroupRequest) throws BadRequestException, ForbiddenException, NotFoundException, MethodNotAllowedException, TooManyRequestsException, InternalServerErrorException, AwsServiceException, SdkClientException, ResourceGroupsException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetGroupResponseUnmarshaller());
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory);
        return (GetGroupResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getGroupRequest).withMarshaller((Marshaller)new GetGroupRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public GetGroupQueryResponse getGroupQuery(GetGroupQueryRequest getGroupQueryRequest) throws BadRequestException, ForbiddenException, NotFoundException, MethodNotAllowedException, TooManyRequestsException, InternalServerErrorException, AwsServiceException, SdkClientException, ResourceGroupsException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetGroupQueryResponseUnmarshaller());
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory);
        return (GetGroupQueryResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getGroupQueryRequest).withMarshaller((Marshaller)new GetGroupQueryRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public GetTagsResponse getTags(GetTagsRequest getTagsRequest) throws BadRequestException, ForbiddenException, NotFoundException, MethodNotAllowedException, TooManyRequestsException, InternalServerErrorException, AwsServiceException, SdkClientException, ResourceGroupsException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetTagsResponseUnmarshaller());
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory);
        return (GetTagsResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getTagsRequest).withMarshaller((Marshaller)new GetTagsRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public ListGroupResourcesResponse listGroupResources(ListGroupResourcesRequest listGroupResourcesRequest) throws UnauthorizedException, BadRequestException, ForbiddenException, NotFoundException, MethodNotAllowedException, TooManyRequestsException, InternalServerErrorException, AwsServiceException, SdkClientException, ResourceGroupsException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListGroupResourcesResponseUnmarshaller());
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory);
        return (ListGroupResourcesResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listGroupResourcesRequest).withMarshaller((Marshaller)new ListGroupResourcesRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public ListGroupResourcesIterable listGroupResourcesPaginator(ListGroupResourcesRequest listGroupResourcesRequest) throws UnauthorizedException, BadRequestException, ForbiddenException, NotFoundException, MethodNotAllowedException, TooManyRequestsException, InternalServerErrorException, AwsServiceException, SdkClientException, ResourceGroupsException {
        return new ListGroupResourcesIterable(this, this.applyPaginatorUserAgent(listGroupResourcesRequest));
    }

    @Override
    public ListGroupsResponse listGroups(ListGroupsRequest listGroupsRequest) throws BadRequestException, ForbiddenException, MethodNotAllowedException, TooManyRequestsException, InternalServerErrorException, AwsServiceException, SdkClientException, ResourceGroupsException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListGroupsResponseUnmarshaller());
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory);
        return (ListGroupsResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listGroupsRequest).withMarshaller((Marshaller)new ListGroupsRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public ListGroupsIterable listGroupsPaginator(ListGroupsRequest listGroupsRequest) throws BadRequestException, ForbiddenException, MethodNotAllowedException, TooManyRequestsException, InternalServerErrorException, AwsServiceException, SdkClientException, ResourceGroupsException {
        return new ListGroupsIterable(this, this.applyPaginatorUserAgent(listGroupsRequest));
    }

    @Override
    public SearchResourcesResponse searchResources(SearchResourcesRequest searchResourcesRequest) throws UnauthorizedException, BadRequestException, ForbiddenException, MethodNotAllowedException, TooManyRequestsException, InternalServerErrorException, AwsServiceException, SdkClientException, ResourceGroupsException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new SearchResourcesResponseUnmarshaller());
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory);
        return (SearchResourcesResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)searchResourcesRequest).withMarshaller((Marshaller)new SearchResourcesRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public SearchResourcesIterable searchResourcesPaginator(SearchResourcesRequest searchResourcesRequest) throws UnauthorizedException, BadRequestException, ForbiddenException, MethodNotAllowedException, TooManyRequestsException, InternalServerErrorException, AwsServiceException, SdkClientException, ResourceGroupsException {
        return new SearchResourcesIterable(this, this.applyPaginatorUserAgent(searchResourcesRequest));
    }

    @Override
    public TagResponse tag(TagRequest tagRequest) throws BadRequestException, ForbiddenException, NotFoundException, MethodNotAllowedException, TooManyRequestsException, InternalServerErrorException, AwsServiceException, SdkClientException, ResourceGroupsException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new TagResponseUnmarshaller());
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory);
        return (TagResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)tagRequest).withMarshaller((Marshaller)new TagRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public UntagResponse untag(UntagRequest untagRequest) throws BadRequestException, ForbiddenException, NotFoundException, MethodNotAllowedException, TooManyRequestsException, InternalServerErrorException, AwsServiceException, SdkClientException, ResourceGroupsException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new UntagResponseUnmarshaller());
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory);
        return (UntagResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)untagRequest).withMarshaller((Marshaller)new UntagRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public UpdateGroupResponse updateGroup(UpdateGroupRequest updateGroupRequest) throws BadRequestException, ForbiddenException, NotFoundException, MethodNotAllowedException, TooManyRequestsException, InternalServerErrorException, AwsServiceException, SdkClientException, ResourceGroupsException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new UpdateGroupResponseUnmarshaller());
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory);
        return (UpdateGroupResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)updateGroupRequest).withMarshaller((Marshaller)new UpdateGroupRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public UpdateGroupQueryResponse updateGroupQuery(UpdateGroupQueryRequest updateGroupQueryRequest) throws BadRequestException, ForbiddenException, NotFoundException, MethodNotAllowedException, TooManyRequestsException, InternalServerErrorException, AwsServiceException, SdkClientException, ResourceGroupsException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new UpdateGroupQueryResponseUnmarshaller());
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory);
        return (UpdateGroupQueryResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)updateGroupQueryRequest).withMarshaller((Marshaller)new UpdateGroupQueryRequestMarshaller(this.protocolFactory)));
    }

    private HttpResponseHandler<AwsServiceException> createErrorResponseHandler(AwsJsonProtocolFactory protocolFactory) {
        return protocolFactory.createErrorResponseHandler(new JsonErrorResponseMetadata());
    }

    private AwsJsonProtocolFactory init(boolean supportsCbor) {
        return new AwsJsonProtocolFactory(new JsonClientMetadata().withSupportsCbor(supportsCbor).withSupportsIon(false).withBaseServiceExceptionClass(ResourceGroupsException.class).withContentTypeOverride("").addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("NotFoundException").withModeledClass(NotFoundException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("UnauthorizedException").withModeledClass(UnauthorizedException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ForbiddenException").withModeledClass(ForbiddenException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("MethodNotAllowedException").withModeledClass(MethodNotAllowedException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("TooManyRequestsException").withModeledClass(TooManyRequestsException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("BadRequestException").withModeledClass(BadRequestException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InternalServerErrorException").withModeledClass(InternalServerErrorException.class)), AwsJsonProtocolMetadata.builder().protocolVersion("1.1").protocol(AwsJsonProtocol.REST_JSON).build());
    }

    public void close() {
        this.clientHandler.close();
    }

    private <T extends ResourceGroupsRequest> T applyPaginatorUserAgent(T request) {
        Consumer<AwsRequestOverrideConfiguration.Builder> userAgentApplier = b -> {
            AwsRequestOverrideConfiguration.Builder cfr_ignored_0 = (AwsRequestOverrideConfiguration.Builder)b.addApiName(ApiName.builder().version("2.0.0-preview-12").name("PAGINATED").build());
        };
        AwsRequestOverrideConfiguration overrideConfiguration = request.overrideConfiguration().map(c -> ((AwsRequestOverrideConfiguration.Builder)c.toBuilder().applyMutation(userAgentApplier)).build()).orElse(((AwsRequestOverrideConfiguration.Builder)AwsRequestOverrideConfiguration.builder().applyMutation(userAgentApplier)).build());
        return (T)((Object)((ResourceGroupsRequest)request.toBuilder().overrideConfiguration(overrideConfiguration).build()));
    }
}

