/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.resourcegroups.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.resourcegroups.model.ResourceQuery;
import software.amazon.awssdk.services.resourcegroups.transform.GroupQueryMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GroupQuery
implements StructuredPojo,
ToCopyableBuilder<Builder, GroupQuery> {
    private final String groupName;
    private final ResourceQuery resourceQuery;

    private GroupQuery(BuilderImpl builder) {
        this.groupName = builder.groupName;
        this.resourceQuery = builder.resourceQuery;
    }

    public String groupName() {
        return this.groupName;
    }

    public ResourceQuery resourceQuery() {
        return this.resourceQuery;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.groupName());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceQuery());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GroupQuery)) {
            return false;
        }
        GroupQuery other = (GroupQuery)obj;
        return Objects.equals(this.groupName(), other.groupName()) && Objects.equals(this.resourceQuery(), other.resourceQuery());
    }

    public String toString() {
        return ToString.builder((String)"GroupQuery").add("GroupName", (Object)this.groupName()).add("ResourceQuery", (Object)this.resourceQuery()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "GroupName": {
                return Optional.ofNullable(clazz.cast(this.groupName()));
            }
            case "ResourceQuery": {
                return Optional.ofNullable(clazz.cast(this.resourceQuery()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        GroupQueryMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String groupName;
        private ResourceQuery resourceQuery;

        private BuilderImpl() {
        }

        private BuilderImpl(GroupQuery model) {
            this.groupName(model.groupName);
            this.resourceQuery(model.resourceQuery);
        }

        public final String getGroupName() {
            return this.groupName;
        }

        @Override
        public final Builder groupName(String groupName) {
            this.groupName = groupName;
            return this;
        }

        public final void setGroupName(String groupName) {
            this.groupName = groupName;
        }

        public final ResourceQuery.Builder getResourceQuery() {
            return this.resourceQuery != null ? this.resourceQuery.toBuilder() : null;
        }

        @Override
        public final Builder resourceQuery(ResourceQuery resourceQuery) {
            this.resourceQuery = resourceQuery;
            return this;
        }

        public final void setResourceQuery(ResourceQuery.BuilderImpl resourceQuery) {
            this.resourceQuery = resourceQuery != null ? resourceQuery.build() : null;
        }

        public GroupQuery build() {
            return new GroupQuery(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, GroupQuery> {
        public Builder groupName(String var1);

        public Builder resourceQuery(ResourceQuery var1);

        default public Builder resourceQuery(Consumer<ResourceQuery.Builder> resourceQuery) {
            return this.resourceQuery((ResourceQuery)((ResourceQuery.Builder)ResourceQuery.builder().applyMutation(resourceQuery)).build());
        }
    }
}

