/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.resourcegroups.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetGroupQueryResponse extends ResourceGroupsResponse implements
        ToCopyableBuilder<GetGroupQueryResponse.Builder, GetGroupQueryResponse> {
    private static final SdkField<GroupQuery> GROUP_QUERY_FIELD = SdkField.<GroupQuery> builder(MarshallingType.SDK_POJO)
            .getter(getter(GetGroupQueryResponse::groupQuery)).setter(setter(Builder::groupQuery))
            .constructor(GroupQuery::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GroupQuery").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GROUP_QUERY_FIELD));

    private final GroupQuery groupQuery;

    private GetGroupQueryResponse(BuilderImpl builder) {
        super(builder);
        this.groupQuery = builder.groupQuery;
    }

    /**
     * <p>
     * The resource query associated with the specified group.
     * </p>
     * 
     * @return The resource query associated with the specified group.
     */
    public GroupQuery groupQuery() {
        return groupQuery;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(groupQuery());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetGroupQueryResponse)) {
            return false;
        }
        GetGroupQueryResponse other = (GetGroupQueryResponse) obj;
        return Objects.equals(groupQuery(), other.groupQuery());
    }

    @Override
    public String toString() {
        return ToString.builder("GetGroupQueryResponse").add("GroupQuery", groupQuery()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "GroupQuery":
            return Optional.ofNullable(clazz.cast(groupQuery()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetGroupQueryResponse, T> g) {
        return obj -> g.apply((GetGroupQueryResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ResourceGroupsResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetGroupQueryResponse> {
        /**
         * <p>
         * The resource query associated with the specified group.
         * </p>
         * 
         * @param groupQuery
         *        The resource query associated with the specified group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder groupQuery(GroupQuery groupQuery);

        /**
         * <p>
         * The resource query associated with the specified group.
         * </p>
         * This is a convenience that creates an instance of the {@link GroupQuery.Builder} avoiding the need to create
         * one manually via {@link GroupQuery#builder()}.
         *
         * When the {@link Consumer} completes, {@link GroupQuery.Builder#build()} is called immediately and its result
         * is passed to {@link #groupQuery(GroupQuery)}.
         * 
         * @param groupQuery
         *        a consumer that will call methods on {@link GroupQuery.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #groupQuery(GroupQuery)
         */
        default Builder groupQuery(Consumer<GroupQuery.Builder> groupQuery) {
            return groupQuery(GroupQuery.builder().applyMutation(groupQuery).build());
        }
    }

    static final class BuilderImpl extends ResourceGroupsResponse.BuilderImpl implements Builder {
        private GroupQuery groupQuery;

        private BuilderImpl() {
        }

        private BuilderImpl(GetGroupQueryResponse model) {
            super(model);
            groupQuery(model.groupQuery);
        }

        public final GroupQuery.Builder getGroupQuery() {
            return groupQuery != null ? groupQuery.toBuilder() : null;
        }

        @Override
        public final Builder groupQuery(GroupQuery groupQuery) {
            this.groupQuery = groupQuery;
            return this;
        }

        public final void setGroupQuery(GroupQuery.BuilderImpl groupQuery) {
            this.groupQuery = groupQuery != null ? groupQuery.build() : null;
        }

        @Override
        public GetGroupQueryResponse build() {
            return new GetGroupQueryResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
