/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.resourcegroups.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A two-part error structure that can occur in <code>ListGroupResources</code> or <code>SearchResources</code>
 * operations on CloudFormation stack-based queries. The error occurs if the CloudFormation stack on which the query is
 * based either does not exist, or has a status that renders the stack inactive. A <code>QueryError</code> occurrence
 * does not necessarily mean that AWS Resource Groups could not complete the operation, but the resulting group might
 * have no member resources.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class QueryError implements SdkPojo, Serializable, ToCopyableBuilder<QueryError.Builder, QueryError> {
    private static final SdkField<String> ERROR_CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(QueryError::errorCodeAsString)).setter(setter(Builder::errorCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ErrorCode").build()).build();

    private static final SdkField<String> MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(QueryError::message)).setter(setter(Builder::message))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Message").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ERROR_CODE_FIELD,
            MESSAGE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String errorCode;

    private final String message;

    private QueryError(BuilderImpl builder) {
        this.errorCode = builder.errorCode;
        this.message = builder.message;
    }

    /**
     * <p>
     * Possible values are <code>CLOUDFORMATION_STACK_INACTIVE</code> and <code>CLOUDFORMATION_STACK_NOT_EXISTING</code>
     * .
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #errorCode} will
     * return {@link QueryErrorCode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #errorCodeAsString}.
     * </p>
     * 
     * @return Possible values are <code>CLOUDFORMATION_STACK_INACTIVE</code> and
     *         <code>CLOUDFORMATION_STACK_NOT_EXISTING</code>.
     * @see QueryErrorCode
     */
    public QueryErrorCode errorCode() {
        return QueryErrorCode.fromValue(errorCode);
    }

    /**
     * <p>
     * Possible values are <code>CLOUDFORMATION_STACK_INACTIVE</code> and <code>CLOUDFORMATION_STACK_NOT_EXISTING</code>
     * .
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #errorCode} will
     * return {@link QueryErrorCode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #errorCodeAsString}.
     * </p>
     * 
     * @return Possible values are <code>CLOUDFORMATION_STACK_INACTIVE</code> and
     *         <code>CLOUDFORMATION_STACK_NOT_EXISTING</code>.
     * @see QueryErrorCode
     */
    public String errorCodeAsString() {
        return errorCode;
    }

    /**
     * <p>
     * A message that explains the <code>ErrorCode</code> value. Messages might state that the specified CloudFormation
     * stack does not exist (or no longer exists). For <code>CLOUDFORMATION_STACK_INACTIVE</code>, the message typically
     * states that the CloudFormation stack has a status that is not (or no longer) active, such as
     * <code>CREATE_FAILED</code>.
     * </p>
     * 
     * @return A message that explains the <code>ErrorCode</code> value. Messages might state that the specified
     *         CloudFormation stack does not exist (or no longer exists). For <code>CLOUDFORMATION_STACK_INACTIVE</code>
     *         , the message typically states that the CloudFormation stack has a status that is not (or no longer)
     *         active, such as <code>CREATE_FAILED</code>.
     */
    public String message() {
        return message;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(errorCodeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(message());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof QueryError)) {
            return false;
        }
        QueryError other = (QueryError) obj;
        return Objects.equals(errorCodeAsString(), other.errorCodeAsString()) && Objects.equals(message(), other.message());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("QueryError").add("ErrorCode", errorCodeAsString()).add("Message", message()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ErrorCode":
            return Optional.ofNullable(clazz.cast(errorCodeAsString()));
        case "Message":
            return Optional.ofNullable(clazz.cast(message()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<QueryError, T> g) {
        return obj -> g.apply((QueryError) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, QueryError> {
        /**
         * <p>
         * Possible values are <code>CLOUDFORMATION_STACK_INACTIVE</code> and
         * <code>CLOUDFORMATION_STACK_NOT_EXISTING</code>.
         * </p>
         * 
         * @param errorCode
         *        Possible values are <code>CLOUDFORMATION_STACK_INACTIVE</code> and
         *        <code>CLOUDFORMATION_STACK_NOT_EXISTING</code>.
         * @see QueryErrorCode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see QueryErrorCode
         */
        Builder errorCode(String errorCode);

        /**
         * <p>
         * Possible values are <code>CLOUDFORMATION_STACK_INACTIVE</code> and
         * <code>CLOUDFORMATION_STACK_NOT_EXISTING</code>.
         * </p>
         * 
         * @param errorCode
         *        Possible values are <code>CLOUDFORMATION_STACK_INACTIVE</code> and
         *        <code>CLOUDFORMATION_STACK_NOT_EXISTING</code>.
         * @see QueryErrorCode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see QueryErrorCode
         */
        Builder errorCode(QueryErrorCode errorCode);

        /**
         * <p>
         * A message that explains the <code>ErrorCode</code> value. Messages might state that the specified
         * CloudFormation stack does not exist (or no longer exists). For <code>CLOUDFORMATION_STACK_INACTIVE</code>,
         * the message typically states that the CloudFormation stack has a status that is not (or no longer) active,
         * such as <code>CREATE_FAILED</code>.
         * </p>
         * 
         * @param message
         *        A message that explains the <code>ErrorCode</code> value. Messages might state that the specified
         *        CloudFormation stack does not exist (or no longer exists). For
         *        <code>CLOUDFORMATION_STACK_INACTIVE</code>, the message typically states that the CloudFormation stack
         *        has a status that is not (or no longer) active, such as <code>CREATE_FAILED</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder message(String message);
    }

    static final class BuilderImpl implements Builder {
        private String errorCode;

        private String message;

        private BuilderImpl() {
        }

        private BuilderImpl(QueryError model) {
            errorCode(model.errorCode);
            message(model.message);
        }

        public final String getErrorCodeAsString() {
            return errorCode;
        }

        @Override
        public final Builder errorCode(String errorCode) {
            this.errorCode = errorCode;
            return this;
        }

        @Override
        public final Builder errorCode(QueryErrorCode errorCode) {
            this.errorCode(errorCode == null ? null : errorCode.toString());
            return this;
        }

        public final void setErrorCode(String errorCode) {
            this.errorCode = errorCode;
        }

        public final String getMessage() {
            return message;
        }

        @Override
        public final Builder message(String message) {
            this.message = message;
            return this;
        }

        public final void setMessage(String message) {
            this.message = message;
        }

        @Override
        public QueryError build() {
            return new QueryError(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
