/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.resourcegroups.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class SearchResourcesRequest extends ResourceGroupsRequest implements
        ToCopyableBuilder<SearchResourcesRequest.Builder, SearchResourcesRequest> {
    private static final SdkField<ResourceQuery> RESOURCE_QUERY_FIELD = SdkField
            .<ResourceQuery> builder(MarshallingType.SDK_POJO).getter(getter(SearchResourcesRequest::resourceQuery))
            .setter(setter(Builder::resourceQuery)).constructor(ResourceQuery::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceQuery").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(SearchResourcesRequest::maxResults)).setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(SearchResourcesRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESOURCE_QUERY_FIELD,
            MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD));

    private final ResourceQuery resourceQuery;

    private final Integer maxResults;

    private final String nextToken;

    private SearchResourcesRequest(BuilderImpl builder) {
        super(builder);
        this.resourceQuery = builder.resourceQuery;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * The search query, using the same formats that are supported for resource group definition.
     * </p>
     * 
     * @return The search query, using the same formats that are supported for resource group definition.
     */
    public ResourceQuery resourceQuery() {
        return resourceQuery;
    }

    /**
     * <p>
     * The maximum number of group member ARNs returned by <code>SearchResources</code> in paginated output. By default,
     * this number is 50.
     * </p>
     * 
     * @return The maximum number of group member ARNs returned by <code>SearchResources</code> in paginated output. By
     *         default, this number is 50.
     */
    public Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * The NextToken value that is returned in a paginated <code>SearchResources</code> request. To get the next page of
     * results, run the call again, add the NextToken parameter, and specify the NextToken value.
     * </p>
     * 
     * @return The NextToken value that is returned in a paginated <code>SearchResources</code> request. To get the next
     *         page of results, run the call again, add the NextToken parameter, and specify the NextToken value.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(resourceQuery());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SearchResourcesRequest)) {
            return false;
        }
        SearchResourcesRequest other = (SearchResourcesRequest) obj;
        return Objects.equals(resourceQuery(), other.resourceQuery()) && Objects.equals(maxResults(), other.maxResults())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("SearchResourcesRequest").add("ResourceQuery", resourceQuery()).add("MaxResults", maxResults())
                .add("NextToken", nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ResourceQuery":
            return Optional.ofNullable(clazz.cast(resourceQuery()));
        case "MaxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SearchResourcesRequest, T> g) {
        return obj -> g.apply((SearchResourcesRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ResourceGroupsRequest.Builder, SdkPojo, CopyableBuilder<Builder, SearchResourcesRequest> {
        /**
         * <p>
         * The search query, using the same formats that are supported for resource group definition.
         * </p>
         * 
         * @param resourceQuery
         *        The search query, using the same formats that are supported for resource group definition.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceQuery(ResourceQuery resourceQuery);

        /**
         * <p>
         * The search query, using the same formats that are supported for resource group definition.
         * </p>
         * This is a convenience that creates an instance of the {@link ResourceQuery.Builder} avoiding the need to
         * create one manually via {@link ResourceQuery#builder()}.
         *
         * When the {@link Consumer} completes, {@link ResourceQuery.Builder#build()} is called immediately and its
         * result is passed to {@link #resourceQuery(ResourceQuery)}.
         * 
         * @param resourceQuery
         *        a consumer that will call methods on {@link ResourceQuery.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #resourceQuery(ResourceQuery)
         */
        default Builder resourceQuery(Consumer<ResourceQuery.Builder> resourceQuery) {
            return resourceQuery(ResourceQuery.builder().applyMutation(resourceQuery).build());
        }

        /**
         * <p>
         * The maximum number of group member ARNs returned by <code>SearchResources</code> in paginated output. By
         * default, this number is 50.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of group member ARNs returned by <code>SearchResources</code> in paginated output.
         *        By default, this number is 50.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * The NextToken value that is returned in a paginated <code>SearchResources</code> request. To get the next
         * page of results, run the call again, add the NextToken parameter, and specify the NextToken value.
         * </p>
         * 
         * @param nextToken
         *        The NextToken value that is returned in a paginated <code>SearchResources</code> request. To get the
         *        next page of results, run the call again, add the NextToken parameter, and specify the NextToken
         *        value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ResourceGroupsRequest.BuilderImpl implements Builder {
        private ResourceQuery resourceQuery;

        private Integer maxResults;

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(SearchResourcesRequest model) {
            super(model);
            resourceQuery(model.resourceQuery);
            maxResults(model.maxResults);
            nextToken(model.nextToken);
        }

        public final ResourceQuery.Builder getResourceQuery() {
            return resourceQuery != null ? resourceQuery.toBuilder() : null;
        }

        @Override
        public final Builder resourceQuery(ResourceQuery resourceQuery) {
            this.resourceQuery = resourceQuery;
            return this;
        }

        public final void setResourceQuery(ResourceQuery.BuilderImpl resourceQuery) {
            this.resourceQuery = resourceQuery != null ? resourceQuery.build() : null;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public SearchResourcesRequest build() {
            return new SearchResourcesRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
