/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.resourcegroups.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The query that is used to define a resource group or a search for resources.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ResourceQuery implements SdkPojo, Serializable, ToCopyableBuilder<ResourceQuery.Builder, ResourceQuery> {
    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ResourceQuery::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()).build();

    private static final SdkField<String> QUERY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ResourceQuery::query)).setter(setter(Builder::query))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Query").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TYPE_FIELD, QUERY_FIELD));

    private static final long serialVersionUID = 1L;

    private final String type;

    private final String query;

    private ResourceQuery(BuilderImpl builder) {
        this.type = builder.type;
        this.query = builder.query;
    }

    /**
     * <p>
     * The type of the query. The valid values in this release are <code>TAG_FILTERS_1_0</code> and
     * <code>CLOUDFORMATION_STACK_1_0</code>.
     * </p>
     * <p>
     * <i> <code>TAG_FILTERS_1_0:</code> </i> A JSON syntax that lets you specify a collection of simple tag filters for
     * resource types and tags, as supported by the AWS Tagging API <a
     * href="https://docs.aws.amazon.com/resourcegroupstagging/latest/APIReference/API_GetResources.html"
     * >GetResources</a> operation. If you specify more than one tag key, only resources that match all tag keys, and at
     * least one value of each specified tag key, are returned in your query. If you specify more than one value for a
     * tag key, a resource matches the filter if it has a tag key value that matches <i>any</i> of the specified values.
     * </p>
     * <p>
     * For example, consider the following sample query for resources that have two tags, <code>Stage</code> and
     * <code>Version</code>, with two values each. (
     * <code>[{"Key":"Stage","Values":["Test","Deploy"]},{"Key":"Version","Values":["1","2"]}]</code>) The results of
     * this query might include the following.
     * </p>
     * <ul>
     * <li>
     * <p>
     * An EC2 instance that has the following two tags: <code>{"Key":"Stage","Value":"Deploy"}</code>, and
     * <code>{"Key":"Version","Value":"2"}</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * An S3 bucket that has the following two tags: {"Key":"Stage","Value":"Test"}, and {"Key":"Version","Value":"1"}
     * </p>
     * </li>
     * </ul>
     * <p>
     * The query would not return the following results, however. The following EC2 instance does not have all tag keys
     * specified in the filter, so it is rejected. The RDS database has all of the tag keys, but no values that match at
     * least one of the specified tag key values in the filter.
     * </p>
     * <ul>
     * <li>
     * <p>
     * An EC2 instance that has only the following tag: <code>{"Key":"Stage","Value":"Deploy"}</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * An RDS database that has the following two tags: <code>{"Key":"Stage","Value":"Archived"}</code>, and
     * <code>{"Key":"Version","Value":"4"}</code>
     * </p>
     * </li>
     * </ul>
     * <p>
     * <i> <code>CLOUDFORMATION_STACK_1_0:</code> </i> A JSON syntax that lets you specify a CloudFormation stack ARN.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link QueryType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of the query. The valid values in this release are <code>TAG_FILTERS_1_0</code> and
     *         <code>CLOUDFORMATION_STACK_1_0</code>.</p>
     *         <p>
     *         <i> <code>TAG_FILTERS_1_0:</code> </i> A JSON syntax that lets you specify a collection of simple tag
     *         filters for resource types and tags, as supported by the AWS Tagging API <a
     *         href="https://docs.aws.amazon.com/resourcegroupstagging/latest/APIReference/API_GetResources.html"
     *         >GetResources</a> operation. If you specify more than one tag key, only resources that match all tag
     *         keys, and at least one value of each specified tag key, are returned in your query. If you specify more
     *         than one value for a tag key, a resource matches the filter if it has a tag key value that matches
     *         <i>any</i> of the specified values.
     *         </p>
     *         <p>
     *         For example, consider the following sample query for resources that have two tags, <code>Stage</code> and
     *         <code>Version</code>, with two values each. (
     *         <code>[{"Key":"Stage","Values":["Test","Deploy"]},{"Key":"Version","Values":["1","2"]}]</code>) The
     *         results of this query might include the following.
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         An EC2 instance that has the following two tags: <code>{"Key":"Stage","Value":"Deploy"}</code>, and
     *         <code>{"Key":"Version","Value":"2"}</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         An S3 bucket that has the following two tags: {"Key":"Stage","Value":"Test"}, and
     *         {"Key":"Version","Value":"1"}
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         The query would not return the following results, however. The following EC2 instance does not have all
     *         tag keys specified in the filter, so it is rejected. The RDS database has all of the tag keys, but no
     *         values that match at least one of the specified tag key values in the filter.
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         An EC2 instance that has only the following tag: <code>{"Key":"Stage","Value":"Deploy"}</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         An RDS database that has the following two tags: <code>{"Key":"Stage","Value":"Archived"}</code>, and
     *         <code>{"Key":"Version","Value":"4"}</code>
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         <i> <code>CLOUDFORMATION_STACK_1_0:</code> </i> A JSON syntax that lets you specify a CloudFormation
     *         stack ARN.
     * @see QueryType
     */
    public QueryType type() {
        return QueryType.fromValue(type);
    }

    /**
     * <p>
     * The type of the query. The valid values in this release are <code>TAG_FILTERS_1_0</code> and
     * <code>CLOUDFORMATION_STACK_1_0</code>.
     * </p>
     * <p>
     * <i> <code>TAG_FILTERS_1_0:</code> </i> A JSON syntax that lets you specify a collection of simple tag filters for
     * resource types and tags, as supported by the AWS Tagging API <a
     * href="https://docs.aws.amazon.com/resourcegroupstagging/latest/APIReference/API_GetResources.html"
     * >GetResources</a> operation. If you specify more than one tag key, only resources that match all tag keys, and at
     * least one value of each specified tag key, are returned in your query. If you specify more than one value for a
     * tag key, a resource matches the filter if it has a tag key value that matches <i>any</i> of the specified values.
     * </p>
     * <p>
     * For example, consider the following sample query for resources that have two tags, <code>Stage</code> and
     * <code>Version</code>, with two values each. (
     * <code>[{"Key":"Stage","Values":["Test","Deploy"]},{"Key":"Version","Values":["1","2"]}]</code>) The results of
     * this query might include the following.
     * </p>
     * <ul>
     * <li>
     * <p>
     * An EC2 instance that has the following two tags: <code>{"Key":"Stage","Value":"Deploy"}</code>, and
     * <code>{"Key":"Version","Value":"2"}</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * An S3 bucket that has the following two tags: {"Key":"Stage","Value":"Test"}, and {"Key":"Version","Value":"1"}
     * </p>
     * </li>
     * </ul>
     * <p>
     * The query would not return the following results, however. The following EC2 instance does not have all tag keys
     * specified in the filter, so it is rejected. The RDS database has all of the tag keys, but no values that match at
     * least one of the specified tag key values in the filter.
     * </p>
     * <ul>
     * <li>
     * <p>
     * An EC2 instance that has only the following tag: <code>{"Key":"Stage","Value":"Deploy"}</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * An RDS database that has the following two tags: <code>{"Key":"Stage","Value":"Archived"}</code>, and
     * <code>{"Key":"Version","Value":"4"}</code>
     * </p>
     * </li>
     * </ul>
     * <p>
     * <i> <code>CLOUDFORMATION_STACK_1_0:</code> </i> A JSON syntax that lets you specify a CloudFormation stack ARN.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link QueryType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of the query. The valid values in this release are <code>TAG_FILTERS_1_0</code> and
     *         <code>CLOUDFORMATION_STACK_1_0</code>.</p>
     *         <p>
     *         <i> <code>TAG_FILTERS_1_0:</code> </i> A JSON syntax that lets you specify a collection of simple tag
     *         filters for resource types and tags, as supported by the AWS Tagging API <a
     *         href="https://docs.aws.amazon.com/resourcegroupstagging/latest/APIReference/API_GetResources.html"
     *         >GetResources</a> operation. If you specify more than one tag key, only resources that match all tag
     *         keys, and at least one value of each specified tag key, are returned in your query. If you specify more
     *         than one value for a tag key, a resource matches the filter if it has a tag key value that matches
     *         <i>any</i> of the specified values.
     *         </p>
     *         <p>
     *         For example, consider the following sample query for resources that have two tags, <code>Stage</code> and
     *         <code>Version</code>, with two values each. (
     *         <code>[{"Key":"Stage","Values":["Test","Deploy"]},{"Key":"Version","Values":["1","2"]}]</code>) The
     *         results of this query might include the following.
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         An EC2 instance that has the following two tags: <code>{"Key":"Stage","Value":"Deploy"}</code>, and
     *         <code>{"Key":"Version","Value":"2"}</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         An S3 bucket that has the following two tags: {"Key":"Stage","Value":"Test"}, and
     *         {"Key":"Version","Value":"1"}
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         The query would not return the following results, however. The following EC2 instance does not have all
     *         tag keys specified in the filter, so it is rejected. The RDS database has all of the tag keys, but no
     *         values that match at least one of the specified tag key values in the filter.
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         An EC2 instance that has only the following tag: <code>{"Key":"Stage","Value":"Deploy"}</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         An RDS database that has the following two tags: <code>{"Key":"Stage","Value":"Archived"}</code>, and
     *         <code>{"Key":"Version","Value":"4"}</code>
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         <i> <code>CLOUDFORMATION_STACK_1_0:</code> </i> A JSON syntax that lets you specify a CloudFormation
     *         stack ARN.
     * @see QueryType
     */
    public String typeAsString() {
        return type;
    }

    /**
     * <p>
     * The query that defines a group or a search.
     * </p>
     * 
     * @return The query that defines a group or a search.
     */
    public String query() {
        return query;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(query());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ResourceQuery)) {
            return false;
        }
        ResourceQuery other = (ResourceQuery) obj;
        return Objects.equals(typeAsString(), other.typeAsString()) && Objects.equals(query(), other.query());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ResourceQuery").add("Type", typeAsString()).add("Query", query()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        case "Query":
            return Optional.ofNullable(clazz.cast(query()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ResourceQuery, T> g) {
        return obj -> g.apply((ResourceQuery) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ResourceQuery> {
        /**
         * <p>
         * The type of the query. The valid values in this release are <code>TAG_FILTERS_1_0</code> and
         * <code>CLOUDFORMATION_STACK_1_0</code>.
         * </p>
         * <p>
         * <i> <code>TAG_FILTERS_1_0:</code> </i> A JSON syntax that lets you specify a collection of simple tag filters
         * for resource types and tags, as supported by the AWS Tagging API <a
         * href="https://docs.aws.amazon.com/resourcegroupstagging/latest/APIReference/API_GetResources.html"
         * >GetResources</a> operation. If you specify more than one tag key, only resources that match all tag keys,
         * and at least one value of each specified tag key, are returned in your query. If you specify more than one
         * value for a tag key, a resource matches the filter if it has a tag key value that matches <i>any</i> of the
         * specified values.
         * </p>
         * <p>
         * For example, consider the following sample query for resources that have two tags, <code>Stage</code> and
         * <code>Version</code>, with two values each. (
         * <code>[{"Key":"Stage","Values":["Test","Deploy"]},{"Key":"Version","Values":["1","2"]}]</code>) The results
         * of this query might include the following.
         * </p>
         * <ul>
         * <li>
         * <p>
         * An EC2 instance that has the following two tags: <code>{"Key":"Stage","Value":"Deploy"}</code>, and
         * <code>{"Key":"Version","Value":"2"}</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * An S3 bucket that has the following two tags: {"Key":"Stage","Value":"Test"}, and
         * {"Key":"Version","Value":"1"}
         * </p>
         * </li>
         * </ul>
         * <p>
         * The query would not return the following results, however. The following EC2 instance does not have all tag
         * keys specified in the filter, so it is rejected. The RDS database has all of the tag keys, but no values that
         * match at least one of the specified tag key values in the filter.
         * </p>
         * <ul>
         * <li>
         * <p>
         * An EC2 instance that has only the following tag: <code>{"Key":"Stage","Value":"Deploy"}</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * An RDS database that has the following two tags: <code>{"Key":"Stage","Value":"Archived"}</code>, and
         * <code>{"Key":"Version","Value":"4"}</code>
         * </p>
         * </li>
         * </ul>
         * <p>
         * <i> <code>CLOUDFORMATION_STACK_1_0:</code> </i> A JSON syntax that lets you specify a CloudFormation stack
         * ARN.
         * </p>
         * 
         * @param type
         *        The type of the query. The valid values in this release are <code>TAG_FILTERS_1_0</code> and
         *        <code>CLOUDFORMATION_STACK_1_0</code>.</p>
         *        <p>
         *        <i> <code>TAG_FILTERS_1_0:</code> </i> A JSON syntax that lets you specify a collection of simple tag
         *        filters for resource types and tags, as supported by the AWS Tagging API <a
         *        href="https://docs.aws.amazon.com/resourcegroupstagging/latest/APIReference/API_GetResources.html"
         *        >GetResources</a> operation. If you specify more than one tag key, only resources that match all tag
         *        keys, and at least one value of each specified tag key, are returned in your query. If you specify
         *        more than one value for a tag key, a resource matches the filter if it has a tag key value that
         *        matches <i>any</i> of the specified values.
         *        </p>
         *        <p>
         *        For example, consider the following sample query for resources that have two tags, <code>Stage</code>
         *        and <code>Version</code>, with two values each. (
         *        <code>[{"Key":"Stage","Values":["Test","Deploy"]},{"Key":"Version","Values":["1","2"]}]</code>) The
         *        results of this query might include the following.
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        An EC2 instance that has the following two tags: <code>{"Key":"Stage","Value":"Deploy"}</code>, and
         *        <code>{"Key":"Version","Value":"2"}</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        An S3 bucket that has the following two tags: {"Key":"Stage","Value":"Test"}, and
         *        {"Key":"Version","Value":"1"}
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        The query would not return the following results, however. The following EC2 instance does not have
         *        all tag keys specified in the filter, so it is rejected. The RDS database has all of the tag keys, but
         *        no values that match at least one of the specified tag key values in the filter.
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        An EC2 instance that has only the following tag: <code>{"Key":"Stage","Value":"Deploy"}</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        An RDS database that has the following two tags: <code>{"Key":"Stage","Value":"Archived"}</code>, and
         *        <code>{"Key":"Version","Value":"4"}</code>
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        <i> <code>CLOUDFORMATION_STACK_1_0:</code> </i> A JSON syntax that lets you specify a CloudFormation
         *        stack ARN.
         * @see QueryType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see QueryType
         */
        Builder type(String type);

        /**
         * <p>
         * The type of the query. The valid values in this release are <code>TAG_FILTERS_1_0</code> and
         * <code>CLOUDFORMATION_STACK_1_0</code>.
         * </p>
         * <p>
         * <i> <code>TAG_FILTERS_1_0:</code> </i> A JSON syntax that lets you specify a collection of simple tag filters
         * for resource types and tags, as supported by the AWS Tagging API <a
         * href="https://docs.aws.amazon.com/resourcegroupstagging/latest/APIReference/API_GetResources.html"
         * >GetResources</a> operation. If you specify more than one tag key, only resources that match all tag keys,
         * and at least one value of each specified tag key, are returned in your query. If you specify more than one
         * value for a tag key, a resource matches the filter if it has a tag key value that matches <i>any</i> of the
         * specified values.
         * </p>
         * <p>
         * For example, consider the following sample query for resources that have two tags, <code>Stage</code> and
         * <code>Version</code>, with two values each. (
         * <code>[{"Key":"Stage","Values":["Test","Deploy"]},{"Key":"Version","Values":["1","2"]}]</code>) The results
         * of this query might include the following.
         * </p>
         * <ul>
         * <li>
         * <p>
         * An EC2 instance that has the following two tags: <code>{"Key":"Stage","Value":"Deploy"}</code>, and
         * <code>{"Key":"Version","Value":"2"}</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * An S3 bucket that has the following two tags: {"Key":"Stage","Value":"Test"}, and
         * {"Key":"Version","Value":"1"}
         * </p>
         * </li>
         * </ul>
         * <p>
         * The query would not return the following results, however. The following EC2 instance does not have all tag
         * keys specified in the filter, so it is rejected. The RDS database has all of the tag keys, but no values that
         * match at least one of the specified tag key values in the filter.
         * </p>
         * <ul>
         * <li>
         * <p>
         * An EC2 instance that has only the following tag: <code>{"Key":"Stage","Value":"Deploy"}</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * An RDS database that has the following two tags: <code>{"Key":"Stage","Value":"Archived"}</code>, and
         * <code>{"Key":"Version","Value":"4"}</code>
         * </p>
         * </li>
         * </ul>
         * <p>
         * <i> <code>CLOUDFORMATION_STACK_1_0:</code> </i> A JSON syntax that lets you specify a CloudFormation stack
         * ARN.
         * </p>
         * 
         * @param type
         *        The type of the query. The valid values in this release are <code>TAG_FILTERS_1_0</code> and
         *        <code>CLOUDFORMATION_STACK_1_0</code>.</p>
         *        <p>
         *        <i> <code>TAG_FILTERS_1_0:</code> </i> A JSON syntax that lets you specify a collection of simple tag
         *        filters for resource types and tags, as supported by the AWS Tagging API <a
         *        href="https://docs.aws.amazon.com/resourcegroupstagging/latest/APIReference/API_GetResources.html"
         *        >GetResources</a> operation. If you specify more than one tag key, only resources that match all tag
         *        keys, and at least one value of each specified tag key, are returned in your query. If you specify
         *        more than one value for a tag key, a resource matches the filter if it has a tag key value that
         *        matches <i>any</i> of the specified values.
         *        </p>
         *        <p>
         *        For example, consider the following sample query for resources that have two tags, <code>Stage</code>
         *        and <code>Version</code>, with two values each. (
         *        <code>[{"Key":"Stage","Values":["Test","Deploy"]},{"Key":"Version","Values":["1","2"]}]</code>) The
         *        results of this query might include the following.
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        An EC2 instance that has the following two tags: <code>{"Key":"Stage","Value":"Deploy"}</code>, and
         *        <code>{"Key":"Version","Value":"2"}</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        An S3 bucket that has the following two tags: {"Key":"Stage","Value":"Test"}, and
         *        {"Key":"Version","Value":"1"}
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        The query would not return the following results, however. The following EC2 instance does not have
         *        all tag keys specified in the filter, so it is rejected. The RDS database has all of the tag keys, but
         *        no values that match at least one of the specified tag key values in the filter.
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        An EC2 instance that has only the following tag: <code>{"Key":"Stage","Value":"Deploy"}</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        An RDS database that has the following two tags: <code>{"Key":"Stage","Value":"Archived"}</code>, and
         *        <code>{"Key":"Version","Value":"4"}</code>
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        <i> <code>CLOUDFORMATION_STACK_1_0:</code> </i> A JSON syntax that lets you specify a CloudFormation
         *        stack ARN.
         * @see QueryType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see QueryType
         */
        Builder type(QueryType type);

        /**
         * <p>
         * The query that defines a group or a search.
         * </p>
         * 
         * @param query
         *        The query that defines a group or a search.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder query(String query);
    }

    static final class BuilderImpl implements Builder {
        private String type;

        private String query;

        private BuilderImpl() {
        }

        private BuilderImpl(ResourceQuery model) {
            type(model.type);
            query(model.query);
        }

        public final String getType() {
            return type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(QueryType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final void setType(String type) {
            this.type = type;
        }

        public final String getQuery() {
            return query;
        }

        @Override
        public final Builder query(String query) {
            this.query = query;
            return this;
        }

        public final void setQuery(String query) {
            this.query = query;
        }

        @Override
        public ResourceQuery build() {
            return new ResourceQuery(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
