/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.resourcegroups.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A parameter for a group configuration item.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class GroupConfigurationParameter implements SdkPojo, Serializable,
        ToCopyableBuilder<GroupConfigurationParameter.Builder, GroupConfigurationParameter> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(GroupConfigurationParameter::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<List<String>> VALUES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("Values")
            .getter(getter(GroupConfigurationParameter::values))
            .setter(setter(Builder::values))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Values").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, VALUES_FIELD));

    private static final long serialVersionUID = 1L;

    private final String name;

    private final List<String> values;

    private GroupConfigurationParameter(BuilderImpl builder) {
        this.name = builder.name;
        this.values = builder.values;
    }

    /**
     * <p>
     * The name of the group configuration parameter.
     * </p>
     * <p>
     * You can specify the following string values:
     * </p>
     * <ul>
     * <li>
     * <p>
     * For configuration item type <code>AWS::ResourceGroups::Generic</code>:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>allowed-resource-types</code>
     * </p>
     * <p>
     * Specifies the types of resources that you can add to this group by using the <a>GroupResources</a> operation.
     * </p>
     * </li>
     * </ul>
     * </li>
     * <li>
     * <p>
     * For configuration item type <code>AWS::EC2::CapacityReservationPool</code>:
     * </p>
     * <ul>
     * <li>
     * <p>
     * None - This configuration item type doesn't support any parameters.
     * </p>
     * </li>
     * </ul>
     * <p>
     * For more information about EC2 capacity reservation groups, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/capacity-reservations-using.html#create-cr-group"
     * >Working with capacity reservation groups</a> in the <i>EC2 Users Guide</i>.
     * </p>
     * </li>
     * </ul>
     * 
     * @return The name of the group configuration parameter.</p>
     *         <p>
     *         You can specify the following string values:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         For configuration item type <code>AWS::ResourceGroups::Generic</code>:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>allowed-resource-types</code>
     *         </p>
     *         <p>
     *         Specifies the types of resources that you can add to this group by using the <a>GroupResources</a>
     *         operation.
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     *         <li>
     *         <p>
     *         For configuration item type <code>AWS::EC2::CapacityReservationPool</code>:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         None - This configuration item type doesn't support any parameters.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         For more information about EC2 capacity reservation groups, see <a href=
     *         "https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/capacity-reservations-using.html#create-cr-group"
     *         >Working with capacity reservation groups</a> in the <i>EC2 Users Guide</i>.
     *         </p>
     *         </li>
     */
    public String name() {
        return name;
    }

    /**
     * Returns true if the Values property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasValues() {
        return values != null && !(values instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The values of for this parameter.
     * </p>
     * <p>
     * You can specify the following string value:
     * </p>
     * <ul>
     * <li>
     * <p>
     * For item type <code>allowed-resource-types</code>: the only supported parameter value is
     * <code>AWS::EC2::CapacityReservation</code>.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasValues()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The values of for this parameter.</p>
     *         <p>
     *         You can specify the following string value:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         For item type <code>allowed-resource-types</code>: the only supported parameter value is
     *         <code>AWS::EC2::CapacityReservation</code>.
     *         </p>
     *         </li>
     */
    public List<String> values() {
        return values;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(hasValues() ? values() : null);
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GroupConfigurationParameter)) {
            return false;
        }
        GroupConfigurationParameter other = (GroupConfigurationParameter) obj;
        return Objects.equals(name(), other.name()) && hasValues() == other.hasValues()
                && Objects.equals(values(), other.values());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("GroupConfigurationParameter").add("Name", name()).add("Values", hasValues() ? values() : null)
                .build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Values":
            return Optional.ofNullable(clazz.cast(values()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GroupConfigurationParameter, T> g) {
        return obj -> g.apply((GroupConfigurationParameter) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, GroupConfigurationParameter> {
        /**
         * <p>
         * The name of the group configuration parameter.
         * </p>
         * <p>
         * You can specify the following string values:
         * </p>
         * <ul>
         * <li>
         * <p>
         * For configuration item type <code>AWS::ResourceGroups::Generic</code>:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>allowed-resource-types</code>
         * </p>
         * <p>
         * Specifies the types of resources that you can add to this group by using the <a>GroupResources</a> operation.
         * </p>
         * </li>
         * </ul>
         * </li>
         * <li>
         * <p>
         * For configuration item type <code>AWS::EC2::CapacityReservationPool</code>:
         * </p>
         * <ul>
         * <li>
         * <p>
         * None - This configuration item type doesn't support any parameters.
         * </p>
         * </li>
         * </ul>
         * <p>
         * For more information about EC2 capacity reservation groups, see <a
         * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/capacity-reservations-using.html#create-cr-group"
         * >Working with capacity reservation groups</a> in the <i>EC2 Users Guide</i>.
         * </p>
         * </li>
         * </ul>
         * 
         * @param name
         *        The name of the group configuration parameter.</p>
         *        <p>
         *        You can specify the following string values:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        For configuration item type <code>AWS::ResourceGroups::Generic</code>:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>allowed-resource-types</code>
         *        </p>
         *        <p>
         *        Specifies the types of resources that you can add to this group by using the <a>GroupResources</a>
         *        operation.
         *        </p>
         *        </li>
         *        </ul>
         *        </li>
         *        <li>
         *        <p>
         *        For configuration item type <code>AWS::EC2::CapacityReservationPool</code>:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        None - This configuration item type doesn't support any parameters.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        For more information about EC2 capacity reservation groups, see <a href=
         *        "https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/capacity-reservations-using.html#create-cr-group"
         *        >Working with capacity reservation groups</a> in the <i>EC2 Users Guide</i>.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The values of for this parameter.
         * </p>
         * <p>
         * You can specify the following string value:
         * </p>
         * <ul>
         * <li>
         * <p>
         * For item type <code>allowed-resource-types</code>: the only supported parameter value is
         * <code>AWS::EC2::CapacityReservation</code>.
         * </p>
         * </li>
         * </ul>
         * 
         * @param values
         *        The values of for this parameter.</p>
         *        <p>
         *        You can specify the following string value:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        For item type <code>allowed-resource-types</code>: the only supported parameter value is
         *        <code>AWS::EC2::CapacityReservation</code>.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder values(Collection<String> values);

        /**
         * <p>
         * The values of for this parameter.
         * </p>
         * <p>
         * You can specify the following string value:
         * </p>
         * <ul>
         * <li>
         * <p>
         * For item type <code>allowed-resource-types</code>: the only supported parameter value is
         * <code>AWS::EC2::CapacityReservation</code>.
         * </p>
         * </li>
         * </ul>
         * 
         * @param values
         *        The values of for this parameter.</p>
         *        <p>
         *        You can specify the following string value:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        For item type <code>allowed-resource-types</code>: the only supported parameter value is
         *        <code>AWS::EC2::CapacityReservation</code>.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder values(String... values);
    }

    static final class BuilderImpl implements Builder {
        private String name;

        private List<String> values = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GroupConfigurationParameter model) {
            name(model.name);
            values(model.values);
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final Collection<String> getValues() {
            if (values instanceof SdkAutoConstructList) {
                return null;
            }
            return values;
        }

        @Override
        public final Builder values(Collection<String> values) {
            this.values = GroupConfigurationParameterValueListCopier.copy(values);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder values(String... values) {
            values(Arrays.asList(values));
            return this;
        }

        public final void setValues(Collection<String> values) {
            this.values = GroupConfigurationParameterValueListCopier.copy(values);
        }

        @Override
        public GroupConfigurationParameter build() {
            return new GroupConfigurationParameter(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
