/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.resourcegroups.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateGroupRequest extends ResourceGroupsRequest implements
        ToCopyableBuilder<CreateGroupRequest.Builder, CreateGroupRequest> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(CreateGroupRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(CreateGroupRequest::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<ResourceQuery> RESOURCE_QUERY_FIELD = SdkField
            .<ResourceQuery> builder(MarshallingType.SDK_POJO).memberName("ResourceQuery")
            .getter(getter(CreateGroupRequest::resourceQuery)).setter(setter(Builder::resourceQuery))
            .constructor(ResourceQuery::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceQuery").build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("Tags")
            .getter(getter(CreateGroupRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<List<GroupConfigurationItem>> CONFIGURATION_FIELD = SdkField
            .<List<GroupConfigurationItem>> builder(MarshallingType.LIST)
            .memberName("Configuration")
            .getter(getter(CreateGroupRequest::configuration))
            .setter(setter(Builder::configuration))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Configuration").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<GroupConfigurationItem> builder(MarshallingType.SDK_POJO)
                                            .constructor(GroupConfigurationItem::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, DESCRIPTION_FIELD,
            RESOURCE_QUERY_FIELD, TAGS_FIELD, CONFIGURATION_FIELD));

    private final String name;

    private final String description;

    private final ResourceQuery resourceQuery;

    private final Map<String, String> tags;

    private final List<GroupConfigurationItem> configuration;

    private CreateGroupRequest(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.description = builder.description;
        this.resourceQuery = builder.resourceQuery;
        this.tags = builder.tags;
        this.configuration = builder.configuration;
    }

    /**
     * <p>
     * The name of the group, which is the identifier of the group in other operations. You can't change the name of a
     * resource group after you create it. A resource group name can consist of letters, numbers, hyphens, periods, and
     * underscores. The name cannot start with <code>AWS</code> or <code>aws</code>; these are reserved. A resource
     * group name must be unique within each AWS Region in your AWS account.
     * </p>
     * 
     * @return The name of the group, which is the identifier of the group in other operations. You can't change the
     *         name of a resource group after you create it. A resource group name can consist of letters, numbers,
     *         hyphens, periods, and underscores. The name cannot start with <code>AWS</code> or <code>aws</code>; these
     *         are reserved. A resource group name must be unique within each AWS Region in your AWS account.
     */
    public String name() {
        return name;
    }

    /**
     * <p>
     * The description of the resource group. Descriptions can consist of letters, numbers, hyphens, underscores,
     * periods, and spaces.
     * </p>
     * 
     * @return The description of the resource group. Descriptions can consist of letters, numbers, hyphens,
     *         underscores, periods, and spaces.
     */
    public String description() {
        return description;
    }

    /**
     * <p>
     * The resource query that determines which AWS resources are members of this group.
     * </p>
     * <note>
     * <p>
     * You can specify either a <code>ResourceQuery</code> or a <code>Configuration</code>, but not both.
     * </p>
     * </note>
     * 
     * @return The resource query that determines which AWS resources are members of this group.</p> <note>
     *         <p>
     *         You can specify either a <code>ResourceQuery</code> or a <code>Configuration</code>, but not both.
     *         </p>
     */
    public ResourceQuery resourceQuery() {
        return resourceQuery;
    }

    /**
     * Returns true if the Tags property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The tags to add to the group. A tag is key-value pair string.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasTags()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The tags to add to the group. A tag is key-value pair string.
     */
    public Map<String, String> tags() {
        return tags;
    }

    /**
     * Returns true if the Configuration property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasConfiguration() {
        return configuration != null && !(configuration instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A configuration associates the resource group with an AWS service and specifies how the service can interact with
     * the resources in the group. A configuration is an array of <a>GroupConfigurationItem</a> elements.
     * </p>
     * <note>
     * <p>
     * You can specify either a <code>Configuration</code> or a <code>ResourceQuery</code> in a group, but not both.
     * </p>
     * </note>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasConfiguration()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A configuration associates the resource group with an AWS service and specifies how the service can
     *         interact with the resources in the group. A configuration is an array of <a>GroupConfigurationItem</a>
     *         elements.</p> <note>
     *         <p>
     *         You can specify either a <code>Configuration</code> or a <code>ResourceQuery</code> in a group, but not
     *         both.
     *         </p>
     */
    public List<GroupConfigurationItem> configuration() {
        return configuration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(resourceQuery());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasConfiguration() ? configuration() : null);
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateGroupRequest)) {
            return false;
        }
        CreateGroupRequest other = (CreateGroupRequest) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(description(), other.description())
                && Objects.equals(resourceQuery(), other.resourceQuery()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags()) && hasConfiguration() == other.hasConfiguration()
                && Objects.equals(configuration(), other.configuration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("CreateGroupRequest").add("Name", name()).add("Description", description())
                .add("ResourceQuery", resourceQuery()).add("Tags", hasTags() ? tags() : null)
                .add("Configuration", hasConfiguration() ? configuration() : null).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "ResourceQuery":
            return Optional.ofNullable(clazz.cast(resourceQuery()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "Configuration":
            return Optional.ofNullable(clazz.cast(configuration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateGroupRequest, T> g) {
        return obj -> g.apply((CreateGroupRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ResourceGroupsRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateGroupRequest> {
        /**
         * <p>
         * The name of the group, which is the identifier of the group in other operations. You can't change the name of
         * a resource group after you create it. A resource group name can consist of letters, numbers, hyphens,
         * periods, and underscores. The name cannot start with <code>AWS</code> or <code>aws</code>; these are
         * reserved. A resource group name must be unique within each AWS Region in your AWS account.
         * </p>
         * 
         * @param name
         *        The name of the group, which is the identifier of the group in other operations. You can't change the
         *        name of a resource group after you create it. A resource group name can consist of letters, numbers,
         *        hyphens, periods, and underscores. The name cannot start with <code>AWS</code> or <code>aws</code>;
         *        these are reserved. A resource group name must be unique within each AWS Region in your AWS account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The description of the resource group. Descriptions can consist of letters, numbers, hyphens, underscores,
         * periods, and spaces.
         * </p>
         * 
         * @param description
         *        The description of the resource group. Descriptions can consist of letters, numbers, hyphens,
         *        underscores, periods, and spaces.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The resource query that determines which AWS resources are members of this group.
         * </p>
         * <note>
         * <p>
         * You can specify either a <code>ResourceQuery</code> or a <code>Configuration</code>, but not both.
         * </p>
         * </note>
         * 
         * @param resourceQuery
         *        The resource query that determines which AWS resources are members of this group.</p> <note>
         *        <p>
         *        You can specify either a <code>ResourceQuery</code> or a <code>Configuration</code>, but not both.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceQuery(ResourceQuery resourceQuery);

        /**
         * <p>
         * The resource query that determines which AWS resources are members of this group.
         * </p>
         * <note>
         * <p>
         * You can specify either a <code>ResourceQuery</code> or a <code>Configuration</code>, but not both.
         * </p>
         * </note> This is a convenience that creates an instance of the {@link ResourceQuery.Builder} avoiding the need
         * to create one manually via {@link ResourceQuery#builder()}.
         *
         * When the {@link Consumer} completes, {@link ResourceQuery.Builder#build()} is called immediately and its
         * result is passed to {@link #resourceQuery(ResourceQuery)}.
         * 
         * @param resourceQuery
         *        a consumer that will call methods on {@link ResourceQuery.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #resourceQuery(ResourceQuery)
         */
        default Builder resourceQuery(Consumer<ResourceQuery.Builder> resourceQuery) {
            return resourceQuery(ResourceQuery.builder().applyMutation(resourceQuery).build());
        }

        /**
         * <p>
         * The tags to add to the group. A tag is key-value pair string.
         * </p>
         * 
         * @param tags
         *        The tags to add to the group. A tag is key-value pair string.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);

        /**
         * <p>
         * A configuration associates the resource group with an AWS service and specifies how the service can interact
         * with the resources in the group. A configuration is an array of <a>GroupConfigurationItem</a> elements.
         * </p>
         * <note>
         * <p>
         * You can specify either a <code>Configuration</code> or a <code>ResourceQuery</code> in a group, but not both.
         * </p>
         * </note>
         * 
         * @param configuration
         *        A configuration associates the resource group with an AWS service and specifies how the service can
         *        interact with the resources in the group. A configuration is an array of <a>GroupConfigurationItem</a>
         *        elements.</p> <note>
         *        <p>
         *        You can specify either a <code>Configuration</code> or a <code>ResourceQuery</code> in a group, but
         *        not both.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configuration(Collection<GroupConfigurationItem> configuration);

        /**
         * <p>
         * A configuration associates the resource group with an AWS service and specifies how the service can interact
         * with the resources in the group. A configuration is an array of <a>GroupConfigurationItem</a> elements.
         * </p>
         * <note>
         * <p>
         * You can specify either a <code>Configuration</code> or a <code>ResourceQuery</code> in a group, but not both.
         * </p>
         * </note>
         * 
         * @param configuration
         *        A configuration associates the resource group with an AWS service and specifies how the service can
         *        interact with the resources in the group. A configuration is an array of <a>GroupConfigurationItem</a>
         *        elements.</p> <note>
         *        <p>
         *        You can specify either a <code>Configuration</code> or a <code>ResourceQuery</code> in a group, but
         *        not both.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configuration(GroupConfigurationItem... configuration);

        /**
         * <p>
         * A configuration associates the resource group with an AWS service and specifies how the service can interact
         * with the resources in the group. A configuration is an array of <a>GroupConfigurationItem</a> elements.
         * </p>
         * <note>
         * <p>
         * You can specify either a <code>Configuration</code> or a <code>ResourceQuery</code> in a group, but not both.
         * </p>
         * </note> This is a convenience that creates an instance of the {@link List<GroupConfigurationItem>.Builder}
         * avoiding the need to create one manually via {@link List<GroupConfigurationItem>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<GroupConfigurationItem>.Builder#build()} is called
         * immediately and its result is passed to {@link #configuration(List<GroupConfigurationItem>)}.
         * 
         * @param configuration
         *        a consumer that will call methods on {@link List<GroupConfigurationItem>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #configuration(List<GroupConfigurationItem>)
         */
        Builder configuration(Consumer<GroupConfigurationItem.Builder>... configuration);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ResourceGroupsRequest.BuilderImpl implements Builder {
        private String name;

        private String description;

        private ResourceQuery resourceQuery;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private List<GroupConfigurationItem> configuration = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateGroupRequest model) {
            super(model);
            name(model.name);
            description(model.description);
            resourceQuery(model.resourceQuery);
            tags(model.tags);
            configuration(model.configuration);
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getDescription() {
            return description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final ResourceQuery.Builder getResourceQuery() {
            return resourceQuery != null ? resourceQuery.toBuilder() : null;
        }

        @Override
        public final Builder resourceQuery(ResourceQuery resourceQuery) {
            this.resourceQuery = resourceQuery;
            return this;
        }

        public final void setResourceQuery(ResourceQuery.BuilderImpl resourceQuery) {
            this.resourceQuery = resourceQuery != null ? resourceQuery.build() : null;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
        }

        public final Collection<GroupConfigurationItem.Builder> getConfiguration() {
            if (configuration instanceof SdkAutoConstructList) {
                return null;
            }
            return configuration != null ? configuration.stream().map(GroupConfigurationItem::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder configuration(Collection<GroupConfigurationItem> configuration) {
            this.configuration = GroupConfigurationListCopier.copy(configuration);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder configuration(GroupConfigurationItem... configuration) {
            configuration(Arrays.asList(configuration));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder configuration(Consumer<GroupConfigurationItem.Builder>... configuration) {
            configuration(Stream.of(configuration).map(c -> GroupConfigurationItem.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setConfiguration(Collection<GroupConfigurationItem.BuilderImpl> configuration) {
            this.configuration = GroupConfigurationListCopier.copyFromBuilder(configuration);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateGroupRequest build() {
            return new CreateGroupRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
