/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.resourcegroups.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetGroupConfigurationResponse extends ResourceGroupsResponse implements
        ToCopyableBuilder<GetGroupConfigurationResponse.Builder, GetGroupConfigurationResponse> {
    private static final SdkField<GroupConfiguration> GROUP_CONFIGURATION_FIELD = SdkField
            .<GroupConfiguration> builder(MarshallingType.SDK_POJO).memberName("GroupConfiguration")
            .getter(getter(GetGroupConfigurationResponse::groupConfiguration)).setter(setter(Builder::groupConfiguration))
            .constructor(GroupConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GroupConfiguration").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GROUP_CONFIGURATION_FIELD));

    private final GroupConfiguration groupConfiguration;

    private GetGroupConfigurationResponse(BuilderImpl builder) {
        super(builder);
        this.groupConfiguration = builder.groupConfiguration;
    }

    /**
     * <p>
     * The configuration associated with the specified group.
     * </p>
     * 
     * @return The configuration associated with the specified group.
     */
    public final GroupConfiguration groupConfiguration() {
        return groupConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(groupConfiguration());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetGroupConfigurationResponse)) {
            return false;
        }
        GetGroupConfigurationResponse other = (GetGroupConfigurationResponse) obj;
        return Objects.equals(groupConfiguration(), other.groupConfiguration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetGroupConfigurationResponse").add("GroupConfiguration", groupConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "GroupConfiguration":
            return Optional.ofNullable(clazz.cast(groupConfiguration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetGroupConfigurationResponse, T> g) {
        return obj -> g.apply((GetGroupConfigurationResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ResourceGroupsResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, GetGroupConfigurationResponse> {
        /**
         * <p>
         * The configuration associated with the specified group.
         * </p>
         * 
         * @param groupConfiguration
         *        The configuration associated with the specified group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder groupConfiguration(GroupConfiguration groupConfiguration);

        /**
         * <p>
         * The configuration associated with the specified group.
         * </p>
         * This is a convenience that creates an instance of the {@link GroupConfiguration.Builder} avoiding the need to
         * create one manually via {@link GroupConfiguration#builder()}.
         *
         * When the {@link Consumer} completes, {@link GroupConfiguration.Builder#build()} is called immediately and its
         * result is passed to {@link #groupConfiguration(GroupConfiguration)}.
         * 
         * @param groupConfiguration
         *        a consumer that will call methods on {@link GroupConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #groupConfiguration(GroupConfiguration)
         */
        default Builder groupConfiguration(Consumer<GroupConfiguration.Builder> groupConfiguration) {
            return groupConfiguration(GroupConfiguration.builder().applyMutation(groupConfiguration).build());
        }
    }

    static final class BuilderImpl extends ResourceGroupsResponse.BuilderImpl implements Builder {
        private GroupConfiguration groupConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(GetGroupConfigurationResponse model) {
            super(model);
            groupConfiguration(model.groupConfiguration);
        }

        public final GroupConfiguration.Builder getGroupConfiguration() {
            return groupConfiguration != null ? groupConfiguration.toBuilder() : null;
        }

        @Override
        public final Builder groupConfiguration(GroupConfiguration groupConfiguration) {
            this.groupConfiguration = groupConfiguration;
            return this;
        }

        public final void setGroupConfiguration(GroupConfiguration.BuilderImpl groupConfiguration) {
            this.groupConfiguration = groupConfiguration != null ? groupConfiguration.build() : null;
        }

        @Override
        public GetGroupConfigurationResponse build() {
            return new GetGroupConfigurationResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
