/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.resourcegroups.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.resourcegroups.ResourceGroupsClient;
import software.amazon.awssdk.services.resourcegroups.model.ListGroupResourcesItem;
import software.amazon.awssdk.services.resourcegroups.model.ListGroupResourcesRequest;
import software.amazon.awssdk.services.resourcegroups.model.ListGroupResourcesResponse;
import software.amazon.awssdk.services.resourcegroups.model.ResourceIdentifier;

public class ListGroupResourcesIterable
implements SdkIterable<ListGroupResourcesResponse> {
    private final ResourceGroupsClient client;
    private final ListGroupResourcesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListGroupResourcesIterable(ResourceGroupsClient client, ListGroupResourcesRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListGroupResourcesResponseFetcher();
    }

    public Iterator<ListGroupResourcesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<ResourceIdentifier> resourceIdentifiers() {
        Function<ListGroupResourcesResponse, Iterator> getIterator = response -> {
            if (response != null && response.resourceIdentifiers() != null) {
                return response.resourceIdentifiers().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    public final SdkIterable<ListGroupResourcesItem> resources() {
        Function<ListGroupResourcesResponse, Iterator> getIterator = response -> {
            if (response != null && response.resources() != null) {
                return response.resources().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListGroupResourcesResponseFetcher
    implements SyncPageFetcher<ListGroupResourcesResponse> {
        private ListGroupResourcesResponseFetcher() {
        }

        public boolean hasNextPage(ListGroupResourcesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListGroupResourcesResponse nextPage(ListGroupResourcesResponse previousPage) {
            if (previousPage == null) {
                return ListGroupResourcesIterable.this.client.listGroupResources(ListGroupResourcesIterable.this.firstRequest);
            }
            return ListGroupResourcesIterable.this.client.listGroupResources((ListGroupResourcesRequest)((Object)ListGroupResourcesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

