/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.resourcegroups.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListGroupsRequest extends ResourceGroupsRequest implements
        ToCopyableBuilder<ListGroupsRequest.Builder, ListGroupsRequest> {
    private static final SdkField<List<GroupFilter>> FILTERS_FIELD = SdkField
            .<List<GroupFilter>> builder(MarshallingType.LIST)
            .memberName("Filters")
            .getter(getter(ListGroupsRequest::filters))
            .setter(setter(Builder::filters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Filters").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<GroupFilter> builder(MarshallingType.SDK_POJO)
                                            .constructor(GroupFilter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxResults").getter(getter(ListGroupsRequest::maxResults)).setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("maxResults").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListGroupsRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FILTERS_FIELD,
            MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD));

    private final List<GroupFilter> filters;

    private final Integer maxResults;

    private final String nextToken;

    private ListGroupsRequest(BuilderImpl builder) {
        super(builder);
        this.filters = builder.filters;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
    }

    /**
     * Returns true if the Filters property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasFilters() {
        return filters != null && !(filters instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Filters, formatted as <a>GroupFilter</a> objects, that you want to apply to a <code>ListGroups</code> operation.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>resource-type</code> - Filter the results to include only those of the specified resource types. Specify up
     * to five resource types in the format <code>AWS::<i>ServiceCode</i>::<i>ResourceType</i> </code>. For example,
     * <code>AWS::EC2::Instance</code>, or <code>AWS::S3::Bucket</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>configuration-type</code> - Filter the results to include only those groups that have the specified
     * configuration types attached. The current supported values are:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>AWS:EC2::CapacityReservationPool</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>AWS:EC2::HostManagement</code>
     * </p>
     * </li>
     * </ul>
     * </li>
     * </ul>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasFilters()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Filters, formatted as <a>GroupFilter</a> objects, that you want to apply to a <code>ListGroups</code>
     *         operation.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>resource-type</code> - Filter the results to include only those of the specified resource types.
     *         Specify up to five resource types in the format
     *         <code>AWS::<i>ServiceCode</i>::<i>ResourceType</i> </code>. For example, <code>AWS::EC2::Instance</code>,
     *         or <code>AWS::S3::Bucket</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>configuration-type</code> - Filter the results to include only those groups that have the specified
     *         configuration types attached. The current supported values are:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>AWS:EC2::CapacityReservationPool</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>AWS:EC2::HostManagement</code>
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     */
    public final List<GroupFilter> filters() {
        return filters;
    }

    /**
     * <p>
     * The total number of results that you want included on each page of the response. If you do not include this
     * parameter, it defaults to a value that is specific to the operation. If additional items exist beyond the maximum
     * you specify, the <code>NextToken</code> response element is present and has a value (is not null). Include that
     * value as the <code>NextToken</code> request parameter in the next call to the operation to get the next part of
     * the results. Note that the service might return fewer results than the maximum even when there are more results
     * available. You should check <code>NextToken</code> after every operation to ensure that you receive all of the
     * results.
     * </p>
     * 
     * @return The total number of results that you want included on each page of the response. If you do not include
     *         this parameter, it defaults to a value that is specific to the operation. If additional items exist
     *         beyond the maximum you specify, the <code>NextToken</code> response element is present and has a value
     *         (is not null). Include that value as the <code>NextToken</code> request parameter in the next call to the
     *         operation to get the next part of the results. Note that the service might return fewer results than the
     *         maximum even when there are more results available. You should check <code>NextToken</code> after every
     *         operation to ensure that you receive all of the results.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * The parameter for receiving additional results if you receive a <code>NextToken</code> response in a previous
     * request. A <code>NextToken</code> response indicates that more output is available. Set this parameter to the
     * value provided by a previous call's <code>NextToken</code> response to indicate where the output should continue
     * from.
     * </p>
     * 
     * @return The parameter for receiving additional results if you receive a <code>NextToken</code> response in a
     *         previous request. A <code>NextToken</code> response indicates that more output is available. Set this
     *         parameter to the value provided by a previous call's <code>NextToken</code> response to indicate where
     *         the output should continue from.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasFilters() ? filters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListGroupsRequest)) {
            return false;
        }
        ListGroupsRequest other = (ListGroupsRequest) obj;
        return hasFilters() == other.hasFilters() && Objects.equals(filters(), other.filters())
                && Objects.equals(maxResults(), other.maxResults()) && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListGroupsRequest").add("Filters", hasFilters() ? filters() : null)
                .add("MaxResults", maxResults()).add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Filters":
            return Optional.ofNullable(clazz.cast(filters()));
        case "MaxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListGroupsRequest, T> g) {
        return obj -> g.apply((ListGroupsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ResourceGroupsRequest.Builder, SdkPojo, CopyableBuilder<Builder, ListGroupsRequest> {
        /**
         * <p>
         * Filters, formatted as <a>GroupFilter</a> objects, that you want to apply to a <code>ListGroups</code>
         * operation.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>resource-type</code> - Filter the results to include only those of the specified resource types.
         * Specify up to five resource types in the format <code>AWS::<i>ServiceCode</i>::<i>ResourceType</i> </code>.
         * For example, <code>AWS::EC2::Instance</code>, or <code>AWS::S3::Bucket</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>configuration-type</code> - Filter the results to include only those groups that have the specified
         * configuration types attached. The current supported values are:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>AWS:EC2::CapacityReservationPool</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>AWS:EC2::HostManagement</code>
         * </p>
         * </li>
         * </ul>
         * </li>
         * </ul>
         * 
         * @param filters
         *        Filters, formatted as <a>GroupFilter</a> objects, that you want to apply to a <code>ListGroups</code>
         *        operation.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>resource-type</code> - Filter the results to include only those of the specified resource types.
         *        Specify up to five resource types in the format
         *        <code>AWS::<i>ServiceCode</i>::<i>ResourceType</i> </code>. For example,
         *        <code>AWS::EC2::Instance</code>, or <code>AWS::S3::Bucket</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>configuration-type</code> - Filter the results to include only those groups that have the
         *        specified configuration types attached. The current supported values are:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>AWS:EC2::CapacityReservationPool</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>AWS:EC2::HostManagement</code>
         *        </p>
         *        </li>
         *        </ul>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filters(Collection<GroupFilter> filters);

        /**
         * <p>
         * Filters, formatted as <a>GroupFilter</a> objects, that you want to apply to a <code>ListGroups</code>
         * operation.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>resource-type</code> - Filter the results to include only those of the specified resource types.
         * Specify up to five resource types in the format <code>AWS::<i>ServiceCode</i>::<i>ResourceType</i> </code>.
         * For example, <code>AWS::EC2::Instance</code>, or <code>AWS::S3::Bucket</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>configuration-type</code> - Filter the results to include only those groups that have the specified
         * configuration types attached. The current supported values are:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>AWS:EC2::CapacityReservationPool</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>AWS:EC2::HostManagement</code>
         * </p>
         * </li>
         * </ul>
         * </li>
         * </ul>
         * 
         * @param filters
         *        Filters, formatted as <a>GroupFilter</a> objects, that you want to apply to a <code>ListGroups</code>
         *        operation.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>resource-type</code> - Filter the results to include only those of the specified resource types.
         *        Specify up to five resource types in the format
         *        <code>AWS::<i>ServiceCode</i>::<i>ResourceType</i> </code>. For example,
         *        <code>AWS::EC2::Instance</code>, or <code>AWS::S3::Bucket</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>configuration-type</code> - Filter the results to include only those groups that have the
         *        specified configuration types attached. The current supported values are:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>AWS:EC2::CapacityReservationPool</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>AWS:EC2::HostManagement</code>
         *        </p>
         *        </li>
         *        </ul>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filters(GroupFilter... filters);

        /**
         * <p>
         * Filters, formatted as <a>GroupFilter</a> objects, that you want to apply to a <code>ListGroups</code>
         * operation.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>resource-type</code> - Filter the results to include only those of the specified resource types.
         * Specify up to five resource types in the format <code>AWS::<i>ServiceCode</i>::<i>ResourceType</i> </code>.
         * For example, <code>AWS::EC2::Instance</code>, or <code>AWS::S3::Bucket</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>configuration-type</code> - Filter the results to include only those groups that have the specified
         * configuration types attached. The current supported values are:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>AWS:EC2::CapacityReservationPool</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>AWS:EC2::HostManagement</code>
         * </p>
         * </li>
         * </ul>
         * </li>
         * </ul>
         * This is a convenience that creates an instance of the {@link List<GroupFilter>.Builder} avoiding the need to
         * create one manually via {@link List<GroupFilter>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<GroupFilter>.Builder#build()} is called immediately and its
         * result is passed to {@link #filters(List<GroupFilter>)}.
         * 
         * @param filters
         *        a consumer that will call methods on {@link List<GroupFilter>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #filters(List<GroupFilter>)
         */
        Builder filters(Consumer<GroupFilter.Builder>... filters);

        /**
         * <p>
         * The total number of results that you want included on each page of the response. If you do not include this
         * parameter, it defaults to a value that is specific to the operation. If additional items exist beyond the
         * maximum you specify, the <code>NextToken</code> response element is present and has a value (is not null).
         * Include that value as the <code>NextToken</code> request parameter in the next call to the operation to get
         * the next part of the results. Note that the service might return fewer results than the maximum even when
         * there are more results available. You should check <code>NextToken</code> after every operation to ensure
         * that you receive all of the results.
         * </p>
         * 
         * @param maxResults
         *        The total number of results that you want included on each page of the response. If you do not include
         *        this parameter, it defaults to a value that is specific to the operation. If additional items exist
         *        beyond the maximum you specify, the <code>NextToken</code> response element is present and has a value
         *        (is not null). Include that value as the <code>NextToken</code> request parameter in the next call to
         *        the operation to get the next part of the results. Note that the service might return fewer results
         *        than the maximum even when there are more results available. You should check <code>NextToken</code>
         *        after every operation to ensure that you receive all of the results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * The parameter for receiving additional results if you receive a <code>NextToken</code> response in a previous
         * request. A <code>NextToken</code> response indicates that more output is available. Set this parameter to the
         * value provided by a previous call's <code>NextToken</code> response to indicate where the output should
         * continue from.
         * </p>
         * 
         * @param nextToken
         *        The parameter for receiving additional results if you receive a <code>NextToken</code> response in a
         *        previous request. A <code>NextToken</code> response indicates that more output is available. Set this
         *        parameter to the value provided by a previous call's <code>NextToken</code> response to indicate where
         *        the output should continue from.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ResourceGroupsRequest.BuilderImpl implements Builder {
        private List<GroupFilter> filters = DefaultSdkAutoConstructList.getInstance();

        private Integer maxResults;

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListGroupsRequest model) {
            super(model);
            filters(model.filters);
            maxResults(model.maxResults);
            nextToken(model.nextToken);
        }

        public final List<GroupFilter.Builder> getFilters() {
            List<GroupFilter.Builder> result = GroupFilterListCopier.copyToBuilder(this.filters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder filters(Collection<GroupFilter> filters) {
            this.filters = GroupFilterListCopier.copy(filters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(GroupFilter... filters) {
            filters(Arrays.asList(filters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(Consumer<GroupFilter.Builder>... filters) {
            filters(Stream.of(filters).map(c -> GroupFilter.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setFilters(Collection<GroupFilter.BuilderImpl> filters) {
            this.filters = GroupFilterListCopier.copyFromBuilder(filters);
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListGroupsRequest build() {
            return new ListGroupsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
