/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.resourcegroups.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum GroupFilterName {
    RESOURCE_TYPE("resource-type"),
    CONFIGURATION_TYPE("configuration-type"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, GroupFilterName> VALUE_MAP;
    private final String value;

    private GroupFilterName(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static GroupFilterName fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<GroupFilterName> knownValues() {
        EnumSet<GroupFilterName> knownValues = EnumSet.allOf(GroupFilterName.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(GroupFilterName.class, GroupFilterName::toString);
    }
}

