/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.resourcegroups.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GroupResourcesResponse extends ResourceGroupsResponse implements
        ToCopyableBuilder<GroupResourcesResponse.Builder, GroupResourcesResponse> {
    private static final SdkField<List<String>> SUCCEEDED_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("Succeeded")
            .getter(getter(GroupResourcesResponse::succeeded))
            .setter(setter(Builder::succeeded))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Succeeded").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<FailedResource>> FAILED_FIELD = SdkField
            .<List<FailedResource>> builder(MarshallingType.LIST)
            .memberName("Failed")
            .getter(getter(GroupResourcesResponse::failed))
            .setter(setter(Builder::failed))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Failed").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<FailedResource> builder(MarshallingType.SDK_POJO)
                                            .constructor(FailedResource::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<PendingResource>> PENDING_FIELD = SdkField
            .<List<PendingResource>> builder(MarshallingType.LIST)
            .memberName("Pending")
            .getter(getter(GroupResourcesResponse::pending))
            .setter(setter(Builder::pending))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Pending").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<PendingResource> builder(MarshallingType.SDK_POJO)
                                            .constructor(PendingResource::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SUCCEEDED_FIELD, FAILED_FIELD,
            PENDING_FIELD));

    private final List<String> succeeded;

    private final List<FailedResource> failed;

    private final List<PendingResource> pending;

    private GroupResourcesResponse(BuilderImpl builder) {
        super(builder);
        this.succeeded = builder.succeeded;
        this.failed = builder.failed;
        this.pending = builder.pending;
    }

    /**
     * For responses, this returns true if the service returned a value for the Succeeded property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasSucceeded() {
        return succeeded != null && !(succeeded instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of ARNs of resources that were successfully added to the group by this operation.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSucceeded} method.
     * </p>
     * 
     * @return A list of ARNs of resources that were successfully added to the group by this operation.
     */
    public final List<String> succeeded() {
        return succeeded;
    }

    /**
     * For responses, this returns true if the service returned a value for the Failed property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasFailed() {
        return failed != null && !(failed instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of ARNs of any resources that failed to be added to the group by this operation.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasFailed} method.
     * </p>
     * 
     * @return A list of ARNs of any resources that failed to be added to the group by this operation.
     */
    public final List<FailedResource> failed() {
        return failed;
    }

    /**
     * For responses, this returns true if the service returned a value for the Pending property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasPending() {
        return pending != null && !(pending instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of ARNs of any resources that are still in the process of being added to the group by this operation.
     * These pending additions continue asynchronously. You can check the status of pending additions by using the
     * <code> <a>ListGroupResources</a> </code> operation, and checking the <code>Resources</code> array in the response
     * and the <code>Status</code> field of each object in that array.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasPending} method.
     * </p>
     * 
     * @return A list of ARNs of any resources that are still in the process of being added to the group by this
     *         operation. These pending additions continue asynchronously. You can check the status of pending additions
     *         by using the <code> <a>ListGroupResources</a> </code> operation, and checking the <code>Resources</code>
     *         array in the response and the <code>Status</code> field of each object in that array.
     */
    public final List<PendingResource> pending() {
        return pending;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasSucceeded() ? succeeded() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasFailed() ? failed() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasPending() ? pending() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GroupResourcesResponse)) {
            return false;
        }
        GroupResourcesResponse other = (GroupResourcesResponse) obj;
        return hasSucceeded() == other.hasSucceeded() && Objects.equals(succeeded(), other.succeeded())
                && hasFailed() == other.hasFailed() && Objects.equals(failed(), other.failed())
                && hasPending() == other.hasPending() && Objects.equals(pending(), other.pending());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GroupResourcesResponse").add("Succeeded", hasSucceeded() ? succeeded() : null)
                .add("Failed", hasFailed() ? failed() : null).add("Pending", hasPending() ? pending() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Succeeded":
            return Optional.ofNullable(clazz.cast(succeeded()));
        case "Failed":
            return Optional.ofNullable(clazz.cast(failed()));
        case "Pending":
            return Optional.ofNullable(clazz.cast(pending()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GroupResourcesResponse, T> g) {
        return obj -> g.apply((GroupResourcesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ResourceGroupsResponse.Builder, SdkPojo, CopyableBuilder<Builder, GroupResourcesResponse> {
        /**
         * <p>
         * A list of ARNs of resources that were successfully added to the group by this operation.
         * </p>
         * 
         * @param succeeded
         *        A list of ARNs of resources that were successfully added to the group by this operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder succeeded(Collection<String> succeeded);

        /**
         * <p>
         * A list of ARNs of resources that were successfully added to the group by this operation.
         * </p>
         * 
         * @param succeeded
         *        A list of ARNs of resources that were successfully added to the group by this operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder succeeded(String... succeeded);

        /**
         * <p>
         * A list of ARNs of any resources that failed to be added to the group by this operation.
         * </p>
         * 
         * @param failed
         *        A list of ARNs of any resources that failed to be added to the group by this operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder failed(Collection<FailedResource> failed);

        /**
         * <p>
         * A list of ARNs of any resources that failed to be added to the group by this operation.
         * </p>
         * 
         * @param failed
         *        A list of ARNs of any resources that failed to be added to the group by this operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder failed(FailedResource... failed);

        /**
         * <p>
         * A list of ARNs of any resources that failed to be added to the group by this operation.
         * </p>
         * This is a convenience method that creates an instance of the {@link List<FailedResource>.Builder} avoiding
         * the need to create one manually via {@link List<FailedResource>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<FailedResource>.Builder#build()} is called immediately and
         * its result is passed to {@link #failed(List<FailedResource>)}.
         * 
         * @param failed
         *        a consumer that will call methods on {@link List<FailedResource>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #failed(List<FailedResource>)
         */
        Builder failed(Consumer<FailedResource.Builder>... failed);

        /**
         * <p>
         * A list of ARNs of any resources that are still in the process of being added to the group by this operation.
         * These pending additions continue asynchronously. You can check the status of pending additions by using the
         * <code> <a>ListGroupResources</a> </code> operation, and checking the <code>Resources</code> array in the
         * response and the <code>Status</code> field of each object in that array.
         * </p>
         * 
         * @param pending
         *        A list of ARNs of any resources that are still in the process of being added to the group by this
         *        operation. These pending additions continue asynchronously. You can check the status of pending
         *        additions by using the <code> <a>ListGroupResources</a> </code> operation, and checking the
         *        <code>Resources</code> array in the response and the <code>Status</code> field of each object in that
         *        array.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pending(Collection<PendingResource> pending);

        /**
         * <p>
         * A list of ARNs of any resources that are still in the process of being added to the group by this operation.
         * These pending additions continue asynchronously. You can check the status of pending additions by using the
         * <code> <a>ListGroupResources</a> </code> operation, and checking the <code>Resources</code> array in the
         * response and the <code>Status</code> field of each object in that array.
         * </p>
         * 
         * @param pending
         *        A list of ARNs of any resources that are still in the process of being added to the group by this
         *        operation. These pending additions continue asynchronously. You can check the status of pending
         *        additions by using the <code> <a>ListGroupResources</a> </code> operation, and checking the
         *        <code>Resources</code> array in the response and the <code>Status</code> field of each object in that
         *        array.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pending(PendingResource... pending);

        /**
         * <p>
         * A list of ARNs of any resources that are still in the process of being added to the group by this operation.
         * These pending additions continue asynchronously. You can check the status of pending additions by using the
         * <code> <a>ListGroupResources</a> </code> operation, and checking the <code>Resources</code> array in the
         * response and the <code>Status</code> field of each object in that array.
         * </p>
         * This is a convenience method that creates an instance of the {@link List<PendingResource>.Builder} avoiding
         * the need to create one manually via {@link List<PendingResource>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<PendingResource>.Builder#build()} is called immediately and
         * its result is passed to {@link #pending(List<PendingResource>)}.
         * 
         * @param pending
         *        a consumer that will call methods on {@link List<PendingResource>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #pending(List<PendingResource>)
         */
        Builder pending(Consumer<PendingResource.Builder>... pending);
    }

    static final class BuilderImpl extends ResourceGroupsResponse.BuilderImpl implements Builder {
        private List<String> succeeded = DefaultSdkAutoConstructList.getInstance();

        private List<FailedResource> failed = DefaultSdkAutoConstructList.getInstance();

        private List<PendingResource> pending = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GroupResourcesResponse model) {
            super(model);
            succeeded(model.succeeded);
            failed(model.failed);
            pending(model.pending);
        }

        public final Collection<String> getSucceeded() {
            if (succeeded instanceof SdkAutoConstructList) {
                return null;
            }
            return succeeded;
        }

        public final void setSucceeded(Collection<String> succeeded) {
            this.succeeded = ResourceArnListCopier.copy(succeeded);
        }

        @Override
        @Transient
        public final Builder succeeded(Collection<String> succeeded) {
            this.succeeded = ResourceArnListCopier.copy(succeeded);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder succeeded(String... succeeded) {
            succeeded(Arrays.asList(succeeded));
            return this;
        }

        public final List<FailedResource.Builder> getFailed() {
            List<FailedResource.Builder> result = FailedResourceListCopier.copyToBuilder(this.failed);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFailed(Collection<FailedResource.BuilderImpl> failed) {
            this.failed = FailedResourceListCopier.copyFromBuilder(failed);
        }

        @Override
        @Transient
        public final Builder failed(Collection<FailedResource> failed) {
            this.failed = FailedResourceListCopier.copy(failed);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder failed(FailedResource... failed) {
            failed(Arrays.asList(failed));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder failed(Consumer<FailedResource.Builder>... failed) {
            failed(Stream.of(failed).map(c -> FailedResource.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<PendingResource.Builder> getPending() {
            List<PendingResource.Builder> result = PendingResourceListCopier.copyToBuilder(this.pending);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setPending(Collection<PendingResource.BuilderImpl> pending) {
            this.pending = PendingResourceListCopier.copyFromBuilder(pending);
        }

        @Override
        @Transient
        public final Builder pending(Collection<PendingResource> pending) {
            this.pending = PendingResourceListCopier.copy(pending);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder pending(PendingResource... pending) {
            pending(Arrays.asList(pending));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder pending(Consumer<PendingResource.Builder>... pending) {
            pending(Stream.of(pending).map(c -> PendingResource.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public GroupResourcesResponse build() {
            return new GroupResourcesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
