/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.resourcegroups.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A structure returned by the <a>ListGroupResources</a> operation that contains identity and group membership status
 * information for one of the resources in the group.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListGroupResourcesItem implements SdkPojo, Serializable,
        ToCopyableBuilder<ListGroupResourcesItem.Builder, ListGroupResourcesItem> {
    private static final SdkField<ResourceIdentifier> IDENTIFIER_FIELD = SdkField
            .<ResourceIdentifier> builder(MarshallingType.SDK_POJO).memberName("Identifier")
            .getter(getter(ListGroupResourcesItem::identifier)).setter(setter(Builder::identifier))
            .constructor(ResourceIdentifier::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Identifier").build()).build();

    private static final SdkField<ResourceStatus> STATUS_FIELD = SdkField.<ResourceStatus> builder(MarshallingType.SDK_POJO)
            .memberName("Status").getter(getter(ListGroupResourcesItem::status)).setter(setter(Builder::status))
            .constructor(ResourceStatus::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(IDENTIFIER_FIELD, STATUS_FIELD));

    private static final long serialVersionUID = 1L;

    private final ResourceIdentifier identifier;

    private final ResourceStatus status;

    private ListGroupResourcesItem(BuilderImpl builder) {
        this.identifier = builder.identifier;
        this.status = builder.status;
    }

    /**
     * Returns the value of the Identifier property for this object.
     * 
     * @return The value of the Identifier property for this object.
     */
    public final ResourceIdentifier identifier() {
        return identifier;
    }

    /**
     * <p>
     * A structure that contains the status of this resource's membership in the group.
     * </p>
     * <note>
     * <p>
     * This field is present in the response only if the group is of type <code>AWS::EC2::HostManagement</code>.
     * </p>
     * </note>
     * 
     * @return A structure that contains the status of this resource's membership in the group.</p> <note>
     *         <p>
     *         This field is present in the response only if the group is of type <code>AWS::EC2::HostManagement</code>.
     *         </p>
     */
    public final ResourceStatus status() {
        return status;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(identifier());
        hashCode = 31 * hashCode + Objects.hashCode(status());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListGroupResourcesItem)) {
            return false;
        }
        ListGroupResourcesItem other = (ListGroupResourcesItem) obj;
        return Objects.equals(identifier(), other.identifier()) && Objects.equals(status(), other.status());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListGroupResourcesItem").add("Identifier", identifier()).add("Status", status()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Identifier":
            return Optional.ofNullable(clazz.cast(identifier()));
        case "Status":
            return Optional.ofNullable(clazz.cast(status()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListGroupResourcesItem, T> g) {
        return obj -> g.apply((ListGroupResourcesItem) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ListGroupResourcesItem> {
        /**
         * Sets the value of the Identifier property for this object.
         *
         * @param identifier
         *        The new value for the Identifier property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder identifier(ResourceIdentifier identifier);

        /**
         * Sets the value of the Identifier property for this object.
         *
         * This is a convenience method that creates an instance of the {@link ResourceIdentifier.Builder} avoiding the
         * need to create one manually via {@link ResourceIdentifier#builder()}.
         *
         * When the {@link Consumer} completes, {@link ResourceIdentifier.Builder#build()} is called immediately and its
         * result is passed to {@link #identifier(ResourceIdentifier)}.
         * 
         * @param identifier
         *        a consumer that will call methods on {@link ResourceIdentifier.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #identifier(ResourceIdentifier)
         */
        default Builder identifier(Consumer<ResourceIdentifier.Builder> identifier) {
            return identifier(ResourceIdentifier.builder().applyMutation(identifier).build());
        }

        /**
         * <p>
         * A structure that contains the status of this resource's membership in the group.
         * </p>
         * <note>
         * <p>
         * This field is present in the response only if the group is of type <code>AWS::EC2::HostManagement</code>.
         * </p>
         * </note>
         * 
         * @param status
         *        A structure that contains the status of this resource's membership in the group.</p> <note>
         *        <p>
         *        This field is present in the response only if the group is of type
         *        <code>AWS::EC2::HostManagement</code>.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder status(ResourceStatus status);

        /**
         * <p>
         * A structure that contains the status of this resource's membership in the group.
         * </p>
         * <note>
         * <p>
         * This field is present in the response only if the group is of type <code>AWS::EC2::HostManagement</code>.
         * </p>
         * </note> This is a convenience method that creates an instance of the {@link ResourceStatus.Builder} avoiding
         * the need to create one manually via {@link ResourceStatus#builder()}.
         *
         * When the {@link Consumer} completes, {@link ResourceStatus.Builder#build()} is called immediately and its
         * result is passed to {@link #status(ResourceStatus)}.
         * 
         * @param status
         *        a consumer that will call methods on {@link ResourceStatus.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #status(ResourceStatus)
         */
        default Builder status(Consumer<ResourceStatus.Builder> status) {
            return status(ResourceStatus.builder().applyMutation(status).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private ResourceIdentifier identifier;

        private ResourceStatus status;

        private BuilderImpl() {
        }

        private BuilderImpl(ListGroupResourcesItem model) {
            identifier(model.identifier);
            status(model.status);
        }

        public final ResourceIdentifier.Builder getIdentifier() {
            return identifier != null ? identifier.toBuilder() : null;
        }

        public final void setIdentifier(ResourceIdentifier.BuilderImpl identifier) {
            this.identifier = identifier != null ? identifier.build() : null;
        }

        @Override
        public final Builder identifier(ResourceIdentifier identifier) {
            this.identifier = identifier;
            return this;
        }

        public final ResourceStatus.Builder getStatus() {
            return status != null ? status.toBuilder() : null;
        }

        public final void setStatus(ResourceStatus.BuilderImpl status) {
            this.status = status != null ? status.build() : null;
        }

        @Override
        public final Builder status(ResourceStatus status) {
            this.status = status;
            return this;
        }

        @Override
        public ListGroupResourcesItem build() {
            return new ListGroupResourcesItem(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
