/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.resourcegroups.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class SearchResourcesResponse extends ResourceGroupsResponse implements
        ToCopyableBuilder<SearchResourcesResponse.Builder, SearchResourcesResponse> {
    private static final SdkField<List<ResourceIdentifier>> RESOURCE_IDENTIFIERS_FIELD = SdkField
            .<List<ResourceIdentifier>> builder(MarshallingType.LIST)
            .memberName("ResourceIdentifiers")
            .getter(getter(SearchResourcesResponse::resourceIdentifiers))
            .setter(setter(Builder::resourceIdentifiers))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceIdentifiers").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ResourceIdentifier> builder(MarshallingType.SDK_POJO)
                                            .constructor(ResourceIdentifier::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(SearchResourcesResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final SdkField<List<QueryError>> QUERY_ERRORS_FIELD = SdkField
            .<List<QueryError>> builder(MarshallingType.LIST)
            .memberName("QueryErrors")
            .getter(getter(SearchResourcesResponse::queryErrors))
            .setter(setter(Builder::queryErrors))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QueryErrors").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<QueryError> builder(MarshallingType.SDK_POJO)
                                            .constructor(QueryError::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESOURCE_IDENTIFIERS_FIELD,
            NEXT_TOKEN_FIELD, QUERY_ERRORS_FIELD));

    private final List<ResourceIdentifier> resourceIdentifiers;

    private final String nextToken;

    private final List<QueryError> queryErrors;

    private SearchResourcesResponse(BuilderImpl builder) {
        super(builder);
        this.resourceIdentifiers = builder.resourceIdentifiers;
        this.nextToken = builder.nextToken;
        this.queryErrors = builder.queryErrors;
    }

    /**
     * For responses, this returns true if the service returned a value for the ResourceIdentifiers property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasResourceIdentifiers() {
        return resourceIdentifiers != null && !(resourceIdentifiers instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The ARNs and resource types of resources that are members of the group that you specified.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasResourceIdentifiers} method.
     * </p>
     * 
     * @return The ARNs and resource types of resources that are members of the group that you specified.
     */
    public final List<ResourceIdentifier> resourceIdentifiers() {
        return resourceIdentifiers;
    }

    /**
     * <p>
     * If present, indicates that more output is available than is included in the current response. Use this value in
     * the <code>NextToken</code> request parameter in a subsequent call to the operation to get the next part of the
     * output. You should repeat this until the <code>NextToken</code> response element comes back as <code>null</code>.
     * </p>
     * 
     * @return If present, indicates that more output is available than is included in the current response. Use this
     *         value in the <code>NextToken</code> request parameter in a subsequent call to the operation to get the
     *         next part of the output. You should repeat this until the <code>NextToken</code> response element comes
     *         back as <code>null</code>.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the QueryErrors property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasQueryErrors() {
        return queryErrors != null && !(queryErrors instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of <code>QueryError</code> objects. Each error is an object that contains <code>ErrorCode</code> and
     * <code>Message</code> structures. Possible values for <code>ErrorCode</code> are
     * <code>CLOUDFORMATION_STACK_INACTIVE</code> and <code>CLOUDFORMATION_STACK_NOT_EXISTING</code>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasQueryErrors} method.
     * </p>
     * 
     * @return A list of <code>QueryError</code> objects. Each error is an object that contains <code>ErrorCode</code>
     *         and <code>Message</code> structures. Possible values for <code>ErrorCode</code> are
     *         <code>CLOUDFORMATION_STACK_INACTIVE</code> and <code>CLOUDFORMATION_STACK_NOT_EXISTING</code>.
     */
    public final List<QueryError> queryErrors() {
        return queryErrors;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasResourceIdentifiers() ? resourceIdentifiers() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(hasQueryErrors() ? queryErrors() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SearchResourcesResponse)) {
            return false;
        }
        SearchResourcesResponse other = (SearchResourcesResponse) obj;
        return hasResourceIdentifiers() == other.hasResourceIdentifiers()
                && Objects.equals(resourceIdentifiers(), other.resourceIdentifiers())
                && Objects.equals(nextToken(), other.nextToken()) && hasQueryErrors() == other.hasQueryErrors()
                && Objects.equals(queryErrors(), other.queryErrors());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SearchResourcesResponse")
                .add("ResourceIdentifiers", hasResourceIdentifiers() ? resourceIdentifiers() : null)
                .add("NextToken", nextToken()).add("QueryErrors", hasQueryErrors() ? queryErrors() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ResourceIdentifiers":
            return Optional.ofNullable(clazz.cast(resourceIdentifiers()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "QueryErrors":
            return Optional.ofNullable(clazz.cast(queryErrors()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SearchResourcesResponse, T> g) {
        return obj -> g.apply((SearchResourcesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ResourceGroupsResponse.Builder, SdkPojo, CopyableBuilder<Builder, SearchResourcesResponse> {
        /**
         * <p>
         * The ARNs and resource types of resources that are members of the group that you specified.
         * </p>
         * 
         * @param resourceIdentifiers
         *        The ARNs and resource types of resources that are members of the group that you specified.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceIdentifiers(Collection<ResourceIdentifier> resourceIdentifiers);

        /**
         * <p>
         * The ARNs and resource types of resources that are members of the group that you specified.
         * </p>
         * 
         * @param resourceIdentifiers
         *        The ARNs and resource types of resources that are members of the group that you specified.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceIdentifiers(ResourceIdentifier... resourceIdentifiers);

        /**
         * <p>
         * The ARNs and resource types of resources that are members of the group that you specified.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.resourcegroups.model.ResourceIdentifier.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.resourcegroups.model.ResourceIdentifier#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.resourcegroups.model.ResourceIdentifier.Builder#build()} is called
         * immediately and its result is passed to {@link #resourceIdentifiers(List<ResourceIdentifier>)}.
         * 
         * @param resourceIdentifiers
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.resourcegroups.model.ResourceIdentifier.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #resourceIdentifiers(java.util.Collection<ResourceIdentifier>)
         */
        Builder resourceIdentifiers(Consumer<ResourceIdentifier.Builder>... resourceIdentifiers);

        /**
         * <p>
         * If present, indicates that more output is available than is included in the current response. Use this value
         * in the <code>NextToken</code> request parameter in a subsequent call to the operation to get the next part of
         * the output. You should repeat this until the <code>NextToken</code> response element comes back as
         * <code>null</code>.
         * </p>
         * 
         * @param nextToken
         *        If present, indicates that more output is available than is included in the current response. Use this
         *        value in the <code>NextToken</code> request parameter in a subsequent call to the operation to get the
         *        next part of the output. You should repeat this until the <code>NextToken</code> response element
         *        comes back as <code>null</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * A list of <code>QueryError</code> objects. Each error is an object that contains <code>ErrorCode</code> and
         * <code>Message</code> structures. Possible values for <code>ErrorCode</code> are
         * <code>CLOUDFORMATION_STACK_INACTIVE</code> and <code>CLOUDFORMATION_STACK_NOT_EXISTING</code>.
         * </p>
         * 
         * @param queryErrors
         *        A list of <code>QueryError</code> objects. Each error is an object that contains
         *        <code>ErrorCode</code> and <code>Message</code> structures. Possible values for <code>ErrorCode</code>
         *        are <code>CLOUDFORMATION_STACK_INACTIVE</code> and <code>CLOUDFORMATION_STACK_NOT_EXISTING</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder queryErrors(Collection<QueryError> queryErrors);

        /**
         * <p>
         * A list of <code>QueryError</code> objects. Each error is an object that contains <code>ErrorCode</code> and
         * <code>Message</code> structures. Possible values for <code>ErrorCode</code> are
         * <code>CLOUDFORMATION_STACK_INACTIVE</code> and <code>CLOUDFORMATION_STACK_NOT_EXISTING</code>.
         * </p>
         * 
         * @param queryErrors
         *        A list of <code>QueryError</code> objects. Each error is an object that contains
         *        <code>ErrorCode</code> and <code>Message</code> structures. Possible values for <code>ErrorCode</code>
         *        are <code>CLOUDFORMATION_STACK_INACTIVE</code> and <code>CLOUDFORMATION_STACK_NOT_EXISTING</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder queryErrors(QueryError... queryErrors);

        /**
         * <p>
         * A list of <code>QueryError</code> objects. Each error is an object that contains <code>ErrorCode</code> and
         * <code>Message</code> structures. Possible values for <code>ErrorCode</code> are
         * <code>CLOUDFORMATION_STACK_INACTIVE</code> and <code>CLOUDFORMATION_STACK_NOT_EXISTING</code>.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.resourcegroups.model.QueryError.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.resourcegroups.model.QueryError#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.resourcegroups.model.QueryError.Builder#build()} is called immediately
         * and its result is passed to {@link #queryErrors(List<QueryError>)}.
         * 
         * @param queryErrors
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.resourcegroups.model.QueryError.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #queryErrors(java.util.Collection<QueryError>)
         */
        Builder queryErrors(Consumer<QueryError.Builder>... queryErrors);
    }

    static final class BuilderImpl extends ResourceGroupsResponse.BuilderImpl implements Builder {
        private List<ResourceIdentifier> resourceIdentifiers = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private List<QueryError> queryErrors = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(SearchResourcesResponse model) {
            super(model);
            resourceIdentifiers(model.resourceIdentifiers);
            nextToken(model.nextToken);
            queryErrors(model.queryErrors);
        }

        public final List<ResourceIdentifier.Builder> getResourceIdentifiers() {
            List<ResourceIdentifier.Builder> result = ResourceIdentifierListCopier.copyToBuilder(this.resourceIdentifiers);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setResourceIdentifiers(Collection<ResourceIdentifier.BuilderImpl> resourceIdentifiers) {
            this.resourceIdentifiers = ResourceIdentifierListCopier.copyFromBuilder(resourceIdentifiers);
        }

        @Override
        public final Builder resourceIdentifiers(Collection<ResourceIdentifier> resourceIdentifiers) {
            this.resourceIdentifiers = ResourceIdentifierListCopier.copy(resourceIdentifiers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceIdentifiers(ResourceIdentifier... resourceIdentifiers) {
            resourceIdentifiers(Arrays.asList(resourceIdentifiers));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceIdentifiers(Consumer<ResourceIdentifier.Builder>... resourceIdentifiers) {
            resourceIdentifiers(Stream.of(resourceIdentifiers).map(c -> ResourceIdentifier.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<QueryError.Builder> getQueryErrors() {
            List<QueryError.Builder> result = QueryErrorListCopier.copyToBuilder(this.queryErrors);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setQueryErrors(Collection<QueryError.BuilderImpl> queryErrors) {
            this.queryErrors = QueryErrorListCopier.copyFromBuilder(queryErrors);
        }

        @Override
        public final Builder queryErrors(Collection<QueryError> queryErrors) {
            this.queryErrors = QueryErrorListCopier.copy(queryErrors);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder queryErrors(QueryError... queryErrors) {
            queryErrors(Arrays.asList(queryErrors));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder queryErrors(Consumer<QueryError.Builder>... queryErrors) {
            queryErrors(Stream.of(queryErrors).map(c -> QueryError.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public SearchResourcesResponse build() {
            return new SearchResourcesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
