/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.resourcegroups.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UntagResponse extends ResourceGroupsResponse implements
        ToCopyableBuilder<UntagResponse.Builder, UntagResponse> {
    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Arn")
            .getter(getter(UntagResponse::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()).build();

    private static final SdkField<List<String>> KEYS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("Keys")
            .getter(getter(UntagResponse::keys))
            .setter(setter(Builder::keys))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Keys").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, KEYS_FIELD));

    private final String arn;

    private final List<String> keys;

    private UntagResponse(BuilderImpl builder) {
        super(builder);
        this.arn = builder.arn;
        this.keys = builder.keys;
    }

    /**
     * <p>
     * The ARN of the resource group from which tags have been removed.
     * </p>
     * 
     * @return The ARN of the resource group from which tags have been removed.
     */
    public final String arn() {
        return arn;
    }

    /**
     * For responses, this returns true if the service returned a value for the Keys property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasKeys() {
        return keys != null && !(keys instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The keys of the tags that were removed.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasKeys} method.
     * </p>
     * 
     * @return The keys of the tags that were removed.
     */
    public final List<String> keys() {
        return keys;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(hasKeys() ? keys() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UntagResponse)) {
            return false;
        }
        UntagResponse other = (UntagResponse) obj;
        return Objects.equals(arn(), other.arn()) && hasKeys() == other.hasKeys() && Objects.equals(keys(), other.keys());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UntagResponse").add("Arn", arn()).add("Keys", hasKeys() ? keys() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "Keys":
            return Optional.ofNullable(clazz.cast(keys()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UntagResponse, T> g) {
        return obj -> g.apply((UntagResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ResourceGroupsResponse.Builder, SdkPojo, CopyableBuilder<Builder, UntagResponse> {
        /**
         * <p>
         * The ARN of the resource group from which tags have been removed.
         * </p>
         * 
         * @param arn
         *        The ARN of the resource group from which tags have been removed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The keys of the tags that were removed.
         * </p>
         * 
         * @param keys
         *        The keys of the tags that were removed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder keys(Collection<String> keys);

        /**
         * <p>
         * The keys of the tags that were removed.
         * </p>
         * 
         * @param keys
         *        The keys of the tags that were removed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder keys(String... keys);
    }

    static final class BuilderImpl extends ResourceGroupsResponse.BuilderImpl implements Builder {
        private String arn;

        private List<String> keys = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UntagResponse model) {
            super(model);
            arn(model.arn);
            keys(model.keys);
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        @Transient
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final Collection<String> getKeys() {
            if (keys instanceof SdkAutoConstructList) {
                return null;
            }
            return keys;
        }

        public final void setKeys(Collection<String> keys) {
            this.keys = TagKeyListCopier.copy(keys);
        }

        @Override
        @Transient
        public final Builder keys(Collection<String> keys) {
            this.keys = TagKeyListCopier.copy(keys);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder keys(String... keys) {
            keys(Arrays.asList(keys));
            return this;
        }

        @Override
        public UntagResponse build() {
            return new UntagResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
