/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.resourcegroups.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListGroupResourcesRequest extends ResourceGroupsRequest implements
        ToCopyableBuilder<ListGroupResourcesRequest.Builder, ListGroupResourcesRequest> {
    private static final SdkField<String> GROUP_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("GroupName").getter(getter(ListGroupResourcesRequest::groupName)).setter(setter(Builder::groupName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GroupName").build()).build();

    private static final SdkField<String> GROUP_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Group")
            .getter(getter(ListGroupResourcesRequest::group)).setter(setter(Builder::group))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Group").build()).build();

    private static final SdkField<List<ResourceFilter>> FILTERS_FIELD = SdkField
            .<List<ResourceFilter>> builder(MarshallingType.LIST)
            .memberName("Filters")
            .getter(getter(ListGroupResourcesRequest::filters))
            .setter(setter(Builder::filters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Filters").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ResourceFilter> builder(MarshallingType.SDK_POJO)
                                            .constructor(ResourceFilter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxResults").getter(getter(ListGroupResourcesRequest::maxResults)).setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListGroupResourcesRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GROUP_NAME_FIELD, GROUP_FIELD,
            FILTERS_FIELD, MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD));

    private final String groupName;

    private final String group;

    private final List<ResourceFilter> filters;

    private final Integer maxResults;

    private final String nextToken;

    private ListGroupResourcesRequest(BuilderImpl builder) {
        super(builder);
        this.groupName = builder.groupName;
        this.group = builder.group;
        this.filters = builder.filters;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
    }

    /**
     * <important>
     * <p>
     * <i> <b>Deprecated - don't use this parameter. Use the <code>Group</code> request field instead.</b> </i>
     * </p>
     * </important>
     * 
     * @return <p>
     *         <i> <b>Deprecated - don't use this parameter. Use the <code>Group</code> request field instead.</b> </i>
     *         </p>
     * @deprecated This field is deprecated, use Group instead.
     */
    @Deprecated
    public final String groupName() {
        return groupName;
    }

    /**
     * <p>
     * The name or the ARN of the resource group
     * </p>
     * 
     * @return The name or the ARN of the resource group
     */
    public final String group() {
        return group;
    }

    /**
     * Returns true if the Filters property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasFilters() {
        return filters != null && !(filters instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Filters, formatted as <a>ResourceFilter</a> objects, that you want to apply to a <code>ListGroupResources</code>
     * operation. Filters the results to include only those of the specified resource types.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>resource-type</code> - Filter resources by their type. Specify up to five resource types in the format
     * <code>AWS::ServiceCode::ResourceType</code>. For example, <code>AWS::EC2::Instance</code>, or
     * <code>AWS::S3::Bucket</code>.
     * </p>
     * </li>
     * </ul>
     * <p>
     * When you specify a <code>resource-type</code> filter for <code>ListGroupResources</code>, AWS Resource Groups
     * validates your filter resource types against the types that are defined in the query associated with the group.
     * For example, if a group contains only S3 buckets because its query specifies only that resource type, but your
     * <code>resource-type</code> filter includes EC2 instances, AWS Resource Groups does not filter for EC2 instances.
     * In this case, a <code>ListGroupResources</code> request returns a <code>BadRequestException</code> error with a
     * message similar to the following:
     * </p>
     * <p>
     * <code>The resource types specified as filters in the request are not valid.</code>
     * </p>
     * <p>
     * The error includes a list of resource types that failed the validation because they are not part of the query
     * associated with the group. This validation doesn't occur when the group query specifies
     * <code>AWS::AllSupported</code>, because a group based on such a query can contain any of the allowed resource
     * types for the query type (tag-based or AWS CloudFormation stack-based queries).
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasFilters()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Filters, formatted as <a>ResourceFilter</a> objects, that you want to apply to a
     *         <code>ListGroupResources</code> operation. Filters the results to include only those of the specified
     *         resource types.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>resource-type</code> - Filter resources by their type. Specify up to five resource types in the
     *         format <code>AWS::ServiceCode::ResourceType</code>. For example, <code>AWS::EC2::Instance</code>, or
     *         <code>AWS::S3::Bucket</code>.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         When you specify a <code>resource-type</code> filter for <code>ListGroupResources</code>, AWS Resource
     *         Groups validates your filter resource types against the types that are defined in the query associated
     *         with the group. For example, if a group contains only S3 buckets because its query specifies only that
     *         resource type, but your <code>resource-type</code> filter includes EC2 instances, AWS Resource Groups
     *         does not filter for EC2 instances. In this case, a <code>ListGroupResources</code> request returns a
     *         <code>BadRequestException</code> error with a message similar to the following:
     *         </p>
     *         <p>
     *         <code>The resource types specified as filters in the request are not valid.</code>
     *         </p>
     *         <p>
     *         The error includes a list of resource types that failed the validation because they are not part of the
     *         query associated with the group. This validation doesn't occur when the group query specifies
     *         <code>AWS::AllSupported</code>, because a group based on such a query can contain any of the allowed
     *         resource types for the query type (tag-based or AWS CloudFormation stack-based queries).
     */
    public final List<ResourceFilter> filters() {
        return filters;
    }

    /**
     * <p>
     * The total number of results that you want included on each page of the response. If you do not include this
     * parameter, it defaults to a value that is specific to the operation. If additional items exist beyond the maximum
     * you specify, the <code>NextToken</code> response element is present and has a value (is not null). Include that
     * value as the <code>NextToken</code> request parameter in the next call to the operation to get the next part of
     * the results. Note that the service might return fewer results than the maximum even when there are more results
     * available. You should check <code>NextToken</code> after every operation to ensure that you receive all of the
     * results.
     * </p>
     * 
     * @return The total number of results that you want included on each page of the response. If you do not include
     *         this parameter, it defaults to a value that is specific to the operation. If additional items exist
     *         beyond the maximum you specify, the <code>NextToken</code> response element is present and has a value
     *         (is not null). Include that value as the <code>NextToken</code> request parameter in the next call to the
     *         operation to get the next part of the results. Note that the service might return fewer results than the
     *         maximum even when there are more results available. You should check <code>NextToken</code> after every
     *         operation to ensure that you receive all of the results.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * The parameter for receiving additional results if you receive a <code>NextToken</code> response in a previous
     * request. A <code>NextToken</code> response indicates that more output is available. Set this parameter to the
     * value provided by a previous call's <code>NextToken</code> response to indicate where the output should continue
     * from.
     * </p>
     * 
     * @return The parameter for receiving additional results if you receive a <code>NextToken</code> response in a
     *         previous request. A <code>NextToken</code> response indicates that more output is available. Set this
     *         parameter to the value provided by a previous call's <code>NextToken</code> response to indicate where
     *         the output should continue from.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(groupName());
        hashCode = 31 * hashCode + Objects.hashCode(group());
        hashCode = 31 * hashCode + Objects.hashCode(hasFilters() ? filters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListGroupResourcesRequest)) {
            return false;
        }
        ListGroupResourcesRequest other = (ListGroupResourcesRequest) obj;
        return Objects.equals(groupName(), other.groupName()) && Objects.equals(group(), other.group())
                && hasFilters() == other.hasFilters() && Objects.equals(filters(), other.filters())
                && Objects.equals(maxResults(), other.maxResults()) && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListGroupResourcesRequest").add("GroupName", groupName()).add("Group", group())
                .add("Filters", hasFilters() ? filters() : null).add("MaxResults", maxResults()).add("NextToken", nextToken())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "GroupName":
            return Optional.ofNullable(clazz.cast(groupName()));
        case "Group":
            return Optional.ofNullable(clazz.cast(group()));
        case "Filters":
            return Optional.ofNullable(clazz.cast(filters()));
        case "MaxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListGroupResourcesRequest, T> g) {
        return obj -> g.apply((ListGroupResourcesRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ResourceGroupsRequest.Builder, SdkPojo, CopyableBuilder<Builder, ListGroupResourcesRequest> {
        /**
         * <important>
         * <p>
         * <i> <b>Deprecated - don't use this parameter. Use the <code>Group</code> request field instead.</b> </i>
         * </p>
         * </important>
         * 
         * @param groupName
         *        <p>
         *        <i> <b>Deprecated - don't use this parameter. Use the <code>Group</code> request field instead.</b>
         *        </i>
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         * @deprecated This field is deprecated, use Group instead.
         */
        @Deprecated
        Builder groupName(String groupName);

        /**
         * <p>
         * The name or the ARN of the resource group
         * </p>
         * 
         * @param group
         *        The name or the ARN of the resource group
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder group(String group);

        /**
         * <p>
         * Filters, formatted as <a>ResourceFilter</a> objects, that you want to apply to a
         * <code>ListGroupResources</code> operation. Filters the results to include only those of the specified
         * resource types.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>resource-type</code> - Filter resources by their type. Specify up to five resource types in the format
         * <code>AWS::ServiceCode::ResourceType</code>. For example, <code>AWS::EC2::Instance</code>, or
         * <code>AWS::S3::Bucket</code>.
         * </p>
         * </li>
         * </ul>
         * <p>
         * When you specify a <code>resource-type</code> filter for <code>ListGroupResources</code>, AWS Resource Groups
         * validates your filter resource types against the types that are defined in the query associated with the
         * group. For example, if a group contains only S3 buckets because its query specifies only that resource type,
         * but your <code>resource-type</code> filter includes EC2 instances, AWS Resource Groups does not filter for
         * EC2 instances. In this case, a <code>ListGroupResources</code> request returns a
         * <code>BadRequestException</code> error with a message similar to the following:
         * </p>
         * <p>
         * <code>The resource types specified as filters in the request are not valid.</code>
         * </p>
         * <p>
         * The error includes a list of resource types that failed the validation because they are not part of the query
         * associated with the group. This validation doesn't occur when the group query specifies
         * <code>AWS::AllSupported</code>, because a group based on such a query can contain any of the allowed resource
         * types for the query type (tag-based or AWS CloudFormation stack-based queries).
         * </p>
         * 
         * @param filters
         *        Filters, formatted as <a>ResourceFilter</a> objects, that you want to apply to a
         *        <code>ListGroupResources</code> operation. Filters the results to include only those of the specified
         *        resource types.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>resource-type</code> - Filter resources by their type. Specify up to five resource types in the
         *        format <code>AWS::ServiceCode::ResourceType</code>. For example, <code>AWS::EC2::Instance</code>, or
         *        <code>AWS::S3::Bucket</code>.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        When you specify a <code>resource-type</code> filter for <code>ListGroupResources</code>, AWS Resource
         *        Groups validates your filter resource types against the types that are defined in the query associated
         *        with the group. For example, if a group contains only S3 buckets because its query specifies only that
         *        resource type, but your <code>resource-type</code> filter includes EC2 instances, AWS Resource Groups
         *        does not filter for EC2 instances. In this case, a <code>ListGroupResources</code> request returns a
         *        <code>BadRequestException</code> error with a message similar to the following:
         *        </p>
         *        <p>
         *        <code>The resource types specified as filters in the request are not valid.</code>
         *        </p>
         *        <p>
         *        The error includes a list of resource types that failed the validation because they are not part of
         *        the query associated with the group. This validation doesn't occur when the group query specifies
         *        <code>AWS::AllSupported</code>, because a group based on such a query can contain any of the allowed
         *        resource types for the query type (tag-based or AWS CloudFormation stack-based queries).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filters(Collection<ResourceFilter> filters);

        /**
         * <p>
         * Filters, formatted as <a>ResourceFilter</a> objects, that you want to apply to a
         * <code>ListGroupResources</code> operation. Filters the results to include only those of the specified
         * resource types.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>resource-type</code> - Filter resources by their type. Specify up to five resource types in the format
         * <code>AWS::ServiceCode::ResourceType</code>. For example, <code>AWS::EC2::Instance</code>, or
         * <code>AWS::S3::Bucket</code>.
         * </p>
         * </li>
         * </ul>
         * <p>
         * When you specify a <code>resource-type</code> filter for <code>ListGroupResources</code>, AWS Resource Groups
         * validates your filter resource types against the types that are defined in the query associated with the
         * group. For example, if a group contains only S3 buckets because its query specifies only that resource type,
         * but your <code>resource-type</code> filter includes EC2 instances, AWS Resource Groups does not filter for
         * EC2 instances. In this case, a <code>ListGroupResources</code> request returns a
         * <code>BadRequestException</code> error with a message similar to the following:
         * </p>
         * <p>
         * <code>The resource types specified as filters in the request are not valid.</code>
         * </p>
         * <p>
         * The error includes a list of resource types that failed the validation because they are not part of the query
         * associated with the group. This validation doesn't occur when the group query specifies
         * <code>AWS::AllSupported</code>, because a group based on such a query can contain any of the allowed resource
         * types for the query type (tag-based or AWS CloudFormation stack-based queries).
         * </p>
         * 
         * @param filters
         *        Filters, formatted as <a>ResourceFilter</a> objects, that you want to apply to a
         *        <code>ListGroupResources</code> operation. Filters the results to include only those of the specified
         *        resource types.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>resource-type</code> - Filter resources by their type. Specify up to five resource types in the
         *        format <code>AWS::ServiceCode::ResourceType</code>. For example, <code>AWS::EC2::Instance</code>, or
         *        <code>AWS::S3::Bucket</code>.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        When you specify a <code>resource-type</code> filter for <code>ListGroupResources</code>, AWS Resource
         *        Groups validates your filter resource types against the types that are defined in the query associated
         *        with the group. For example, if a group contains only S3 buckets because its query specifies only that
         *        resource type, but your <code>resource-type</code> filter includes EC2 instances, AWS Resource Groups
         *        does not filter for EC2 instances. In this case, a <code>ListGroupResources</code> request returns a
         *        <code>BadRequestException</code> error with a message similar to the following:
         *        </p>
         *        <p>
         *        <code>The resource types specified as filters in the request are not valid.</code>
         *        </p>
         *        <p>
         *        The error includes a list of resource types that failed the validation because they are not part of
         *        the query associated with the group. This validation doesn't occur when the group query specifies
         *        <code>AWS::AllSupported</code>, because a group based on such a query can contain any of the allowed
         *        resource types for the query type (tag-based or AWS CloudFormation stack-based queries).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filters(ResourceFilter... filters);

        /**
         * <p>
         * Filters, formatted as <a>ResourceFilter</a> objects, that you want to apply to a
         * <code>ListGroupResources</code> operation. Filters the results to include only those of the specified
         * resource types.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>resource-type</code> - Filter resources by their type. Specify up to five resource types in the format
         * <code>AWS::ServiceCode::ResourceType</code>. For example, <code>AWS::EC2::Instance</code>, or
         * <code>AWS::S3::Bucket</code>.
         * </p>
         * </li>
         * </ul>
         * <p>
         * When you specify a <code>resource-type</code> filter for <code>ListGroupResources</code>, AWS Resource Groups
         * validates your filter resource types against the types that are defined in the query associated with the
         * group. For example, if a group contains only S3 buckets because its query specifies only that resource type,
         * but your <code>resource-type</code> filter includes EC2 instances, AWS Resource Groups does not filter for
         * EC2 instances. In this case, a <code>ListGroupResources</code> request returns a
         * <code>BadRequestException</code> error with a message similar to the following:
         * </p>
         * <p>
         * <code>The resource types specified as filters in the request are not valid.</code>
         * </p>
         * <p>
         * The error includes a list of resource types that failed the validation because they are not part of the query
         * associated with the group. This validation doesn't occur when the group query specifies
         * <code>AWS::AllSupported</code>, because a group based on such a query can contain any of the allowed resource
         * types for the query type (tag-based or AWS CloudFormation stack-based queries).
         * </p>
         * This is a convenience that creates an instance of the {@link List<ResourceFilter>.Builder} avoiding the need
         * to create one manually via {@link List<ResourceFilter>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ResourceFilter>.Builder#build()} is called immediately and
         * its result is passed to {@link #filters(List<ResourceFilter>)}.
         * 
         * @param filters
         *        a consumer that will call methods on {@link List<ResourceFilter>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #filters(List<ResourceFilter>)
         */
        Builder filters(Consumer<ResourceFilter.Builder>... filters);

        /**
         * <p>
         * The total number of results that you want included on each page of the response. If you do not include this
         * parameter, it defaults to a value that is specific to the operation. If additional items exist beyond the
         * maximum you specify, the <code>NextToken</code> response element is present and has a value (is not null).
         * Include that value as the <code>NextToken</code> request parameter in the next call to the operation to get
         * the next part of the results. Note that the service might return fewer results than the maximum even when
         * there are more results available. You should check <code>NextToken</code> after every operation to ensure
         * that you receive all of the results.
         * </p>
         * 
         * @param maxResults
         *        The total number of results that you want included on each page of the response. If you do not include
         *        this parameter, it defaults to a value that is specific to the operation. If additional items exist
         *        beyond the maximum you specify, the <code>NextToken</code> response element is present and has a value
         *        (is not null). Include that value as the <code>NextToken</code> request parameter in the next call to
         *        the operation to get the next part of the results. Note that the service might return fewer results
         *        than the maximum even when there are more results available. You should check <code>NextToken</code>
         *        after every operation to ensure that you receive all of the results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * The parameter for receiving additional results if you receive a <code>NextToken</code> response in a previous
         * request. A <code>NextToken</code> response indicates that more output is available. Set this parameter to the
         * value provided by a previous call's <code>NextToken</code> response to indicate where the output should
         * continue from.
         * </p>
         * 
         * @param nextToken
         *        The parameter for receiving additional results if you receive a <code>NextToken</code> response in a
         *        previous request. A <code>NextToken</code> response indicates that more output is available. Set this
         *        parameter to the value provided by a previous call's <code>NextToken</code> response to indicate where
         *        the output should continue from.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ResourceGroupsRequest.BuilderImpl implements Builder {
        private String groupName;

        private String group;

        private List<ResourceFilter> filters = DefaultSdkAutoConstructList.getInstance();

        private Integer maxResults;

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListGroupResourcesRequest model) {
            super(model);
            groupName(model.groupName);
            group(model.group);
            filters(model.filters);
            maxResults(model.maxResults);
            nextToken(model.nextToken);
        }

        @Deprecated
        public final String getGroupName() {
            return groupName;
        }

        @Override
        @Deprecated
        public final Builder groupName(String groupName) {
            this.groupName = groupName;
            return this;
        }

        @Deprecated
        public final void setGroupName(String groupName) {
            this.groupName = groupName;
        }

        public final String getGroup() {
            return group;
        }

        @Override
        public final Builder group(String group) {
            this.group = group;
            return this;
        }

        public final void setGroup(String group) {
            this.group = group;
        }

        public final List<ResourceFilter.Builder> getFilters() {
            List<ResourceFilter.Builder> result = ResourceFilterListCopier.copyToBuilder(this.filters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder filters(Collection<ResourceFilter> filters) {
            this.filters = ResourceFilterListCopier.copy(filters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(ResourceFilter... filters) {
            filters(Arrays.asList(filters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(Consumer<ResourceFilter.Builder>... filters) {
            filters(Stream.of(filters).map(c -> ResourceFilter.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setFilters(Collection<ResourceFilter.BuilderImpl> filters) {
            this.filters = ResourceFilterListCopier.copyFromBuilder(filters);
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListGroupResourcesRequest build() {
            return new ListGroupResourcesRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
