/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.resourcegroups.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class PutGroupConfigurationRequest extends ResourceGroupsRequest implements
        ToCopyableBuilder<PutGroupConfigurationRequest.Builder, PutGroupConfigurationRequest> {
    private static final SdkField<String> GROUP_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Group")
            .getter(getter(PutGroupConfigurationRequest::group)).setter(setter(Builder::group))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Group").build()).build();

    private static final SdkField<List<GroupConfigurationItem>> CONFIGURATION_FIELD = SdkField
            .<List<GroupConfigurationItem>> builder(MarshallingType.LIST)
            .memberName("Configuration")
            .getter(getter(PutGroupConfigurationRequest::configuration))
            .setter(setter(Builder::configuration))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Configuration").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<GroupConfigurationItem> builder(MarshallingType.SDK_POJO)
                                            .constructor(GroupConfigurationItem::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GROUP_FIELD,
            CONFIGURATION_FIELD));

    private final String group;

    private final List<GroupConfigurationItem> configuration;

    private PutGroupConfigurationRequest(BuilderImpl builder) {
        super(builder);
        this.group = builder.group;
        this.configuration = builder.configuration;
    }

    /**
     * <p>
     * The name or ARN of the resource group with the configuration that you want to update.
     * </p>
     * 
     * @return The name or ARN of the resource group with the configuration that you want to update.
     */
    public final String group() {
        return group;
    }

    /**
     * For responses, this returns true if the service returned a value for the Configuration property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasConfiguration() {
        return configuration != null && !(configuration instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The new configuration to associate with the specified group. A configuration associates the resource group with
     * an AWS service and specifies how the service can interact with the resources in the group. A configuration is an
     * array of <a>GroupConfigurationItem</a> elements.
     * </p>
     * <p>
     * For information about the syntax of a service configuration, see <a
     * href="https://docs.aws.amazon.com/ARG/latest/APIReference/about-slg.html">Service configurations for resource
     * groups</a>.
     * </p>
     * <note>
     * <p>
     * A resource group can contain either a <code>Configuration</code> or a <code>ResourceQuery</code>, but not both.
     * </p>
     * </note>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasConfiguration} method.
     * </p>
     * 
     * @return The new configuration to associate with the specified group. A configuration associates the resource
     *         group with an AWS service and specifies how the service can interact with the resources in the group. A
     *         configuration is an array of <a>GroupConfigurationItem</a> elements.</p>
     *         <p>
     *         For information about the syntax of a service configuration, see <a
     *         href="https://docs.aws.amazon.com/ARG/latest/APIReference/about-slg.html">Service configurations for
     *         resource groups</a>.
     *         </p>
     *         <note>
     *         <p>
     *         A resource group can contain either a <code>Configuration</code> or a <code>ResourceQuery</code>, but not
     *         both.
     *         </p>
     */
    public final List<GroupConfigurationItem> configuration() {
        return configuration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(group());
        hashCode = 31 * hashCode + Objects.hashCode(hasConfiguration() ? configuration() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutGroupConfigurationRequest)) {
            return false;
        }
        PutGroupConfigurationRequest other = (PutGroupConfigurationRequest) obj;
        return Objects.equals(group(), other.group()) && hasConfiguration() == other.hasConfiguration()
                && Objects.equals(configuration(), other.configuration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PutGroupConfigurationRequest").add("Group", group())
                .add("Configuration", hasConfiguration() ? configuration() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Group":
            return Optional.ofNullable(clazz.cast(group()));
        case "Configuration":
            return Optional.ofNullable(clazz.cast(configuration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PutGroupConfigurationRequest, T> g) {
        return obj -> g.apply((PutGroupConfigurationRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ResourceGroupsRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, PutGroupConfigurationRequest> {
        /**
         * <p>
         * The name or ARN of the resource group with the configuration that you want to update.
         * </p>
         * 
         * @param group
         *        The name or ARN of the resource group with the configuration that you want to update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder group(String group);

        /**
         * <p>
         * The new configuration to associate with the specified group. A configuration associates the resource group
         * with an AWS service and specifies how the service can interact with the resources in the group. A
         * configuration is an array of <a>GroupConfigurationItem</a> elements.
         * </p>
         * <p>
         * For information about the syntax of a service configuration, see <a
         * href="https://docs.aws.amazon.com/ARG/latest/APIReference/about-slg.html">Service configurations for resource
         * groups</a>.
         * </p>
         * <note>
         * <p>
         * A resource group can contain either a <code>Configuration</code> or a <code>ResourceQuery</code>, but not
         * both.
         * </p>
         * </note>
         * 
         * @param configuration
         *        The new configuration to associate with the specified group. A configuration associates the resource
         *        group with an AWS service and specifies how the service can interact with the resources in the group.
         *        A configuration is an array of <a>GroupConfigurationItem</a> elements.</p>
         *        <p>
         *        For information about the syntax of a service configuration, see <a
         *        href="https://docs.aws.amazon.com/ARG/latest/APIReference/about-slg.html">Service configurations for
         *        resource groups</a>.
         *        </p>
         *        <note>
         *        <p>
         *        A resource group can contain either a <code>Configuration</code> or a <code>ResourceQuery</code>, but
         *        not both.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configuration(Collection<GroupConfigurationItem> configuration);

        /**
         * <p>
         * The new configuration to associate with the specified group. A configuration associates the resource group
         * with an AWS service and specifies how the service can interact with the resources in the group. A
         * configuration is an array of <a>GroupConfigurationItem</a> elements.
         * </p>
         * <p>
         * For information about the syntax of a service configuration, see <a
         * href="https://docs.aws.amazon.com/ARG/latest/APIReference/about-slg.html">Service configurations for resource
         * groups</a>.
         * </p>
         * <note>
         * <p>
         * A resource group can contain either a <code>Configuration</code> or a <code>ResourceQuery</code>, but not
         * both.
         * </p>
         * </note>
         * 
         * @param configuration
         *        The new configuration to associate with the specified group. A configuration associates the resource
         *        group with an AWS service and specifies how the service can interact with the resources in the group.
         *        A configuration is an array of <a>GroupConfigurationItem</a> elements.</p>
         *        <p>
         *        For information about the syntax of a service configuration, see <a
         *        href="https://docs.aws.amazon.com/ARG/latest/APIReference/about-slg.html">Service configurations for
         *        resource groups</a>.
         *        </p>
         *        <note>
         *        <p>
         *        A resource group can contain either a <code>Configuration</code> or a <code>ResourceQuery</code>, but
         *        not both.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configuration(GroupConfigurationItem... configuration);

        /**
         * <p>
         * The new configuration to associate with the specified group. A configuration associates the resource group
         * with an AWS service and specifies how the service can interact with the resources in the group. A
         * configuration is an array of <a>GroupConfigurationItem</a> elements.
         * </p>
         * <p>
         * For information about the syntax of a service configuration, see <a
         * href="https://docs.aws.amazon.com/ARG/latest/APIReference/about-slg.html">Service configurations for resource
         * groups</a>.
         * </p>
         * <note>
         * <p>
         * A resource group can contain either a <code>Configuration</code> or a <code>ResourceQuery</code>, but not
         * both.
         * </p>
         * </note> This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.resourcegroups.model.GroupConfigurationItem.Builder} avoiding the need
         * to create one manually via
         * {@link software.amazon.awssdk.services.resourcegroups.model.GroupConfigurationItem#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.resourcegroups.model.GroupConfigurationItem.Builder#build()} is called
         * immediately and its result is passed to {@link #configuration(List<GroupConfigurationItem>)}.
         * 
         * @param configuration
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.resourcegroups.model.GroupConfigurationItem.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #configuration(java.util.Collection<GroupConfigurationItem>)
         */
        Builder configuration(Consumer<GroupConfigurationItem.Builder>... configuration);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ResourceGroupsRequest.BuilderImpl implements Builder {
        private String group;

        private List<GroupConfigurationItem> configuration = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(PutGroupConfigurationRequest model) {
            super(model);
            group(model.group);
            configuration(model.configuration);
        }

        public final String getGroup() {
            return group;
        }

        public final void setGroup(String group) {
            this.group = group;
        }

        @Override
        public final Builder group(String group) {
            this.group = group;
            return this;
        }

        public final List<GroupConfigurationItem.Builder> getConfiguration() {
            List<GroupConfigurationItem.Builder> result = GroupConfigurationListCopier.copyToBuilder(this.configuration);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setConfiguration(Collection<GroupConfigurationItem.BuilderImpl> configuration) {
            this.configuration = GroupConfigurationListCopier.copyFromBuilder(configuration);
        }

        @Override
        public final Builder configuration(Collection<GroupConfigurationItem> configuration) {
            this.configuration = GroupConfigurationListCopier.copy(configuration);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder configuration(GroupConfigurationItem... configuration) {
            configuration(Arrays.asList(configuration));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder configuration(Consumer<GroupConfigurationItem.Builder>... configuration) {
            configuration(Stream.of(configuration).map(c -> GroupConfigurationItem.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PutGroupConfigurationRequest build() {
            return new PutGroupConfigurationRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
