/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.resourcegroups.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateGroupResponse extends ResourceGroupsResponse implements
        ToCopyableBuilder<CreateGroupResponse.Builder, CreateGroupResponse> {
    private static final SdkField<Group> GROUP_FIELD = SdkField.<Group> builder(MarshallingType.SDK_POJO)
            .getter(getter(CreateGroupResponse::group)).setter(setter(Builder::group)).constructor(Group::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Group").build()).build();

    private static final SdkField<ResourceQuery> RESOURCE_QUERY_FIELD = SdkField
            .<ResourceQuery> builder(MarshallingType.SDK_POJO).getter(getter(CreateGroupResponse::resourceQuery))
            .setter(setter(Builder::resourceQuery)).constructor(ResourceQuery::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceQuery").build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .getter(getter(CreateGroupResponse::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GROUP_FIELD,
            RESOURCE_QUERY_FIELD, TAGS_FIELD));

    private final Group group;

    private final ResourceQuery resourceQuery;

    private final Map<String, String> tags;

    private CreateGroupResponse(BuilderImpl builder) {
        super(builder);
        this.group = builder.group;
        this.resourceQuery = builder.resourceQuery;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * A full description of the resource group after it is created.
     * </p>
     * 
     * @return A full description of the resource group after it is created.
     */
    public Group group() {
        return group;
    }

    /**
     * <p>
     * The resource query associated with the group.
     * </p>
     * 
     * @return The resource query associated with the group.
     */
    public ResourceQuery resourceQuery() {
        return resourceQuery;
    }

    /**
     * <p>
     * The tags associated with the group.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The tags associated with the group.
     */
    public Map<String, String> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(group());
        hashCode = 31 * hashCode + Objects.hashCode(resourceQuery());
        hashCode = 31 * hashCode + Objects.hashCode(tags());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateGroupResponse)) {
            return false;
        }
        CreateGroupResponse other = (CreateGroupResponse) obj;
        return Objects.equals(group(), other.group()) && Objects.equals(resourceQuery(), other.resourceQuery())
                && Objects.equals(tags(), other.tags());
    }

    @Override
    public String toString() {
        return ToString.builder("CreateGroupResponse").add("Group", group()).add("ResourceQuery", resourceQuery())
                .add("Tags", tags()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Group":
            return Optional.ofNullable(clazz.cast(group()));
        case "ResourceQuery":
            return Optional.ofNullable(clazz.cast(resourceQuery()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateGroupResponse, T> g) {
        return obj -> g.apply((CreateGroupResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ResourceGroupsResponse.Builder, SdkPojo, CopyableBuilder<Builder, CreateGroupResponse> {
        /**
         * <p>
         * A full description of the resource group after it is created.
         * </p>
         * 
         * @param group
         *        A full description of the resource group after it is created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder group(Group group);

        /**
         * <p>
         * A full description of the resource group after it is created.
         * </p>
         * This is a convenience that creates an instance of the {@link Group.Builder} avoiding the need to create one
         * manually via {@link Group#builder()}.
         *
         * When the {@link Consumer} completes, {@link Group.Builder#build()} is called immediately and its result is
         * passed to {@link #group(Group)}.
         * 
         * @param group
         *        a consumer that will call methods on {@link Group.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #group(Group)
         */
        default Builder group(Consumer<Group.Builder> group) {
            return group(Group.builder().applyMutation(group).build());
        }

        /**
         * <p>
         * The resource query associated with the group.
         * </p>
         * 
         * @param resourceQuery
         *        The resource query associated with the group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceQuery(ResourceQuery resourceQuery);

        /**
         * <p>
         * The resource query associated with the group.
         * </p>
         * This is a convenience that creates an instance of the {@link ResourceQuery.Builder} avoiding the need to
         * create one manually via {@link ResourceQuery#builder()}.
         *
         * When the {@link Consumer} completes, {@link ResourceQuery.Builder#build()} is called immediately and its
         * result is passed to {@link #resourceQuery(ResourceQuery)}.
         * 
         * @param resourceQuery
         *        a consumer that will call methods on {@link ResourceQuery.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #resourceQuery(ResourceQuery)
         */
        default Builder resourceQuery(Consumer<ResourceQuery.Builder> resourceQuery) {
            return resourceQuery(ResourceQuery.builder().applyMutation(resourceQuery).build());
        }

        /**
         * <p>
         * The tags associated with the group.
         * </p>
         * 
         * @param tags
         *        The tags associated with the group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);
    }

    static final class BuilderImpl extends ResourceGroupsResponse.BuilderImpl implements Builder {
        private Group group;

        private ResourceQuery resourceQuery;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateGroupResponse model) {
            super(model);
            group(model.group);
            resourceQuery(model.resourceQuery);
            tags(model.tags);
        }

        public final Group.Builder getGroup() {
            return group != null ? group.toBuilder() : null;
        }

        @Override
        public final Builder group(Group group) {
            this.group = group;
            return this;
        }

        public final void setGroup(Group.BuilderImpl group) {
            this.group = group != null ? group.build() : null;
        }

        public final ResourceQuery.Builder getResourceQuery() {
            return resourceQuery != null ? resourceQuery.toBuilder() : null;
        }

        @Override
        public final Builder resourceQuery(ResourceQuery resourceQuery) {
            this.resourceQuery = resourceQuery;
            return this;
        }

        public final void setResourceQuery(ResourceQuery.BuilderImpl resourceQuery) {
            this.resourceQuery = resourceQuery != null ? resourceQuery.build() : null;
        }

        public final Map<String, String> getTags() {
            return tags;
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
        }

        @Override
        public CreateGroupResponse build() {
            return new CreateGroupResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
