/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.resourcegroups.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateGroupResponse extends ResourceGroupsResponse implements
        ToCopyableBuilder<CreateGroupResponse.Builder, CreateGroupResponse> {
    private static final SdkField<Group> GROUP_FIELD = SdkField.<Group> builder(MarshallingType.SDK_POJO).memberName("Group")
            .getter(getter(CreateGroupResponse::group)).setter(setter(Builder::group)).constructor(Group::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Group").build()).build();

    private static final SdkField<ResourceQuery> RESOURCE_QUERY_FIELD = SdkField
            .<ResourceQuery> builder(MarshallingType.SDK_POJO).memberName("ResourceQuery")
            .getter(getter(CreateGroupResponse::resourceQuery)).setter(setter(Builder::resourceQuery))
            .constructor(ResourceQuery::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceQuery").build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("Tags")
            .getter(getter(CreateGroupResponse::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<GroupConfiguration> GROUP_CONFIGURATION_FIELD = SdkField
            .<GroupConfiguration> builder(MarshallingType.SDK_POJO).memberName("GroupConfiguration")
            .getter(getter(CreateGroupResponse::groupConfiguration)).setter(setter(Builder::groupConfiguration))
            .constructor(GroupConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GroupConfiguration").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GROUP_FIELD,
            RESOURCE_QUERY_FIELD, TAGS_FIELD, GROUP_CONFIGURATION_FIELD));

    private final Group group;

    private final ResourceQuery resourceQuery;

    private final Map<String, String> tags;

    private final GroupConfiguration groupConfiguration;

    private CreateGroupResponse(BuilderImpl builder) {
        super(builder);
        this.group = builder.group;
        this.resourceQuery = builder.resourceQuery;
        this.tags = builder.tags;
        this.groupConfiguration = builder.groupConfiguration;
    }

    /**
     * <p>
     * The description of the resource group.
     * </p>
     * 
     * @return The description of the resource group.
     */
    public final Group group() {
        return group;
    }

    /**
     * <p>
     * The resource query associated with the group. For more information about resource queries, see <a
     * href="https://docs.aws.amazon.com/ARG/latest/userguide/gettingstarted-query.html#gettingstarted-query-cli-tag"
     * >Create a tag-based group in Resource Groups</a>.
     * </p>
     * 
     * @return The resource query associated with the group. For more information about resource queries, see <a
     *         href="https://docs.aws.amazon.com/ARG/latest/userguide/gettingstarted-query.html#gettingstarted-query-cli-tag"
     *         >Create a tag-based group in Resource Groups</a>.
     */
    public final ResourceQuery resourceQuery() {
        return resourceQuery;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The tags associated with the group.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return The tags associated with the group.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    /**
     * <p>
     * The service configuration associated with the resource group. For details about the syntax of a service
     * configuration, see <a href="https://docs.aws.amazon.com/ARG/latest/APIReference/about-slg.html">Service
     * configurations for Resource Groups</a>.
     * </p>
     * 
     * @return The service configuration associated with the resource group. For details about the syntax of a service
     *         configuration, see <a href="https://docs.aws.amazon.com/ARG/latest/APIReference/about-slg.html">Service
     *         configurations for Resource Groups</a>.
     */
    public final GroupConfiguration groupConfiguration() {
        return groupConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(group());
        hashCode = 31 * hashCode + Objects.hashCode(resourceQuery());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(groupConfiguration());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateGroupResponse)) {
            return false;
        }
        CreateGroupResponse other = (CreateGroupResponse) obj;
        return Objects.equals(group(), other.group()) && Objects.equals(resourceQuery(), other.resourceQuery())
                && hasTags() == other.hasTags() && Objects.equals(tags(), other.tags())
                && Objects.equals(groupConfiguration(), other.groupConfiguration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateGroupResponse").add("Group", group()).add("ResourceQuery", resourceQuery())
                .add("Tags", hasTags() ? tags() : null).add("GroupConfiguration", groupConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Group":
            return Optional.ofNullable(clazz.cast(group()));
        case "ResourceQuery":
            return Optional.ofNullable(clazz.cast(resourceQuery()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "GroupConfiguration":
            return Optional.ofNullable(clazz.cast(groupConfiguration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateGroupResponse, T> g) {
        return obj -> g.apply((CreateGroupResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ResourceGroupsResponse.Builder, SdkPojo, CopyableBuilder<Builder, CreateGroupResponse> {
        /**
         * <p>
         * The description of the resource group.
         * </p>
         * 
         * @param group
         *        The description of the resource group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder group(Group group);

        /**
         * <p>
         * The description of the resource group.
         * </p>
         * This is a convenience method that creates an instance of the {@link Group.Builder} avoiding the need to
         * create one manually via {@link Group#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Group.Builder#build()} is called immediately and its result is
         * passed to {@link #group(Group)}.
         * 
         * @param group
         *        a consumer that will call methods on {@link Group.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #group(Group)
         */
        default Builder group(Consumer<Group.Builder> group) {
            return group(Group.builder().applyMutation(group).build());
        }

        /**
         * <p>
         * The resource query associated with the group. For more information about resource queries, see <a href=
         * "https://docs.aws.amazon.com/ARG/latest/userguide/gettingstarted-query.html#gettingstarted-query-cli-tag"
         * >Create a tag-based group in Resource Groups</a>.
         * </p>
         * 
         * @param resourceQuery
         *        The resource query associated with the group. For more information about resource queries, see <a
         *        href=
         *        "https://docs.aws.amazon.com/ARG/latest/userguide/gettingstarted-query.html#gettingstarted-query-cli-tag"
         *        >Create a tag-based group in Resource Groups</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceQuery(ResourceQuery resourceQuery);

        /**
         * <p>
         * The resource query associated with the group. For more information about resource queries, see <a href=
         * "https://docs.aws.amazon.com/ARG/latest/userguide/gettingstarted-query.html#gettingstarted-query-cli-tag"
         * >Create a tag-based group in Resource Groups</a>.
         * </p>
         * This is a convenience method that creates an instance of the {@link ResourceQuery.Builder} avoiding the need
         * to create one manually via {@link ResourceQuery#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ResourceQuery.Builder#build()} is called immediately and its
         * result is passed to {@link #resourceQuery(ResourceQuery)}.
         * 
         * @param resourceQuery
         *        a consumer that will call methods on {@link ResourceQuery.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #resourceQuery(ResourceQuery)
         */
        default Builder resourceQuery(Consumer<ResourceQuery.Builder> resourceQuery) {
            return resourceQuery(ResourceQuery.builder().applyMutation(resourceQuery).build());
        }

        /**
         * <p>
         * The tags associated with the group.
         * </p>
         * 
         * @param tags
         *        The tags associated with the group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);

        /**
         * <p>
         * The service configuration associated with the resource group. For details about the syntax of a service
         * configuration, see <a href="https://docs.aws.amazon.com/ARG/latest/APIReference/about-slg.html">Service
         * configurations for Resource Groups</a>.
         * </p>
         * 
         * @param groupConfiguration
         *        The service configuration associated with the resource group. For details about the syntax of a
         *        service configuration, see <a
         *        href="https://docs.aws.amazon.com/ARG/latest/APIReference/about-slg.html">Service configurations for
         *        Resource Groups</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder groupConfiguration(GroupConfiguration groupConfiguration);

        /**
         * <p>
         * The service configuration associated with the resource group. For details about the syntax of a service
         * configuration, see <a href="https://docs.aws.amazon.com/ARG/latest/APIReference/about-slg.html">Service
         * configurations for Resource Groups</a>.
         * </p>
         * This is a convenience method that creates an instance of the {@link GroupConfiguration.Builder} avoiding the
         * need to create one manually via {@link GroupConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link GroupConfiguration.Builder#build()} is called immediately and its
         * result is passed to {@link #groupConfiguration(GroupConfiguration)}.
         * 
         * @param groupConfiguration
         *        a consumer that will call methods on {@link GroupConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #groupConfiguration(GroupConfiguration)
         */
        default Builder groupConfiguration(Consumer<GroupConfiguration.Builder> groupConfiguration) {
            return groupConfiguration(GroupConfiguration.builder().applyMutation(groupConfiguration).build());
        }
    }

    static final class BuilderImpl extends ResourceGroupsResponse.BuilderImpl implements Builder {
        private Group group;

        private ResourceQuery resourceQuery;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private GroupConfiguration groupConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateGroupResponse model) {
            super(model);
            group(model.group);
            resourceQuery(model.resourceQuery);
            tags(model.tags);
            groupConfiguration(model.groupConfiguration);
        }

        public final Group.Builder getGroup() {
            return group != null ? group.toBuilder() : null;
        }

        public final void setGroup(Group.BuilderImpl group) {
            this.group = group != null ? group.build() : null;
        }

        @Override
        public final Builder group(Group group) {
            this.group = group;
            return this;
        }

        public final ResourceQuery.Builder getResourceQuery() {
            return resourceQuery != null ? resourceQuery.toBuilder() : null;
        }

        public final void setResourceQuery(ResourceQuery.BuilderImpl resourceQuery) {
            this.resourceQuery = resourceQuery != null ? resourceQuery.build() : null;
        }

        @Override
        public final Builder resourceQuery(ResourceQuery resourceQuery) {
            this.resourceQuery = resourceQuery;
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        public final GroupConfiguration.Builder getGroupConfiguration() {
            return groupConfiguration != null ? groupConfiguration.toBuilder() : null;
        }

        public final void setGroupConfiguration(GroupConfiguration.BuilderImpl groupConfiguration) {
            this.groupConfiguration = groupConfiguration != null ? groupConfiguration.build() : null;
        }

        @Override
        public final Builder groupConfiguration(GroupConfiguration groupConfiguration) {
            this.groupConfiguration = groupConfiguration;
            return this;
        }

        @Override
        public CreateGroupResponse build() {
            return new CreateGroupResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
