/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.resourcegroups.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The Resource Groups settings for this Amazon Web Services account.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AccountSettings implements SdkPojo, Serializable, ToCopyableBuilder<AccountSettings.Builder, AccountSettings> {
    private static final SdkField<String> GROUP_LIFECYCLE_EVENTS_DESIRED_STATUS_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("GroupLifecycleEventsDesiredStatus")
            .getter(getter(AccountSettings::groupLifecycleEventsDesiredStatusAsString))
            .setter(setter(Builder::groupLifecycleEventsDesiredStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GroupLifecycleEventsDesiredStatus")
                    .build()).build();

    private static final SdkField<String> GROUP_LIFECYCLE_EVENTS_STATUS_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("GroupLifecycleEventsStatus")
            .getter(getter(AccountSettings::groupLifecycleEventsStatusAsString))
            .setter(setter(Builder::groupLifecycleEventsStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GroupLifecycleEventsStatus").build())
            .build();

    private static final SdkField<String> GROUP_LIFECYCLE_EVENTS_STATUS_MESSAGE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("GroupLifecycleEventsStatusMessage")
            .getter(getter(AccountSettings::groupLifecycleEventsStatusMessage))
            .setter(setter(Builder::groupLifecycleEventsStatusMessage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GroupLifecycleEventsStatusMessage")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            GROUP_LIFECYCLE_EVENTS_DESIRED_STATUS_FIELD, GROUP_LIFECYCLE_EVENTS_STATUS_FIELD,
            GROUP_LIFECYCLE_EVENTS_STATUS_MESSAGE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String groupLifecycleEventsDesiredStatus;

    private final String groupLifecycleEventsStatus;

    private final String groupLifecycleEventsStatusMessage;

    private AccountSettings(BuilderImpl builder) {
        this.groupLifecycleEventsDesiredStatus = builder.groupLifecycleEventsDesiredStatus;
        this.groupLifecycleEventsStatus = builder.groupLifecycleEventsStatus;
        this.groupLifecycleEventsStatusMessage = builder.groupLifecycleEventsStatusMessage;
    }

    /**
     * <p>
     * The desired target status of the group lifecycle events feature. If
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #groupLifecycleEventsDesiredStatus} will return
     * {@link GroupLifecycleEventsDesiredStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #groupLifecycleEventsDesiredStatusAsString}.
     * </p>
     * 
     * @return The desired target status of the group lifecycle events feature. If
     * @see GroupLifecycleEventsDesiredStatus
     */
    public final GroupLifecycleEventsDesiredStatus groupLifecycleEventsDesiredStatus() {
        return GroupLifecycleEventsDesiredStatus.fromValue(groupLifecycleEventsDesiredStatus);
    }

    /**
     * <p>
     * The desired target status of the group lifecycle events feature. If
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #groupLifecycleEventsDesiredStatus} will return
     * {@link GroupLifecycleEventsDesiredStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #groupLifecycleEventsDesiredStatusAsString}.
     * </p>
     * 
     * @return The desired target status of the group lifecycle events feature. If
     * @see GroupLifecycleEventsDesiredStatus
     */
    public final String groupLifecycleEventsDesiredStatusAsString() {
        return groupLifecycleEventsDesiredStatus;
    }

    /**
     * <p>
     * The current status of the group lifecycle events feature.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #groupLifecycleEventsStatus} will return {@link GroupLifecycleEventsStatus#UNKNOWN_TO_SDK_VERSION}. The
     * raw value returned by the service is available from {@link #groupLifecycleEventsStatusAsString}.
     * </p>
     * 
     * @return The current status of the group lifecycle events feature.
     * @see GroupLifecycleEventsStatus
     */
    public final GroupLifecycleEventsStatus groupLifecycleEventsStatus() {
        return GroupLifecycleEventsStatus.fromValue(groupLifecycleEventsStatus);
    }

    /**
     * <p>
     * The current status of the group lifecycle events feature.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #groupLifecycleEventsStatus} will return {@link GroupLifecycleEventsStatus#UNKNOWN_TO_SDK_VERSION}. The
     * raw value returned by the service is available from {@link #groupLifecycleEventsStatusAsString}.
     * </p>
     * 
     * @return The current status of the group lifecycle events feature.
     * @see GroupLifecycleEventsStatus
     */
    public final String groupLifecycleEventsStatusAsString() {
        return groupLifecycleEventsStatus;
    }

    /**
     * <p>
     * The text of any error message occurs during an attempt to turn group lifecycle events on or off.
     * </p>
     * 
     * @return The text of any error message occurs during an attempt to turn group lifecycle events on or off.
     */
    public final String groupLifecycleEventsStatusMessage() {
        return groupLifecycleEventsStatusMessage;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(groupLifecycleEventsDesiredStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(groupLifecycleEventsStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(groupLifecycleEventsStatusMessage());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AccountSettings)) {
            return false;
        }
        AccountSettings other = (AccountSettings) obj;
        return Objects.equals(groupLifecycleEventsDesiredStatusAsString(), other.groupLifecycleEventsDesiredStatusAsString())
                && Objects.equals(groupLifecycleEventsStatusAsString(), other.groupLifecycleEventsStatusAsString())
                && Objects.equals(groupLifecycleEventsStatusMessage(), other.groupLifecycleEventsStatusMessage());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AccountSettings")
                .add("GroupLifecycleEventsDesiredStatus", groupLifecycleEventsDesiredStatusAsString())
                .add("GroupLifecycleEventsStatus", groupLifecycleEventsStatusAsString())
                .add("GroupLifecycleEventsStatusMessage", groupLifecycleEventsStatusMessage()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "GroupLifecycleEventsDesiredStatus":
            return Optional.ofNullable(clazz.cast(groupLifecycleEventsDesiredStatusAsString()));
        case "GroupLifecycleEventsStatus":
            return Optional.ofNullable(clazz.cast(groupLifecycleEventsStatusAsString()));
        case "GroupLifecycleEventsStatusMessage":
            return Optional.ofNullable(clazz.cast(groupLifecycleEventsStatusMessage()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AccountSettings, T> g) {
        return obj -> g.apply((AccountSettings) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AccountSettings> {
        /**
         * <p>
         * The desired target status of the group lifecycle events feature. If
         * </p>
         * 
         * @param groupLifecycleEventsDesiredStatus
         *        The desired target status of the group lifecycle events feature. If
         * @see GroupLifecycleEventsDesiredStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see GroupLifecycleEventsDesiredStatus
         */
        Builder groupLifecycleEventsDesiredStatus(String groupLifecycleEventsDesiredStatus);

        /**
         * <p>
         * The desired target status of the group lifecycle events feature. If
         * </p>
         * 
         * @param groupLifecycleEventsDesiredStatus
         *        The desired target status of the group lifecycle events feature. If
         * @see GroupLifecycleEventsDesiredStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see GroupLifecycleEventsDesiredStatus
         */
        Builder groupLifecycleEventsDesiredStatus(GroupLifecycleEventsDesiredStatus groupLifecycleEventsDesiredStatus);

        /**
         * <p>
         * The current status of the group lifecycle events feature.
         * </p>
         * 
         * @param groupLifecycleEventsStatus
         *        The current status of the group lifecycle events feature.
         * @see GroupLifecycleEventsStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see GroupLifecycleEventsStatus
         */
        Builder groupLifecycleEventsStatus(String groupLifecycleEventsStatus);

        /**
         * <p>
         * The current status of the group lifecycle events feature.
         * </p>
         * 
         * @param groupLifecycleEventsStatus
         *        The current status of the group lifecycle events feature.
         * @see GroupLifecycleEventsStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see GroupLifecycleEventsStatus
         */
        Builder groupLifecycleEventsStatus(GroupLifecycleEventsStatus groupLifecycleEventsStatus);

        /**
         * <p>
         * The text of any error message occurs during an attempt to turn group lifecycle events on or off.
         * </p>
         * 
         * @param groupLifecycleEventsStatusMessage
         *        The text of any error message occurs during an attempt to turn group lifecycle events on or off.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder groupLifecycleEventsStatusMessage(String groupLifecycleEventsStatusMessage);
    }

    static final class BuilderImpl implements Builder {
        private String groupLifecycleEventsDesiredStatus;

        private String groupLifecycleEventsStatus;

        private String groupLifecycleEventsStatusMessage;

        private BuilderImpl() {
        }

        private BuilderImpl(AccountSettings model) {
            groupLifecycleEventsDesiredStatus(model.groupLifecycleEventsDesiredStatus);
            groupLifecycleEventsStatus(model.groupLifecycleEventsStatus);
            groupLifecycleEventsStatusMessage(model.groupLifecycleEventsStatusMessage);
        }

        public final String getGroupLifecycleEventsDesiredStatus() {
            return groupLifecycleEventsDesiredStatus;
        }

        public final void setGroupLifecycleEventsDesiredStatus(String groupLifecycleEventsDesiredStatus) {
            this.groupLifecycleEventsDesiredStatus = groupLifecycleEventsDesiredStatus;
        }

        @Override
        public final Builder groupLifecycleEventsDesiredStatus(String groupLifecycleEventsDesiredStatus) {
            this.groupLifecycleEventsDesiredStatus = groupLifecycleEventsDesiredStatus;
            return this;
        }

        @Override
        public final Builder groupLifecycleEventsDesiredStatus(GroupLifecycleEventsDesiredStatus groupLifecycleEventsDesiredStatus) {
            this.groupLifecycleEventsDesiredStatus(groupLifecycleEventsDesiredStatus == null ? null
                    : groupLifecycleEventsDesiredStatus.toString());
            return this;
        }

        public final String getGroupLifecycleEventsStatus() {
            return groupLifecycleEventsStatus;
        }

        public final void setGroupLifecycleEventsStatus(String groupLifecycleEventsStatus) {
            this.groupLifecycleEventsStatus = groupLifecycleEventsStatus;
        }

        @Override
        public final Builder groupLifecycleEventsStatus(String groupLifecycleEventsStatus) {
            this.groupLifecycleEventsStatus = groupLifecycleEventsStatus;
            return this;
        }

        @Override
        public final Builder groupLifecycleEventsStatus(GroupLifecycleEventsStatus groupLifecycleEventsStatus) {
            this.groupLifecycleEventsStatus(groupLifecycleEventsStatus == null ? null : groupLifecycleEventsStatus.toString());
            return this;
        }

        public final String getGroupLifecycleEventsStatusMessage() {
            return groupLifecycleEventsStatusMessage;
        }

        public final void setGroupLifecycleEventsStatusMessage(String groupLifecycleEventsStatusMessage) {
            this.groupLifecycleEventsStatusMessage = groupLifecycleEventsStatusMessage;
        }

        @Override
        public final Builder groupLifecycleEventsStatusMessage(String groupLifecycleEventsStatusMessage) {
            this.groupLifecycleEventsStatusMessage = groupLifecycleEventsStatusMessage;
            return this;
        }

        @Override
        public AccountSettings build() {
            return new AccountSettings(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
