/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.resourcegroups.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The information about a grouping or ungrouping resource action.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class GroupingStatusesItem implements SdkPojo, Serializable,
        ToCopyableBuilder<GroupingStatusesItem.Builder, GroupingStatusesItem> {
    private static final SdkField<String> RESOURCE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ResourceArn").getter(getter(GroupingStatusesItem::resourceArn)).setter(setter(Builder::resourceArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceArn").build()).build();

    private static final SdkField<String> ACTION_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Action")
            .getter(getter(GroupingStatusesItem::actionAsString)).setter(setter(Builder::action))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Action").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(GroupingStatusesItem::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<String> ERROR_MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ErrorMessage").getter(getter(GroupingStatusesItem::errorMessage)).setter(setter(Builder::errorMessage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ErrorMessage").build()).build();

    private static final SdkField<String> ERROR_CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ErrorCode").getter(getter(GroupingStatusesItem::errorCode)).setter(setter(Builder::errorCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ErrorCode").build()).build();

    private static final SdkField<Instant> UPDATED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("UpdatedAt").getter(getter(GroupingStatusesItem::updatedAt)).setter(setter(Builder::updatedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UpdatedAt").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESOURCE_ARN_FIELD,
            ACTION_FIELD, STATUS_FIELD, ERROR_MESSAGE_FIELD, ERROR_CODE_FIELD, UPDATED_AT_FIELD));

    private static final long serialVersionUID = 1L;

    private final String resourceArn;

    private final String action;

    private final String status;

    private final String errorMessage;

    private final String errorCode;

    private final Instant updatedAt;

    private GroupingStatusesItem(BuilderImpl builder) {
        this.resourceArn = builder.resourceArn;
        this.action = builder.action;
        this.status = builder.status;
        this.errorMessage = builder.errorMessage;
        this.errorCode = builder.errorCode;
        this.updatedAt = builder.updatedAt;
    }

    /**
     * <p>
     * The Amazon resource name (ARN) of a resource.
     * </p>
     * 
     * @return The Amazon resource name (ARN) of a resource.
     */
    public final String resourceArn() {
        return resourceArn;
    }

    /**
     * <p>
     * Describes the resource grouping action with values of <code>GROUP</code> or <code>UNGROUP</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #action} will
     * return {@link GroupingType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #actionAsString}.
     * </p>
     * 
     * @return Describes the resource grouping action with values of <code>GROUP</code> or <code>UNGROUP</code>.
     * @see GroupingType
     */
    public final GroupingType action() {
        return GroupingType.fromValue(action);
    }

    /**
     * <p>
     * Describes the resource grouping action with values of <code>GROUP</code> or <code>UNGROUP</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #action} will
     * return {@link GroupingType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #actionAsString}.
     * </p>
     * 
     * @return Describes the resource grouping action with values of <code>GROUP</code> or <code>UNGROUP</code>.
     * @see GroupingType
     */
    public final String actionAsString() {
        return action;
    }

    /**
     * <p>
     * Describes the resource grouping status with values of <code>SUCCESS</code>, <code>FAILED</code>,
     * <code>IN_PROGRESS</code>, or <code>SKIPPED</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link GroupingStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return Describes the resource grouping status with values of <code>SUCCESS</code>, <code>FAILED</code>,
     *         <code>IN_PROGRESS</code>, or <code>SKIPPED</code>.
     * @see GroupingStatus
     */
    public final GroupingStatus status() {
        return GroupingStatus.fromValue(status);
    }

    /**
     * <p>
     * Describes the resource grouping status with values of <code>SUCCESS</code>, <code>FAILED</code>,
     * <code>IN_PROGRESS</code>, or <code>SKIPPED</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link GroupingStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return Describes the resource grouping status with values of <code>SUCCESS</code>, <code>FAILED</code>,
     *         <code>IN_PROGRESS</code>, or <code>SKIPPED</code>.
     * @see GroupingStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * A message that explains the <code>ErrorCode</code>.
     * </p>
     * 
     * @return A message that explains the <code>ErrorCode</code>.
     */
    public final String errorMessage() {
        return errorMessage;
    }

    /**
     * <p>
     * Specifies the error code that was raised.
     * </p>
     * 
     * @return Specifies the error code that was raised.
     */
    public final String errorCode() {
        return errorCode;
    }

    /**
     * <p>
     * A timestamp of when the status was last updated.
     * </p>
     * 
     * @return A timestamp of when the status was last updated.
     */
    public final Instant updatedAt() {
        return updatedAt;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(resourceArn());
        hashCode = 31 * hashCode + Objects.hashCode(actionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(errorMessage());
        hashCode = 31 * hashCode + Objects.hashCode(errorCode());
        hashCode = 31 * hashCode + Objects.hashCode(updatedAt());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GroupingStatusesItem)) {
            return false;
        }
        GroupingStatusesItem other = (GroupingStatusesItem) obj;
        return Objects.equals(resourceArn(), other.resourceArn()) && Objects.equals(actionAsString(), other.actionAsString())
                && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(errorMessage(), other.errorMessage()) && Objects.equals(errorCode(), other.errorCode())
                && Objects.equals(updatedAt(), other.updatedAt());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GroupingStatusesItem").add("ResourceArn", resourceArn()).add("Action", actionAsString())
                .add("Status", statusAsString()).add("ErrorMessage", errorMessage()).add("ErrorCode", errorCode())
                .add("UpdatedAt", updatedAt()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ResourceArn":
            return Optional.ofNullable(clazz.cast(resourceArn()));
        case "Action":
            return Optional.ofNullable(clazz.cast(actionAsString()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "ErrorMessage":
            return Optional.ofNullable(clazz.cast(errorMessage()));
        case "ErrorCode":
            return Optional.ofNullable(clazz.cast(errorCode()));
        case "UpdatedAt":
            return Optional.ofNullable(clazz.cast(updatedAt()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GroupingStatusesItem, T> g) {
        return obj -> g.apply((GroupingStatusesItem) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, GroupingStatusesItem> {
        /**
         * <p>
         * The Amazon resource name (ARN) of a resource.
         * </p>
         * 
         * @param resourceArn
         *        The Amazon resource name (ARN) of a resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceArn(String resourceArn);

        /**
         * <p>
         * Describes the resource grouping action with values of <code>GROUP</code> or <code>UNGROUP</code>.
         * </p>
         * 
         * @param action
         *        Describes the resource grouping action with values of <code>GROUP</code> or <code>UNGROUP</code>.
         * @see GroupingType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see GroupingType
         */
        Builder action(String action);

        /**
         * <p>
         * Describes the resource grouping action with values of <code>GROUP</code> or <code>UNGROUP</code>.
         * </p>
         * 
         * @param action
         *        Describes the resource grouping action with values of <code>GROUP</code> or <code>UNGROUP</code>.
         * @see GroupingType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see GroupingType
         */
        Builder action(GroupingType action);

        /**
         * <p>
         * Describes the resource grouping status with values of <code>SUCCESS</code>, <code>FAILED</code>,
         * <code>IN_PROGRESS</code>, or <code>SKIPPED</code>.
         * </p>
         * 
         * @param status
         *        Describes the resource grouping status with values of <code>SUCCESS</code>, <code>FAILED</code>,
         *        <code>IN_PROGRESS</code>, or <code>SKIPPED</code>.
         * @see GroupingStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see GroupingStatus
         */
        Builder status(String status);

        /**
         * <p>
         * Describes the resource grouping status with values of <code>SUCCESS</code>, <code>FAILED</code>,
         * <code>IN_PROGRESS</code>, or <code>SKIPPED</code>.
         * </p>
         * 
         * @param status
         *        Describes the resource grouping status with values of <code>SUCCESS</code>, <code>FAILED</code>,
         *        <code>IN_PROGRESS</code>, or <code>SKIPPED</code>.
         * @see GroupingStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see GroupingStatus
         */
        Builder status(GroupingStatus status);

        /**
         * <p>
         * A message that explains the <code>ErrorCode</code>.
         * </p>
         * 
         * @param errorMessage
         *        A message that explains the <code>ErrorCode</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errorMessage(String errorMessage);

        /**
         * <p>
         * Specifies the error code that was raised.
         * </p>
         * 
         * @param errorCode
         *        Specifies the error code that was raised.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errorCode(String errorCode);

        /**
         * <p>
         * A timestamp of when the status was last updated.
         * </p>
         * 
         * @param updatedAt
         *        A timestamp of when the status was last updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updatedAt(Instant updatedAt);
    }

    static final class BuilderImpl implements Builder {
        private String resourceArn;

        private String action;

        private String status;

        private String errorMessage;

        private String errorCode;

        private Instant updatedAt;

        private BuilderImpl() {
        }

        private BuilderImpl(GroupingStatusesItem model) {
            resourceArn(model.resourceArn);
            action(model.action);
            status(model.status);
            errorMessage(model.errorMessage);
            errorCode(model.errorCode);
            updatedAt(model.updatedAt);
        }

        public final String getResourceArn() {
            return resourceArn;
        }

        public final void setResourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
        }

        @Override
        public final Builder resourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
            return this;
        }

        public final String getAction() {
            return action;
        }

        public final void setAction(String action) {
            this.action = action;
        }

        @Override
        public final Builder action(String action) {
            this.action = action;
            return this;
        }

        @Override
        public final Builder action(GroupingType action) {
            this.action(action == null ? null : action.toString());
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(GroupingStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getErrorMessage() {
            return errorMessage;
        }

        public final void setErrorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
        }

        @Override
        public final Builder errorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
            return this;
        }

        public final String getErrorCode() {
            return errorCode;
        }

        public final void setErrorCode(String errorCode) {
            this.errorCode = errorCode;
        }

        @Override
        public final Builder errorCode(String errorCode) {
            this.errorCode = errorCode;
            return this;
        }

        public final Instant getUpdatedAt() {
            return updatedAt;
        }

        public final void setUpdatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
        }

        @Override
        public final Builder updatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        @Override
        public GroupingStatusesItem build() {
            return new GroupingStatusesItem(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
