/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.resourcegroups.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateAccountSettingsRequest extends ResourceGroupsRequest implements
        ToCopyableBuilder<UpdateAccountSettingsRequest.Builder, UpdateAccountSettingsRequest> {
    private static final SdkField<String> GROUP_LIFECYCLE_EVENTS_DESIRED_STATUS_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("GroupLifecycleEventsDesiredStatus")
            .getter(getter(UpdateAccountSettingsRequest::groupLifecycleEventsDesiredStatusAsString))
            .setter(setter(Builder::groupLifecycleEventsDesiredStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GroupLifecycleEventsDesiredStatus")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(GROUP_LIFECYCLE_EVENTS_DESIRED_STATUS_FIELD));

    private final String groupLifecycleEventsDesiredStatus;

    private UpdateAccountSettingsRequest(BuilderImpl builder) {
        super(builder);
        this.groupLifecycleEventsDesiredStatus = builder.groupLifecycleEventsDesiredStatus;
    }

    /**
     * <p>
     * Specifies whether you want to turn <a
     * href="https://docs.aws.amazon.com/ARG/latest/userguide/monitor-groups.html">group lifecycle events</a> on or off.
     * </p>
     * <p>
     * You can't turn on group lifecycle events if your resource groups quota is greater than 2,000.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #groupLifecycleEventsDesiredStatus} will return
     * {@link GroupLifecycleEventsDesiredStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #groupLifecycleEventsDesiredStatusAsString}.
     * </p>
     * 
     * @return Specifies whether you want to turn <a
     *         href="https://docs.aws.amazon.com/ARG/latest/userguide/monitor-groups.html">group lifecycle events</a> on
     *         or off.</p>
     *         <p>
     *         You can't turn on group lifecycle events if your resource groups quota is greater than 2,000.
     * @see GroupLifecycleEventsDesiredStatus
     */
    public final GroupLifecycleEventsDesiredStatus groupLifecycleEventsDesiredStatus() {
        return GroupLifecycleEventsDesiredStatus.fromValue(groupLifecycleEventsDesiredStatus);
    }

    /**
     * <p>
     * Specifies whether you want to turn <a
     * href="https://docs.aws.amazon.com/ARG/latest/userguide/monitor-groups.html">group lifecycle events</a> on or off.
     * </p>
     * <p>
     * You can't turn on group lifecycle events if your resource groups quota is greater than 2,000.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #groupLifecycleEventsDesiredStatus} will return
     * {@link GroupLifecycleEventsDesiredStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #groupLifecycleEventsDesiredStatusAsString}.
     * </p>
     * 
     * @return Specifies whether you want to turn <a
     *         href="https://docs.aws.amazon.com/ARG/latest/userguide/monitor-groups.html">group lifecycle events</a> on
     *         or off.</p>
     *         <p>
     *         You can't turn on group lifecycle events if your resource groups quota is greater than 2,000.
     * @see GroupLifecycleEventsDesiredStatus
     */
    public final String groupLifecycleEventsDesiredStatusAsString() {
        return groupLifecycleEventsDesiredStatus;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(groupLifecycleEventsDesiredStatusAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateAccountSettingsRequest)) {
            return false;
        }
        UpdateAccountSettingsRequest other = (UpdateAccountSettingsRequest) obj;
        return Objects.equals(groupLifecycleEventsDesiredStatusAsString(), other.groupLifecycleEventsDesiredStatusAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateAccountSettingsRequest")
                .add("GroupLifecycleEventsDesiredStatus", groupLifecycleEventsDesiredStatusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "GroupLifecycleEventsDesiredStatus":
            return Optional.ofNullable(clazz.cast(groupLifecycleEventsDesiredStatusAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateAccountSettingsRequest, T> g) {
        return obj -> g.apply((UpdateAccountSettingsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ResourceGroupsRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, UpdateAccountSettingsRequest> {
        /**
         * <p>
         * Specifies whether you want to turn <a
         * href="https://docs.aws.amazon.com/ARG/latest/userguide/monitor-groups.html">group lifecycle events</a> on or
         * off.
         * </p>
         * <p>
         * You can't turn on group lifecycle events if your resource groups quota is greater than 2,000.
         * </p>
         * 
         * @param groupLifecycleEventsDesiredStatus
         *        Specifies whether you want to turn <a
         *        href="https://docs.aws.amazon.com/ARG/latest/userguide/monitor-groups.html">group lifecycle events</a>
         *        on or off.</p>
         *        <p>
         *        You can't turn on group lifecycle events if your resource groups quota is greater than 2,000.
         * @see GroupLifecycleEventsDesiredStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see GroupLifecycleEventsDesiredStatus
         */
        Builder groupLifecycleEventsDesiredStatus(String groupLifecycleEventsDesiredStatus);

        /**
         * <p>
         * Specifies whether you want to turn <a
         * href="https://docs.aws.amazon.com/ARG/latest/userguide/monitor-groups.html">group lifecycle events</a> on or
         * off.
         * </p>
         * <p>
         * You can't turn on group lifecycle events if your resource groups quota is greater than 2,000.
         * </p>
         * 
         * @param groupLifecycleEventsDesiredStatus
         *        Specifies whether you want to turn <a
         *        href="https://docs.aws.amazon.com/ARG/latest/userguide/monitor-groups.html">group lifecycle events</a>
         *        on or off.</p>
         *        <p>
         *        You can't turn on group lifecycle events if your resource groups quota is greater than 2,000.
         * @see GroupLifecycleEventsDesiredStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see GroupLifecycleEventsDesiredStatus
         */
        Builder groupLifecycleEventsDesiredStatus(GroupLifecycleEventsDesiredStatus groupLifecycleEventsDesiredStatus);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ResourceGroupsRequest.BuilderImpl implements Builder {
        private String groupLifecycleEventsDesiredStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateAccountSettingsRequest model) {
            super(model);
            groupLifecycleEventsDesiredStatus(model.groupLifecycleEventsDesiredStatus);
        }

        public final String getGroupLifecycleEventsDesiredStatus() {
            return groupLifecycleEventsDesiredStatus;
        }

        public final void setGroupLifecycleEventsDesiredStatus(String groupLifecycleEventsDesiredStatus) {
            this.groupLifecycleEventsDesiredStatus = groupLifecycleEventsDesiredStatus;
        }

        @Override
        public final Builder groupLifecycleEventsDesiredStatus(String groupLifecycleEventsDesiredStatus) {
            this.groupLifecycleEventsDesiredStatus = groupLifecycleEventsDesiredStatus;
            return this;
        }

        @Override
        public final Builder groupLifecycleEventsDesiredStatus(GroupLifecycleEventsDesiredStatus groupLifecycleEventsDesiredStatus) {
            this.groupLifecycleEventsDesiredStatus(groupLifecycleEventsDesiredStatus == null ? null
                    : groupLifecycleEventsDesiredStatus.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateAccountSettingsRequest build() {
            return new UpdateAccountSettingsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
