/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.resourcegroups.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListGroupResourcesRequest extends ResourceGroupsRequest implements
        ToCopyableBuilder<ListGroupResourcesRequest.Builder, ListGroupResourcesRequest> {
    private static final SdkField<String> GROUP_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ListGroupResourcesRequest::groupName)).setter(setter(Builder::groupName))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("GroupName").build()).build();

    private static final SdkField<List<ResourceFilter>> FILTERS_FIELD = SdkField
            .<List<ResourceFilter>> builder(MarshallingType.LIST)
            .getter(getter(ListGroupResourcesRequest::filters))
            .setter(setter(Builder::filters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Filters").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ResourceFilter> builder(MarshallingType.SDK_POJO)
                                            .constructor(ResourceFilter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(ListGroupResourcesRequest::maxResults)).setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("maxResults").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ListGroupResourcesRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GROUP_NAME_FIELD,
            FILTERS_FIELD, MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD));

    private final String groupName;

    private final List<ResourceFilter> filters;

    private final Integer maxResults;

    private final String nextToken;

    private ListGroupResourcesRequest(BuilderImpl builder) {
        super(builder);
        this.groupName = builder.groupName;
        this.filters = builder.filters;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * The name of the resource group.
     * </p>
     * 
     * @return The name of the resource group.
     */
    public String groupName() {
        return groupName;
    }

    /**
     * <p>
     * Filters, formatted as ResourceFilter objects, that you want to apply to a ListGroupResources operation.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>resource-type</code> - Filter resources by their type. Specify up to five resource types in the format
     * AWS::ServiceCode::ResourceType. For example, AWS::EC2::Instance, or AWS::S3::Bucket.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return Filters, formatted as ResourceFilter objects, that you want to apply to a ListGroupResources
     *         operation.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>resource-type</code> - Filter resources by their type. Specify up to five resource types in the
     *         format AWS::ServiceCode::ResourceType. For example, AWS::EC2::Instance, or AWS::S3::Bucket.
     *         </p>
     *         </li>
     */
    public List<ResourceFilter> filters() {
        return filters;
    }

    /**
     * <p>
     * The maximum number of group member ARNs that are returned in a single call by ListGroupResources, in paginated
     * output. By default, this number is 50.
     * </p>
     * 
     * @return The maximum number of group member ARNs that are returned in a single call by ListGroupResources, in
     *         paginated output. By default, this number is 50.
     */
    public Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * The NextToken value that is returned in a paginated ListGroupResources request. To get the next page of results,
     * run the call again, add the NextToken parameter, and specify the NextToken value.
     * </p>
     * 
     * @return The NextToken value that is returned in a paginated ListGroupResources request. To get the next page of
     *         results, run the call again, add the NextToken parameter, and specify the NextToken value.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(groupName());
        hashCode = 31 * hashCode + Objects.hashCode(filters());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListGroupResourcesRequest)) {
            return false;
        }
        ListGroupResourcesRequest other = (ListGroupResourcesRequest) obj;
        return Objects.equals(groupName(), other.groupName()) && Objects.equals(filters(), other.filters())
                && Objects.equals(maxResults(), other.maxResults()) && Objects.equals(nextToken(), other.nextToken());
    }

    @Override
    public String toString() {
        return ToString.builder("ListGroupResourcesRequest").add("GroupName", groupName()).add("Filters", filters())
                .add("MaxResults", maxResults()).add("NextToken", nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "GroupName":
            return Optional.ofNullable(clazz.cast(groupName()));
        case "Filters":
            return Optional.ofNullable(clazz.cast(filters()));
        case "MaxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListGroupResourcesRequest, T> g) {
        return obj -> g.apply((ListGroupResourcesRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ResourceGroupsRequest.Builder, SdkPojo, CopyableBuilder<Builder, ListGroupResourcesRequest> {
        /**
         * <p>
         * The name of the resource group.
         * </p>
         * 
         * @param groupName
         *        The name of the resource group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder groupName(String groupName);

        /**
         * <p>
         * Filters, formatted as ResourceFilter objects, that you want to apply to a ListGroupResources operation.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>resource-type</code> - Filter resources by their type. Specify up to five resource types in the format
         * AWS::ServiceCode::ResourceType. For example, AWS::EC2::Instance, or AWS::S3::Bucket.
         * </p>
         * </li>
         * </ul>
         * 
         * @param filters
         *        Filters, formatted as ResourceFilter objects, that you want to apply to a ListGroupResources
         *        operation.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>resource-type</code> - Filter resources by their type. Specify up to five resource types in the
         *        format AWS::ServiceCode::ResourceType. For example, AWS::EC2::Instance, or AWS::S3::Bucket.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filters(Collection<ResourceFilter> filters);

        /**
         * <p>
         * Filters, formatted as ResourceFilter objects, that you want to apply to a ListGroupResources operation.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>resource-type</code> - Filter resources by their type. Specify up to five resource types in the format
         * AWS::ServiceCode::ResourceType. For example, AWS::EC2::Instance, or AWS::S3::Bucket.
         * </p>
         * </li>
         * </ul>
         * 
         * @param filters
         *        Filters, formatted as ResourceFilter objects, that you want to apply to a ListGroupResources
         *        operation.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>resource-type</code> - Filter resources by their type. Specify up to five resource types in the
         *        format AWS::ServiceCode::ResourceType. For example, AWS::EC2::Instance, or AWS::S3::Bucket.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filters(ResourceFilter... filters);

        /**
         * <p>
         * Filters, formatted as ResourceFilter objects, that you want to apply to a ListGroupResources operation.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>resource-type</code> - Filter resources by their type. Specify up to five resource types in the format
         * AWS::ServiceCode::ResourceType. For example, AWS::EC2::Instance, or AWS::S3::Bucket.
         * </p>
         * </li>
         * </ul>
         * This is a convenience that creates an instance of the {@link List<ResourceFilter>.Builder} avoiding the need
         * to create one manually via {@link List<ResourceFilter>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ResourceFilter>.Builder#build()} is called immediately and
         * its result is passed to {@link #filters(List<ResourceFilter>)}.
         * 
         * @param filters
         *        a consumer that will call methods on {@link List<ResourceFilter>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #filters(List<ResourceFilter>)
         */
        Builder filters(Consumer<ResourceFilter.Builder>... filters);

        /**
         * <p>
         * The maximum number of group member ARNs that are returned in a single call by ListGroupResources, in
         * paginated output. By default, this number is 50.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of group member ARNs that are returned in a single call by ListGroupResources, in
         *        paginated output. By default, this number is 50.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * The NextToken value that is returned in a paginated ListGroupResources request. To get the next page of
         * results, run the call again, add the NextToken parameter, and specify the NextToken value.
         * </p>
         * 
         * @param nextToken
         *        The NextToken value that is returned in a paginated ListGroupResources request. To get the next page
         *        of results, run the call again, add the NextToken parameter, and specify the NextToken value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ResourceGroupsRequest.BuilderImpl implements Builder {
        private String groupName;

        private List<ResourceFilter> filters = DefaultSdkAutoConstructList.getInstance();

        private Integer maxResults;

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListGroupResourcesRequest model) {
            super(model);
            groupName(model.groupName);
            filters(model.filters);
            maxResults(model.maxResults);
            nextToken(model.nextToken);
        }

        public final String getGroupName() {
            return groupName;
        }

        @Override
        public final Builder groupName(String groupName) {
            this.groupName = groupName;
            return this;
        }

        public final void setGroupName(String groupName) {
            this.groupName = groupName;
        }

        public final Collection<ResourceFilter.Builder> getFilters() {
            return filters != null ? filters.stream().map(ResourceFilter::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder filters(Collection<ResourceFilter> filters) {
            this.filters = ResourceFilterListCopier.copy(filters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(ResourceFilter... filters) {
            filters(Arrays.asList(filters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(Consumer<ResourceFilter.Builder>... filters) {
            filters(Stream.of(filters).map(c -> ResourceFilter.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setFilters(Collection<ResourceFilter.BuilderImpl> filters) {
            this.filters = ResourceFilterListCopier.copyFromBuilder(filters);
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListGroupResourcesRequest build() {
            return new ListGroupResourcesRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
