/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.resourcegroups.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A resource group that contains Amazon Web Services resources. You can assign resources to the group by associating
 * either of the following elements with the group:
 * </p>
 * <ul>
 * <li>
 * <p>
 * <a>ResourceQuery</a> - Use a resource query to specify a set of tag keys and values. All resources in the same Amazon
 * Web Services Region and Amazon Web Services account that have those keys with the same values are included in the
 * group. You can add a resource query when you create the group, or later by using the <a>PutGroupConfiguration</a>
 * operation.
 * </p>
 * </li>
 * <li>
 * <p>
 * <a>GroupConfiguration</a> - Use a service configuration to associate the group with an Amazon Web Services service.
 * The configuration specifies which resource types can be included in the group.
 * </p>
 * </li>
 * </ul>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Group implements SdkPojo, Serializable, ToCopyableBuilder<Group.Builder, Group> {
    private static final SdkField<String> GROUP_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("GroupArn").getter(getter(Group::groupArn)).setter(setter(Builder::groupArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GroupArn").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(Group::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(Group::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<Integer> CRITICALITY_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("Criticality").getter(getter(Group::criticality)).setter(setter(Builder::criticality))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Criticality").build()).build();

    private static final SdkField<String> OWNER_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Owner")
            .getter(getter(Group::owner)).setter(setter(Builder::owner))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Owner").build()).build();

    private static final SdkField<String> DISPLAY_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DisplayName").getter(getter(Group::displayName)).setter(setter(Builder::displayName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DisplayName").build()).build();

    private static final SdkField<Map<String, String>> APPLICATION_TAG_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("ApplicationTag")
            .getter(getter(Group::applicationTag))
            .setter(setter(Builder::applicationTag))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApplicationTag").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GROUP_ARN_FIELD, NAME_FIELD,
            DESCRIPTION_FIELD, CRITICALITY_FIELD, OWNER_FIELD, DISPLAY_NAME_FIELD, APPLICATION_TAG_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String groupArn;

    private final String name;

    private final String description;

    private final Integer criticality;

    private final String owner;

    private final String displayName;

    private final Map<String, String> applicationTag;

    private Group(BuilderImpl builder) {
        this.groupArn = builder.groupArn;
        this.name = builder.name;
        this.description = builder.description;
        this.criticality = builder.criticality;
        this.owner = builder.owner;
        this.displayName = builder.displayName;
        this.applicationTag = builder.applicationTag;
    }

    /**
     * <p>
     * The Amazon resource name (ARN) of the resource group.
     * </p>
     * 
     * @return The Amazon resource name (ARN) of the resource group.
     */
    public final String groupArn() {
        return groupArn;
    }

    /**
     * <p>
     * The name of the resource group.
     * </p>
     * 
     * @return The name of the resource group.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The description of the resource group.
     * </p>
     * 
     * @return The description of the resource group.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The critical rank of the application group on a scale of 1 to 10, with a rank of 1 being the most critical, and a
     * rank of 10 being least critical.
     * </p>
     * 
     * @return The critical rank of the application group on a scale of 1 to 10, with a rank of 1 being the most
     *         critical, and a rank of 10 being least critical.
     */
    public final Integer criticality() {
        return criticality;
    }

    /**
     * <p>
     * A name, email address or other identifier for the person or group who is considered as the owner of this
     * application group within your organization.
     * </p>
     * 
     * @return A name, email address or other identifier for the person or group who is considered as the owner of this
     *         application group within your organization.
     */
    public final String owner() {
        return owner;
    }

    /**
     * <p>
     * The name of the application group, which you can change at any time.
     * </p>
     * 
     * @return The name of the application group, which you can change at any time.
     */
    public final String displayName() {
        return displayName;
    }

    /**
     * For responses, this returns true if the service returned a value for the ApplicationTag property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasApplicationTag() {
        return applicationTag != null && !(applicationTag instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * A tag that defines the application group membership. This tag is only supported for application groups.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasApplicationTag} method.
     * </p>
     * 
     * @return A tag that defines the application group membership. This tag is only supported for application groups.
     */
    public final Map<String, String> applicationTag() {
        return applicationTag;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(groupArn());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(criticality());
        hashCode = 31 * hashCode + Objects.hashCode(owner());
        hashCode = 31 * hashCode + Objects.hashCode(displayName());
        hashCode = 31 * hashCode + Objects.hashCode(hasApplicationTag() ? applicationTag() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Group)) {
            return false;
        }
        Group other = (Group) obj;
        return Objects.equals(groupArn(), other.groupArn()) && Objects.equals(name(), other.name())
                && Objects.equals(description(), other.description()) && Objects.equals(criticality(), other.criticality())
                && Objects.equals(owner(), other.owner()) && Objects.equals(displayName(), other.displayName())
                && hasApplicationTag() == other.hasApplicationTag() && Objects.equals(applicationTag(), other.applicationTag());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Group").add("GroupArn", groupArn()).add("Name", name()).add("Description", description())
                .add("Criticality", criticality()).add("Owner", owner()).add("DisplayName", displayName())
                .add("ApplicationTag", hasApplicationTag() ? applicationTag() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "GroupArn":
            return Optional.ofNullable(clazz.cast(groupArn()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "Criticality":
            return Optional.ofNullable(clazz.cast(criticality()));
        case "Owner":
            return Optional.ofNullable(clazz.cast(owner()));
        case "DisplayName":
            return Optional.ofNullable(clazz.cast(displayName()));
        case "ApplicationTag":
            return Optional.ofNullable(clazz.cast(applicationTag()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("GroupArn", GROUP_ARN_FIELD);
        map.put("Name", NAME_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("Criticality", CRITICALITY_FIELD);
        map.put("Owner", OWNER_FIELD);
        map.put("DisplayName", DISPLAY_NAME_FIELD);
        map.put("ApplicationTag", APPLICATION_TAG_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Group, T> g) {
        return obj -> g.apply((Group) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Group> {
        /**
         * <p>
         * The Amazon resource name (ARN) of the resource group.
         * </p>
         * 
         * @param groupArn
         *        The Amazon resource name (ARN) of the resource group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder groupArn(String groupArn);

        /**
         * <p>
         * The name of the resource group.
         * </p>
         * 
         * @param name
         *        The name of the resource group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The description of the resource group.
         * </p>
         * 
         * @param description
         *        The description of the resource group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The critical rank of the application group on a scale of 1 to 10, with a rank of 1 being the most critical,
         * and a rank of 10 being least critical.
         * </p>
         * 
         * @param criticality
         *        The critical rank of the application group on a scale of 1 to 10, with a rank of 1 being the most
         *        critical, and a rank of 10 being least critical.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder criticality(Integer criticality);

        /**
         * <p>
         * A name, email address or other identifier for the person or group who is considered as the owner of this
         * application group within your organization.
         * </p>
         * 
         * @param owner
         *        A name, email address or other identifier for the person or group who is considered as the owner of
         *        this application group within your organization.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder owner(String owner);

        /**
         * <p>
         * The name of the application group, which you can change at any time.
         * </p>
         * 
         * @param displayName
         *        The name of the application group, which you can change at any time.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder displayName(String displayName);

        /**
         * <p>
         * A tag that defines the application group membership. This tag is only supported for application groups.
         * </p>
         * 
         * @param applicationTag
         *        A tag that defines the application group membership. This tag is only supported for application
         *        groups.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applicationTag(Map<String, String> applicationTag);
    }

    static final class BuilderImpl implements Builder {
        private String groupArn;

        private String name;

        private String description;

        private Integer criticality;

        private String owner;

        private String displayName;

        private Map<String, String> applicationTag = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(Group model) {
            groupArn(model.groupArn);
            name(model.name);
            description(model.description);
            criticality(model.criticality);
            owner(model.owner);
            displayName(model.displayName);
            applicationTag(model.applicationTag);
        }

        public final String getGroupArn() {
            return groupArn;
        }

        public final void setGroupArn(String groupArn) {
            this.groupArn = groupArn;
        }

        @Override
        public final Builder groupArn(String groupArn) {
            this.groupArn = groupArn;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Integer getCriticality() {
            return criticality;
        }

        public final void setCriticality(Integer criticality) {
            this.criticality = criticality;
        }

        @Override
        public final Builder criticality(Integer criticality) {
            this.criticality = criticality;
            return this;
        }

        public final String getOwner() {
            return owner;
        }

        public final void setOwner(String owner) {
            this.owner = owner;
        }

        @Override
        public final Builder owner(String owner) {
            this.owner = owner;
            return this;
        }

        public final String getDisplayName() {
            return displayName;
        }

        public final void setDisplayName(String displayName) {
            this.displayName = displayName;
        }

        @Override
        public final Builder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public final Map<String, String> getApplicationTag() {
            if (applicationTag instanceof SdkAutoConstructMap) {
                return null;
            }
            return applicationTag;
        }

        public final void setApplicationTag(Map<String, String> applicationTag) {
            this.applicationTag = ApplicationTagCopier.copy(applicationTag);
        }

        @Override
        public final Builder applicationTag(Map<String, String> applicationTag) {
            this.applicationTag = ApplicationTagCopier.copy(applicationTag);
            return this;
        }

        @Override
        public Group build() {
            return new Group(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
