/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.resourcegroups.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class StartTagSyncTaskRequest extends ResourceGroupsRequest implements
        ToCopyableBuilder<StartTagSyncTaskRequest.Builder, StartTagSyncTaskRequest> {
    private static final SdkField<String> GROUP_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Group")
            .getter(getter(StartTagSyncTaskRequest::group)).setter(setter(Builder::group))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Group").build()).build();

    private static final SdkField<String> TAG_KEY_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("TagKey")
            .getter(getter(StartTagSyncTaskRequest::tagKey)).setter(setter(Builder::tagKey))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TagKey").build()).build();

    private static final SdkField<String> TAG_VALUE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TagValue").getter(getter(StartTagSyncTaskRequest::tagValue)).setter(setter(Builder::tagValue))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TagValue").build()).build();

    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RoleArn").getter(getter(StartTagSyncTaskRequest::roleArn)).setter(setter(Builder::roleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoleArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GROUP_FIELD, TAG_KEY_FIELD,
            TAG_VALUE_FIELD, ROLE_ARN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String group;

    private final String tagKey;

    private final String tagValue;

    private final String roleArn;

    private StartTagSyncTaskRequest(BuilderImpl builder) {
        super(builder);
        this.group = builder.group;
        this.tagKey = builder.tagKey;
        this.tagValue = builder.tagValue;
        this.roleArn = builder.roleArn;
    }

    /**
     * <p>
     * The Amazon resource name (ARN) or name of the application group for which you want to create a tag-sync task.
     * </p>
     * 
     * @return The Amazon resource name (ARN) or name of the application group for which you want to create a tag-sync
     *         task.
     */
    public final String group() {
        return group;
    }

    /**
     * <p>
     * The tag key. Resources tagged with this tag key-value pair will be added to the application. If a resource with
     * this tag is later untagged, the tag-sync task removes the resource from the application.
     * </p>
     * 
     * @return The tag key. Resources tagged with this tag key-value pair will be added to the application. If a
     *         resource with this tag is later untagged, the tag-sync task removes the resource from the application.
     */
    public final String tagKey() {
        return tagKey;
    }

    /**
     * <p>
     * The tag value. Resources tagged with this tag key-value pair will be added to the application. If a resource with
     * this tag is later untagged, the tag-sync task removes the resource from the application.
     * </p>
     * 
     * @return The tag value. Resources tagged with this tag key-value pair will be added to the application. If a
     *         resource with this tag is later untagged, the tag-sync task removes the resource from the application.
     */
    public final String tagValue() {
        return tagValue;
    }

    /**
     * <p>
     * The Amazon resource name (ARN) of the role assumed by the service to tag and untag resources on your behalf.
     * </p>
     * 
     * @return The Amazon resource name (ARN) of the role assumed by the service to tag and untag resources on your
     *         behalf.
     */
    public final String roleArn() {
        return roleArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(group());
        hashCode = 31 * hashCode + Objects.hashCode(tagKey());
        hashCode = 31 * hashCode + Objects.hashCode(tagValue());
        hashCode = 31 * hashCode + Objects.hashCode(roleArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartTagSyncTaskRequest)) {
            return false;
        }
        StartTagSyncTaskRequest other = (StartTagSyncTaskRequest) obj;
        return Objects.equals(group(), other.group()) && Objects.equals(tagKey(), other.tagKey())
                && Objects.equals(tagValue(), other.tagValue()) && Objects.equals(roleArn(), other.roleArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("StartTagSyncTaskRequest").add("Group", group()).add("TagKey", tagKey())
                .add("TagValue", tagValue()).add("RoleArn", roleArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Group":
            return Optional.ofNullable(clazz.cast(group()));
        case "TagKey":
            return Optional.ofNullable(clazz.cast(tagKey()));
        case "TagValue":
            return Optional.ofNullable(clazz.cast(tagValue()));
        case "RoleArn":
            return Optional.ofNullable(clazz.cast(roleArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Group", GROUP_FIELD);
        map.put("TagKey", TAG_KEY_FIELD);
        map.put("TagValue", TAG_VALUE_FIELD);
        map.put("RoleArn", ROLE_ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<StartTagSyncTaskRequest, T> g) {
        return obj -> g.apply((StartTagSyncTaskRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ResourceGroupsRequest.Builder, SdkPojo, CopyableBuilder<Builder, StartTagSyncTaskRequest> {
        /**
         * <p>
         * The Amazon resource name (ARN) or name of the application group for which you want to create a tag-sync task.
         * </p>
         * 
         * @param group
         *        The Amazon resource name (ARN) or name of the application group for which you want to create a
         *        tag-sync task.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder group(String group);

        /**
         * <p>
         * The tag key. Resources tagged with this tag key-value pair will be added to the application. If a resource
         * with this tag is later untagged, the tag-sync task removes the resource from the application.
         * </p>
         * 
         * @param tagKey
         *        The tag key. Resources tagged with this tag key-value pair will be added to the application. If a
         *        resource with this tag is later untagged, the tag-sync task removes the resource from the application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tagKey(String tagKey);

        /**
         * <p>
         * The tag value. Resources tagged with this tag key-value pair will be added to the application. If a resource
         * with this tag is later untagged, the tag-sync task removes the resource from the application.
         * </p>
         * 
         * @param tagValue
         *        The tag value. Resources tagged with this tag key-value pair will be added to the application. If a
         *        resource with this tag is later untagged, the tag-sync task removes the resource from the application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tagValue(String tagValue);

        /**
         * <p>
         * The Amazon resource name (ARN) of the role assumed by the service to tag and untag resources on your behalf.
         * </p>
         * 
         * @param roleArn
         *        The Amazon resource name (ARN) of the role assumed by the service to tag and untag resources on your
         *        behalf.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleArn(String roleArn);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ResourceGroupsRequest.BuilderImpl implements Builder {
        private String group;

        private String tagKey;

        private String tagValue;

        private String roleArn;

        private BuilderImpl() {
        }

        private BuilderImpl(StartTagSyncTaskRequest model) {
            super(model);
            group(model.group);
            tagKey(model.tagKey);
            tagValue(model.tagValue);
            roleArn(model.roleArn);
        }

        public final String getGroup() {
            return group;
        }

        public final void setGroup(String group) {
            this.group = group;
        }

        @Override
        public final Builder group(String group) {
            this.group = group;
            return this;
        }

        public final String getTagKey() {
            return tagKey;
        }

        public final void setTagKey(String tagKey) {
            this.tagKey = tagKey;
        }

        @Override
        public final Builder tagKey(String tagKey) {
            this.tagKey = tagKey;
            return this;
        }

        public final String getTagValue() {
            return tagValue;
        }

        public final void setTagValue(String tagValue) {
            this.tagValue = tagValue;
        }

        @Override
        public final Builder tagValue(String tagValue) {
            this.tagValue = tagValue;
            return this;
        }

        public final String getRoleArn() {
            return roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public StartTagSyncTaskRequest build() {
            return new StartTagSyncTaskRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
