/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.resourcegroups.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateGroupRequest extends ResourceGroupsRequest implements
        ToCopyableBuilder<UpdateGroupRequest.Builder, UpdateGroupRequest> {
    private static final SdkField<String> GROUP_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("GroupName").getter(getter(UpdateGroupRequest::groupName)).setter(setter(Builder::groupName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GroupName").build()).build();

    private static final SdkField<String> GROUP_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Group")
            .getter(getter(UpdateGroupRequest::group)).setter(setter(Builder::group))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Group").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(UpdateGroupRequest::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<Integer> CRITICALITY_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("Criticality").getter(getter(UpdateGroupRequest::criticality)).setter(setter(Builder::criticality))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Criticality").build()).build();

    private static final SdkField<String> OWNER_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Owner")
            .getter(getter(UpdateGroupRequest::owner)).setter(setter(Builder::owner))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Owner").build()).build();

    private static final SdkField<String> DISPLAY_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DisplayName").getter(getter(UpdateGroupRequest::displayName)).setter(setter(Builder::displayName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DisplayName").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GROUP_NAME_FIELD, GROUP_FIELD,
            DESCRIPTION_FIELD, CRITICALITY_FIELD, OWNER_FIELD, DISPLAY_NAME_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String groupName;

    private final String group;

    private final String description;

    private final Integer criticality;

    private final String owner;

    private final String displayName;

    private UpdateGroupRequest(BuilderImpl builder) {
        super(builder);
        this.groupName = builder.groupName;
        this.group = builder.group;
        this.description = builder.description;
        this.criticality = builder.criticality;
        this.owner = builder.owner;
        this.displayName = builder.displayName;
    }

    /**
     * <p>
     * Don't use this parameter. Use <code>Group</code> instead.
     * </p>
     * 
     * @return Don't use this parameter. Use <code>Group</code> instead.
     * @deprecated This field is deprecated, use Group instead.
     */
    @Deprecated
    public final String groupName() {
        return groupName;
    }

    /**
     * <p>
     * The name or the ARN of the resource group to update.
     * </p>
     * 
     * @return The name or the ARN of the resource group to update.
     */
    public final String group() {
        return group;
    }

    /**
     * <p>
     * The new description that you want to update the resource group with. Descriptions can contain letters, numbers,
     * hyphens, underscores, periods, and spaces.
     * </p>
     * 
     * @return The new description that you want to update the resource group with. Descriptions can contain letters,
     *         numbers, hyphens, underscores, periods, and spaces.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The critical rank of the application group on a scale of 1 to 10, with a rank of 1 being the most critical, and a
     * rank of 10 being least critical.
     * </p>
     * 
     * @return The critical rank of the application group on a scale of 1 to 10, with a rank of 1 being the most
     *         critical, and a rank of 10 being least critical.
     */
    public final Integer criticality() {
        return criticality;
    }

    /**
     * <p>
     * A name, email address or other identifier for the person or group who is considered as the owner of this
     * application group within your organization.
     * </p>
     * 
     * @return A name, email address or other identifier for the person or group who is considered as the owner of this
     *         application group within your organization.
     */
    public final String owner() {
        return owner;
    }

    /**
     * <p>
     * The name of the application group, which you can change at any time.
     * </p>
     * 
     * @return The name of the application group, which you can change at any time.
     */
    public final String displayName() {
        return displayName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(groupName());
        hashCode = 31 * hashCode + Objects.hashCode(group());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(criticality());
        hashCode = 31 * hashCode + Objects.hashCode(owner());
        hashCode = 31 * hashCode + Objects.hashCode(displayName());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateGroupRequest)) {
            return false;
        }
        UpdateGroupRequest other = (UpdateGroupRequest) obj;
        return Objects.equals(groupName(), other.groupName()) && Objects.equals(group(), other.group())
                && Objects.equals(description(), other.description()) && Objects.equals(criticality(), other.criticality())
                && Objects.equals(owner(), other.owner()) && Objects.equals(displayName(), other.displayName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateGroupRequest").add("GroupName", groupName()).add("Group", group())
                .add("Description", description()).add("Criticality", criticality()).add("Owner", owner())
                .add("DisplayName", displayName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "GroupName":
            return Optional.ofNullable(clazz.cast(groupName()));
        case "Group":
            return Optional.ofNullable(clazz.cast(group()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "Criticality":
            return Optional.ofNullable(clazz.cast(criticality()));
        case "Owner":
            return Optional.ofNullable(clazz.cast(owner()));
        case "DisplayName":
            return Optional.ofNullable(clazz.cast(displayName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("GroupName", GROUP_NAME_FIELD);
        map.put("Group", GROUP_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("Criticality", CRITICALITY_FIELD);
        map.put("Owner", OWNER_FIELD);
        map.put("DisplayName", DISPLAY_NAME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateGroupRequest, T> g) {
        return obj -> g.apply((UpdateGroupRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ResourceGroupsRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateGroupRequest> {
        /**
         * <p>
         * Don't use this parameter. Use <code>Group</code> instead.
         * </p>
         * 
         * @param groupName
         *        Don't use this parameter. Use <code>Group</code> instead.
         * @return Returns a reference to this object so that method calls can be chained together.
         * @deprecated This field is deprecated, use Group instead.
         */
        @Deprecated
        Builder groupName(String groupName);

        /**
         * <p>
         * The name or the ARN of the resource group to update.
         * </p>
         * 
         * @param group
         *        The name or the ARN of the resource group to update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder group(String group);

        /**
         * <p>
         * The new description that you want to update the resource group with. Descriptions can contain letters,
         * numbers, hyphens, underscores, periods, and spaces.
         * </p>
         * 
         * @param description
         *        The new description that you want to update the resource group with. Descriptions can contain letters,
         *        numbers, hyphens, underscores, periods, and spaces.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The critical rank of the application group on a scale of 1 to 10, with a rank of 1 being the most critical,
         * and a rank of 10 being least critical.
         * </p>
         * 
         * @param criticality
         *        The critical rank of the application group on a scale of 1 to 10, with a rank of 1 being the most
         *        critical, and a rank of 10 being least critical.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder criticality(Integer criticality);

        /**
         * <p>
         * A name, email address or other identifier for the person or group who is considered as the owner of this
         * application group within your organization.
         * </p>
         * 
         * @param owner
         *        A name, email address or other identifier for the person or group who is considered as the owner of
         *        this application group within your organization.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder owner(String owner);

        /**
         * <p>
         * The name of the application group, which you can change at any time.
         * </p>
         * 
         * @param displayName
         *        The name of the application group, which you can change at any time.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder displayName(String displayName);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ResourceGroupsRequest.BuilderImpl implements Builder {
        private String groupName;

        private String group;

        private String description;

        private Integer criticality;

        private String owner;

        private String displayName;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateGroupRequest model) {
            super(model);
            groupName(model.groupName);
            group(model.group);
            description(model.description);
            criticality(model.criticality);
            owner(model.owner);
            displayName(model.displayName);
        }

        @Deprecated
        public final String getGroupName() {
            return groupName;
        }

        @Deprecated
        public final void setGroupName(String groupName) {
            this.groupName = groupName;
        }

        @Override
        @Deprecated
        public final Builder groupName(String groupName) {
            this.groupName = groupName;
            return this;
        }

        public final String getGroup() {
            return group;
        }

        public final void setGroup(String group) {
            this.group = group;
        }

        @Override
        public final Builder group(String group) {
            this.group = group;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Integer getCriticality() {
            return criticality;
        }

        public final void setCriticality(Integer criticality) {
            this.criticality = criticality;
        }

        @Override
        public final Builder criticality(Integer criticality) {
            this.criticality = criticality;
            return this;
        }

        public final String getOwner() {
            return owner;
        }

        public final void setOwner(String owner) {
            this.owner = owner;
        }

        @Override
        public final Builder owner(String owner) {
            this.owner = owner;
            return this;
        }

        public final String getDisplayName() {
            return displayName;
        }

        public final void setDisplayName(String displayName) {
            this.displayName = displayName;
        }

        @Override
        public final Builder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateGroupRequest build() {
            return new UpdateGroupRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
