/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.resourcegroups.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateGroupRequest extends ResourceGroupsRequest implements
        ToCopyableBuilder<CreateGroupRequest.Builder, CreateGroupRequest> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(CreateGroupRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(CreateGroupRequest::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<ResourceQuery> RESOURCE_QUERY_FIELD = SdkField
            .<ResourceQuery> builder(MarshallingType.SDK_POJO).memberName("ResourceQuery")
            .getter(getter(CreateGroupRequest::resourceQuery)).setter(setter(Builder::resourceQuery))
            .constructor(ResourceQuery::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceQuery").build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("Tags")
            .getter(getter(CreateGroupRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<List<GroupConfigurationItem>> CONFIGURATION_FIELD = SdkField
            .<List<GroupConfigurationItem>> builder(MarshallingType.LIST)
            .memberName("Configuration")
            .getter(getter(CreateGroupRequest::configuration))
            .setter(setter(Builder::configuration))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Configuration").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<GroupConfigurationItem> builder(MarshallingType.SDK_POJO)
                                            .constructor(GroupConfigurationItem::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Integer> CRITICALITY_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("Criticality").getter(getter(CreateGroupRequest::criticality)).setter(setter(Builder::criticality))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Criticality").build()).build();

    private static final SdkField<String> OWNER_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Owner")
            .getter(getter(CreateGroupRequest::owner)).setter(setter(Builder::owner))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Owner").build()).build();

    private static final SdkField<String> DISPLAY_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DisplayName").getter(getter(CreateGroupRequest::displayName)).setter(setter(Builder::displayName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DisplayName").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, DESCRIPTION_FIELD,
            RESOURCE_QUERY_FIELD, TAGS_FIELD, CONFIGURATION_FIELD, CRITICALITY_FIELD, OWNER_FIELD, DISPLAY_NAME_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String name;

    private final String description;

    private final ResourceQuery resourceQuery;

    private final Map<String, String> tags;

    private final List<GroupConfigurationItem> configuration;

    private final Integer criticality;

    private final String owner;

    private final String displayName;

    private CreateGroupRequest(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.description = builder.description;
        this.resourceQuery = builder.resourceQuery;
        this.tags = builder.tags;
        this.configuration = builder.configuration;
        this.criticality = builder.criticality;
        this.owner = builder.owner;
        this.displayName = builder.displayName;
    }

    /**
     * <p>
     * The name of the group, which is the identifier of the group in other operations. You can't change the name of a
     * resource group after you create it. A resource group name can consist of letters, numbers, hyphens, periods, and
     * underscores. The name cannot start with <code>AWS</code>, <code>aws</code>, or any other possible capitalization;
     * these are reserved. A resource group name must be unique within each Amazon Web Services Region in your Amazon
     * Web Services account.
     * </p>
     * 
     * @return The name of the group, which is the identifier of the group in other operations. You can't change the
     *         name of a resource group after you create it. A resource group name can consist of letters, numbers,
     *         hyphens, periods, and underscores. The name cannot start with <code>AWS</code>, <code>aws</code>, or any
     *         other possible capitalization; these are reserved. A resource group name must be unique within each
     *         Amazon Web Services Region in your Amazon Web Services account.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The description of the resource group. Descriptions can consist of letters, numbers, hyphens, underscores,
     * periods, and spaces.
     * </p>
     * 
     * @return The description of the resource group. Descriptions can consist of letters, numbers, hyphens,
     *         underscores, periods, and spaces.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The resource query that determines which Amazon Web Services resources are members of this group. For more
     * information about resource queries, see <a
     * href="https://docs.aws.amazon.com/ARG/latest/userguide/gettingstarted-query.html#gettingstarted-query-cli-tag"
     * >Create a tag-based group in Resource Groups</a>.
     * </p>
     * <note>
     * <p>
     * A resource group can contain either a <code>ResourceQuery</code> or a <code>Configuration</code>, but not both.
     * </p>
     * </note>
     * 
     * @return The resource query that determines which Amazon Web Services resources are members of this group. For
     *         more information about resource queries, see <a href=
     *         "https://docs.aws.amazon.com/ARG/latest/userguide/gettingstarted-query.html#gettingstarted-query-cli-tag"
     *         >Create a tag-based group in Resource Groups</a>. </p> <note>
     *         <p>
     *         A resource group can contain either a <code>ResourceQuery</code> or a <code>Configuration</code>, but not
     *         both.
     *         </p>
     */
    public final ResourceQuery resourceQuery() {
        return resourceQuery;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The tags to add to the group. A tag is key-value pair string.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return The tags to add to the group. A tag is key-value pair string.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    /**
     * For responses, this returns true if the service returned a value for the Configuration property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasConfiguration() {
        return configuration != null && !(configuration instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A configuration associates the resource group with an Amazon Web Services service and specifies how the service
     * can interact with the resources in the group. A configuration is an array of <a>GroupConfigurationItem</a>
     * elements. For details about the syntax of service configurations, see <a
     * href="https://docs.aws.amazon.com/ARG/latest/APIReference/about-slg.html">Service configurations for Resource
     * Groups</a>.
     * </p>
     * <note>
     * <p>
     * A resource group can contain either a <code>Configuration</code> or a <code>ResourceQuery</code>, but not both.
     * </p>
     * </note>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasConfiguration} method.
     * </p>
     * 
     * @return A configuration associates the resource group with an Amazon Web Services service and specifies how the
     *         service can interact with the resources in the group. A configuration is an array of
     *         <a>GroupConfigurationItem</a> elements. For details about the syntax of service configurations, see <a
     *         href="https://docs.aws.amazon.com/ARG/latest/APIReference/about-slg.html">Service configurations for
     *         Resource Groups</a>.</p> <note>
     *         <p>
     *         A resource group can contain either a <code>Configuration</code> or a <code>ResourceQuery</code>, but not
     *         both.
     *         </p>
     */
    public final List<GroupConfigurationItem> configuration() {
        return configuration;
    }

    /**
     * <p>
     * The critical rank of the application group on a scale of 1 to 10, with a rank of 1 being the most critical, and a
     * rank of 10 being least critical.
     * </p>
     * 
     * @return The critical rank of the application group on a scale of 1 to 10, with a rank of 1 being the most
     *         critical, and a rank of 10 being least critical.
     */
    public final Integer criticality() {
        return criticality;
    }

    /**
     * <p>
     * A name, email address or other identifier for the person or group who is considered as the owner of this
     * application group within your organization.
     * </p>
     * 
     * @return A name, email address or other identifier for the person or group who is considered as the owner of this
     *         application group within your organization.
     */
    public final String owner() {
        return owner;
    }

    /**
     * <p>
     * The name of the application group, which you can change at any time.
     * </p>
     * 
     * @return The name of the application group, which you can change at any time.
     */
    public final String displayName() {
        return displayName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(resourceQuery());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasConfiguration() ? configuration() : null);
        hashCode = 31 * hashCode + Objects.hashCode(criticality());
        hashCode = 31 * hashCode + Objects.hashCode(owner());
        hashCode = 31 * hashCode + Objects.hashCode(displayName());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateGroupRequest)) {
            return false;
        }
        CreateGroupRequest other = (CreateGroupRequest) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(description(), other.description())
                && Objects.equals(resourceQuery(), other.resourceQuery()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags()) && hasConfiguration() == other.hasConfiguration()
                && Objects.equals(configuration(), other.configuration()) && Objects.equals(criticality(), other.criticality())
                && Objects.equals(owner(), other.owner()) && Objects.equals(displayName(), other.displayName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateGroupRequest").add("Name", name()).add("Description", description())
                .add("ResourceQuery", resourceQuery()).add("Tags", hasTags() ? tags() : null)
                .add("Configuration", hasConfiguration() ? configuration() : null).add("Criticality", criticality())
                .add("Owner", owner()).add("DisplayName", displayName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "ResourceQuery":
            return Optional.ofNullable(clazz.cast(resourceQuery()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "Configuration":
            return Optional.ofNullable(clazz.cast(configuration()));
        case "Criticality":
            return Optional.ofNullable(clazz.cast(criticality()));
        case "Owner":
            return Optional.ofNullable(clazz.cast(owner()));
        case "DisplayName":
            return Optional.ofNullable(clazz.cast(displayName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Name", NAME_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("ResourceQuery", RESOURCE_QUERY_FIELD);
        map.put("Tags", TAGS_FIELD);
        map.put("Configuration", CONFIGURATION_FIELD);
        map.put("Criticality", CRITICALITY_FIELD);
        map.put("Owner", OWNER_FIELD);
        map.put("DisplayName", DISPLAY_NAME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateGroupRequest, T> g) {
        return obj -> g.apply((CreateGroupRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends ResourceGroupsRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateGroupRequest> {
        /**
         * <p>
         * The name of the group, which is the identifier of the group in other operations. You can't change the name of
         * a resource group after you create it. A resource group name can consist of letters, numbers, hyphens,
         * periods, and underscores. The name cannot start with <code>AWS</code>, <code>aws</code>, or any other
         * possible capitalization; these are reserved. A resource group name must be unique within each Amazon Web
         * Services Region in your Amazon Web Services account.
         * </p>
         * 
         * @param name
         *        The name of the group, which is the identifier of the group in other operations. You can't change the
         *        name of a resource group after you create it. A resource group name can consist of letters, numbers,
         *        hyphens, periods, and underscores. The name cannot start with <code>AWS</code>, <code>aws</code>, or
         *        any other possible capitalization; these are reserved. A resource group name must be unique within
         *        each Amazon Web Services Region in your Amazon Web Services account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The description of the resource group. Descriptions can consist of letters, numbers, hyphens, underscores,
         * periods, and spaces.
         * </p>
         * 
         * @param description
         *        The description of the resource group. Descriptions can consist of letters, numbers, hyphens,
         *        underscores, periods, and spaces.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The resource query that determines which Amazon Web Services resources are members of this group. For more
         * information about resource queries, see <a href=
         * "https://docs.aws.amazon.com/ARG/latest/userguide/gettingstarted-query.html#gettingstarted-query-cli-tag"
         * >Create a tag-based group in Resource Groups</a>.
         * </p>
         * <note>
         * <p>
         * A resource group can contain either a <code>ResourceQuery</code> or a <code>Configuration</code>, but not
         * both.
         * </p>
         * </note>
         * 
         * @param resourceQuery
         *        The resource query that determines which Amazon Web Services resources are members of this group. For
         *        more information about resource queries, see <a href=
         *        "https://docs.aws.amazon.com/ARG/latest/userguide/gettingstarted-query.html#gettingstarted-query-cli-tag"
         *        >Create a tag-based group in Resource Groups</a>. </p> <note>
         *        <p>
         *        A resource group can contain either a <code>ResourceQuery</code> or a <code>Configuration</code>, but
         *        not both.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceQuery(ResourceQuery resourceQuery);

        /**
         * <p>
         * The resource query that determines which Amazon Web Services resources are members of this group. For more
         * information about resource queries, see <a href=
         * "https://docs.aws.amazon.com/ARG/latest/userguide/gettingstarted-query.html#gettingstarted-query-cli-tag"
         * >Create a tag-based group in Resource Groups</a>.
         * </p>
         * <note>
         * <p>
         * A resource group can contain either a <code>ResourceQuery</code> or a <code>Configuration</code>, but not
         * both.
         * </p>
         * </note> This is a convenience method that creates an instance of the {@link ResourceQuery.Builder} avoiding
         * the need to create one manually via {@link ResourceQuery#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ResourceQuery.Builder#build()} is called immediately and its
         * result is passed to {@link #resourceQuery(ResourceQuery)}.
         * 
         * @param resourceQuery
         *        a consumer that will call methods on {@link ResourceQuery.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #resourceQuery(ResourceQuery)
         */
        default Builder resourceQuery(Consumer<ResourceQuery.Builder> resourceQuery) {
            return resourceQuery(ResourceQuery.builder().applyMutation(resourceQuery).build());
        }

        /**
         * <p>
         * The tags to add to the group. A tag is key-value pair string.
         * </p>
         * 
         * @param tags
         *        The tags to add to the group. A tag is key-value pair string.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);

        /**
         * <p>
         * A configuration associates the resource group with an Amazon Web Services service and specifies how the
         * service can interact with the resources in the group. A configuration is an array of
         * <a>GroupConfigurationItem</a> elements. For details about the syntax of service configurations, see <a
         * href="https://docs.aws.amazon.com/ARG/latest/APIReference/about-slg.html">Service configurations for Resource
         * Groups</a>.
         * </p>
         * <note>
         * <p>
         * A resource group can contain either a <code>Configuration</code> or a <code>ResourceQuery</code>, but not
         * both.
         * </p>
         * </note>
         * 
         * @param configuration
         *        A configuration associates the resource group with an Amazon Web Services service and specifies how
         *        the service can interact with the resources in the group. A configuration is an array of
         *        <a>GroupConfigurationItem</a> elements. For details about the syntax of service configurations, see <a
         *        href="https://docs.aws.amazon.com/ARG/latest/APIReference/about-slg.html">Service configurations for
         *        Resource Groups</a>.</p> <note>
         *        <p>
         *        A resource group can contain either a <code>Configuration</code> or a <code>ResourceQuery</code>, but
         *        not both.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configuration(Collection<GroupConfigurationItem> configuration);

        /**
         * <p>
         * A configuration associates the resource group with an Amazon Web Services service and specifies how the
         * service can interact with the resources in the group. A configuration is an array of
         * <a>GroupConfigurationItem</a> elements. For details about the syntax of service configurations, see <a
         * href="https://docs.aws.amazon.com/ARG/latest/APIReference/about-slg.html">Service configurations for Resource
         * Groups</a>.
         * </p>
         * <note>
         * <p>
         * A resource group can contain either a <code>Configuration</code> or a <code>ResourceQuery</code>, but not
         * both.
         * </p>
         * </note>
         * 
         * @param configuration
         *        A configuration associates the resource group with an Amazon Web Services service and specifies how
         *        the service can interact with the resources in the group. A configuration is an array of
         *        <a>GroupConfigurationItem</a> elements. For details about the syntax of service configurations, see <a
         *        href="https://docs.aws.amazon.com/ARG/latest/APIReference/about-slg.html">Service configurations for
         *        Resource Groups</a>.</p> <note>
         *        <p>
         *        A resource group can contain either a <code>Configuration</code> or a <code>ResourceQuery</code>, but
         *        not both.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configuration(GroupConfigurationItem... configuration);

        /**
         * <p>
         * A configuration associates the resource group with an Amazon Web Services service and specifies how the
         * service can interact with the resources in the group. A configuration is an array of
         * <a>GroupConfigurationItem</a> elements. For details about the syntax of service configurations, see <a
         * href="https://docs.aws.amazon.com/ARG/latest/APIReference/about-slg.html">Service configurations for Resource
         * Groups</a>.
         * </p>
         * <note>
         * <p>
         * A resource group can contain either a <code>Configuration</code> or a <code>ResourceQuery</code>, but not
         * both.
         * </p>
         * </note> This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.resourcegroups.model.GroupConfigurationItem.Builder} avoiding the need
         * to create one manually via
         * {@link software.amazon.awssdk.services.resourcegroups.model.GroupConfigurationItem#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.resourcegroups.model.GroupConfigurationItem.Builder#build()} is called
         * immediately and its result is passed to {@link #configuration(List<GroupConfigurationItem>)}.
         * 
         * @param configuration
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.resourcegroups.model.GroupConfigurationItem.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #configuration(java.util.Collection<GroupConfigurationItem>)
         */
        Builder configuration(Consumer<GroupConfigurationItem.Builder>... configuration);

        /**
         * <p>
         * The critical rank of the application group on a scale of 1 to 10, with a rank of 1 being the most critical,
         * and a rank of 10 being least critical.
         * </p>
         * 
         * @param criticality
         *        The critical rank of the application group on a scale of 1 to 10, with a rank of 1 being the most
         *        critical, and a rank of 10 being least critical.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder criticality(Integer criticality);

        /**
         * <p>
         * A name, email address or other identifier for the person or group who is considered as the owner of this
         * application group within your organization.
         * </p>
         * 
         * @param owner
         *        A name, email address or other identifier for the person or group who is considered as the owner of
         *        this application group within your organization.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder owner(String owner);

        /**
         * <p>
         * The name of the application group, which you can change at any time.
         * </p>
         * 
         * @param displayName
         *        The name of the application group, which you can change at any time.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder displayName(String displayName);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ResourceGroupsRequest.BuilderImpl implements Builder {
        private String name;

        private String description;

        private ResourceQuery resourceQuery;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private List<GroupConfigurationItem> configuration = DefaultSdkAutoConstructList.getInstance();

        private Integer criticality;

        private String owner;

        private String displayName;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateGroupRequest model) {
            super(model);
            name(model.name);
            description(model.description);
            resourceQuery(model.resourceQuery);
            tags(model.tags);
            configuration(model.configuration);
            criticality(model.criticality);
            owner(model.owner);
            displayName(model.displayName);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final ResourceQuery.Builder getResourceQuery() {
            return resourceQuery != null ? resourceQuery.toBuilder() : null;
        }

        public final void setResourceQuery(ResourceQuery.BuilderImpl resourceQuery) {
            this.resourceQuery = resourceQuery != null ? resourceQuery.build() : null;
        }

        @Override
        public final Builder resourceQuery(ResourceQuery resourceQuery) {
            this.resourceQuery = resourceQuery;
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        public final List<GroupConfigurationItem.Builder> getConfiguration() {
            List<GroupConfigurationItem.Builder> result = GroupConfigurationListCopier.copyToBuilder(this.configuration);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setConfiguration(Collection<GroupConfigurationItem.BuilderImpl> configuration) {
            this.configuration = GroupConfigurationListCopier.copyFromBuilder(configuration);
        }

        @Override
        public final Builder configuration(Collection<GroupConfigurationItem> configuration) {
            this.configuration = GroupConfigurationListCopier.copy(configuration);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder configuration(GroupConfigurationItem... configuration) {
            configuration(Arrays.asList(configuration));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder configuration(Consumer<GroupConfigurationItem.Builder>... configuration) {
            configuration(Stream.of(configuration).map(c -> GroupConfigurationItem.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final Integer getCriticality() {
            return criticality;
        }

        public final void setCriticality(Integer criticality) {
            this.criticality = criticality;
        }

        @Override
        public final Builder criticality(Integer criticality) {
            this.criticality = criticality;
            return this;
        }

        public final String getOwner() {
            return owner;
        }

        public final void setOwner(String owner) {
            this.owner = owner;
        }

        @Override
        public final Builder owner(String owner) {
            this.owner = owner;
            return this;
        }

        public final String getDisplayName() {
            return displayName;
        }

        public final void setDisplayName(String displayName) {
            this.displayName = displayName;
        }

        @Override
        public final Builder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateGroupRequest build() {
            return new CreateGroupRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
