/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.resourcegroups.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetGroupQueryResponse extends ResourceGroupsResponse implements
        ToCopyableBuilder<GetGroupQueryResponse.Builder, GetGroupQueryResponse> {
    private static final SdkField<GroupQuery> GROUP_QUERY_FIELD = SdkField.<GroupQuery> builder(MarshallingType.SDK_POJO)
            .memberName("GroupQuery").getter(getter(GetGroupQueryResponse::groupQuery)).setter(setter(Builder::groupQuery))
            .constructor(GroupQuery::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GroupQuery").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GROUP_QUERY_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final GroupQuery groupQuery;

    private GetGroupQueryResponse(BuilderImpl builder) {
        super(builder);
        this.groupQuery = builder.groupQuery;
    }

    /**
     * <p>
     * The resource query associated with the specified group. For more information about resource queries, see <a
     * href="https://docs.aws.amazon.com/ARG/latest/userguide/gettingstarted-query.html#gettingstarted-query-cli-tag"
     * >Create a tag-based group in Resource Groups</a>.
     * </p>
     * 
     * @return The resource query associated with the specified group. For more information about resource queries, see
     *         <a href=
     *         "https://docs.aws.amazon.com/ARG/latest/userguide/gettingstarted-query.html#gettingstarted-query-cli-tag"
     *         >Create a tag-based group in Resource Groups</a>.
     */
    public final GroupQuery groupQuery() {
        return groupQuery;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(groupQuery());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetGroupQueryResponse)) {
            return false;
        }
        GetGroupQueryResponse other = (GetGroupQueryResponse) obj;
        return Objects.equals(groupQuery(), other.groupQuery());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetGroupQueryResponse").add("GroupQuery", groupQuery()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "GroupQuery":
            return Optional.ofNullable(clazz.cast(groupQuery()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("GroupQuery", GROUP_QUERY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetGroupQueryResponse, T> g) {
        return obj -> g.apply((GetGroupQueryResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends ResourceGroupsResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetGroupQueryResponse> {
        /**
         * <p>
         * The resource query associated with the specified group. For more information about resource queries, see <a
         * href
         * ="https://docs.aws.amazon.com/ARG/latest/userguide/gettingstarted-query.html#gettingstarted-query-cli-tag"
         * >Create a tag-based group in Resource Groups</a>.
         * </p>
         * 
         * @param groupQuery
         *        The resource query associated with the specified group. For more information about resource queries,
         *        see <a href=
         *        "https://docs.aws.amazon.com/ARG/latest/userguide/gettingstarted-query.html#gettingstarted-query-cli-tag"
         *        >Create a tag-based group in Resource Groups</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder groupQuery(GroupQuery groupQuery);

        /**
         * <p>
         * The resource query associated with the specified group. For more information about resource queries, see <a
         * href
         * ="https://docs.aws.amazon.com/ARG/latest/userguide/gettingstarted-query.html#gettingstarted-query-cli-tag"
         * >Create a tag-based group in Resource Groups</a>.
         * </p>
         * This is a convenience method that creates an instance of the {@link GroupQuery.Builder} avoiding the need to
         * create one manually via {@link GroupQuery#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link GroupQuery.Builder#build()} is called immediately and its result
         * is passed to {@link #groupQuery(GroupQuery)}.
         * 
         * @param groupQuery
         *        a consumer that will call methods on {@link GroupQuery.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #groupQuery(GroupQuery)
         */
        default Builder groupQuery(Consumer<GroupQuery.Builder> groupQuery) {
            return groupQuery(GroupQuery.builder().applyMutation(groupQuery).build());
        }
    }

    static final class BuilderImpl extends ResourceGroupsResponse.BuilderImpl implements Builder {
        private GroupQuery groupQuery;

        private BuilderImpl() {
        }

        private BuilderImpl(GetGroupQueryResponse model) {
            super(model);
            groupQuery(model.groupQuery);
        }

        public final GroupQuery.Builder getGroupQuery() {
            return groupQuery != null ? groupQuery.toBuilder() : null;
        }

        public final void setGroupQuery(GroupQuery.BuilderImpl groupQuery) {
            this.groupQuery = groupQuery != null ? groupQuery.build() : null;
        }

        @Override
        public final Builder groupQuery(GroupQuery groupQuery) {
            this.groupQuery = groupQuery;
            return this;
        }

        @Override
        public GetGroupQueryResponse build() {
            return new GetGroupQueryResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
