/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.resourcegroups.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListGroupingStatusesResponse extends ResourceGroupsResponse implements
        ToCopyableBuilder<ListGroupingStatusesResponse.Builder, ListGroupingStatusesResponse> {
    private static final SdkField<String> GROUP_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Group")
            .getter(getter(ListGroupingStatusesResponse::group)).setter(setter(Builder::group))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Group").build()).build();

    private static final SdkField<List<GroupingStatusesItem>> GROUPING_STATUSES_FIELD = SdkField
            .<List<GroupingStatusesItem>> builder(MarshallingType.LIST)
            .memberName("GroupingStatuses")
            .getter(getter(ListGroupingStatusesResponse::groupingStatuses))
            .setter(setter(Builder::groupingStatuses))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GroupingStatuses").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<GroupingStatusesItem> builder(MarshallingType.SDK_POJO)
                                            .constructor(GroupingStatusesItem::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListGroupingStatusesResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GROUP_FIELD,
            GROUPING_STATUSES_FIELD, NEXT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String group;

    private final List<GroupingStatusesItem> groupingStatuses;

    private final String nextToken;

    private ListGroupingStatusesResponse(BuilderImpl builder) {
        super(builder);
        this.group = builder.group;
        this.groupingStatuses = builder.groupingStatuses;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * The application group identifier, expressed as an Amazon resource name (ARN) or the application group name.
     * </p>
     * 
     * @return The application group identifier, expressed as an Amazon resource name (ARN) or the application group
     *         name.
     */
    public final String group() {
        return group;
    }

    /**
     * For responses, this returns true if the service returned a value for the GroupingStatuses property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasGroupingStatuses() {
        return groupingStatuses != null && !(groupingStatuses instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Returns details about the grouping or ungrouping status of the resources in the specified application group.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasGroupingStatuses} method.
     * </p>
     * 
     * @return Returns details about the grouping or ungrouping status of the resources in the specified application
     *         group.
     */
    public final List<GroupingStatusesItem> groupingStatuses() {
        return groupingStatuses;
    }

    /**
     * <p>
     * If present, indicates that more output is available than is included in the current response. Use this value in
     * the <code>NextToken</code> request parameter in a subsequent call to the operation to get the next part of the
     * output. You should repeat this until the <code>NextToken</code> response element comes back as <code>null</code>.
     * </p>
     * 
     * @return If present, indicates that more output is available than is included in the current response. Use this
     *         value in the <code>NextToken</code> request parameter in a subsequent call to the operation to get the
     *         next part of the output. You should repeat this until the <code>NextToken</code> response element comes
     *         back as <code>null</code>.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(group());
        hashCode = 31 * hashCode + Objects.hashCode(hasGroupingStatuses() ? groupingStatuses() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListGroupingStatusesResponse)) {
            return false;
        }
        ListGroupingStatusesResponse other = (ListGroupingStatusesResponse) obj;
        return Objects.equals(group(), other.group()) && hasGroupingStatuses() == other.hasGroupingStatuses()
                && Objects.equals(groupingStatuses(), other.groupingStatuses()) && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListGroupingStatusesResponse").add("Group", group())
                .add("GroupingStatuses", hasGroupingStatuses() ? groupingStatuses() : null).add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Group":
            return Optional.ofNullable(clazz.cast(group()));
        case "GroupingStatuses":
            return Optional.ofNullable(clazz.cast(groupingStatuses()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Group", GROUP_FIELD);
        map.put("GroupingStatuses", GROUPING_STATUSES_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListGroupingStatusesResponse, T> g) {
        return obj -> g.apply((ListGroupingStatusesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends ResourceGroupsResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ListGroupingStatusesResponse> {
        /**
         * <p>
         * The application group identifier, expressed as an Amazon resource name (ARN) or the application group name.
         * </p>
         * 
         * @param group
         *        The application group identifier, expressed as an Amazon resource name (ARN) or the application group
         *        name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder group(String group);

        /**
         * <p>
         * Returns details about the grouping or ungrouping status of the resources in the specified application group.
         * </p>
         * 
         * @param groupingStatuses
         *        Returns details about the grouping or ungrouping status of the resources in the specified application
         *        group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder groupingStatuses(Collection<GroupingStatusesItem> groupingStatuses);

        /**
         * <p>
         * Returns details about the grouping or ungrouping status of the resources in the specified application group.
         * </p>
         * 
         * @param groupingStatuses
         *        Returns details about the grouping or ungrouping status of the resources in the specified application
         *        group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder groupingStatuses(GroupingStatusesItem... groupingStatuses);

        /**
         * <p>
         * Returns details about the grouping or ungrouping status of the resources in the specified application group.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.resourcegroups.model.GroupingStatusesItem.Builder} avoiding the need
         * to create one manually via
         * {@link software.amazon.awssdk.services.resourcegroups.model.GroupingStatusesItem#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.resourcegroups.model.GroupingStatusesItem.Builder#build()} is called
         * immediately and its result is passed to {@link #groupingStatuses(List<GroupingStatusesItem>)}.
         * 
         * @param groupingStatuses
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.resourcegroups.model.GroupingStatusesItem.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #groupingStatuses(java.util.Collection<GroupingStatusesItem>)
         */
        Builder groupingStatuses(Consumer<GroupingStatusesItem.Builder>... groupingStatuses);

        /**
         * <p>
         * If present, indicates that more output is available than is included in the current response. Use this value
         * in the <code>NextToken</code> request parameter in a subsequent call to the operation to get the next part of
         * the output. You should repeat this until the <code>NextToken</code> response element comes back as
         * <code>null</code>.
         * </p>
         * 
         * @param nextToken
         *        If present, indicates that more output is available than is included in the current response. Use this
         *        value in the <code>NextToken</code> request parameter in a subsequent call to the operation to get the
         *        next part of the output. You should repeat this until the <code>NextToken</code> response element
         *        comes back as <code>null</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends ResourceGroupsResponse.BuilderImpl implements Builder {
        private String group;

        private List<GroupingStatusesItem> groupingStatuses = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListGroupingStatusesResponse model) {
            super(model);
            group(model.group);
            groupingStatuses(model.groupingStatuses);
            nextToken(model.nextToken);
        }

        public final String getGroup() {
            return group;
        }

        public final void setGroup(String group) {
            this.group = group;
        }

        @Override
        public final Builder group(String group) {
            this.group = group;
            return this;
        }

        public final List<GroupingStatusesItem.Builder> getGroupingStatuses() {
            List<GroupingStatusesItem.Builder> result = GroupingStatusesListCopier.copyToBuilder(this.groupingStatuses);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setGroupingStatuses(Collection<GroupingStatusesItem.BuilderImpl> groupingStatuses) {
            this.groupingStatuses = GroupingStatusesListCopier.copyFromBuilder(groupingStatuses);
        }

        @Override
        public final Builder groupingStatuses(Collection<GroupingStatusesItem> groupingStatuses) {
            this.groupingStatuses = GroupingStatusesListCopier.copy(groupingStatuses);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder groupingStatuses(GroupingStatusesItem... groupingStatuses) {
            groupingStatuses(Arrays.asList(groupingStatuses));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder groupingStatuses(Consumer<GroupingStatusesItem.Builder>... groupingStatuses) {
            groupingStatuses(Stream.of(groupingStatuses).map(c -> GroupingStatusesItem.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListGroupingStatusesResponse build() {
            return new ListGroupingStatusesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
