/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.resourcegroups.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class StartTagSyncTaskResponse extends ResourceGroupsResponse implements
        ToCopyableBuilder<StartTagSyncTaskResponse.Builder, StartTagSyncTaskResponse> {
    private static final SdkField<String> GROUP_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("GroupArn").getter(getter(StartTagSyncTaskResponse::groupArn)).setter(setter(Builder::groupArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GroupArn").build()).build();

    private static final SdkField<String> GROUP_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("GroupName").getter(getter(StartTagSyncTaskResponse::groupName)).setter(setter(Builder::groupName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GroupName").build()).build();

    private static final SdkField<String> TASK_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TaskArn").getter(getter(StartTagSyncTaskResponse::taskArn)).setter(setter(Builder::taskArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TaskArn").build()).build();

    private static final SdkField<String> TAG_KEY_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("TagKey")
            .getter(getter(StartTagSyncTaskResponse::tagKey)).setter(setter(Builder::tagKey))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TagKey").build()).build();

    private static final SdkField<String> TAG_VALUE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TagValue").getter(getter(StartTagSyncTaskResponse::tagValue)).setter(setter(Builder::tagValue))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TagValue").build()).build();

    private static final SdkField<ResourceQuery> RESOURCE_QUERY_FIELD = SdkField
            .<ResourceQuery> builder(MarshallingType.SDK_POJO).memberName("ResourceQuery")
            .getter(getter(StartTagSyncTaskResponse::resourceQuery)).setter(setter(Builder::resourceQuery))
            .constructor(ResourceQuery::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceQuery").build()).build();

    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RoleArn").getter(getter(StartTagSyncTaskResponse::roleArn)).setter(setter(Builder::roleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoleArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GROUP_ARN_FIELD,
            GROUP_NAME_FIELD, TASK_ARN_FIELD, TAG_KEY_FIELD, TAG_VALUE_FIELD, RESOURCE_QUERY_FIELD, ROLE_ARN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String groupArn;

    private final String groupName;

    private final String taskArn;

    private final String tagKey;

    private final String tagValue;

    private final ResourceQuery resourceQuery;

    private final String roleArn;

    private StartTagSyncTaskResponse(BuilderImpl builder) {
        super(builder);
        this.groupArn = builder.groupArn;
        this.groupName = builder.groupName;
        this.taskArn = builder.taskArn;
        this.tagKey = builder.tagKey;
        this.tagValue = builder.tagValue;
        this.resourceQuery = builder.resourceQuery;
        this.roleArn = builder.roleArn;
    }

    /**
     * <p>
     * The Amazon resource name (ARN) of the application group for which you want to add or remove resources.
     * </p>
     * 
     * @return The Amazon resource name (ARN) of the application group for which you want to add or remove resources.
     */
    public final String groupArn() {
        return groupArn;
    }

    /**
     * <p>
     * The name of the application group to onboard and sync resources.
     * </p>
     * 
     * @return The name of the application group to onboard and sync resources.
     */
    public final String groupName() {
        return groupName;
    }

    /**
     * <p>
     * The Amazon resource name (ARN) of the new tag-sync task.
     * </p>
     * 
     * @return The Amazon resource name (ARN) of the new tag-sync task.
     */
    public final String taskArn() {
        return taskArn;
    }

    /**
     * <p>
     * The tag key of the tag-sync task.
     * </p>
     * 
     * @return The tag key of the tag-sync task.
     */
    public final String tagKey() {
        return tagKey;
    }

    /**
     * <p>
     * The tag value of the tag-sync task.
     * </p>
     * 
     * @return The tag value of the tag-sync task.
     */
    public final String tagValue() {
        return tagValue;
    }

    /**
     * Returns the value of the ResourceQuery property for this object.
     * 
     * @return The value of the ResourceQuery property for this object.
     */
    public final ResourceQuery resourceQuery() {
        return resourceQuery;
    }

    /**
     * <p>
     * The Amazon resource name (ARN) of the role assumed by the service to tag and untag resources on your behalf.
     * </p>
     * 
     * @return The Amazon resource name (ARN) of the role assumed by the service to tag and untag resources on your
     *         behalf.
     */
    public final String roleArn() {
        return roleArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(groupArn());
        hashCode = 31 * hashCode + Objects.hashCode(groupName());
        hashCode = 31 * hashCode + Objects.hashCode(taskArn());
        hashCode = 31 * hashCode + Objects.hashCode(tagKey());
        hashCode = 31 * hashCode + Objects.hashCode(tagValue());
        hashCode = 31 * hashCode + Objects.hashCode(resourceQuery());
        hashCode = 31 * hashCode + Objects.hashCode(roleArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartTagSyncTaskResponse)) {
            return false;
        }
        StartTagSyncTaskResponse other = (StartTagSyncTaskResponse) obj;
        return Objects.equals(groupArn(), other.groupArn()) && Objects.equals(groupName(), other.groupName())
                && Objects.equals(taskArn(), other.taskArn()) && Objects.equals(tagKey(), other.tagKey())
                && Objects.equals(tagValue(), other.tagValue()) && Objects.equals(resourceQuery(), other.resourceQuery())
                && Objects.equals(roleArn(), other.roleArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("StartTagSyncTaskResponse").add("GroupArn", groupArn()).add("GroupName", groupName())
                .add("TaskArn", taskArn()).add("TagKey", tagKey()).add("TagValue", tagValue())
                .add("ResourceQuery", resourceQuery()).add("RoleArn", roleArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "GroupArn":
            return Optional.ofNullable(clazz.cast(groupArn()));
        case "GroupName":
            return Optional.ofNullable(clazz.cast(groupName()));
        case "TaskArn":
            return Optional.ofNullable(clazz.cast(taskArn()));
        case "TagKey":
            return Optional.ofNullable(clazz.cast(tagKey()));
        case "TagValue":
            return Optional.ofNullable(clazz.cast(tagValue()));
        case "ResourceQuery":
            return Optional.ofNullable(clazz.cast(resourceQuery()));
        case "RoleArn":
            return Optional.ofNullable(clazz.cast(roleArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("GroupArn", GROUP_ARN_FIELD);
        map.put("GroupName", GROUP_NAME_FIELD);
        map.put("TaskArn", TASK_ARN_FIELD);
        map.put("TagKey", TAG_KEY_FIELD);
        map.put("TagValue", TAG_VALUE_FIELD);
        map.put("ResourceQuery", RESOURCE_QUERY_FIELD);
        map.put("RoleArn", ROLE_ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<StartTagSyncTaskResponse, T> g) {
        return obj -> g.apply((StartTagSyncTaskResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends ResourceGroupsResponse.Builder, SdkPojo, CopyableBuilder<Builder, StartTagSyncTaskResponse> {
        /**
         * <p>
         * The Amazon resource name (ARN) of the application group for which you want to add or remove resources.
         * </p>
         * 
         * @param groupArn
         *        The Amazon resource name (ARN) of the application group for which you want to add or remove resources.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder groupArn(String groupArn);

        /**
         * <p>
         * The name of the application group to onboard and sync resources.
         * </p>
         * 
         * @param groupName
         *        The name of the application group to onboard and sync resources.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder groupName(String groupName);

        /**
         * <p>
         * The Amazon resource name (ARN) of the new tag-sync task.
         * </p>
         * 
         * @param taskArn
         *        The Amazon resource name (ARN) of the new tag-sync task.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder taskArn(String taskArn);

        /**
         * <p>
         * The tag key of the tag-sync task.
         * </p>
         * 
         * @param tagKey
         *        The tag key of the tag-sync task.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tagKey(String tagKey);

        /**
         * <p>
         * The tag value of the tag-sync task.
         * </p>
         * 
         * @param tagValue
         *        The tag value of the tag-sync task.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tagValue(String tagValue);

        /**
         * Sets the value of the ResourceQuery property for this object.
         *
         * @param resourceQuery
         *        The new value for the ResourceQuery property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceQuery(ResourceQuery resourceQuery);

        /**
         * Sets the value of the ResourceQuery property for this object.
         *
         * This is a convenience method that creates an instance of the {@link ResourceQuery.Builder} avoiding the need
         * to create one manually via {@link ResourceQuery#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ResourceQuery.Builder#build()} is called immediately and its
         * result is passed to {@link #resourceQuery(ResourceQuery)}.
         * 
         * @param resourceQuery
         *        a consumer that will call methods on {@link ResourceQuery.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #resourceQuery(ResourceQuery)
         */
        default Builder resourceQuery(Consumer<ResourceQuery.Builder> resourceQuery) {
            return resourceQuery(ResourceQuery.builder().applyMutation(resourceQuery).build());
        }

        /**
         * <p>
         * The Amazon resource name (ARN) of the role assumed by the service to tag and untag resources on your behalf.
         * </p>
         * 
         * @param roleArn
         *        The Amazon resource name (ARN) of the role assumed by the service to tag and untag resources on your
         *        behalf.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleArn(String roleArn);
    }

    static final class BuilderImpl extends ResourceGroupsResponse.BuilderImpl implements Builder {
        private String groupArn;

        private String groupName;

        private String taskArn;

        private String tagKey;

        private String tagValue;

        private ResourceQuery resourceQuery;

        private String roleArn;

        private BuilderImpl() {
        }

        private BuilderImpl(StartTagSyncTaskResponse model) {
            super(model);
            groupArn(model.groupArn);
            groupName(model.groupName);
            taskArn(model.taskArn);
            tagKey(model.tagKey);
            tagValue(model.tagValue);
            resourceQuery(model.resourceQuery);
            roleArn(model.roleArn);
        }

        public final String getGroupArn() {
            return groupArn;
        }

        public final void setGroupArn(String groupArn) {
            this.groupArn = groupArn;
        }

        @Override
        public final Builder groupArn(String groupArn) {
            this.groupArn = groupArn;
            return this;
        }

        public final String getGroupName() {
            return groupName;
        }

        public final void setGroupName(String groupName) {
            this.groupName = groupName;
        }

        @Override
        public final Builder groupName(String groupName) {
            this.groupName = groupName;
            return this;
        }

        public final String getTaskArn() {
            return taskArn;
        }

        public final void setTaskArn(String taskArn) {
            this.taskArn = taskArn;
        }

        @Override
        public final Builder taskArn(String taskArn) {
            this.taskArn = taskArn;
            return this;
        }

        public final String getTagKey() {
            return tagKey;
        }

        public final void setTagKey(String tagKey) {
            this.tagKey = tagKey;
        }

        @Override
        public final Builder tagKey(String tagKey) {
            this.tagKey = tagKey;
            return this;
        }

        public final String getTagValue() {
            return tagValue;
        }

        public final void setTagValue(String tagValue) {
            this.tagValue = tagValue;
        }

        @Override
        public final Builder tagValue(String tagValue) {
            this.tagValue = tagValue;
            return this;
        }

        public final ResourceQuery.Builder getResourceQuery() {
            return resourceQuery != null ? resourceQuery.toBuilder() : null;
        }

        public final void setResourceQuery(ResourceQuery.BuilderImpl resourceQuery) {
            this.resourceQuery = resourceQuery != null ? resourceQuery.build() : null;
        }

        @Override
        public final Builder resourceQuery(ResourceQuery resourceQuery) {
            this.resourceQuery = resourceQuery;
            return this;
        }

        public final String getRoleArn() {
            return roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        @Override
        public StartTagSyncTaskResponse build() {
            return new StartTagSyncTaskResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
