/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.resourcegroups.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The Amazon resource name (ARN) of the tag-sync task.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TagSyncTaskItem implements SdkPojo, Serializable, ToCopyableBuilder<TagSyncTaskItem.Builder, TagSyncTaskItem> {
    private static final SdkField<String> GROUP_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("GroupArn").getter(getter(TagSyncTaskItem::groupArn)).setter(setter(Builder::groupArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GroupArn").build()).build();

    private static final SdkField<String> GROUP_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("GroupName").getter(getter(TagSyncTaskItem::groupName)).setter(setter(Builder::groupName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GroupName").build()).build();

    private static final SdkField<String> TASK_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TaskArn").getter(getter(TagSyncTaskItem::taskArn)).setter(setter(Builder::taskArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TaskArn").build()).build();

    private static final SdkField<String> TAG_KEY_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("TagKey")
            .getter(getter(TagSyncTaskItem::tagKey)).setter(setter(Builder::tagKey))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TagKey").build()).build();

    private static final SdkField<String> TAG_VALUE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TagValue").getter(getter(TagSyncTaskItem::tagValue)).setter(setter(Builder::tagValue))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TagValue").build()).build();

    private static final SdkField<ResourceQuery> RESOURCE_QUERY_FIELD = SdkField
            .<ResourceQuery> builder(MarshallingType.SDK_POJO).memberName("ResourceQuery")
            .getter(getter(TagSyncTaskItem::resourceQuery)).setter(setter(Builder::resourceQuery))
            .constructor(ResourceQuery::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceQuery").build()).build();

    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RoleArn").getter(getter(TagSyncTaskItem::roleArn)).setter(setter(Builder::roleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoleArn").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(TagSyncTaskItem::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<String> ERROR_MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ErrorMessage").getter(getter(TagSyncTaskItem::errorMessage)).setter(setter(Builder::errorMessage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ErrorMessage").build()).build();

    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreatedAt").getter(getter(TagSyncTaskItem::createdAt)).setter(setter(Builder::createdAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedAt").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GROUP_ARN_FIELD,
            GROUP_NAME_FIELD, TASK_ARN_FIELD, TAG_KEY_FIELD, TAG_VALUE_FIELD, RESOURCE_QUERY_FIELD, ROLE_ARN_FIELD, STATUS_FIELD,
            ERROR_MESSAGE_FIELD, CREATED_AT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String groupArn;

    private final String groupName;

    private final String taskArn;

    private final String tagKey;

    private final String tagValue;

    private final ResourceQuery resourceQuery;

    private final String roleArn;

    private final String status;

    private final String errorMessage;

    private final Instant createdAt;

    private TagSyncTaskItem(BuilderImpl builder) {
        this.groupArn = builder.groupArn;
        this.groupName = builder.groupName;
        this.taskArn = builder.taskArn;
        this.tagKey = builder.tagKey;
        this.tagValue = builder.tagValue;
        this.resourceQuery = builder.resourceQuery;
        this.roleArn = builder.roleArn;
        this.status = builder.status;
        this.errorMessage = builder.errorMessage;
        this.createdAt = builder.createdAt;
    }

    /**
     * <p>
     * The Amazon resource name (ARN) of the application group.
     * </p>
     * 
     * @return The Amazon resource name (ARN) of the application group.
     */
    public final String groupArn() {
        return groupArn;
    }

    /**
     * <p>
     * The name of the application group.
     * </p>
     * 
     * @return The name of the application group.
     */
    public final String groupName() {
        return groupName;
    }

    /**
     * <p>
     * The Amazon resource name (ARN) of the tag-sync task.
     * </p>
     * 
     * @return The Amazon resource name (ARN) of the tag-sync task.
     */
    public final String taskArn() {
        return taskArn;
    }

    /**
     * <p>
     * The tag key.
     * </p>
     * 
     * @return The tag key.
     */
    public final String tagKey() {
        return tagKey;
    }

    /**
     * <p>
     * The tag value.
     * </p>
     * 
     * @return The tag value.
     */
    public final String tagValue() {
        return tagValue;
    }

    /**
     * Returns the value of the ResourceQuery property for this object.
     * 
     * @return The value of the ResourceQuery property for this object.
     */
    public final ResourceQuery resourceQuery() {
        return resourceQuery;
    }

    /**
     * <p>
     * The Amazon resource name (ARN) of the role assumed by the service to tag and untag resources on your behalf.
     * </p>
     * 
     * @return The Amazon resource name (ARN) of the role assumed by the service to tag and untag resources on your
     *         behalf.
     */
    public final String roleArn() {
        return roleArn;
    }

    /**
     * <p>
     * The status of the tag-sync task.
     * </p>
     * <p>
     * Valid values include:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>ACTIVE</code> - The tag-sync task is actively managing resources in the application by adding or removing
     * the <code>awsApplication</code> tag from resources when they are tagged or untagged with the specified tag
     * key-value pair.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ERROR</code> - The tag-sync task is not actively managing resources in the application. Review the
     * <code>ErrorMessage</code> for more information about resolving the error.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link TagSyncTaskStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the tag-sync task. </p>
     *         <p>
     *         Valid values include:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>ACTIVE</code> - The tag-sync task is actively managing resources in the application by adding or
     *         removing the <code>awsApplication</code> tag from resources when they are tagged or untagged with the
     *         specified tag key-value pair.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ERROR</code> - The tag-sync task is not actively managing resources in the application. Review the
     *         <code>ErrorMessage</code> for more information about resolving the error.
     *         </p>
     *         </li>
     * @see TagSyncTaskStatus
     */
    public final TagSyncTaskStatus status() {
        return TagSyncTaskStatus.fromValue(status);
    }

    /**
     * <p>
     * The status of the tag-sync task.
     * </p>
     * <p>
     * Valid values include:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>ACTIVE</code> - The tag-sync task is actively managing resources in the application by adding or removing
     * the <code>awsApplication</code> tag from resources when they are tagged or untagged with the specified tag
     * key-value pair.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ERROR</code> - The tag-sync task is not actively managing resources in the application. Review the
     * <code>ErrorMessage</code> for more information about resolving the error.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link TagSyncTaskStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the tag-sync task. </p>
     *         <p>
     *         Valid values include:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>ACTIVE</code> - The tag-sync task is actively managing resources in the application by adding or
     *         removing the <code>awsApplication</code> tag from resources when they are tagged or untagged with the
     *         specified tag key-value pair.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ERROR</code> - The tag-sync task is not actively managing resources in the application. Review the
     *         <code>ErrorMessage</code> for more information about resolving the error.
     *         </p>
     *         </li>
     * @see TagSyncTaskStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The specific error message in cases where the tag-sync task status is <code>Error</code>.
     * </p>
     * 
     * @return The specific error message in cases where the tag-sync task status is <code>Error</code>.
     */
    public final String errorMessage() {
        return errorMessage;
    }

    /**
     * <p>
     * The timestamp of when the tag-sync task was created.
     * </p>
     * 
     * @return The timestamp of when the tag-sync task was created.
     */
    public final Instant createdAt() {
        return createdAt;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(groupArn());
        hashCode = 31 * hashCode + Objects.hashCode(groupName());
        hashCode = 31 * hashCode + Objects.hashCode(taskArn());
        hashCode = 31 * hashCode + Objects.hashCode(tagKey());
        hashCode = 31 * hashCode + Objects.hashCode(tagValue());
        hashCode = 31 * hashCode + Objects.hashCode(resourceQuery());
        hashCode = 31 * hashCode + Objects.hashCode(roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(errorMessage());
        hashCode = 31 * hashCode + Objects.hashCode(createdAt());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TagSyncTaskItem)) {
            return false;
        }
        TagSyncTaskItem other = (TagSyncTaskItem) obj;
        return Objects.equals(groupArn(), other.groupArn()) && Objects.equals(groupName(), other.groupName())
                && Objects.equals(taskArn(), other.taskArn()) && Objects.equals(tagKey(), other.tagKey())
                && Objects.equals(tagValue(), other.tagValue()) && Objects.equals(resourceQuery(), other.resourceQuery())
                && Objects.equals(roleArn(), other.roleArn()) && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(errorMessage(), other.errorMessage()) && Objects.equals(createdAt(), other.createdAt());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TagSyncTaskItem").add("GroupArn", groupArn()).add("GroupName", groupName())
                .add("TaskArn", taskArn()).add("TagKey", tagKey()).add("TagValue", tagValue())
                .add("ResourceQuery", resourceQuery()).add("RoleArn", roleArn()).add("Status", statusAsString())
                .add("ErrorMessage", errorMessage()).add("CreatedAt", createdAt()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "GroupArn":
            return Optional.ofNullable(clazz.cast(groupArn()));
        case "GroupName":
            return Optional.ofNullable(clazz.cast(groupName()));
        case "TaskArn":
            return Optional.ofNullable(clazz.cast(taskArn()));
        case "TagKey":
            return Optional.ofNullable(clazz.cast(tagKey()));
        case "TagValue":
            return Optional.ofNullable(clazz.cast(tagValue()));
        case "ResourceQuery":
            return Optional.ofNullable(clazz.cast(resourceQuery()));
        case "RoleArn":
            return Optional.ofNullable(clazz.cast(roleArn()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "ErrorMessage":
            return Optional.ofNullable(clazz.cast(errorMessage()));
        case "CreatedAt":
            return Optional.ofNullable(clazz.cast(createdAt()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("GroupArn", GROUP_ARN_FIELD);
        map.put("GroupName", GROUP_NAME_FIELD);
        map.put("TaskArn", TASK_ARN_FIELD);
        map.put("TagKey", TAG_KEY_FIELD);
        map.put("TagValue", TAG_VALUE_FIELD);
        map.put("ResourceQuery", RESOURCE_QUERY_FIELD);
        map.put("RoleArn", ROLE_ARN_FIELD);
        map.put("Status", STATUS_FIELD);
        map.put("ErrorMessage", ERROR_MESSAGE_FIELD);
        map.put("CreatedAt", CREATED_AT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<TagSyncTaskItem, T> g) {
        return obj -> g.apply((TagSyncTaskItem) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TagSyncTaskItem> {
        /**
         * <p>
         * The Amazon resource name (ARN) of the application group.
         * </p>
         * 
         * @param groupArn
         *        The Amazon resource name (ARN) of the application group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder groupArn(String groupArn);

        /**
         * <p>
         * The name of the application group.
         * </p>
         * 
         * @param groupName
         *        The name of the application group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder groupName(String groupName);

        /**
         * <p>
         * The Amazon resource name (ARN) of the tag-sync task.
         * </p>
         * 
         * @param taskArn
         *        The Amazon resource name (ARN) of the tag-sync task.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder taskArn(String taskArn);

        /**
         * <p>
         * The tag key.
         * </p>
         * 
         * @param tagKey
         *        The tag key.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tagKey(String tagKey);

        /**
         * <p>
         * The tag value.
         * </p>
         * 
         * @param tagValue
         *        The tag value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tagValue(String tagValue);

        /**
         * Sets the value of the ResourceQuery property for this object.
         *
         * @param resourceQuery
         *        The new value for the ResourceQuery property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceQuery(ResourceQuery resourceQuery);

        /**
         * Sets the value of the ResourceQuery property for this object.
         *
         * This is a convenience method that creates an instance of the {@link ResourceQuery.Builder} avoiding the need
         * to create one manually via {@link ResourceQuery#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ResourceQuery.Builder#build()} is called immediately and its
         * result is passed to {@link #resourceQuery(ResourceQuery)}.
         * 
         * @param resourceQuery
         *        a consumer that will call methods on {@link ResourceQuery.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #resourceQuery(ResourceQuery)
         */
        default Builder resourceQuery(Consumer<ResourceQuery.Builder> resourceQuery) {
            return resourceQuery(ResourceQuery.builder().applyMutation(resourceQuery).build());
        }

        /**
         * <p>
         * The Amazon resource name (ARN) of the role assumed by the service to tag and untag resources on your behalf.
         * </p>
         * 
         * @param roleArn
         *        The Amazon resource name (ARN) of the role assumed by the service to tag and untag resources on your
         *        behalf.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleArn(String roleArn);

        /**
         * <p>
         * The status of the tag-sync task.
         * </p>
         * <p>
         * Valid values include:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>ACTIVE</code> - The tag-sync task is actively managing resources in the application by adding or
         * removing the <code>awsApplication</code> tag from resources when they are tagged or untagged with the
         * specified tag key-value pair.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ERROR</code> - The tag-sync task is not actively managing resources in the application. Review the
         * <code>ErrorMessage</code> for more information about resolving the error.
         * </p>
         * </li>
         * </ul>
         * 
         * @param status
         *        The status of the tag-sync task. </p>
         *        <p>
         *        Valid values include:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>ACTIVE</code> - The tag-sync task is actively managing resources in the application by adding or
         *        removing the <code>awsApplication</code> tag from resources when they are tagged or untagged with the
         *        specified tag key-value pair.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ERROR</code> - The tag-sync task is not actively managing resources in the application. Review
         *        the <code>ErrorMessage</code> for more information about resolving the error.
         *        </p>
         *        </li>
         * @see TagSyncTaskStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TagSyncTaskStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status of the tag-sync task.
         * </p>
         * <p>
         * Valid values include:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>ACTIVE</code> - The tag-sync task is actively managing resources in the application by adding or
         * removing the <code>awsApplication</code> tag from resources when they are tagged or untagged with the
         * specified tag key-value pair.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ERROR</code> - The tag-sync task is not actively managing resources in the application. Review the
         * <code>ErrorMessage</code> for more information about resolving the error.
         * </p>
         * </li>
         * </ul>
         * 
         * @param status
         *        The status of the tag-sync task. </p>
         *        <p>
         *        Valid values include:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>ACTIVE</code> - The tag-sync task is actively managing resources in the application by adding or
         *        removing the <code>awsApplication</code> tag from resources when they are tagged or untagged with the
         *        specified tag key-value pair.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ERROR</code> - The tag-sync task is not actively managing resources in the application. Review
         *        the <code>ErrorMessage</code> for more information about resolving the error.
         *        </p>
         *        </li>
         * @see TagSyncTaskStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TagSyncTaskStatus
         */
        Builder status(TagSyncTaskStatus status);

        /**
         * <p>
         * The specific error message in cases where the tag-sync task status is <code>Error</code>.
         * </p>
         * 
         * @param errorMessage
         *        The specific error message in cases where the tag-sync task status is <code>Error</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errorMessage(String errorMessage);

        /**
         * <p>
         * The timestamp of when the tag-sync task was created.
         * </p>
         * 
         * @param createdAt
         *        The timestamp of when the tag-sync task was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(Instant createdAt);
    }

    static final class BuilderImpl implements Builder {
        private String groupArn;

        private String groupName;

        private String taskArn;

        private String tagKey;

        private String tagValue;

        private ResourceQuery resourceQuery;

        private String roleArn;

        private String status;

        private String errorMessage;

        private Instant createdAt;

        private BuilderImpl() {
        }

        private BuilderImpl(TagSyncTaskItem model) {
            groupArn(model.groupArn);
            groupName(model.groupName);
            taskArn(model.taskArn);
            tagKey(model.tagKey);
            tagValue(model.tagValue);
            resourceQuery(model.resourceQuery);
            roleArn(model.roleArn);
            status(model.status);
            errorMessage(model.errorMessage);
            createdAt(model.createdAt);
        }

        public final String getGroupArn() {
            return groupArn;
        }

        public final void setGroupArn(String groupArn) {
            this.groupArn = groupArn;
        }

        @Override
        public final Builder groupArn(String groupArn) {
            this.groupArn = groupArn;
            return this;
        }

        public final String getGroupName() {
            return groupName;
        }

        public final void setGroupName(String groupName) {
            this.groupName = groupName;
        }

        @Override
        public final Builder groupName(String groupName) {
            this.groupName = groupName;
            return this;
        }

        public final String getTaskArn() {
            return taskArn;
        }

        public final void setTaskArn(String taskArn) {
            this.taskArn = taskArn;
        }

        @Override
        public final Builder taskArn(String taskArn) {
            this.taskArn = taskArn;
            return this;
        }

        public final String getTagKey() {
            return tagKey;
        }

        public final void setTagKey(String tagKey) {
            this.tagKey = tagKey;
        }

        @Override
        public final Builder tagKey(String tagKey) {
            this.tagKey = tagKey;
            return this;
        }

        public final String getTagValue() {
            return tagValue;
        }

        public final void setTagValue(String tagValue) {
            this.tagValue = tagValue;
        }

        @Override
        public final Builder tagValue(String tagValue) {
            this.tagValue = tagValue;
            return this;
        }

        public final ResourceQuery.Builder getResourceQuery() {
            return resourceQuery != null ? resourceQuery.toBuilder() : null;
        }

        public final void setResourceQuery(ResourceQuery.BuilderImpl resourceQuery) {
            this.resourceQuery = resourceQuery != null ? resourceQuery.build() : null;
        }

        @Override
        public final Builder resourceQuery(ResourceQuery resourceQuery) {
            this.resourceQuery = resourceQuery;
            return this;
        }

        public final String getRoleArn() {
            return roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(TagSyncTaskStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getErrorMessage() {
            return errorMessage;
        }

        public final void setErrorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
        }

        @Override
        public final Builder errorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
            return this;
        }

        public final Instant getCreatedAt() {
            return createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        @Override
        public TagSyncTaskItem build() {
            return new TagSyncTaskItem(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
