/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.resourcegroups;

import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkClient;
import software.amazon.awssdk.services.resourcegroups.model.CreateGroupRequest;
import software.amazon.awssdk.services.resourcegroups.model.CreateGroupResponse;
import software.amazon.awssdk.services.resourcegroups.model.DeleteGroupRequest;
import software.amazon.awssdk.services.resourcegroups.model.DeleteGroupResponse;
import software.amazon.awssdk.services.resourcegroups.model.GetGroupQueryRequest;
import software.amazon.awssdk.services.resourcegroups.model.GetGroupQueryResponse;
import software.amazon.awssdk.services.resourcegroups.model.GetGroupRequest;
import software.amazon.awssdk.services.resourcegroups.model.GetGroupResponse;
import software.amazon.awssdk.services.resourcegroups.model.GetTagsRequest;
import software.amazon.awssdk.services.resourcegroups.model.GetTagsResponse;
import software.amazon.awssdk.services.resourcegroups.model.ListGroupResourcesRequest;
import software.amazon.awssdk.services.resourcegroups.model.ListGroupResourcesResponse;
import software.amazon.awssdk.services.resourcegroups.model.ListGroupsRequest;
import software.amazon.awssdk.services.resourcegroups.model.ListGroupsResponse;
import software.amazon.awssdk.services.resourcegroups.model.SearchResourcesRequest;
import software.amazon.awssdk.services.resourcegroups.model.SearchResourcesResponse;
import software.amazon.awssdk.services.resourcegroups.model.TagRequest;
import software.amazon.awssdk.services.resourcegroups.model.TagResponse;
import software.amazon.awssdk.services.resourcegroups.model.UntagRequest;
import software.amazon.awssdk.services.resourcegroups.model.UntagResponse;
import software.amazon.awssdk.services.resourcegroups.model.UpdateGroupQueryRequest;
import software.amazon.awssdk.services.resourcegroups.model.UpdateGroupQueryResponse;
import software.amazon.awssdk.services.resourcegroups.model.UpdateGroupRequest;
import software.amazon.awssdk.services.resourcegroups.model.UpdateGroupResponse;
import software.amazon.awssdk.services.resourcegroups.paginators.ListGroupResourcesPublisher;
import software.amazon.awssdk.services.resourcegroups.paginators.ListGroupsPublisher;
import software.amazon.awssdk.services.resourcegroups.paginators.SearchResourcesPublisher;

/**
 * Service client for accessing Resource Groups asynchronously. This can be created using the static {@link #builder()}
 * method.
 *
 * <fullname>AWS Resource Groups</fullname>
 * <p>
 * AWS Resource Groups lets you organize AWS resources such as Amazon EC2 instances, Amazon Relational Database Service
 * databases, and Amazon S3 buckets into groups using criteria that you define as tags. A resource group is a collection
 * of resources that match the resource types specified in a query, and share one or more tags or portions of tags. You
 * can create a group of resources based on their roles in your cloud infrastructure, lifecycle stages, regions,
 * application layers, or virtually any criteria. Resource groups enable you to automate management tasks, such as those
 * in AWS Systems Manager Automation documents, on tag-related resources in AWS Systems Manager. Groups of tagged
 * resources also let you quickly view a custom console in AWS Systems Manager that shows AWS Config compliance and
 * other monitoring data about member resources.
 * </p>
 * <p>
 * To create a resource group, build a resource query, and specify tags that identify the criteria that members of the
 * group have in common. Tags are key-value pairs.
 * </p>
 * <p>
 * For more information about Resource Groups, see the <a
 * href="https://docs.aws.amazon.com/ARG/latest/userguide/welcome.html">AWS Resource Groups User Guide</a>.
 * </p>
 * <p>
 * AWS Resource Groups uses a REST-compliant API that you can use to perform the following types of operations.
 * </p>
 * <ul>
 * <li>
 * <p>
 * Create, Read, Update, and Delete (CRUD) operations on resource groups and resource query entities
 * </p>
 * </li>
 * <li>
 * <p>
 * Applying, editing, and removing tags from resource groups
 * </p>
 * </li>
 * <li>
 * <p>
 * Resolving resource group member ARNs so they can be returned as search results
 * </p>
 * </li>
 * <li>
 * <p>
 * Getting data about resources that are members of a group
 * </p>
 * </li>
 * <li>
 * <p>
 * Searching AWS resources based on a resource query
 * </p>
 * </li>
 * </ul>
 */
@Generated("software.amazon.awssdk:codegen")
public interface ResourceGroupsAsyncClient extends SdkClient {
    String SERVICE_NAME = "resource-groups";

    /**
     * Create a {@link ResourceGroupsAsyncClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static ResourceGroupsAsyncClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link ResourceGroupsAsyncClient}.
     */
    static ResourceGroupsAsyncClientBuilder builder() {
        return new DefaultResourceGroupsAsyncClientBuilder();
    }

    /**
     * <p>
     * Creates a group with a specified name, description, and resource query.
     * </p>
     *
     * @param createGroupRequest
     * @return A Java Future containing the result of the CreateGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The request does not comply with validation rules that are defined for the
     *         request parameters.</li>
     *         <li>ForbiddenException The caller is not authorized to make the request.</li>
     *         <li>MethodNotAllowedException The request uses an HTTP method which is not allowed for the specified
     *         resource.</li>
     *         <li>TooManyRequestsException The caller has exceeded throttling limits.</li>
     *         <li>InternalServerErrorException An internal error occurred while processing the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ResourceGroupsException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ResourceGroupsAsyncClient.CreateGroup
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/resource-groups-2017-11-27/CreateGroup" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateGroupResponse> createGroup(CreateGroupRequest createGroupRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a group with a specified name, description, and resource query.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateGroupRequest.Builder} avoiding the need to
     * create one manually via {@link CreateGroupRequest#builder()}
     * </p>
     *
     * @param createGroupRequest
     *        A {@link Consumer} that will call methods on {@link CreateGroupInput.Builder} to create a request.
     * @return A Java Future containing the result of the CreateGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The request does not comply with validation rules that are defined for the
     *         request parameters.</li>
     *         <li>ForbiddenException The caller is not authorized to make the request.</li>
     *         <li>MethodNotAllowedException The request uses an HTTP method which is not allowed for the specified
     *         resource.</li>
     *         <li>TooManyRequestsException The caller has exceeded throttling limits.</li>
     *         <li>InternalServerErrorException An internal error occurred while processing the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ResourceGroupsException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ResourceGroupsAsyncClient.CreateGroup
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/resource-groups-2017-11-27/CreateGroup" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateGroupResponse> createGroup(Consumer<CreateGroupRequest.Builder> createGroupRequest) {
        return createGroup(CreateGroupRequest.builder().applyMutation(createGroupRequest).build());
    }

    /**
     * <p>
     * Deletes a specified resource group. Deleting a resource group does not delete resources that are members of the
     * group; it only deletes the group structure.
     * </p>
     *
     * @param deleteGroupRequest
     * @return A Java Future containing the result of the DeleteGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The request does not comply with validation rules that are defined for the
     *         request parameters.</li>
     *         <li>ForbiddenException The caller is not authorized to make the request.</li>
     *         <li>NotFoundException One or more resources specified in the request do not exist.</li>
     *         <li>MethodNotAllowedException The request uses an HTTP method which is not allowed for the specified
     *         resource.</li>
     *         <li>TooManyRequestsException The caller has exceeded throttling limits.</li>
     *         <li>InternalServerErrorException An internal error occurred while processing the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ResourceGroupsException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ResourceGroupsAsyncClient.DeleteGroup
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/resource-groups-2017-11-27/DeleteGroup" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteGroupResponse> deleteGroup(DeleteGroupRequest deleteGroupRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a specified resource group. Deleting a resource group does not delete resources that are members of the
     * group; it only deletes the group structure.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteGroupRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteGroupRequest#builder()}
     * </p>
     *
     * @param deleteGroupRequest
     *        A {@link Consumer} that will call methods on {@link DeleteGroupInput.Builder} to create a request.
     * @return A Java Future containing the result of the DeleteGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The request does not comply with validation rules that are defined for the
     *         request parameters.</li>
     *         <li>ForbiddenException The caller is not authorized to make the request.</li>
     *         <li>NotFoundException One or more resources specified in the request do not exist.</li>
     *         <li>MethodNotAllowedException The request uses an HTTP method which is not allowed for the specified
     *         resource.</li>
     *         <li>TooManyRequestsException The caller has exceeded throttling limits.</li>
     *         <li>InternalServerErrorException An internal error occurred while processing the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ResourceGroupsException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ResourceGroupsAsyncClient.DeleteGroup
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/resource-groups-2017-11-27/DeleteGroup" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteGroupResponse> deleteGroup(Consumer<DeleteGroupRequest.Builder> deleteGroupRequest) {
        return deleteGroup(DeleteGroupRequest.builder().applyMutation(deleteGroupRequest).build());
    }

    /**
     * <p>
     * Returns information about a specified resource group.
     * </p>
     *
     * @param getGroupRequest
     * @return A Java Future containing the result of the GetGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The request does not comply with validation rules that are defined for the
     *         request parameters.</li>
     *         <li>ForbiddenException The caller is not authorized to make the request.</li>
     *         <li>NotFoundException One or more resources specified in the request do not exist.</li>
     *         <li>MethodNotAllowedException The request uses an HTTP method which is not allowed for the specified
     *         resource.</li>
     *         <li>TooManyRequestsException The caller has exceeded throttling limits.</li>
     *         <li>InternalServerErrorException An internal error occurred while processing the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ResourceGroupsException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ResourceGroupsAsyncClient.GetGroup
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/resource-groups-2017-11-27/GetGroup" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetGroupResponse> getGroup(GetGroupRequest getGroupRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about a specified resource group.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetGroupRequest.Builder} avoiding the need to
     * create one manually via {@link GetGroupRequest#builder()}
     * </p>
     *
     * @param getGroupRequest
     *        A {@link Consumer} that will call methods on {@link GetGroupInput.Builder} to create a request.
     * @return A Java Future containing the result of the GetGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The request does not comply with validation rules that are defined for the
     *         request parameters.</li>
     *         <li>ForbiddenException The caller is not authorized to make the request.</li>
     *         <li>NotFoundException One or more resources specified in the request do not exist.</li>
     *         <li>MethodNotAllowedException The request uses an HTTP method which is not allowed for the specified
     *         resource.</li>
     *         <li>TooManyRequestsException The caller has exceeded throttling limits.</li>
     *         <li>InternalServerErrorException An internal error occurred while processing the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ResourceGroupsException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ResourceGroupsAsyncClient.GetGroup
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/resource-groups-2017-11-27/GetGroup" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetGroupResponse> getGroup(Consumer<GetGroupRequest.Builder> getGroupRequest) {
        return getGroup(GetGroupRequest.builder().applyMutation(getGroupRequest).build());
    }

    /**
     * <p>
     * Returns the resource query associated with the specified resource group.
     * </p>
     *
     * @param getGroupQueryRequest
     * @return A Java Future containing the result of the GetGroupQuery operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The request does not comply with validation rules that are defined for the
     *         request parameters.</li>
     *         <li>ForbiddenException The caller is not authorized to make the request.</li>
     *         <li>NotFoundException One or more resources specified in the request do not exist.</li>
     *         <li>MethodNotAllowedException The request uses an HTTP method which is not allowed for the specified
     *         resource.</li>
     *         <li>TooManyRequestsException The caller has exceeded throttling limits.</li>
     *         <li>InternalServerErrorException An internal error occurred while processing the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ResourceGroupsException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ResourceGroupsAsyncClient.GetGroupQuery
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/resource-groups-2017-11-27/GetGroupQuery" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetGroupQueryResponse> getGroupQuery(GetGroupQueryRequest getGroupQueryRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the resource query associated with the specified resource group.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetGroupQueryRequest.Builder} avoiding the need to
     * create one manually via {@link GetGroupQueryRequest#builder()}
     * </p>
     *
     * @param getGroupQueryRequest
     *        A {@link Consumer} that will call methods on {@link GetGroupQueryInput.Builder} to create a request.
     * @return A Java Future containing the result of the GetGroupQuery operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The request does not comply with validation rules that are defined for the
     *         request parameters.</li>
     *         <li>ForbiddenException The caller is not authorized to make the request.</li>
     *         <li>NotFoundException One or more resources specified in the request do not exist.</li>
     *         <li>MethodNotAllowedException The request uses an HTTP method which is not allowed for the specified
     *         resource.</li>
     *         <li>TooManyRequestsException The caller has exceeded throttling limits.</li>
     *         <li>InternalServerErrorException An internal error occurred while processing the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ResourceGroupsException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ResourceGroupsAsyncClient.GetGroupQuery
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/resource-groups-2017-11-27/GetGroupQuery" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetGroupQueryResponse> getGroupQuery(Consumer<GetGroupQueryRequest.Builder> getGroupQueryRequest) {
        return getGroupQuery(GetGroupQueryRequest.builder().applyMutation(getGroupQueryRequest).build());
    }

    /**
     * <p>
     * Returns a list of tags that are associated with a resource group, specified by an ARN.
     * </p>
     *
     * @param getTagsRequest
     * @return A Java Future containing the result of the GetTags operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The request does not comply with validation rules that are defined for the
     *         request parameters.</li>
     *         <li>ForbiddenException The caller is not authorized to make the request.</li>
     *         <li>NotFoundException One or more resources specified in the request do not exist.</li>
     *         <li>MethodNotAllowedException The request uses an HTTP method which is not allowed for the specified
     *         resource.</li>
     *         <li>TooManyRequestsException The caller has exceeded throttling limits.</li>
     *         <li>InternalServerErrorException An internal error occurred while processing the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ResourceGroupsException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ResourceGroupsAsyncClient.GetTags
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/resource-groups-2017-11-27/GetTags" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetTagsResponse> getTags(GetTagsRequest getTagsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of tags that are associated with a resource group, specified by an ARN.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetTagsRequest.Builder} avoiding the need to create
     * one manually via {@link GetTagsRequest#builder()}
     * </p>
     *
     * @param getTagsRequest
     *        A {@link Consumer} that will call methods on {@link GetTagsInput.Builder} to create a request.
     * @return A Java Future containing the result of the GetTags operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The request does not comply with validation rules that are defined for the
     *         request parameters.</li>
     *         <li>ForbiddenException The caller is not authorized to make the request.</li>
     *         <li>NotFoundException One or more resources specified in the request do not exist.</li>
     *         <li>MethodNotAllowedException The request uses an HTTP method which is not allowed for the specified
     *         resource.</li>
     *         <li>TooManyRequestsException The caller has exceeded throttling limits.</li>
     *         <li>InternalServerErrorException An internal error occurred while processing the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ResourceGroupsException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ResourceGroupsAsyncClient.GetTags
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/resource-groups-2017-11-27/GetTags" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetTagsResponse> getTags(Consumer<GetTagsRequest.Builder> getTagsRequest) {
        return getTags(GetTagsRequest.builder().applyMutation(getTagsRequest).build());
    }

    /**
     * <p>
     * Returns a list of ARNs of resources that are members of a specified resource group.
     * </p>
     *
     * @param listGroupResourcesRequest
     * @return A Java Future containing the result of the ListGroupResources operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedException The request has not been applied because it lacks valid authentication
     *         credentials for the target resource.</li>
     *         <li>BadRequestException The request does not comply with validation rules that are defined for the
     *         request parameters.</li>
     *         <li>ForbiddenException The caller is not authorized to make the request.</li>
     *         <li>NotFoundException One or more resources specified in the request do not exist.</li>
     *         <li>MethodNotAllowedException The request uses an HTTP method which is not allowed for the specified
     *         resource.</li>
     *         <li>TooManyRequestsException The caller has exceeded throttling limits.</li>
     *         <li>InternalServerErrorException An internal error occurred while processing the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ResourceGroupsException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ResourceGroupsAsyncClient.ListGroupResources
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/resource-groups-2017-11-27/ListGroupResources"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListGroupResourcesResponse> listGroupResources(ListGroupResourcesRequest listGroupResourcesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of ARNs of resources that are members of a specified resource group.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListGroupResourcesRequest.Builder} avoiding the
     * need to create one manually via {@link ListGroupResourcesRequest#builder()}
     * </p>
     *
     * @param listGroupResourcesRequest
     *        A {@link Consumer} that will call methods on {@link ListGroupResourcesInput.Builder} to create a request.
     * @return A Java Future containing the result of the ListGroupResources operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedException The request has not been applied because it lacks valid authentication
     *         credentials for the target resource.</li>
     *         <li>BadRequestException The request does not comply with validation rules that are defined for the
     *         request parameters.</li>
     *         <li>ForbiddenException The caller is not authorized to make the request.</li>
     *         <li>NotFoundException One or more resources specified in the request do not exist.</li>
     *         <li>MethodNotAllowedException The request uses an HTTP method which is not allowed for the specified
     *         resource.</li>
     *         <li>TooManyRequestsException The caller has exceeded throttling limits.</li>
     *         <li>InternalServerErrorException An internal error occurred while processing the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ResourceGroupsException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ResourceGroupsAsyncClient.ListGroupResources
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/resource-groups-2017-11-27/ListGroupResources"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListGroupResourcesResponse> listGroupResources(
            Consumer<ListGroupResourcesRequest.Builder> listGroupResourcesRequest) {
        return listGroupResources(ListGroupResourcesRequest.builder().applyMutation(listGroupResourcesRequest).build());
    }

    /**
     * <p>
     * Returns a list of ARNs of resources that are members of a specified resource group.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listGroupResources(software.amazon.awssdk.services.resourcegroups.model.ListGroupResourcesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.resourcegroups.paginators.ListGroupResourcesPublisher publisher = client.listGroupResourcesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.resourcegroups.paginators.ListGroupResourcesPublisher publisher = client.listGroupResourcesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.resourcegroups.model.ListGroupResourcesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.resourcegroups.model.ListGroupResourcesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listGroupResources(software.amazon.awssdk.services.resourcegroups.model.ListGroupResourcesRequest)}
     * operation.</b>
     * </p>
     *
     * @param listGroupResourcesRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedException The request has not been applied because it lacks valid authentication
     *         credentials for the target resource.</li>
     *         <li>BadRequestException The request does not comply with validation rules that are defined for the
     *         request parameters.</li>
     *         <li>ForbiddenException The caller is not authorized to make the request.</li>
     *         <li>NotFoundException One or more resources specified in the request do not exist.</li>
     *         <li>MethodNotAllowedException The request uses an HTTP method which is not allowed for the specified
     *         resource.</li>
     *         <li>TooManyRequestsException The caller has exceeded throttling limits.</li>
     *         <li>InternalServerErrorException An internal error occurred while processing the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ResourceGroupsException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ResourceGroupsAsyncClient.ListGroupResources
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/resource-groups-2017-11-27/ListGroupResources"
     *      target="_top">AWS API Documentation</a>
     */
    default ListGroupResourcesPublisher listGroupResourcesPaginator(ListGroupResourcesRequest listGroupResourcesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of ARNs of resources that are members of a specified resource group.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listGroupResources(software.amazon.awssdk.services.resourcegroups.model.ListGroupResourcesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.resourcegroups.paginators.ListGroupResourcesPublisher publisher = client.listGroupResourcesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.resourcegroups.paginators.ListGroupResourcesPublisher publisher = client.listGroupResourcesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.resourcegroups.model.ListGroupResourcesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.resourcegroups.model.ListGroupResourcesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listGroupResources(software.amazon.awssdk.services.resourcegroups.model.ListGroupResourcesRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListGroupResourcesRequest.Builder} avoiding the
     * need to create one manually via {@link ListGroupResourcesRequest#builder()}
     * </p>
     *
     * @param listGroupResourcesRequest
     *        A {@link Consumer} that will call methods on {@link ListGroupResourcesInput.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedException The request has not been applied because it lacks valid authentication
     *         credentials for the target resource.</li>
     *         <li>BadRequestException The request does not comply with validation rules that are defined for the
     *         request parameters.</li>
     *         <li>ForbiddenException The caller is not authorized to make the request.</li>
     *         <li>NotFoundException One or more resources specified in the request do not exist.</li>
     *         <li>MethodNotAllowedException The request uses an HTTP method which is not allowed for the specified
     *         resource.</li>
     *         <li>TooManyRequestsException The caller has exceeded throttling limits.</li>
     *         <li>InternalServerErrorException An internal error occurred while processing the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ResourceGroupsException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ResourceGroupsAsyncClient.ListGroupResources
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/resource-groups-2017-11-27/ListGroupResources"
     *      target="_top">AWS API Documentation</a>
     */
    default ListGroupResourcesPublisher listGroupResourcesPaginator(
            Consumer<ListGroupResourcesRequest.Builder> listGroupResourcesRequest) {
        return listGroupResourcesPaginator(ListGroupResourcesRequest.builder().applyMutation(listGroupResourcesRequest).build());
    }

    /**
     * <p>
     * Returns a list of existing resource groups in your account.
     * </p>
     *
     * @param listGroupsRequest
     * @return A Java Future containing the result of the ListGroups operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The request does not comply with validation rules that are defined for the
     *         request parameters.</li>
     *         <li>ForbiddenException The caller is not authorized to make the request.</li>
     *         <li>MethodNotAllowedException The request uses an HTTP method which is not allowed for the specified
     *         resource.</li>
     *         <li>TooManyRequestsException The caller has exceeded throttling limits.</li>
     *         <li>InternalServerErrorException An internal error occurred while processing the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ResourceGroupsException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ResourceGroupsAsyncClient.ListGroups
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/resource-groups-2017-11-27/ListGroups" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListGroupsResponse> listGroups(ListGroupsRequest listGroupsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of existing resource groups in your account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListGroupsRequest.Builder} avoiding the need to
     * create one manually via {@link ListGroupsRequest#builder()}
     * </p>
     *
     * @param listGroupsRequest
     *        A {@link Consumer} that will call methods on {@link ListGroupsInput.Builder} to create a request.
     * @return A Java Future containing the result of the ListGroups operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The request does not comply with validation rules that are defined for the
     *         request parameters.</li>
     *         <li>ForbiddenException The caller is not authorized to make the request.</li>
     *         <li>MethodNotAllowedException The request uses an HTTP method which is not allowed for the specified
     *         resource.</li>
     *         <li>TooManyRequestsException The caller has exceeded throttling limits.</li>
     *         <li>InternalServerErrorException An internal error occurred while processing the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ResourceGroupsException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ResourceGroupsAsyncClient.ListGroups
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/resource-groups-2017-11-27/ListGroups" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListGroupsResponse> listGroups(Consumer<ListGroupsRequest.Builder> listGroupsRequest) {
        return listGroups(ListGroupsRequest.builder().applyMutation(listGroupsRequest).build());
    }

    /**
     * <p>
     * Returns a list of existing resource groups in your account.
     * </p>
     *
     * @return A Java Future containing the result of the ListGroups operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The request does not comply with validation rules that are defined for the
     *         request parameters.</li>
     *         <li>ForbiddenException The caller is not authorized to make the request.</li>
     *         <li>MethodNotAllowedException The request uses an HTTP method which is not allowed for the specified
     *         resource.</li>
     *         <li>TooManyRequestsException The caller has exceeded throttling limits.</li>
     *         <li>InternalServerErrorException An internal error occurred while processing the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ResourceGroupsException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ResourceGroupsAsyncClient.ListGroups
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/resource-groups-2017-11-27/ListGroups" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListGroupsResponse> listGroups() {
        return listGroups(ListGroupsRequest.builder().build());
    }

    /**
     * <p>
     * Returns a list of existing resource groups in your account.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listGroups(software.amazon.awssdk.services.resourcegroups.model.ListGroupsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.resourcegroups.paginators.ListGroupsPublisher publisher = client.listGroupsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.resourcegroups.paginators.ListGroupsPublisher publisher = client.listGroupsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.resourcegroups.model.ListGroupsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.resourcegroups.model.ListGroupsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listGroups(software.amazon.awssdk.services.resourcegroups.model.ListGroupsRequest)} operation.</b>
     * </p>
     *
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The request does not comply with validation rules that are defined for the
     *         request parameters.</li>
     *         <li>ForbiddenException The caller is not authorized to make the request.</li>
     *         <li>MethodNotAllowedException The request uses an HTTP method which is not allowed for the specified
     *         resource.</li>
     *         <li>TooManyRequestsException The caller has exceeded throttling limits.</li>
     *         <li>InternalServerErrorException An internal error occurred while processing the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ResourceGroupsException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ResourceGroupsAsyncClient.ListGroups
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/resource-groups-2017-11-27/ListGroups" target="_top">AWS API
     *      Documentation</a>
     */
    default ListGroupsPublisher listGroupsPaginator() {
        return listGroupsPaginator(ListGroupsRequest.builder().build());
    }

    /**
     * <p>
     * Returns a list of existing resource groups in your account.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listGroups(software.amazon.awssdk.services.resourcegroups.model.ListGroupsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.resourcegroups.paginators.ListGroupsPublisher publisher = client.listGroupsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.resourcegroups.paginators.ListGroupsPublisher publisher = client.listGroupsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.resourcegroups.model.ListGroupsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.resourcegroups.model.ListGroupsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listGroups(software.amazon.awssdk.services.resourcegroups.model.ListGroupsRequest)} operation.</b>
     * </p>
     *
     * @param listGroupsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The request does not comply with validation rules that are defined for the
     *         request parameters.</li>
     *         <li>ForbiddenException The caller is not authorized to make the request.</li>
     *         <li>MethodNotAllowedException The request uses an HTTP method which is not allowed for the specified
     *         resource.</li>
     *         <li>TooManyRequestsException The caller has exceeded throttling limits.</li>
     *         <li>InternalServerErrorException An internal error occurred while processing the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ResourceGroupsException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ResourceGroupsAsyncClient.ListGroups
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/resource-groups-2017-11-27/ListGroups" target="_top">AWS API
     *      Documentation</a>
     */
    default ListGroupsPublisher listGroupsPaginator(ListGroupsRequest listGroupsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of existing resource groups in your account.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listGroups(software.amazon.awssdk.services.resourcegroups.model.ListGroupsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.resourcegroups.paginators.ListGroupsPublisher publisher = client.listGroupsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.resourcegroups.paginators.ListGroupsPublisher publisher = client.listGroupsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.resourcegroups.model.ListGroupsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.resourcegroups.model.ListGroupsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listGroups(software.amazon.awssdk.services.resourcegroups.model.ListGroupsRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListGroupsRequest.Builder} avoiding the need to
     * create one manually via {@link ListGroupsRequest#builder()}
     * </p>
     *
     * @param listGroupsRequest
     *        A {@link Consumer} that will call methods on {@link ListGroupsInput.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The request does not comply with validation rules that are defined for the
     *         request parameters.</li>
     *         <li>ForbiddenException The caller is not authorized to make the request.</li>
     *         <li>MethodNotAllowedException The request uses an HTTP method which is not allowed for the specified
     *         resource.</li>
     *         <li>TooManyRequestsException The caller has exceeded throttling limits.</li>
     *         <li>InternalServerErrorException An internal error occurred while processing the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ResourceGroupsException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ResourceGroupsAsyncClient.ListGroups
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/resource-groups-2017-11-27/ListGroups" target="_top">AWS API
     *      Documentation</a>
     */
    default ListGroupsPublisher listGroupsPaginator(Consumer<ListGroupsRequest.Builder> listGroupsRequest) {
        return listGroupsPaginator(ListGroupsRequest.builder().applyMutation(listGroupsRequest).build());
    }

    /**
     * <p>
     * Returns a list of AWS resource identifiers that matches a specified query. The query uses the same format as a
     * resource query in a CreateGroup or UpdateGroupQuery operation.
     * </p>
     *
     * @param searchResourcesRequest
     * @return A Java Future containing the result of the SearchResources operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedException The request has not been applied because it lacks valid authentication
     *         credentials for the target resource.</li>
     *         <li>BadRequestException The request does not comply with validation rules that are defined for the
     *         request parameters.</li>
     *         <li>ForbiddenException The caller is not authorized to make the request.</li>
     *         <li>MethodNotAllowedException The request uses an HTTP method which is not allowed for the specified
     *         resource.</li>
     *         <li>TooManyRequestsException The caller has exceeded throttling limits.</li>
     *         <li>InternalServerErrorException An internal error occurred while processing the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ResourceGroupsException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ResourceGroupsAsyncClient.SearchResources
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/resource-groups-2017-11-27/SearchResources"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<SearchResourcesResponse> searchResources(SearchResourcesRequest searchResourcesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of AWS resource identifiers that matches a specified query. The query uses the same format as a
     * resource query in a CreateGroup or UpdateGroupQuery operation.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link SearchResourcesRequest.Builder} avoiding the need
     * to create one manually via {@link SearchResourcesRequest#builder()}
     * </p>
     *
     * @param searchResourcesRequest
     *        A {@link Consumer} that will call methods on {@link SearchResourcesInput.Builder} to create a request.
     * @return A Java Future containing the result of the SearchResources operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedException The request has not been applied because it lacks valid authentication
     *         credentials for the target resource.</li>
     *         <li>BadRequestException The request does not comply with validation rules that are defined for the
     *         request parameters.</li>
     *         <li>ForbiddenException The caller is not authorized to make the request.</li>
     *         <li>MethodNotAllowedException The request uses an HTTP method which is not allowed for the specified
     *         resource.</li>
     *         <li>TooManyRequestsException The caller has exceeded throttling limits.</li>
     *         <li>InternalServerErrorException An internal error occurred while processing the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ResourceGroupsException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ResourceGroupsAsyncClient.SearchResources
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/resource-groups-2017-11-27/SearchResources"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<SearchResourcesResponse> searchResources(
            Consumer<SearchResourcesRequest.Builder> searchResourcesRequest) {
        return searchResources(SearchResourcesRequest.builder().applyMutation(searchResourcesRequest).build());
    }

    /**
     * <p>
     * Returns a list of AWS resource identifiers that matches a specified query. The query uses the same format as a
     * resource query in a CreateGroup or UpdateGroupQuery operation.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #searchResources(software.amazon.awssdk.services.resourcegroups.model.SearchResourcesRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.resourcegroups.paginators.SearchResourcesPublisher publisher = client.searchResourcesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.resourcegroups.paginators.SearchResourcesPublisher publisher = client.searchResourcesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.resourcegroups.model.SearchResourcesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.resourcegroups.model.SearchResourcesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #searchResources(software.amazon.awssdk.services.resourcegroups.model.SearchResourcesRequest)}
     * operation.</b>
     * </p>
     *
     * @param searchResourcesRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedException The request has not been applied because it lacks valid authentication
     *         credentials for the target resource.</li>
     *         <li>BadRequestException The request does not comply with validation rules that are defined for the
     *         request parameters.</li>
     *         <li>ForbiddenException The caller is not authorized to make the request.</li>
     *         <li>MethodNotAllowedException The request uses an HTTP method which is not allowed for the specified
     *         resource.</li>
     *         <li>TooManyRequestsException The caller has exceeded throttling limits.</li>
     *         <li>InternalServerErrorException An internal error occurred while processing the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ResourceGroupsException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ResourceGroupsAsyncClient.SearchResources
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/resource-groups-2017-11-27/SearchResources"
     *      target="_top">AWS API Documentation</a>
     */
    default SearchResourcesPublisher searchResourcesPaginator(SearchResourcesRequest searchResourcesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of AWS resource identifiers that matches a specified query. The query uses the same format as a
     * resource query in a CreateGroup or UpdateGroupQuery operation.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #searchResources(software.amazon.awssdk.services.resourcegroups.model.SearchResourcesRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.resourcegroups.paginators.SearchResourcesPublisher publisher = client.searchResourcesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.resourcegroups.paginators.SearchResourcesPublisher publisher = client.searchResourcesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.resourcegroups.model.SearchResourcesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.resourcegroups.model.SearchResourcesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #searchResources(software.amazon.awssdk.services.resourcegroups.model.SearchResourcesRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link SearchResourcesRequest.Builder} avoiding the need
     * to create one manually via {@link SearchResourcesRequest#builder()}
     * </p>
     *
     * @param searchResourcesRequest
     *        A {@link Consumer} that will call methods on {@link SearchResourcesInput.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UnauthorizedException The request has not been applied because it lacks valid authentication
     *         credentials for the target resource.</li>
     *         <li>BadRequestException The request does not comply with validation rules that are defined for the
     *         request parameters.</li>
     *         <li>ForbiddenException The caller is not authorized to make the request.</li>
     *         <li>MethodNotAllowedException The request uses an HTTP method which is not allowed for the specified
     *         resource.</li>
     *         <li>TooManyRequestsException The caller has exceeded throttling limits.</li>
     *         <li>InternalServerErrorException An internal error occurred while processing the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ResourceGroupsException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ResourceGroupsAsyncClient.SearchResources
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/resource-groups-2017-11-27/SearchResources"
     *      target="_top">AWS API Documentation</a>
     */
    default SearchResourcesPublisher searchResourcesPaginator(Consumer<SearchResourcesRequest.Builder> searchResourcesRequest) {
        return searchResourcesPaginator(SearchResourcesRequest.builder().applyMutation(searchResourcesRequest).build());
    }

    /**
     * <p>
     * Adds tags to a resource group with the specified ARN. Existing tags on a resource group are not changed if they
     * are not specified in the request parameters.
     * </p>
     *
     * @param tagRequest
     * @return A Java Future containing the result of the Tag operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The request does not comply with validation rules that are defined for the
     *         request parameters.</li>
     *         <li>ForbiddenException The caller is not authorized to make the request.</li>
     *         <li>NotFoundException One or more resources specified in the request do not exist.</li>
     *         <li>MethodNotAllowedException The request uses an HTTP method which is not allowed for the specified
     *         resource.</li>
     *         <li>TooManyRequestsException The caller has exceeded throttling limits.</li>
     *         <li>InternalServerErrorException An internal error occurred while processing the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ResourceGroupsException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ResourceGroupsAsyncClient.Tag
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/resource-groups-2017-11-27/Tag" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<TagResponse> tag(TagRequest tagRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Adds tags to a resource group with the specified ARN. Existing tags on a resource group are not changed if they
     * are not specified in the request parameters.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link TagRequest.Builder} avoiding the need to create one
     * manually via {@link TagRequest#builder()}
     * </p>
     *
     * @param tagRequest
     *        A {@link Consumer} that will call methods on {@link TagInput.Builder} to create a request.
     * @return A Java Future containing the result of the Tag operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The request does not comply with validation rules that are defined for the
     *         request parameters.</li>
     *         <li>ForbiddenException The caller is not authorized to make the request.</li>
     *         <li>NotFoundException One or more resources specified in the request do not exist.</li>
     *         <li>MethodNotAllowedException The request uses an HTTP method which is not allowed for the specified
     *         resource.</li>
     *         <li>TooManyRequestsException The caller has exceeded throttling limits.</li>
     *         <li>InternalServerErrorException An internal error occurred while processing the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ResourceGroupsException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ResourceGroupsAsyncClient.Tag
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/resource-groups-2017-11-27/Tag" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<TagResponse> tag(Consumer<TagRequest.Builder> tagRequest) {
        return tag(TagRequest.builder().applyMutation(tagRequest).build());
    }

    /**
     * <p>
     * Deletes specified tags from a specified resource.
     * </p>
     *
     * @param untagRequest
     * @return A Java Future containing the result of the Untag operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The request does not comply with validation rules that are defined for the
     *         request parameters.</li>
     *         <li>ForbiddenException The caller is not authorized to make the request.</li>
     *         <li>NotFoundException One or more resources specified in the request do not exist.</li>
     *         <li>MethodNotAllowedException The request uses an HTTP method which is not allowed for the specified
     *         resource.</li>
     *         <li>TooManyRequestsException The caller has exceeded throttling limits.</li>
     *         <li>InternalServerErrorException An internal error occurred while processing the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ResourceGroupsException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ResourceGroupsAsyncClient.Untag
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/resource-groups-2017-11-27/Untag" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UntagResponse> untag(UntagRequest untagRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes specified tags from a specified resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UntagRequest.Builder} avoiding the need to create
     * one manually via {@link UntagRequest#builder()}
     * </p>
     *
     * @param untagRequest
     *        A {@link Consumer} that will call methods on {@link UntagInput.Builder} to create a request.
     * @return A Java Future containing the result of the Untag operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The request does not comply with validation rules that are defined for the
     *         request parameters.</li>
     *         <li>ForbiddenException The caller is not authorized to make the request.</li>
     *         <li>NotFoundException One or more resources specified in the request do not exist.</li>
     *         <li>MethodNotAllowedException The request uses an HTTP method which is not allowed for the specified
     *         resource.</li>
     *         <li>TooManyRequestsException The caller has exceeded throttling limits.</li>
     *         <li>InternalServerErrorException An internal error occurred while processing the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ResourceGroupsException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ResourceGroupsAsyncClient.Untag
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/resource-groups-2017-11-27/Untag" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UntagResponse> untag(Consumer<UntagRequest.Builder> untagRequest) {
        return untag(UntagRequest.builder().applyMutation(untagRequest).build());
    }

    /**
     * <p>
     * Updates an existing group with a new or changed description. You cannot update the name of a resource group.
     * </p>
     *
     * @param updateGroupRequest
     * @return A Java Future containing the result of the UpdateGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The request does not comply with validation rules that are defined for the
     *         request parameters.</li>
     *         <li>ForbiddenException The caller is not authorized to make the request.</li>
     *         <li>NotFoundException One or more resources specified in the request do not exist.</li>
     *         <li>MethodNotAllowedException The request uses an HTTP method which is not allowed for the specified
     *         resource.</li>
     *         <li>TooManyRequestsException The caller has exceeded throttling limits.</li>
     *         <li>InternalServerErrorException An internal error occurred while processing the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ResourceGroupsException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ResourceGroupsAsyncClient.UpdateGroup
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/resource-groups-2017-11-27/UpdateGroup" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<UpdateGroupResponse> updateGroup(UpdateGroupRequest updateGroupRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates an existing group with a new or changed description. You cannot update the name of a resource group.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateGroupRequest.Builder} avoiding the need to
     * create one manually via {@link UpdateGroupRequest#builder()}
     * </p>
     *
     * @param updateGroupRequest
     *        A {@link Consumer} that will call methods on {@link UpdateGroupInput.Builder} to create a request.
     * @return A Java Future containing the result of the UpdateGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The request does not comply with validation rules that are defined for the
     *         request parameters.</li>
     *         <li>ForbiddenException The caller is not authorized to make the request.</li>
     *         <li>NotFoundException One or more resources specified in the request do not exist.</li>
     *         <li>MethodNotAllowedException The request uses an HTTP method which is not allowed for the specified
     *         resource.</li>
     *         <li>TooManyRequestsException The caller has exceeded throttling limits.</li>
     *         <li>InternalServerErrorException An internal error occurred while processing the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ResourceGroupsException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ResourceGroupsAsyncClient.UpdateGroup
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/resource-groups-2017-11-27/UpdateGroup" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<UpdateGroupResponse> updateGroup(Consumer<UpdateGroupRequest.Builder> updateGroupRequest) {
        return updateGroup(UpdateGroupRequest.builder().applyMutation(updateGroupRequest).build());
    }

    /**
     * <p>
     * Updates the resource query of a group.
     * </p>
     *
     * @param updateGroupQueryRequest
     * @return A Java Future containing the result of the UpdateGroupQuery operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The request does not comply with validation rules that are defined for the
     *         request parameters.</li>
     *         <li>ForbiddenException The caller is not authorized to make the request.</li>
     *         <li>NotFoundException One or more resources specified in the request do not exist.</li>
     *         <li>MethodNotAllowedException The request uses an HTTP method which is not allowed for the specified
     *         resource.</li>
     *         <li>TooManyRequestsException The caller has exceeded throttling limits.</li>
     *         <li>InternalServerErrorException An internal error occurred while processing the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ResourceGroupsException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ResourceGroupsAsyncClient.UpdateGroupQuery
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/resource-groups-2017-11-27/UpdateGroupQuery"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateGroupQueryResponse> updateGroupQuery(UpdateGroupQueryRequest updateGroupQueryRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the resource query of a group.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateGroupQueryRequest.Builder} avoiding the need
     * to create one manually via {@link UpdateGroupQueryRequest#builder()}
     * </p>
     *
     * @param updateGroupQueryRequest
     *        A {@link Consumer} that will call methods on {@link UpdateGroupQueryInput.Builder} to create a request.
     * @return A Java Future containing the result of the UpdateGroupQuery operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException The request does not comply with validation rules that are defined for the
     *         request parameters.</li>
     *         <li>ForbiddenException The caller is not authorized to make the request.</li>
     *         <li>NotFoundException One or more resources specified in the request do not exist.</li>
     *         <li>MethodNotAllowedException The request uses an HTTP method which is not allowed for the specified
     *         resource.</li>
     *         <li>TooManyRequestsException The caller has exceeded throttling limits.</li>
     *         <li>InternalServerErrorException An internal error occurred while processing the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ResourceGroupsException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ResourceGroupsAsyncClient.UpdateGroupQuery
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/resource-groups-2017-11-27/UpdateGroupQuery"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateGroupQueryResponse> updateGroupQuery(
            Consumer<UpdateGroupQueryRequest.Builder> updateGroupQueryRequest) {
        return updateGroupQuery(UpdateGroupQueryRequest.builder().applyMutation(updateGroupQueryRequest).build());
    }
}
