/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.resourcegroups.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateGroupRequest extends ResourceGroupsRequest implements
        ToCopyableBuilder<CreateGroupRequest.Builder, CreateGroupRequest> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateGroupRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateGroupRequest::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<ResourceQuery> RESOURCE_QUERY_FIELD = SdkField
            .<ResourceQuery> builder(MarshallingType.SDK_POJO).getter(getter(CreateGroupRequest::resourceQuery))
            .setter(setter(Builder::resourceQuery)).constructor(ResourceQuery::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceQuery").build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .getter(getter(CreateGroupRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, DESCRIPTION_FIELD,
            RESOURCE_QUERY_FIELD, TAGS_FIELD));

    private final String name;

    private final String description;

    private final ResourceQuery resourceQuery;

    private final Map<String, String> tags;

    private CreateGroupRequest(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.description = builder.description;
        this.resourceQuery = builder.resourceQuery;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * The name of the group, which is the identifier of the group in other operations. A resource group name cannot be
     * updated after it is created. A resource group name can have a maximum of 128 characters, including letters,
     * numbers, hyphens, dots, and underscores. The name cannot start with <code>AWS</code> or <code>aws</code>; these
     * are reserved. A resource group name must be unique within your account.
     * </p>
     * 
     * @return The name of the group, which is the identifier of the group in other operations. A resource group name
     *         cannot be updated after it is created. A resource group name can have a maximum of 128 characters,
     *         including letters, numbers, hyphens, dots, and underscores. The name cannot start with <code>AWS</code>
     *         or <code>aws</code>; these are reserved. A resource group name must be unique within your account.
     */
    public String name() {
        return name;
    }

    /**
     * <p>
     * The description of the resource group. Descriptions can have a maximum of 511 characters, including letters,
     * numbers, hyphens, underscores, punctuation, and spaces.
     * </p>
     * 
     * @return The description of the resource group. Descriptions can have a maximum of 511 characters, including
     *         letters, numbers, hyphens, underscores, punctuation, and spaces.
     */
    public String description() {
        return description;
    }

    /**
     * <p>
     * The resource query that determines which AWS resources are members of this group.
     * </p>
     * 
     * @return The resource query that determines which AWS resources are members of this group.
     */
    public ResourceQuery resourceQuery() {
        return resourceQuery;
    }

    /**
     * <p>
     * The tags to add to the group. A tag is a string-to-string map of key-value pairs. Tag keys can have a maximum
     * character length of 128 characters, and tag values can have a maximum length of 256 characters.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The tags to add to the group. A tag is a string-to-string map of key-value pairs. Tag keys can have a
     *         maximum character length of 128 characters, and tag values can have a maximum length of 256 characters.
     */
    public Map<String, String> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(resourceQuery());
        hashCode = 31 * hashCode + Objects.hashCode(tags());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateGroupRequest)) {
            return false;
        }
        CreateGroupRequest other = (CreateGroupRequest) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(description(), other.description())
                && Objects.equals(resourceQuery(), other.resourceQuery()) && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("CreateGroupRequest").add("Name", name()).add("Description", description())
                .add("ResourceQuery", resourceQuery()).add("Tags", tags()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "ResourceQuery":
            return Optional.ofNullable(clazz.cast(resourceQuery()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateGroupRequest, T> g) {
        return obj -> g.apply((CreateGroupRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ResourceGroupsRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateGroupRequest> {
        /**
         * <p>
         * The name of the group, which is the identifier of the group in other operations. A resource group name cannot
         * be updated after it is created. A resource group name can have a maximum of 128 characters, including
         * letters, numbers, hyphens, dots, and underscores. The name cannot start with <code>AWS</code> or
         * <code>aws</code>; these are reserved. A resource group name must be unique within your account.
         * </p>
         * 
         * @param name
         *        The name of the group, which is the identifier of the group in other operations. A resource group name
         *        cannot be updated after it is created. A resource group name can have a maximum of 128 characters,
         *        including letters, numbers, hyphens, dots, and underscores. The name cannot start with
         *        <code>AWS</code> or <code>aws</code>; these are reserved. A resource group name must be unique within
         *        your account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The description of the resource group. Descriptions can have a maximum of 511 characters, including letters,
         * numbers, hyphens, underscores, punctuation, and spaces.
         * </p>
         * 
         * @param description
         *        The description of the resource group. Descriptions can have a maximum of 511 characters, including
         *        letters, numbers, hyphens, underscores, punctuation, and spaces.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The resource query that determines which AWS resources are members of this group.
         * </p>
         * 
         * @param resourceQuery
         *        The resource query that determines which AWS resources are members of this group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceQuery(ResourceQuery resourceQuery);

        /**
         * <p>
         * The resource query that determines which AWS resources are members of this group.
         * </p>
         * This is a convenience that creates an instance of the {@link ResourceQuery.Builder} avoiding the need to
         * create one manually via {@link ResourceQuery#builder()}.
         *
         * When the {@link Consumer} completes, {@link ResourceQuery.Builder#build()} is called immediately and its
         * result is passed to {@link #resourceQuery(ResourceQuery)}.
         * 
         * @param resourceQuery
         *        a consumer that will call methods on {@link ResourceQuery.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #resourceQuery(ResourceQuery)
         */
        default Builder resourceQuery(Consumer<ResourceQuery.Builder> resourceQuery) {
            return resourceQuery(ResourceQuery.builder().applyMutation(resourceQuery).build());
        }

        /**
         * <p>
         * The tags to add to the group. A tag is a string-to-string map of key-value pairs. Tag keys can have a maximum
         * character length of 128 characters, and tag values can have a maximum length of 256 characters.
         * </p>
         * 
         * @param tags
         *        The tags to add to the group. A tag is a string-to-string map of key-value pairs. Tag keys can have a
         *        maximum character length of 128 characters, and tag values can have a maximum length of 256
         *        characters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ResourceGroupsRequest.BuilderImpl implements Builder {
        private String name;

        private String description;

        private ResourceQuery resourceQuery;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateGroupRequest model) {
            super(model);
            name(model.name);
            description(model.description);
            resourceQuery(model.resourceQuery);
            tags(model.tags);
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getDescription() {
            return description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final ResourceQuery.Builder getResourceQuery() {
            return resourceQuery != null ? resourceQuery.toBuilder() : null;
        }

        @Override
        public final Builder resourceQuery(ResourceQuery resourceQuery) {
            this.resourceQuery = resourceQuery;
            return this;
        }

        public final void setResourceQuery(ResourceQuery.BuilderImpl resourceQuery) {
            this.resourceQuery = resourceQuery != null ? resourceQuery.build() : null;
        }

        public final Map<String, String> getTags() {
            return tags;
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateGroupRequest build() {
            return new CreateGroupRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
