/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.retries.internal.circuitbreaker;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.utils.Validate;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

@SdkInternalApi
public final class ReleaseResponse
implements ToCopyableBuilder<Builder, ReleaseResponse> {
    private final int capacityReleased;
    private final int currentCapacity;
    private final int maxCapacity;

    private ReleaseResponse(Builder builder) {
        this.capacityReleased = (Integer)Validate.paramNotNull((Object)builder.capacityReleased, (String)"capacityReleased");
        this.currentCapacity = (Integer)Validate.paramNotNull((Object)builder.currentCapacity, (String)"currentCapacity");
        this.maxCapacity = (Integer)Validate.paramNotNull((Object)builder.maxCapacity, (String)"maxCapacity");
    }

    public int capacityReleased() {
        return this.capacityReleased;
    }

    public int currentCapacity() {
        return this.currentCapacity;
    }

    public int maxCapacity() {
        return this.maxCapacity;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static class Builder
    implements CopyableBuilder<Builder, ReleaseResponse> {
        private Integer capacityReleased;
        private Integer currentCapacity;
        private Integer maxCapacity;

        Builder(ReleaseResponse releaseResponse) {
            this.capacityReleased = releaseResponse.capacityReleased;
            this.currentCapacity = releaseResponse.currentCapacity;
            this.maxCapacity = releaseResponse.maxCapacity;
        }

        Builder() {
        }

        public Builder capacityReleased(Integer capacityReleased) {
            this.capacityReleased = capacityReleased;
            return this;
        }

        public Builder currentCapacity(Integer currentCapacity) {
            this.currentCapacity = currentCapacity;
            return this;
        }

        public Builder maxCapacity(Integer maxCapacity) {
            this.maxCapacity = maxCapacity;
            return this;
        }

        public ReleaseResponse build() {
            return new ReleaseResponse(this);
        }
    }
}

