/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.retries.internal;

import java.util.function.Predicate;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.retries.LegacyRetryStrategy;
import software.amazon.awssdk.retries.api.BackoffStrategy;
import software.amazon.awssdk.retries.api.RefreshRetryTokenRequest;
import software.amazon.awssdk.retries.internal.BaseRetryStrategy;
import software.amazon.awssdk.retries.internal.circuitbreaker.TokenBucketStore;
import software.amazon.awssdk.utils.Logger;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public final class DefaultLegacyRetryStrategy
extends BaseRetryStrategy
implements LegacyRetryStrategy {
    private static final Logger LOG = Logger.loggerFor(LegacyRetryStrategy.class);
    private final int throttlingExceptionCost;

    DefaultLegacyRetryStrategy(Builder builder) {
        super(LOG, builder);
        this.throttlingExceptionCost = (Integer)Validate.paramNotNull((Object)builder.throttlingExceptionCost, (String)"throttlingExceptionCost");
    }

    @Override
    protected int exceptionCost(RefreshRetryTokenRequest request) {
        if (this.circuitBreakerEnabled) {
            if (this.treatAsThrottling.test(request.failure())) {
                return this.throttlingExceptionCost;
            }
            return this.exceptionCost;
        }
        return 0;
    }

    @Override
    public Builder toBuilder() {
        return new Builder(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder
    extends BaseRetryStrategy.Builder
    implements LegacyRetryStrategy.Builder {
        private Integer throttlingExceptionCost;

        Builder() {
        }

        Builder(DefaultLegacyRetryStrategy strategy) {
            super(strategy);
            this.throttlingExceptionCost = strategy.throttlingExceptionCost;
        }

        public Builder retryOnException(Predicate<Throwable> shouldRetry) {
            this.setRetryOnException(shouldRetry);
            return this;
        }

        public Builder maxAttempts(int maxAttempts) {
            this.setMaxAttempts(maxAttempts);
            return this;
        }

        public Builder backoffStrategy(BackoffStrategy backoffStrategy) {
            this.setBackoffStrategy(backoffStrategy);
            return this;
        }

        @Override
        public Builder throttlingBackoffStrategy(BackoffStrategy throttlingBackoffStrategy) {
            this.setThrottlingBackoffStrategy(throttlingBackoffStrategy);
            return this;
        }

        @Override
        public Builder circuitBreakerEnabled(Boolean circuitBreakerEnabled) {
            this.setCircuitBreakerEnabled(circuitBreakerEnabled);
            return this;
        }

        @Override
        public Builder treatAsThrottling(Predicate<Throwable> treatAsThrottling) {
            this.setTreatAsThrottling(treatAsThrottling);
            return this;
        }

        public Builder tokenBucketExceptionCost(int exceptionCost) {
            this.setTokenBucketExceptionCost(exceptionCost);
            return this;
        }

        public Builder tokenBucketThrottlingExceptionCost(int throttlingExceptionCost) {
            this.throttlingExceptionCost = throttlingExceptionCost;
            return this;
        }

        public Builder tokenBucketStore(TokenBucketStore tokenBucketStore) {
            this.setTokenBucketStore(tokenBucketStore);
            return this;
        }

        public Builder useClientDefaults(boolean useClientDefaults) {
            this.setUseClientDefaults(useClientDefaults);
            return this;
        }

        @Override
        public LegacyRetryStrategy build() {
            return new DefaultLegacyRetryStrategy(this);
        }
    }
}

