/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.robomaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about a deployment application configuration.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeploymentApplicationConfig implements SdkPojo, Serializable,
        ToCopyableBuilder<DeploymentApplicationConfig.Builder, DeploymentApplicationConfig> {
    private static final SdkField<String> APPLICATION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DeploymentApplicationConfig::application)).setter(setter(Builder::application))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("application").build()).build();

    private static final SdkField<String> APPLICATION_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DeploymentApplicationConfig::applicationVersion)).setter(setter(Builder::applicationVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("applicationVersion").build())
            .build();

    private static final SdkField<DeploymentLaunchConfig> LAUNCH_CONFIG_FIELD = SdkField
            .<DeploymentLaunchConfig> builder(MarshallingType.SDK_POJO).getter(getter(DeploymentApplicationConfig::launchConfig))
            .setter(setter(Builder::launchConfig)).constructor(DeploymentLaunchConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("launchConfig").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPLICATION_FIELD,
            APPLICATION_VERSION_FIELD, LAUNCH_CONFIG_FIELD));

    private static final long serialVersionUID = 1L;

    private final String application;

    private final String applicationVersion;

    private final DeploymentLaunchConfig launchConfig;

    private DeploymentApplicationConfig(BuilderImpl builder) {
        this.application = builder.application;
        this.applicationVersion = builder.applicationVersion;
        this.launchConfig = builder.launchConfig;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the robot application.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the robot application.
     */
    public String application() {
        return application;
    }

    /**
     * <p>
     * The version of the application.
     * </p>
     * 
     * @return The version of the application.
     */
    public String applicationVersion() {
        return applicationVersion;
    }

    /**
     * <p>
     * The launch configuration.
     * </p>
     * 
     * @return The launch configuration.
     */
    public DeploymentLaunchConfig launchConfig() {
        return launchConfig;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(application());
        hashCode = 31 * hashCode + Objects.hashCode(applicationVersion());
        hashCode = 31 * hashCode + Objects.hashCode(launchConfig());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeploymentApplicationConfig)) {
            return false;
        }
        DeploymentApplicationConfig other = (DeploymentApplicationConfig) obj;
        return Objects.equals(application(), other.application())
                && Objects.equals(applicationVersion(), other.applicationVersion())
                && Objects.equals(launchConfig(), other.launchConfig());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DeploymentApplicationConfig").add("Application", application())
                .add("ApplicationVersion", applicationVersion()).add("LaunchConfig", launchConfig()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "application":
            return Optional.ofNullable(clazz.cast(application()));
        case "applicationVersion":
            return Optional.ofNullable(clazz.cast(applicationVersion()));
        case "launchConfig":
            return Optional.ofNullable(clazz.cast(launchConfig()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeploymentApplicationConfig, T> g) {
        return obj -> g.apply((DeploymentApplicationConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DeploymentApplicationConfig> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the robot application.
         * </p>
         * 
         * @param application
         *        The Amazon Resource Name (ARN) of the robot application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder application(String application);

        /**
         * <p>
         * The version of the application.
         * </p>
         * 
         * @param applicationVersion
         *        The version of the application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applicationVersion(String applicationVersion);

        /**
         * <p>
         * The launch configuration.
         * </p>
         * 
         * @param launchConfig
         *        The launch configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder launchConfig(DeploymentLaunchConfig launchConfig);

        /**
         * <p>
         * The launch configuration.
         * </p>
         * This is a convenience that creates an instance of the {@link DeploymentLaunchConfig.Builder} avoiding the
         * need to create one manually via {@link DeploymentLaunchConfig#builder()}.
         *
         * When the {@link Consumer} completes, {@link DeploymentLaunchConfig.Builder#build()} is called immediately and
         * its result is passed to {@link #launchConfig(DeploymentLaunchConfig)}.
         * 
         * @param launchConfig
         *        a consumer that will call methods on {@link DeploymentLaunchConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #launchConfig(DeploymentLaunchConfig)
         */
        default Builder launchConfig(Consumer<DeploymentLaunchConfig.Builder> launchConfig) {
            return launchConfig(DeploymentLaunchConfig.builder().applyMutation(launchConfig).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String application;

        private String applicationVersion;

        private DeploymentLaunchConfig launchConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(DeploymentApplicationConfig model) {
            application(model.application);
            applicationVersion(model.applicationVersion);
            launchConfig(model.launchConfig);
        }

        public final String getApplication() {
            return application;
        }

        @Override
        public final Builder application(String application) {
            this.application = application;
            return this;
        }

        public final void setApplication(String application) {
            this.application = application;
        }

        public final String getApplicationVersion() {
            return applicationVersion;
        }

        @Override
        public final Builder applicationVersion(String applicationVersion) {
            this.applicationVersion = applicationVersion;
            return this;
        }

        public final void setApplicationVersion(String applicationVersion) {
            this.applicationVersion = applicationVersion;
        }

        public final DeploymentLaunchConfig.Builder getLaunchConfig() {
            return launchConfig != null ? launchConfig.toBuilder() : null;
        }

        @Override
        public final Builder launchConfig(DeploymentLaunchConfig launchConfig) {
            this.launchConfig = launchConfig;
            return this;
        }

        public final void setLaunchConfig(DeploymentLaunchConfig.BuilderImpl launchConfig) {
            this.launchConfig = launchConfig != null ? launchConfig.build() : null;
        }

        @Override
        public DeploymentApplicationConfig build() {
            return new DeploymentApplicationConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
