/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.robomaker.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeRobotResponse extends RoboMakerResponse implements
        ToCopyableBuilder<DescribeRobotResponse.Builder, DescribeRobotResponse> {
    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeRobotResponse::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeRobotResponse::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> FLEET_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeRobotResponse::fleetArn)).setter(setter(Builder::fleetArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fleetArn").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeRobotResponse::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<String> GREENGRASS_GROUP_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeRobotResponse::greengrassGroupId)).setter(setter(Builder::greengrassGroupId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("greengrassGroupId").build()).build();

    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(DescribeRobotResponse::createdAt)).setter(setter(Builder::createdAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build()).build();

    private static final SdkField<String> ARCHITECTURE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeRobotResponse::architectureAsString)).setter(setter(Builder::architecture))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("architecture").build()).build();

    private static final SdkField<String> LAST_DEPLOYMENT_JOB_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeRobotResponse::lastDeploymentJob)).setter(setter(Builder::lastDeploymentJob))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastDeploymentJob").build()).build();

    private static final SdkField<Instant> LAST_DEPLOYMENT_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(DescribeRobotResponse::lastDeploymentTime)).setter(setter(Builder::lastDeploymentTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastDeploymentTime").build())
            .build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .getter(getter(DescribeRobotResponse::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, NAME_FIELD,
            FLEET_ARN_FIELD, STATUS_FIELD, GREENGRASS_GROUP_ID_FIELD, CREATED_AT_FIELD, ARCHITECTURE_FIELD,
            LAST_DEPLOYMENT_JOB_FIELD, LAST_DEPLOYMENT_TIME_FIELD, TAGS_FIELD));

    private final String arn;

    private final String name;

    private final String fleetArn;

    private final String status;

    private final String greengrassGroupId;

    private final Instant createdAt;

    private final String architecture;

    private final String lastDeploymentJob;

    private final Instant lastDeploymentTime;

    private final Map<String, String> tags;

    private DescribeRobotResponse(BuilderImpl builder) {
        super(builder);
        this.arn = builder.arn;
        this.name = builder.name;
        this.fleetArn = builder.fleetArn;
        this.status = builder.status;
        this.greengrassGroupId = builder.greengrassGroupId;
        this.createdAt = builder.createdAt;
        this.architecture = builder.architecture;
        this.lastDeploymentJob = builder.lastDeploymentJob;
        this.lastDeploymentTime = builder.lastDeploymentTime;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the robot.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the robot.
     */
    public String arn() {
        return arn;
    }

    /**
     * <p>
     * The name of the robot.
     * </p>
     * 
     * @return The name of the robot.
     */
    public String name() {
        return name;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the fleet.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the fleet.
     */
    public String fleetArn() {
        return fleetArn;
    }

    /**
     * <p>
     * The status of the fleet.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link RobotStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the fleet.
     * @see RobotStatus
     */
    public RobotStatus status() {
        return RobotStatus.fromValue(status);
    }

    /**
     * <p>
     * The status of the fleet.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link RobotStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the fleet.
     * @see RobotStatus
     */
    public String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The Greengrass group id.
     * </p>
     * 
     * @return The Greengrass group id.
     */
    public String greengrassGroupId() {
        return greengrassGroupId;
    }

    /**
     * <p>
     * The time, in milliseconds since the epoch, when the robot was created.
     * </p>
     * 
     * @return The time, in milliseconds since the epoch, when the robot was created.
     */
    public Instant createdAt() {
        return createdAt;
    }

    /**
     * <p>
     * The target architecture of the robot application.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #architecture} will
     * return {@link Architecture#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #architectureAsString}.
     * </p>
     * 
     * @return The target architecture of the robot application.
     * @see Architecture
     */
    public Architecture architecture() {
        return Architecture.fromValue(architecture);
    }

    /**
     * <p>
     * The target architecture of the robot application.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #architecture} will
     * return {@link Architecture#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #architectureAsString}.
     * </p>
     * 
     * @return The target architecture of the robot application.
     * @see Architecture
     */
    public String architectureAsString() {
        return architecture;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the last deployment job.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the last deployment job.
     */
    public String lastDeploymentJob() {
        return lastDeploymentJob;
    }

    /**
     * <p>
     * The time of the last deployment job.
     * </p>
     * 
     * @return The time of the last deployment job.
     */
    public Instant lastDeploymentTime() {
        return lastDeploymentTime;
    }

    /**
     * <p>
     * The list of all tags added to the specified robot.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The list of all tags added to the specified robot.
     */
    public Map<String, String> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(fleetArn());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(greengrassGroupId());
        hashCode = 31 * hashCode + Objects.hashCode(createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(architectureAsString());
        hashCode = 31 * hashCode + Objects.hashCode(lastDeploymentJob());
        hashCode = 31 * hashCode + Objects.hashCode(lastDeploymentTime());
        hashCode = 31 * hashCode + Objects.hashCode(tags());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeRobotResponse)) {
            return false;
        }
        DescribeRobotResponse other = (DescribeRobotResponse) obj;
        return Objects.equals(arn(), other.arn()) && Objects.equals(name(), other.name())
                && Objects.equals(fleetArn(), other.fleetArn()) && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(greengrassGroupId(), other.greengrassGroupId())
                && Objects.equals(createdAt(), other.createdAt())
                && Objects.equals(architectureAsString(), other.architectureAsString())
                && Objects.equals(lastDeploymentJob(), other.lastDeploymentJob())
                && Objects.equals(lastDeploymentTime(), other.lastDeploymentTime()) && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DescribeRobotResponse").add("Arn", arn()).add("Name", name()).add("FleetArn", fleetArn())
                .add("Status", statusAsString()).add("GreengrassGroupId", greengrassGroupId()).add("CreatedAt", createdAt())
                .add("Architecture", architectureAsString()).add("LastDeploymentJob", lastDeploymentJob())
                .add("LastDeploymentTime", lastDeploymentTime()).add("Tags", tags()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "fleetArn":
            return Optional.ofNullable(clazz.cast(fleetArn()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "greengrassGroupId":
            return Optional.ofNullable(clazz.cast(greengrassGroupId()));
        case "createdAt":
            return Optional.ofNullable(clazz.cast(createdAt()));
        case "architecture":
            return Optional.ofNullable(clazz.cast(architectureAsString()));
        case "lastDeploymentJob":
            return Optional.ofNullable(clazz.cast(lastDeploymentJob()));
        case "lastDeploymentTime":
            return Optional.ofNullable(clazz.cast(lastDeploymentTime()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeRobotResponse, T> g) {
        return obj -> g.apply((DescribeRobotResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends RoboMakerResponse.Builder, SdkPojo, CopyableBuilder<Builder, DescribeRobotResponse> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the robot.
         * </p>
         * 
         * @param arn
         *        The Amazon Resource Name (ARN) of the robot.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The name of the robot.
         * </p>
         * 
         * @param name
         *        The name of the robot.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the fleet.
         * </p>
         * 
         * @param fleetArn
         *        The Amazon Resource Name (ARN) of the fleet.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fleetArn(String fleetArn);

        /**
         * <p>
         * The status of the fleet.
         * </p>
         * 
         * @param status
         *        The status of the fleet.
         * @see RobotStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RobotStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status of the fleet.
         * </p>
         * 
         * @param status
         *        The status of the fleet.
         * @see RobotStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RobotStatus
         */
        Builder status(RobotStatus status);

        /**
         * <p>
         * The Greengrass group id.
         * </p>
         * 
         * @param greengrassGroupId
         *        The Greengrass group id.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder greengrassGroupId(String greengrassGroupId);

        /**
         * <p>
         * The time, in milliseconds since the epoch, when the robot was created.
         * </p>
         * 
         * @param createdAt
         *        The time, in milliseconds since the epoch, when the robot was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(Instant createdAt);

        /**
         * <p>
         * The target architecture of the robot application.
         * </p>
         * 
         * @param architecture
         *        The target architecture of the robot application.
         * @see Architecture
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Architecture
         */
        Builder architecture(String architecture);

        /**
         * <p>
         * The target architecture of the robot application.
         * </p>
         * 
         * @param architecture
         *        The target architecture of the robot application.
         * @see Architecture
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Architecture
         */
        Builder architecture(Architecture architecture);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the last deployment job.
         * </p>
         * 
         * @param lastDeploymentJob
         *        The Amazon Resource Name (ARN) of the last deployment job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastDeploymentJob(String lastDeploymentJob);

        /**
         * <p>
         * The time of the last deployment job.
         * </p>
         * 
         * @param lastDeploymentTime
         *        The time of the last deployment job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastDeploymentTime(Instant lastDeploymentTime);

        /**
         * <p>
         * The list of all tags added to the specified robot.
         * </p>
         * 
         * @param tags
         *        The list of all tags added to the specified robot.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);
    }

    static final class BuilderImpl extends RoboMakerResponse.BuilderImpl implements Builder {
        private String arn;

        private String name;

        private String fleetArn;

        private String status;

        private String greengrassGroupId;

        private Instant createdAt;

        private String architecture;

        private String lastDeploymentJob;

        private Instant lastDeploymentTime;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeRobotResponse model) {
            super(model);
            arn(model.arn);
            name(model.name);
            fleetArn(model.fleetArn);
            status(model.status);
            greengrassGroupId(model.greengrassGroupId);
            createdAt(model.createdAt);
            architecture(model.architecture);
            lastDeploymentJob(model.lastDeploymentJob);
            lastDeploymentTime(model.lastDeploymentTime);
            tags(model.tags);
        }

        public final String getArn() {
            return arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getFleetArn() {
            return fleetArn;
        }

        @Override
        public final Builder fleetArn(String fleetArn) {
            this.fleetArn = fleetArn;
            return this;
        }

        public final void setFleetArn(String fleetArn) {
            this.fleetArn = fleetArn;
        }

        public final String getStatusAsString() {
            return status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(RobotStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final String getGreengrassGroupId() {
            return greengrassGroupId;
        }

        @Override
        public final Builder greengrassGroupId(String greengrassGroupId) {
            this.greengrassGroupId = greengrassGroupId;
            return this;
        }

        public final void setGreengrassGroupId(String greengrassGroupId) {
            this.greengrassGroupId = greengrassGroupId;
        }

        public final Instant getCreatedAt() {
            return createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        public final String getArchitectureAsString() {
            return architecture;
        }

        @Override
        public final Builder architecture(String architecture) {
            this.architecture = architecture;
            return this;
        }

        @Override
        public final Builder architecture(Architecture architecture) {
            this.architecture(architecture == null ? null : architecture.toString());
            return this;
        }

        public final void setArchitecture(String architecture) {
            this.architecture = architecture;
        }

        public final String getLastDeploymentJob() {
            return lastDeploymentJob;
        }

        @Override
        public final Builder lastDeploymentJob(String lastDeploymentJob) {
            this.lastDeploymentJob = lastDeploymentJob;
            return this;
        }

        public final void setLastDeploymentJob(String lastDeploymentJob) {
            this.lastDeploymentJob = lastDeploymentJob;
        }

        public final Instant getLastDeploymentTime() {
            return lastDeploymentTime;
        }

        @Override
        public final Builder lastDeploymentTime(Instant lastDeploymentTime) {
            this.lastDeploymentTime = lastDeploymentTime;
            return this;
        }

        public final void setLastDeploymentTime(Instant lastDeploymentTime) {
            this.lastDeploymentTime = lastDeploymentTime;
        }

        public final Map<String, String> getTags() {
            return tags;
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public DescribeRobotResponse build() {
            return new DescribeRobotResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
