/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.robomaker.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeSimulationJobResponse extends RoboMakerResponse implements
        ToCopyableBuilder<DescribeSimulationJobResponse.Builder, DescribeSimulationJobResponse> {
    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeSimulationJobResponse::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeSimulationJobResponse::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeSimulationJobResponse::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<Instant> LAST_STARTED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(DescribeSimulationJobResponse::lastStartedAt)).setter(setter(Builder::lastStartedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastStartedAt").build()).build();

    private static final SdkField<Instant> LAST_UPDATED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(DescribeSimulationJobResponse::lastUpdatedAt)).setter(setter(Builder::lastUpdatedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastUpdatedAt").build()).build();

    private static final SdkField<String> FAILURE_BEHAVIOR_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeSimulationJobResponse::failureBehaviorAsString)).setter(setter(Builder::failureBehavior))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("failureBehavior").build()).build();

    private static final SdkField<String> FAILURE_CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeSimulationJobResponse::failureCodeAsString)).setter(setter(Builder::failureCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("failureCode").build()).build();

    private static final SdkField<String> FAILURE_REASON_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeSimulationJobResponse::failureReason)).setter(setter(Builder::failureReason))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("failureReason").build()).build();

    private static final SdkField<String> CLIENT_REQUEST_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeSimulationJobResponse::clientRequestToken)).setter(setter(Builder::clientRequestToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientRequestToken").build())
            .build();

    private static final SdkField<OutputLocation> OUTPUT_LOCATION_FIELD = SdkField
            .<OutputLocation> builder(MarshallingType.SDK_POJO).getter(getter(DescribeSimulationJobResponse::outputLocation))
            .setter(setter(Builder::outputLocation)).constructor(OutputLocation::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("outputLocation").build()).build();

    private static final SdkField<LoggingConfig> LOGGING_CONFIG_FIELD = SdkField
            .<LoggingConfig> builder(MarshallingType.SDK_POJO).getter(getter(DescribeSimulationJobResponse::loggingConfig))
            .setter(setter(Builder::loggingConfig)).constructor(LoggingConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("loggingConfig").build()).build();

    private static final SdkField<Long> MAX_JOB_DURATION_IN_SECONDS_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .getter(getter(DescribeSimulationJobResponse::maxJobDurationInSeconds))
            .setter(setter(Builder::maxJobDurationInSeconds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxJobDurationInSeconds").build())
            .build();

    private static final SdkField<Long> SIMULATION_TIME_MILLIS_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .getter(getter(DescribeSimulationJobResponse::simulationTimeMillis)).setter(setter(Builder::simulationTimeMillis))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("simulationTimeMillis").build())
            .build();

    private static final SdkField<String> IAM_ROLE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeSimulationJobResponse::iamRole)).setter(setter(Builder::iamRole))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("iamRole").build()).build();

    private static final SdkField<List<RobotApplicationConfig>> ROBOT_APPLICATIONS_FIELD = SdkField
            .<List<RobotApplicationConfig>> builder(MarshallingType.LIST)
            .getter(getter(DescribeSimulationJobResponse::robotApplications))
            .setter(setter(Builder::robotApplications))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("robotApplications").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<RobotApplicationConfig> builder(MarshallingType.SDK_POJO)
                                            .constructor(RobotApplicationConfig::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<SimulationApplicationConfig>> SIMULATION_APPLICATIONS_FIELD = SdkField
            .<List<SimulationApplicationConfig>> builder(MarshallingType.LIST)
            .getter(getter(DescribeSimulationJobResponse::simulationApplications))
            .setter(setter(Builder::simulationApplications))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("simulationApplications").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<SimulationApplicationConfig> builder(MarshallingType.SDK_POJO)
                                            .constructor(SimulationApplicationConfig::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<DataSource>> DATA_SOURCES_FIELD = SdkField
            .<List<DataSource>> builder(MarshallingType.LIST)
            .getter(getter(DescribeSimulationJobResponse::dataSources))
            .setter(setter(Builder::dataSources))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dataSources").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<DataSource> builder(MarshallingType.SDK_POJO)
                                            .constructor(DataSource::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .getter(getter(DescribeSimulationJobResponse::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<VPCConfigResponse> VPC_CONFIG_FIELD = SdkField
            .<VPCConfigResponse> builder(MarshallingType.SDK_POJO).getter(getter(DescribeSimulationJobResponse::vpcConfig))
            .setter(setter(Builder::vpcConfig)).constructor(VPCConfigResponse::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("vpcConfig").build()).build();

    private static final SdkField<NetworkInterface> NETWORK_INTERFACE_FIELD = SdkField
            .<NetworkInterface> builder(MarshallingType.SDK_POJO).getter(getter(DescribeSimulationJobResponse::networkInterface))
            .setter(setter(Builder::networkInterface)).constructor(NetworkInterface::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("networkInterface").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, NAME_FIELD,
            STATUS_FIELD, LAST_STARTED_AT_FIELD, LAST_UPDATED_AT_FIELD, FAILURE_BEHAVIOR_FIELD, FAILURE_CODE_FIELD,
            FAILURE_REASON_FIELD, CLIENT_REQUEST_TOKEN_FIELD, OUTPUT_LOCATION_FIELD, LOGGING_CONFIG_FIELD,
            MAX_JOB_DURATION_IN_SECONDS_FIELD, SIMULATION_TIME_MILLIS_FIELD, IAM_ROLE_FIELD, ROBOT_APPLICATIONS_FIELD,
            SIMULATION_APPLICATIONS_FIELD, DATA_SOURCES_FIELD, TAGS_FIELD, VPC_CONFIG_FIELD, NETWORK_INTERFACE_FIELD));

    private final String arn;

    private final String name;

    private final String status;

    private final Instant lastStartedAt;

    private final Instant lastUpdatedAt;

    private final String failureBehavior;

    private final String failureCode;

    private final String failureReason;

    private final String clientRequestToken;

    private final OutputLocation outputLocation;

    private final LoggingConfig loggingConfig;

    private final Long maxJobDurationInSeconds;

    private final Long simulationTimeMillis;

    private final String iamRole;

    private final List<RobotApplicationConfig> robotApplications;

    private final List<SimulationApplicationConfig> simulationApplications;

    private final List<DataSource> dataSources;

    private final Map<String, String> tags;

    private final VPCConfigResponse vpcConfig;

    private final NetworkInterface networkInterface;

    private DescribeSimulationJobResponse(BuilderImpl builder) {
        super(builder);
        this.arn = builder.arn;
        this.name = builder.name;
        this.status = builder.status;
        this.lastStartedAt = builder.lastStartedAt;
        this.lastUpdatedAt = builder.lastUpdatedAt;
        this.failureBehavior = builder.failureBehavior;
        this.failureCode = builder.failureCode;
        this.failureReason = builder.failureReason;
        this.clientRequestToken = builder.clientRequestToken;
        this.outputLocation = builder.outputLocation;
        this.loggingConfig = builder.loggingConfig;
        this.maxJobDurationInSeconds = builder.maxJobDurationInSeconds;
        this.simulationTimeMillis = builder.simulationTimeMillis;
        this.iamRole = builder.iamRole;
        this.robotApplications = builder.robotApplications;
        this.simulationApplications = builder.simulationApplications;
        this.dataSources = builder.dataSources;
        this.tags = builder.tags;
        this.vpcConfig = builder.vpcConfig;
        this.networkInterface = builder.networkInterface;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the simulation job.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the simulation job.
     */
    public String arn() {
        return arn;
    }

    /**
     * <p>
     * The name of the simulation job.
     * </p>
     * 
     * @return The name of the simulation job.
     */
    public String name() {
        return name;
    }

    /**
     * <p>
     * The status of the simulation job.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link SimulationJobStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the simulation job.
     * @see SimulationJobStatus
     */
    public SimulationJobStatus status() {
        return SimulationJobStatus.fromValue(status);
    }

    /**
     * <p>
     * The status of the simulation job.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link SimulationJobStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the simulation job.
     * @see SimulationJobStatus
     */
    public String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The time, in milliseconds since the epoch, when the simulation job was last started.
     * </p>
     * 
     * @return The time, in milliseconds since the epoch, when the simulation job was last started.
     */
    public Instant lastStartedAt() {
        return lastStartedAt;
    }

    /**
     * <p>
     * The time, in milliseconds since the epoch, when the simulation job was last updated.
     * </p>
     * 
     * @return The time, in milliseconds since the epoch, when the simulation job was last updated.
     */
    public Instant lastUpdatedAt() {
        return lastUpdatedAt;
    }

    /**
     * <p>
     * The failure behavior for the simulation job.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #failureBehavior}
     * will return {@link FailureBehavior#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #failureBehaviorAsString}.
     * </p>
     * 
     * @return The failure behavior for the simulation job.
     * @see FailureBehavior
     */
    public FailureBehavior failureBehavior() {
        return FailureBehavior.fromValue(failureBehavior);
    }

    /**
     * <p>
     * The failure behavior for the simulation job.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #failureBehavior}
     * will return {@link FailureBehavior#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #failureBehaviorAsString}.
     * </p>
     * 
     * @return The failure behavior for the simulation job.
     * @see FailureBehavior
     */
    public String failureBehaviorAsString() {
        return failureBehavior;
    }

    /**
     * <p>
     * The failure code of the simulation job if it failed:
     * </p>
     * <dl>
     * <dt>InternalServiceError</dt>
     * <dd>
     * <p>
     * Internal service error.
     * </p>
     * </dd>
     * <dt>RobotApplicationCrash</dt>
     * <dd>
     * <p>
     * Robot application exited abnormally.
     * </p>
     * </dd>
     * <dt>SimulationApplicationCrash</dt>
     * <dd>
     * <p>
     * Simulation application exited abnormally.
     * </p>
     * </dd>
     * <dt>BadPermissionsRobotApplication</dt>
     * <dd>
     * <p>
     * Robot application bundle could not be downloaded.
     * </p>
     * </dd>
     * <dt>BadPermissionsSimulationApplication</dt>
     * <dd>
     * <p>
     * Simulation application bundle could not be downloaded.
     * </p>
     * </dd>
     * <dt>BadPermissionsS3Output</dt>
     * <dd>
     * <p>
     * Unable to publish outputs to customer-provided S3 bucket.
     * </p>
     * </dd>
     * <dt>BadPermissionsCloudwatchLogs</dt>
     * <dd>
     * <p>
     * Unable to publish logs to customer-provided CloudWatch Logs resource.
     * </p>
     * </dd>
     * <dt>SubnetIpLimitExceeded</dt>
     * <dd>
     * <p>
     * Subnet IP limit exceeded.
     * </p>
     * </dd>
     * <dt>ENILimitExceeded</dt>
     * <dd>
     * <p>
     * ENI limit exceeded.
     * </p>
     * </dd>
     * <dt>BadPermissionsUserCredentials</dt>
     * <dd>
     * <p>
     * Unable to use the Role provided.
     * </p>
     * </dd>
     * <dt>InvalidBundleRobotApplication</dt>
     * <dd>
     * <p>
     * Robot bundle cannot be extracted (invalid format, bundling error, or other issue).
     * </p>
     * </dd>
     * <dt>InvalidBundleSimulationApplication</dt>
     * <dd>
     * <p>
     * Simulation bundle cannot be extracted (invalid format, bundling error, or other issue).
     * </p>
     * </dd>
     * <dt>RobotApplicationVersionMismatchedEtag</dt>
     * <dd>
     * <p>
     * Etag for RobotApplication does not match value during version creation.
     * </p>
     * </dd>
     * <dt>SimulationApplicationVersionMismatchedEtag</dt>
     * <dd>
     * <p>
     * Etag for SimulationApplication does not match value during version creation.
     * </p>
     * </dd>
     * </dl>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #failureCode} will
     * return {@link SimulationJobErrorCode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #failureCodeAsString}.
     * </p>
     * 
     * @return The failure code of the simulation job if it failed:</p>
     *         <dl>
     *         <dt>InternalServiceError</dt>
     *         <dd>
     *         <p>
     *         Internal service error.
     *         </p>
     *         </dd>
     *         <dt>RobotApplicationCrash</dt>
     *         <dd>
     *         <p>
     *         Robot application exited abnormally.
     *         </p>
     *         </dd>
     *         <dt>SimulationApplicationCrash</dt>
     *         <dd>
     *         <p>
     *         Simulation application exited abnormally.
     *         </p>
     *         </dd>
     *         <dt>BadPermissionsRobotApplication</dt>
     *         <dd>
     *         <p>
     *         Robot application bundle could not be downloaded.
     *         </p>
     *         </dd>
     *         <dt>BadPermissionsSimulationApplication</dt>
     *         <dd>
     *         <p>
     *         Simulation application bundle could not be downloaded.
     *         </p>
     *         </dd>
     *         <dt>BadPermissionsS3Output</dt>
     *         <dd>
     *         <p>
     *         Unable to publish outputs to customer-provided S3 bucket.
     *         </p>
     *         </dd>
     *         <dt>BadPermissionsCloudwatchLogs</dt>
     *         <dd>
     *         <p>
     *         Unable to publish logs to customer-provided CloudWatch Logs resource.
     *         </p>
     *         </dd>
     *         <dt>SubnetIpLimitExceeded</dt>
     *         <dd>
     *         <p>
     *         Subnet IP limit exceeded.
     *         </p>
     *         </dd>
     *         <dt>ENILimitExceeded</dt>
     *         <dd>
     *         <p>
     *         ENI limit exceeded.
     *         </p>
     *         </dd>
     *         <dt>BadPermissionsUserCredentials</dt>
     *         <dd>
     *         <p>
     *         Unable to use the Role provided.
     *         </p>
     *         </dd>
     *         <dt>InvalidBundleRobotApplication</dt>
     *         <dd>
     *         <p>
     *         Robot bundle cannot be extracted (invalid format, bundling error, or other issue).
     *         </p>
     *         </dd>
     *         <dt>InvalidBundleSimulationApplication</dt>
     *         <dd>
     *         <p>
     *         Simulation bundle cannot be extracted (invalid format, bundling error, or other issue).
     *         </p>
     *         </dd>
     *         <dt>RobotApplicationVersionMismatchedEtag</dt>
     *         <dd>
     *         <p>
     *         Etag for RobotApplication does not match value during version creation.
     *         </p>
     *         </dd>
     *         <dt>SimulationApplicationVersionMismatchedEtag</dt>
     *         <dd>
     *         <p>
     *         Etag for SimulationApplication does not match value during version creation.
     *         </p>
     *         </dd>
     * @see SimulationJobErrorCode
     */
    public SimulationJobErrorCode failureCode() {
        return SimulationJobErrorCode.fromValue(failureCode);
    }

    /**
     * <p>
     * The failure code of the simulation job if it failed:
     * </p>
     * <dl>
     * <dt>InternalServiceError</dt>
     * <dd>
     * <p>
     * Internal service error.
     * </p>
     * </dd>
     * <dt>RobotApplicationCrash</dt>
     * <dd>
     * <p>
     * Robot application exited abnormally.
     * </p>
     * </dd>
     * <dt>SimulationApplicationCrash</dt>
     * <dd>
     * <p>
     * Simulation application exited abnormally.
     * </p>
     * </dd>
     * <dt>BadPermissionsRobotApplication</dt>
     * <dd>
     * <p>
     * Robot application bundle could not be downloaded.
     * </p>
     * </dd>
     * <dt>BadPermissionsSimulationApplication</dt>
     * <dd>
     * <p>
     * Simulation application bundle could not be downloaded.
     * </p>
     * </dd>
     * <dt>BadPermissionsS3Output</dt>
     * <dd>
     * <p>
     * Unable to publish outputs to customer-provided S3 bucket.
     * </p>
     * </dd>
     * <dt>BadPermissionsCloudwatchLogs</dt>
     * <dd>
     * <p>
     * Unable to publish logs to customer-provided CloudWatch Logs resource.
     * </p>
     * </dd>
     * <dt>SubnetIpLimitExceeded</dt>
     * <dd>
     * <p>
     * Subnet IP limit exceeded.
     * </p>
     * </dd>
     * <dt>ENILimitExceeded</dt>
     * <dd>
     * <p>
     * ENI limit exceeded.
     * </p>
     * </dd>
     * <dt>BadPermissionsUserCredentials</dt>
     * <dd>
     * <p>
     * Unable to use the Role provided.
     * </p>
     * </dd>
     * <dt>InvalidBundleRobotApplication</dt>
     * <dd>
     * <p>
     * Robot bundle cannot be extracted (invalid format, bundling error, or other issue).
     * </p>
     * </dd>
     * <dt>InvalidBundleSimulationApplication</dt>
     * <dd>
     * <p>
     * Simulation bundle cannot be extracted (invalid format, bundling error, or other issue).
     * </p>
     * </dd>
     * <dt>RobotApplicationVersionMismatchedEtag</dt>
     * <dd>
     * <p>
     * Etag for RobotApplication does not match value during version creation.
     * </p>
     * </dd>
     * <dt>SimulationApplicationVersionMismatchedEtag</dt>
     * <dd>
     * <p>
     * Etag for SimulationApplication does not match value during version creation.
     * </p>
     * </dd>
     * </dl>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #failureCode} will
     * return {@link SimulationJobErrorCode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #failureCodeAsString}.
     * </p>
     * 
     * @return The failure code of the simulation job if it failed:</p>
     *         <dl>
     *         <dt>InternalServiceError</dt>
     *         <dd>
     *         <p>
     *         Internal service error.
     *         </p>
     *         </dd>
     *         <dt>RobotApplicationCrash</dt>
     *         <dd>
     *         <p>
     *         Robot application exited abnormally.
     *         </p>
     *         </dd>
     *         <dt>SimulationApplicationCrash</dt>
     *         <dd>
     *         <p>
     *         Simulation application exited abnormally.
     *         </p>
     *         </dd>
     *         <dt>BadPermissionsRobotApplication</dt>
     *         <dd>
     *         <p>
     *         Robot application bundle could not be downloaded.
     *         </p>
     *         </dd>
     *         <dt>BadPermissionsSimulationApplication</dt>
     *         <dd>
     *         <p>
     *         Simulation application bundle could not be downloaded.
     *         </p>
     *         </dd>
     *         <dt>BadPermissionsS3Output</dt>
     *         <dd>
     *         <p>
     *         Unable to publish outputs to customer-provided S3 bucket.
     *         </p>
     *         </dd>
     *         <dt>BadPermissionsCloudwatchLogs</dt>
     *         <dd>
     *         <p>
     *         Unable to publish logs to customer-provided CloudWatch Logs resource.
     *         </p>
     *         </dd>
     *         <dt>SubnetIpLimitExceeded</dt>
     *         <dd>
     *         <p>
     *         Subnet IP limit exceeded.
     *         </p>
     *         </dd>
     *         <dt>ENILimitExceeded</dt>
     *         <dd>
     *         <p>
     *         ENI limit exceeded.
     *         </p>
     *         </dd>
     *         <dt>BadPermissionsUserCredentials</dt>
     *         <dd>
     *         <p>
     *         Unable to use the Role provided.
     *         </p>
     *         </dd>
     *         <dt>InvalidBundleRobotApplication</dt>
     *         <dd>
     *         <p>
     *         Robot bundle cannot be extracted (invalid format, bundling error, or other issue).
     *         </p>
     *         </dd>
     *         <dt>InvalidBundleSimulationApplication</dt>
     *         <dd>
     *         <p>
     *         Simulation bundle cannot be extracted (invalid format, bundling error, or other issue).
     *         </p>
     *         </dd>
     *         <dt>RobotApplicationVersionMismatchedEtag</dt>
     *         <dd>
     *         <p>
     *         Etag for RobotApplication does not match value during version creation.
     *         </p>
     *         </dd>
     *         <dt>SimulationApplicationVersionMismatchedEtag</dt>
     *         <dd>
     *         <p>
     *         Etag for SimulationApplication does not match value during version creation.
     *         </p>
     *         </dd>
     * @see SimulationJobErrorCode
     */
    public String failureCodeAsString() {
        return failureCode;
    }

    /**
     * <p>
     * Details about why the simulation job failed. For more information about troubleshooting, see <a
     * href="https://docs.aws.amazon.com/robomaker/latest/dg/troubleshooting.html">Troubleshooting</a>.
     * </p>
     * 
     * @return Details about why the simulation job failed. For more information about troubleshooting, see <a
     *         href="https://docs.aws.amazon.com/robomaker/latest/dg/troubleshooting.html">Troubleshooting</a>.
     */
    public String failureReason() {
        return failureReason;
    }

    /**
     * <p>
     * Unique, case-sensitive identifier that you provide to ensure the idempotency of the request.
     * </p>
     * 
     * @return Unique, case-sensitive identifier that you provide to ensure the idempotency of the request.
     */
    public String clientRequestToken() {
        return clientRequestToken;
    }

    /**
     * <p>
     * Location for output files generated by the simulation job.
     * </p>
     * 
     * @return Location for output files generated by the simulation job.
     */
    public OutputLocation outputLocation() {
        return outputLocation;
    }

    /**
     * <p>
     * The logging configuration.
     * </p>
     * 
     * @return The logging configuration.
     */
    public LoggingConfig loggingConfig() {
        return loggingConfig;
    }

    /**
     * <p>
     * The maximum job duration in seconds. The value must be 8 days (691,200 seconds) or less.
     * </p>
     * 
     * @return The maximum job duration in seconds. The value must be 8 days (691,200 seconds) or less.
     */
    public Long maxJobDurationInSeconds() {
        return maxJobDurationInSeconds;
    }

    /**
     * <p>
     * The simulation job execution duration in milliseconds.
     * </p>
     * 
     * @return The simulation job execution duration in milliseconds.
     */
    public Long simulationTimeMillis() {
        return simulationTimeMillis;
    }

    /**
     * <p>
     * The IAM role that allows the simulation instance to call the AWS APIs that are specified in its associated
     * policies on your behalf.
     * </p>
     * 
     * @return The IAM role that allows the simulation instance to call the AWS APIs that are specified in its
     *         associated policies on your behalf.
     */
    public String iamRole() {
        return iamRole;
    }

    /**
     * <p>
     * A list of robot applications.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return A list of robot applications.
     */
    public List<RobotApplicationConfig> robotApplications() {
        return robotApplications;
    }

    /**
     * <p>
     * A list of simulation applications.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return A list of simulation applications.
     */
    public List<SimulationApplicationConfig> simulationApplications() {
        return simulationApplications;
    }

    /**
     * <p>
     * The data sources for the simulation job.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The data sources for the simulation job.
     */
    public List<DataSource> dataSources() {
        return dataSources;
    }

    /**
     * <p>
     * The list of all tags added to the specified simulation job.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The list of all tags added to the specified simulation job.
     */
    public Map<String, String> tags() {
        return tags;
    }

    /**
     * <p>
     * The VPC configuration.
     * </p>
     * 
     * @return The VPC configuration.
     */
    public VPCConfigResponse vpcConfig() {
        return vpcConfig;
    }

    /**
     * <p>
     * The network interface information for the simulation job.
     * </p>
     * 
     * @return The network interface information for the simulation job.
     */
    public NetworkInterface networkInterface() {
        return networkInterface;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(lastStartedAt());
        hashCode = 31 * hashCode + Objects.hashCode(lastUpdatedAt());
        hashCode = 31 * hashCode + Objects.hashCode(failureBehaviorAsString());
        hashCode = 31 * hashCode + Objects.hashCode(failureCodeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(failureReason());
        hashCode = 31 * hashCode + Objects.hashCode(clientRequestToken());
        hashCode = 31 * hashCode + Objects.hashCode(outputLocation());
        hashCode = 31 * hashCode + Objects.hashCode(loggingConfig());
        hashCode = 31 * hashCode + Objects.hashCode(maxJobDurationInSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(simulationTimeMillis());
        hashCode = 31 * hashCode + Objects.hashCode(iamRole());
        hashCode = 31 * hashCode + Objects.hashCode(robotApplications());
        hashCode = 31 * hashCode + Objects.hashCode(simulationApplications());
        hashCode = 31 * hashCode + Objects.hashCode(dataSources());
        hashCode = 31 * hashCode + Objects.hashCode(tags());
        hashCode = 31 * hashCode + Objects.hashCode(vpcConfig());
        hashCode = 31 * hashCode + Objects.hashCode(networkInterface());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeSimulationJobResponse)) {
            return false;
        }
        DescribeSimulationJobResponse other = (DescribeSimulationJobResponse) obj;
        return Objects.equals(arn(), other.arn()) && Objects.equals(name(), other.name())
                && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(lastStartedAt(), other.lastStartedAt())
                && Objects.equals(lastUpdatedAt(), other.lastUpdatedAt())
                && Objects.equals(failureBehaviorAsString(), other.failureBehaviorAsString())
                && Objects.equals(failureCodeAsString(), other.failureCodeAsString())
                && Objects.equals(failureReason(), other.failureReason())
                && Objects.equals(clientRequestToken(), other.clientRequestToken())
                && Objects.equals(outputLocation(), other.outputLocation())
                && Objects.equals(loggingConfig(), other.loggingConfig())
                && Objects.equals(maxJobDurationInSeconds(), other.maxJobDurationInSeconds())
                && Objects.equals(simulationTimeMillis(), other.simulationTimeMillis())
                && Objects.equals(iamRole(), other.iamRole()) && Objects.equals(robotApplications(), other.robotApplications())
                && Objects.equals(simulationApplications(), other.simulationApplications())
                && Objects.equals(dataSources(), other.dataSources()) && Objects.equals(tags(), other.tags())
                && Objects.equals(vpcConfig(), other.vpcConfig()) && Objects.equals(networkInterface(), other.networkInterface());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DescribeSimulationJobResponse").add("Arn", arn()).add("Name", name())
                .add("Status", statusAsString()).add("LastStartedAt", lastStartedAt()).add("LastUpdatedAt", lastUpdatedAt())
                .add("FailureBehavior", failureBehaviorAsString()).add("FailureCode", failureCodeAsString())
                .add("FailureReason", failureReason()).add("ClientRequestToken", clientRequestToken())
                .add("OutputLocation", outputLocation()).add("LoggingConfig", loggingConfig())
                .add("MaxJobDurationInSeconds", maxJobDurationInSeconds()).add("SimulationTimeMillis", simulationTimeMillis())
                .add("IamRole", iamRole()).add("RobotApplications", robotApplications())
                .add("SimulationApplications", simulationApplications()).add("DataSources", dataSources()).add("Tags", tags())
                .add("VpcConfig", vpcConfig()).add("NetworkInterface", networkInterface()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "lastStartedAt":
            return Optional.ofNullable(clazz.cast(lastStartedAt()));
        case "lastUpdatedAt":
            return Optional.ofNullable(clazz.cast(lastUpdatedAt()));
        case "failureBehavior":
            return Optional.ofNullable(clazz.cast(failureBehaviorAsString()));
        case "failureCode":
            return Optional.ofNullable(clazz.cast(failureCodeAsString()));
        case "failureReason":
            return Optional.ofNullable(clazz.cast(failureReason()));
        case "clientRequestToken":
            return Optional.ofNullable(clazz.cast(clientRequestToken()));
        case "outputLocation":
            return Optional.ofNullable(clazz.cast(outputLocation()));
        case "loggingConfig":
            return Optional.ofNullable(clazz.cast(loggingConfig()));
        case "maxJobDurationInSeconds":
            return Optional.ofNullable(clazz.cast(maxJobDurationInSeconds()));
        case "simulationTimeMillis":
            return Optional.ofNullable(clazz.cast(simulationTimeMillis()));
        case "iamRole":
            return Optional.ofNullable(clazz.cast(iamRole()));
        case "robotApplications":
            return Optional.ofNullable(clazz.cast(robotApplications()));
        case "simulationApplications":
            return Optional.ofNullable(clazz.cast(simulationApplications()));
        case "dataSources":
            return Optional.ofNullable(clazz.cast(dataSources()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "vpcConfig":
            return Optional.ofNullable(clazz.cast(vpcConfig()));
        case "networkInterface":
            return Optional.ofNullable(clazz.cast(networkInterface()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeSimulationJobResponse, T> g) {
        return obj -> g.apply((DescribeSimulationJobResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends RoboMakerResponse.Builder, SdkPojo, CopyableBuilder<Builder, DescribeSimulationJobResponse> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the simulation job.
         * </p>
         * 
         * @param arn
         *        The Amazon Resource Name (ARN) of the simulation job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The name of the simulation job.
         * </p>
         * 
         * @param name
         *        The name of the simulation job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The status of the simulation job.
         * </p>
         * 
         * @param status
         *        The status of the simulation job.
         * @see SimulationJobStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SimulationJobStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status of the simulation job.
         * </p>
         * 
         * @param status
         *        The status of the simulation job.
         * @see SimulationJobStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SimulationJobStatus
         */
        Builder status(SimulationJobStatus status);

        /**
         * <p>
         * The time, in milliseconds since the epoch, when the simulation job was last started.
         * </p>
         * 
         * @param lastStartedAt
         *        The time, in milliseconds since the epoch, when the simulation job was last started.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastStartedAt(Instant lastStartedAt);

        /**
         * <p>
         * The time, in milliseconds since the epoch, when the simulation job was last updated.
         * </p>
         * 
         * @param lastUpdatedAt
         *        The time, in milliseconds since the epoch, when the simulation job was last updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastUpdatedAt(Instant lastUpdatedAt);

        /**
         * <p>
         * The failure behavior for the simulation job.
         * </p>
         * 
         * @param failureBehavior
         *        The failure behavior for the simulation job.
         * @see FailureBehavior
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FailureBehavior
         */
        Builder failureBehavior(String failureBehavior);

        /**
         * <p>
         * The failure behavior for the simulation job.
         * </p>
         * 
         * @param failureBehavior
         *        The failure behavior for the simulation job.
         * @see FailureBehavior
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FailureBehavior
         */
        Builder failureBehavior(FailureBehavior failureBehavior);

        /**
         * <p>
         * The failure code of the simulation job if it failed:
         * </p>
         * <dl>
         * <dt>InternalServiceError</dt>
         * <dd>
         * <p>
         * Internal service error.
         * </p>
         * </dd>
         * <dt>RobotApplicationCrash</dt>
         * <dd>
         * <p>
         * Robot application exited abnormally.
         * </p>
         * </dd>
         * <dt>SimulationApplicationCrash</dt>
         * <dd>
         * <p>
         * Simulation application exited abnormally.
         * </p>
         * </dd>
         * <dt>BadPermissionsRobotApplication</dt>
         * <dd>
         * <p>
         * Robot application bundle could not be downloaded.
         * </p>
         * </dd>
         * <dt>BadPermissionsSimulationApplication</dt>
         * <dd>
         * <p>
         * Simulation application bundle could not be downloaded.
         * </p>
         * </dd>
         * <dt>BadPermissionsS3Output</dt>
         * <dd>
         * <p>
         * Unable to publish outputs to customer-provided S3 bucket.
         * </p>
         * </dd>
         * <dt>BadPermissionsCloudwatchLogs</dt>
         * <dd>
         * <p>
         * Unable to publish logs to customer-provided CloudWatch Logs resource.
         * </p>
         * </dd>
         * <dt>SubnetIpLimitExceeded</dt>
         * <dd>
         * <p>
         * Subnet IP limit exceeded.
         * </p>
         * </dd>
         * <dt>ENILimitExceeded</dt>
         * <dd>
         * <p>
         * ENI limit exceeded.
         * </p>
         * </dd>
         * <dt>BadPermissionsUserCredentials</dt>
         * <dd>
         * <p>
         * Unable to use the Role provided.
         * </p>
         * </dd>
         * <dt>InvalidBundleRobotApplication</dt>
         * <dd>
         * <p>
         * Robot bundle cannot be extracted (invalid format, bundling error, or other issue).
         * </p>
         * </dd>
         * <dt>InvalidBundleSimulationApplication</dt>
         * <dd>
         * <p>
         * Simulation bundle cannot be extracted (invalid format, bundling error, or other issue).
         * </p>
         * </dd>
         * <dt>RobotApplicationVersionMismatchedEtag</dt>
         * <dd>
         * <p>
         * Etag for RobotApplication does not match value during version creation.
         * </p>
         * </dd>
         * <dt>SimulationApplicationVersionMismatchedEtag</dt>
         * <dd>
         * <p>
         * Etag for SimulationApplication does not match value during version creation.
         * </p>
         * </dd>
         * </dl>
         * 
         * @param failureCode
         *        The failure code of the simulation job if it failed:</p>
         *        <dl>
         *        <dt>InternalServiceError</dt>
         *        <dd>
         *        <p>
         *        Internal service error.
         *        </p>
         *        </dd>
         *        <dt>RobotApplicationCrash</dt>
         *        <dd>
         *        <p>
         *        Robot application exited abnormally.
         *        </p>
         *        </dd>
         *        <dt>SimulationApplicationCrash</dt>
         *        <dd>
         *        <p>
         *        Simulation application exited abnormally.
         *        </p>
         *        </dd>
         *        <dt>BadPermissionsRobotApplication</dt>
         *        <dd>
         *        <p>
         *        Robot application bundle could not be downloaded.
         *        </p>
         *        </dd>
         *        <dt>BadPermissionsSimulationApplication</dt>
         *        <dd>
         *        <p>
         *        Simulation application bundle could not be downloaded.
         *        </p>
         *        </dd>
         *        <dt>BadPermissionsS3Output</dt>
         *        <dd>
         *        <p>
         *        Unable to publish outputs to customer-provided S3 bucket.
         *        </p>
         *        </dd>
         *        <dt>BadPermissionsCloudwatchLogs</dt>
         *        <dd>
         *        <p>
         *        Unable to publish logs to customer-provided CloudWatch Logs resource.
         *        </p>
         *        </dd>
         *        <dt>SubnetIpLimitExceeded</dt>
         *        <dd>
         *        <p>
         *        Subnet IP limit exceeded.
         *        </p>
         *        </dd>
         *        <dt>ENILimitExceeded</dt>
         *        <dd>
         *        <p>
         *        ENI limit exceeded.
         *        </p>
         *        </dd>
         *        <dt>BadPermissionsUserCredentials</dt>
         *        <dd>
         *        <p>
         *        Unable to use the Role provided.
         *        </p>
         *        </dd>
         *        <dt>InvalidBundleRobotApplication</dt>
         *        <dd>
         *        <p>
         *        Robot bundle cannot be extracted (invalid format, bundling error, or other issue).
         *        </p>
         *        </dd>
         *        <dt>InvalidBundleSimulationApplication</dt>
         *        <dd>
         *        <p>
         *        Simulation bundle cannot be extracted (invalid format, bundling error, or other issue).
         *        </p>
         *        </dd>
         *        <dt>RobotApplicationVersionMismatchedEtag</dt>
         *        <dd>
         *        <p>
         *        Etag for RobotApplication does not match value during version creation.
         *        </p>
         *        </dd>
         *        <dt>SimulationApplicationVersionMismatchedEtag</dt>
         *        <dd>
         *        <p>
         *        Etag for SimulationApplication does not match value during version creation.
         *        </p>
         *        </dd>
         * @see SimulationJobErrorCode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SimulationJobErrorCode
         */
        Builder failureCode(String failureCode);

        /**
         * <p>
         * The failure code of the simulation job if it failed:
         * </p>
         * <dl>
         * <dt>InternalServiceError</dt>
         * <dd>
         * <p>
         * Internal service error.
         * </p>
         * </dd>
         * <dt>RobotApplicationCrash</dt>
         * <dd>
         * <p>
         * Robot application exited abnormally.
         * </p>
         * </dd>
         * <dt>SimulationApplicationCrash</dt>
         * <dd>
         * <p>
         * Simulation application exited abnormally.
         * </p>
         * </dd>
         * <dt>BadPermissionsRobotApplication</dt>
         * <dd>
         * <p>
         * Robot application bundle could not be downloaded.
         * </p>
         * </dd>
         * <dt>BadPermissionsSimulationApplication</dt>
         * <dd>
         * <p>
         * Simulation application bundle could not be downloaded.
         * </p>
         * </dd>
         * <dt>BadPermissionsS3Output</dt>
         * <dd>
         * <p>
         * Unable to publish outputs to customer-provided S3 bucket.
         * </p>
         * </dd>
         * <dt>BadPermissionsCloudwatchLogs</dt>
         * <dd>
         * <p>
         * Unable to publish logs to customer-provided CloudWatch Logs resource.
         * </p>
         * </dd>
         * <dt>SubnetIpLimitExceeded</dt>
         * <dd>
         * <p>
         * Subnet IP limit exceeded.
         * </p>
         * </dd>
         * <dt>ENILimitExceeded</dt>
         * <dd>
         * <p>
         * ENI limit exceeded.
         * </p>
         * </dd>
         * <dt>BadPermissionsUserCredentials</dt>
         * <dd>
         * <p>
         * Unable to use the Role provided.
         * </p>
         * </dd>
         * <dt>InvalidBundleRobotApplication</dt>
         * <dd>
         * <p>
         * Robot bundle cannot be extracted (invalid format, bundling error, or other issue).
         * </p>
         * </dd>
         * <dt>InvalidBundleSimulationApplication</dt>
         * <dd>
         * <p>
         * Simulation bundle cannot be extracted (invalid format, bundling error, or other issue).
         * </p>
         * </dd>
         * <dt>RobotApplicationVersionMismatchedEtag</dt>
         * <dd>
         * <p>
         * Etag for RobotApplication does not match value during version creation.
         * </p>
         * </dd>
         * <dt>SimulationApplicationVersionMismatchedEtag</dt>
         * <dd>
         * <p>
         * Etag for SimulationApplication does not match value during version creation.
         * </p>
         * </dd>
         * </dl>
         * 
         * @param failureCode
         *        The failure code of the simulation job if it failed:</p>
         *        <dl>
         *        <dt>InternalServiceError</dt>
         *        <dd>
         *        <p>
         *        Internal service error.
         *        </p>
         *        </dd>
         *        <dt>RobotApplicationCrash</dt>
         *        <dd>
         *        <p>
         *        Robot application exited abnormally.
         *        </p>
         *        </dd>
         *        <dt>SimulationApplicationCrash</dt>
         *        <dd>
         *        <p>
         *        Simulation application exited abnormally.
         *        </p>
         *        </dd>
         *        <dt>BadPermissionsRobotApplication</dt>
         *        <dd>
         *        <p>
         *        Robot application bundle could not be downloaded.
         *        </p>
         *        </dd>
         *        <dt>BadPermissionsSimulationApplication</dt>
         *        <dd>
         *        <p>
         *        Simulation application bundle could not be downloaded.
         *        </p>
         *        </dd>
         *        <dt>BadPermissionsS3Output</dt>
         *        <dd>
         *        <p>
         *        Unable to publish outputs to customer-provided S3 bucket.
         *        </p>
         *        </dd>
         *        <dt>BadPermissionsCloudwatchLogs</dt>
         *        <dd>
         *        <p>
         *        Unable to publish logs to customer-provided CloudWatch Logs resource.
         *        </p>
         *        </dd>
         *        <dt>SubnetIpLimitExceeded</dt>
         *        <dd>
         *        <p>
         *        Subnet IP limit exceeded.
         *        </p>
         *        </dd>
         *        <dt>ENILimitExceeded</dt>
         *        <dd>
         *        <p>
         *        ENI limit exceeded.
         *        </p>
         *        </dd>
         *        <dt>BadPermissionsUserCredentials</dt>
         *        <dd>
         *        <p>
         *        Unable to use the Role provided.
         *        </p>
         *        </dd>
         *        <dt>InvalidBundleRobotApplication</dt>
         *        <dd>
         *        <p>
         *        Robot bundle cannot be extracted (invalid format, bundling error, or other issue).
         *        </p>
         *        </dd>
         *        <dt>InvalidBundleSimulationApplication</dt>
         *        <dd>
         *        <p>
         *        Simulation bundle cannot be extracted (invalid format, bundling error, or other issue).
         *        </p>
         *        </dd>
         *        <dt>RobotApplicationVersionMismatchedEtag</dt>
         *        <dd>
         *        <p>
         *        Etag for RobotApplication does not match value during version creation.
         *        </p>
         *        </dd>
         *        <dt>SimulationApplicationVersionMismatchedEtag</dt>
         *        <dd>
         *        <p>
         *        Etag for SimulationApplication does not match value during version creation.
         *        </p>
         *        </dd>
         * @see SimulationJobErrorCode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SimulationJobErrorCode
         */
        Builder failureCode(SimulationJobErrorCode failureCode);

        /**
         * <p>
         * Details about why the simulation job failed. For more information about troubleshooting, see <a
         * href="https://docs.aws.amazon.com/robomaker/latest/dg/troubleshooting.html">Troubleshooting</a>.
         * </p>
         * 
         * @param failureReason
         *        Details about why the simulation job failed. For more information about troubleshooting, see <a
         *        href="https://docs.aws.amazon.com/robomaker/latest/dg/troubleshooting.html">Troubleshooting</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder failureReason(String failureReason);

        /**
         * <p>
         * Unique, case-sensitive identifier that you provide to ensure the idempotency of the request.
         * </p>
         * 
         * @param clientRequestToken
         *        Unique, case-sensitive identifier that you provide to ensure the idempotency of the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientRequestToken(String clientRequestToken);

        /**
         * <p>
         * Location for output files generated by the simulation job.
         * </p>
         * 
         * @param outputLocation
         *        Location for output files generated by the simulation job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outputLocation(OutputLocation outputLocation);

        /**
         * <p>
         * Location for output files generated by the simulation job.
         * </p>
         * This is a convenience that creates an instance of the {@link OutputLocation.Builder} avoiding the need to
         * create one manually via {@link OutputLocation#builder()}.
         *
         * When the {@link Consumer} completes, {@link OutputLocation.Builder#build()} is called immediately and its
         * result is passed to {@link #outputLocation(OutputLocation)}.
         * 
         * @param outputLocation
         *        a consumer that will call methods on {@link OutputLocation.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #outputLocation(OutputLocation)
         */
        default Builder outputLocation(Consumer<OutputLocation.Builder> outputLocation) {
            return outputLocation(OutputLocation.builder().applyMutation(outputLocation).build());
        }

        /**
         * <p>
         * The logging configuration.
         * </p>
         * 
         * @param loggingConfig
         *        The logging configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder loggingConfig(LoggingConfig loggingConfig);

        /**
         * <p>
         * The logging configuration.
         * </p>
         * This is a convenience that creates an instance of the {@link LoggingConfig.Builder} avoiding the need to
         * create one manually via {@link LoggingConfig#builder()}.
         *
         * When the {@link Consumer} completes, {@link LoggingConfig.Builder#build()} is called immediately and its
         * result is passed to {@link #loggingConfig(LoggingConfig)}.
         * 
         * @param loggingConfig
         *        a consumer that will call methods on {@link LoggingConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #loggingConfig(LoggingConfig)
         */
        default Builder loggingConfig(Consumer<LoggingConfig.Builder> loggingConfig) {
            return loggingConfig(LoggingConfig.builder().applyMutation(loggingConfig).build());
        }

        /**
         * <p>
         * The maximum job duration in seconds. The value must be 8 days (691,200 seconds) or less.
         * </p>
         * 
         * @param maxJobDurationInSeconds
         *        The maximum job duration in seconds. The value must be 8 days (691,200 seconds) or less.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxJobDurationInSeconds(Long maxJobDurationInSeconds);

        /**
         * <p>
         * The simulation job execution duration in milliseconds.
         * </p>
         * 
         * @param simulationTimeMillis
         *        The simulation job execution duration in milliseconds.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder simulationTimeMillis(Long simulationTimeMillis);

        /**
         * <p>
         * The IAM role that allows the simulation instance to call the AWS APIs that are specified in its associated
         * policies on your behalf.
         * </p>
         * 
         * @param iamRole
         *        The IAM role that allows the simulation instance to call the AWS APIs that are specified in its
         *        associated policies on your behalf.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder iamRole(String iamRole);

        /**
         * <p>
         * A list of robot applications.
         * </p>
         * 
         * @param robotApplications
         *        A list of robot applications.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder robotApplications(Collection<RobotApplicationConfig> robotApplications);

        /**
         * <p>
         * A list of robot applications.
         * </p>
         * 
         * @param robotApplications
         *        A list of robot applications.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder robotApplications(RobotApplicationConfig... robotApplications);

        /**
         * <p>
         * A list of robot applications.
         * </p>
         * This is a convenience that creates an instance of the {@link List<RobotApplicationConfig>.Builder} avoiding
         * the need to create one manually via {@link List<RobotApplicationConfig>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<RobotApplicationConfig>.Builder#build()} is called
         * immediately and its result is passed to {@link #robotApplications(List<RobotApplicationConfig>)}.
         * 
         * @param robotApplications
         *        a consumer that will call methods on {@link List<RobotApplicationConfig>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #robotApplications(List<RobotApplicationConfig>)
         */
        Builder robotApplications(Consumer<RobotApplicationConfig.Builder>... robotApplications);

        /**
         * <p>
         * A list of simulation applications.
         * </p>
         * 
         * @param simulationApplications
         *        A list of simulation applications.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder simulationApplications(Collection<SimulationApplicationConfig> simulationApplications);

        /**
         * <p>
         * A list of simulation applications.
         * </p>
         * 
         * @param simulationApplications
         *        A list of simulation applications.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder simulationApplications(SimulationApplicationConfig... simulationApplications);

        /**
         * <p>
         * A list of simulation applications.
         * </p>
         * This is a convenience that creates an instance of the {@link List<SimulationApplicationConfig>.Builder}
         * avoiding the need to create one manually via {@link List<SimulationApplicationConfig>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<SimulationApplicationConfig>.Builder#build()} is called
         * immediately and its result is passed to {@link #simulationApplications(List<SimulationApplicationConfig>)}.
         * 
         * @param simulationApplications
         *        a consumer that will call methods on {@link List<SimulationApplicationConfig>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #simulationApplications(List<SimulationApplicationConfig>)
         */
        Builder simulationApplications(Consumer<SimulationApplicationConfig.Builder>... simulationApplications);

        /**
         * <p>
         * The data sources for the simulation job.
         * </p>
         * 
         * @param dataSources
         *        The data sources for the simulation job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataSources(Collection<DataSource> dataSources);

        /**
         * <p>
         * The data sources for the simulation job.
         * </p>
         * 
         * @param dataSources
         *        The data sources for the simulation job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataSources(DataSource... dataSources);

        /**
         * <p>
         * The data sources for the simulation job.
         * </p>
         * This is a convenience that creates an instance of the {@link List<DataSource>.Builder} avoiding the need to
         * create one manually via {@link List<DataSource>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<DataSource>.Builder#build()} is called immediately and its
         * result is passed to {@link #dataSources(List<DataSource>)}.
         * 
         * @param dataSources
         *        a consumer that will call methods on {@link List<DataSource>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dataSources(List<DataSource>)
         */
        Builder dataSources(Consumer<DataSource.Builder>... dataSources);

        /**
         * <p>
         * The list of all tags added to the specified simulation job.
         * </p>
         * 
         * @param tags
         *        The list of all tags added to the specified simulation job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);

        /**
         * <p>
         * The VPC configuration.
         * </p>
         * 
         * @param vpcConfig
         *        The VPC configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcConfig(VPCConfigResponse vpcConfig);

        /**
         * <p>
         * The VPC configuration.
         * </p>
         * This is a convenience that creates an instance of the {@link VPCConfigResponse.Builder} avoiding the need to
         * create one manually via {@link VPCConfigResponse#builder()}.
         *
         * When the {@link Consumer} completes, {@link VPCConfigResponse.Builder#build()} is called immediately and its
         * result is passed to {@link #vpcConfig(VPCConfigResponse)}.
         * 
         * @param vpcConfig
         *        a consumer that will call methods on {@link VPCConfigResponse.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #vpcConfig(VPCConfigResponse)
         */
        default Builder vpcConfig(Consumer<VPCConfigResponse.Builder> vpcConfig) {
            return vpcConfig(VPCConfigResponse.builder().applyMutation(vpcConfig).build());
        }

        /**
         * <p>
         * The network interface information for the simulation job.
         * </p>
         * 
         * @param networkInterface
         *        The network interface information for the simulation job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder networkInterface(NetworkInterface networkInterface);

        /**
         * <p>
         * The network interface information for the simulation job.
         * </p>
         * This is a convenience that creates an instance of the {@link NetworkInterface.Builder} avoiding the need to
         * create one manually via {@link NetworkInterface#builder()}.
         *
         * When the {@link Consumer} completes, {@link NetworkInterface.Builder#build()} is called immediately and its
         * result is passed to {@link #networkInterface(NetworkInterface)}.
         * 
         * @param networkInterface
         *        a consumer that will call methods on {@link NetworkInterface.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #networkInterface(NetworkInterface)
         */
        default Builder networkInterface(Consumer<NetworkInterface.Builder> networkInterface) {
            return networkInterface(NetworkInterface.builder().applyMutation(networkInterface).build());
        }
    }

    static final class BuilderImpl extends RoboMakerResponse.BuilderImpl implements Builder {
        private String arn;

        private String name;

        private String status;

        private Instant lastStartedAt;

        private Instant lastUpdatedAt;

        private String failureBehavior;

        private String failureCode;

        private String failureReason;

        private String clientRequestToken;

        private OutputLocation outputLocation;

        private LoggingConfig loggingConfig;

        private Long maxJobDurationInSeconds;

        private Long simulationTimeMillis;

        private String iamRole;

        private List<RobotApplicationConfig> robotApplications = DefaultSdkAutoConstructList.getInstance();

        private List<SimulationApplicationConfig> simulationApplications = DefaultSdkAutoConstructList.getInstance();

        private List<DataSource> dataSources = DefaultSdkAutoConstructList.getInstance();

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private VPCConfigResponse vpcConfig;

        private NetworkInterface networkInterface;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeSimulationJobResponse model) {
            super(model);
            arn(model.arn);
            name(model.name);
            status(model.status);
            lastStartedAt(model.lastStartedAt);
            lastUpdatedAt(model.lastUpdatedAt);
            failureBehavior(model.failureBehavior);
            failureCode(model.failureCode);
            failureReason(model.failureReason);
            clientRequestToken(model.clientRequestToken);
            outputLocation(model.outputLocation);
            loggingConfig(model.loggingConfig);
            maxJobDurationInSeconds(model.maxJobDurationInSeconds);
            simulationTimeMillis(model.simulationTimeMillis);
            iamRole(model.iamRole);
            robotApplications(model.robotApplications);
            simulationApplications(model.simulationApplications);
            dataSources(model.dataSources);
            tags(model.tags);
            vpcConfig(model.vpcConfig);
            networkInterface(model.networkInterface);
        }

        public final String getArn() {
            return arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getStatusAsString() {
            return status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(SimulationJobStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final Instant getLastStartedAt() {
            return lastStartedAt;
        }

        @Override
        public final Builder lastStartedAt(Instant lastStartedAt) {
            this.lastStartedAt = lastStartedAt;
            return this;
        }

        public final void setLastStartedAt(Instant lastStartedAt) {
            this.lastStartedAt = lastStartedAt;
        }

        public final Instant getLastUpdatedAt() {
            return lastUpdatedAt;
        }

        @Override
        public final Builder lastUpdatedAt(Instant lastUpdatedAt) {
            this.lastUpdatedAt = lastUpdatedAt;
            return this;
        }

        public final void setLastUpdatedAt(Instant lastUpdatedAt) {
            this.lastUpdatedAt = lastUpdatedAt;
        }

        public final String getFailureBehaviorAsString() {
            return failureBehavior;
        }

        @Override
        public final Builder failureBehavior(String failureBehavior) {
            this.failureBehavior = failureBehavior;
            return this;
        }

        @Override
        public final Builder failureBehavior(FailureBehavior failureBehavior) {
            this.failureBehavior(failureBehavior == null ? null : failureBehavior.toString());
            return this;
        }

        public final void setFailureBehavior(String failureBehavior) {
            this.failureBehavior = failureBehavior;
        }

        public final String getFailureCodeAsString() {
            return failureCode;
        }

        @Override
        public final Builder failureCode(String failureCode) {
            this.failureCode = failureCode;
            return this;
        }

        @Override
        public final Builder failureCode(SimulationJobErrorCode failureCode) {
            this.failureCode(failureCode == null ? null : failureCode.toString());
            return this;
        }

        public final void setFailureCode(String failureCode) {
            this.failureCode = failureCode;
        }

        public final String getFailureReason() {
            return failureReason;
        }

        @Override
        public final Builder failureReason(String failureReason) {
            this.failureReason = failureReason;
            return this;
        }

        public final void setFailureReason(String failureReason) {
            this.failureReason = failureReason;
        }

        public final String getClientRequestToken() {
            return clientRequestToken;
        }

        @Override
        public final Builder clientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
            return this;
        }

        public final void setClientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
        }

        public final OutputLocation.Builder getOutputLocation() {
            return outputLocation != null ? outputLocation.toBuilder() : null;
        }

        @Override
        public final Builder outputLocation(OutputLocation outputLocation) {
            this.outputLocation = outputLocation;
            return this;
        }

        public final void setOutputLocation(OutputLocation.BuilderImpl outputLocation) {
            this.outputLocation = outputLocation != null ? outputLocation.build() : null;
        }

        public final LoggingConfig.Builder getLoggingConfig() {
            return loggingConfig != null ? loggingConfig.toBuilder() : null;
        }

        @Override
        public final Builder loggingConfig(LoggingConfig loggingConfig) {
            this.loggingConfig = loggingConfig;
            return this;
        }

        public final void setLoggingConfig(LoggingConfig.BuilderImpl loggingConfig) {
            this.loggingConfig = loggingConfig != null ? loggingConfig.build() : null;
        }

        public final Long getMaxJobDurationInSeconds() {
            return maxJobDurationInSeconds;
        }

        @Override
        public final Builder maxJobDurationInSeconds(Long maxJobDurationInSeconds) {
            this.maxJobDurationInSeconds = maxJobDurationInSeconds;
            return this;
        }

        public final void setMaxJobDurationInSeconds(Long maxJobDurationInSeconds) {
            this.maxJobDurationInSeconds = maxJobDurationInSeconds;
        }

        public final Long getSimulationTimeMillis() {
            return simulationTimeMillis;
        }

        @Override
        public final Builder simulationTimeMillis(Long simulationTimeMillis) {
            this.simulationTimeMillis = simulationTimeMillis;
            return this;
        }

        public final void setSimulationTimeMillis(Long simulationTimeMillis) {
            this.simulationTimeMillis = simulationTimeMillis;
        }

        public final String getIamRole() {
            return iamRole;
        }

        @Override
        public final Builder iamRole(String iamRole) {
            this.iamRole = iamRole;
            return this;
        }

        public final void setIamRole(String iamRole) {
            this.iamRole = iamRole;
        }

        public final Collection<RobotApplicationConfig.Builder> getRobotApplications() {
            return robotApplications != null ? robotApplications.stream().map(RobotApplicationConfig::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder robotApplications(Collection<RobotApplicationConfig> robotApplications) {
            this.robotApplications = RobotApplicationConfigsCopier.copy(robotApplications);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder robotApplications(RobotApplicationConfig... robotApplications) {
            robotApplications(Arrays.asList(robotApplications));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder robotApplications(Consumer<RobotApplicationConfig.Builder>... robotApplications) {
            robotApplications(Stream.of(robotApplications).map(c -> RobotApplicationConfig.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setRobotApplications(Collection<RobotApplicationConfig.BuilderImpl> robotApplications) {
            this.robotApplications = RobotApplicationConfigsCopier.copyFromBuilder(robotApplications);
        }

        public final Collection<SimulationApplicationConfig.Builder> getSimulationApplications() {
            return simulationApplications != null ? simulationApplications.stream().map(SimulationApplicationConfig::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder simulationApplications(Collection<SimulationApplicationConfig> simulationApplications) {
            this.simulationApplications = SimulationApplicationConfigsCopier.copy(simulationApplications);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder simulationApplications(SimulationApplicationConfig... simulationApplications) {
            simulationApplications(Arrays.asList(simulationApplications));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder simulationApplications(Consumer<SimulationApplicationConfig.Builder>... simulationApplications) {
            simulationApplications(Stream.of(simulationApplications)
                    .map(c -> SimulationApplicationConfig.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setSimulationApplications(Collection<SimulationApplicationConfig.BuilderImpl> simulationApplications) {
            this.simulationApplications = SimulationApplicationConfigsCopier.copyFromBuilder(simulationApplications);
        }

        public final Collection<DataSource.Builder> getDataSources() {
            return dataSources != null ? dataSources.stream().map(DataSource::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder dataSources(Collection<DataSource> dataSources) {
            this.dataSources = DataSourcesCopier.copy(dataSources);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dataSources(DataSource... dataSources) {
            dataSources(Arrays.asList(dataSources));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dataSources(Consumer<DataSource.Builder>... dataSources) {
            dataSources(Stream.of(dataSources).map(c -> DataSource.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setDataSources(Collection<DataSource.BuilderImpl> dataSources) {
            this.dataSources = DataSourcesCopier.copyFromBuilder(dataSources);
        }

        public final Map<String, String> getTags() {
            return tags;
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        public final VPCConfigResponse.Builder getVpcConfig() {
            return vpcConfig != null ? vpcConfig.toBuilder() : null;
        }

        @Override
        public final Builder vpcConfig(VPCConfigResponse vpcConfig) {
            this.vpcConfig = vpcConfig;
            return this;
        }

        public final void setVpcConfig(VPCConfigResponse.BuilderImpl vpcConfig) {
            this.vpcConfig = vpcConfig != null ? vpcConfig.build() : null;
        }

        public final NetworkInterface.Builder getNetworkInterface() {
            return networkInterface != null ? networkInterface.toBuilder() : null;
        }

        @Override
        public final Builder networkInterface(NetworkInterface networkInterface) {
            this.networkInterface = networkInterface;
            return this;
        }

        public final void setNetworkInterface(NetworkInterface.BuilderImpl networkInterface) {
            this.networkInterface = networkInterface != null ? networkInterface.build() : null;
        }

        @Override
        public DescribeSimulationJobResponse build() {
            return new DescribeSimulationJobResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
