/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.robomaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about a robot software suite.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RobotSoftwareSuite implements SdkPojo, Serializable,
        ToCopyableBuilder<RobotSoftwareSuite.Builder, RobotSoftwareSuite> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(RobotSoftwareSuite::nameAsString)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(RobotSoftwareSuite::versionAsString)).setter(setter(Builder::version))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("version").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, VERSION_FIELD));

    private static final long serialVersionUID = 1L;

    private final String name;

    private final String version;

    private RobotSoftwareSuite(BuilderImpl builder) {
        this.name = builder.name;
        this.version = builder.version;
    }

    /**
     * <p>
     * The name of the robot software suite.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #name} will return
     * {@link RobotSoftwareSuiteType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #nameAsString}.
     * </p>
     * 
     * @return The name of the robot software suite.
     * @see RobotSoftwareSuiteType
     */
    public RobotSoftwareSuiteType name() {
        return RobotSoftwareSuiteType.fromValue(name);
    }

    /**
     * <p>
     * The name of the robot software suite.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #name} will return
     * {@link RobotSoftwareSuiteType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #nameAsString}.
     * </p>
     * 
     * @return The name of the robot software suite.
     * @see RobotSoftwareSuiteType
     */
    public String nameAsString() {
        return name;
    }

    /**
     * <p>
     * The version of the robot software suite.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #version} will
     * return {@link RobotSoftwareSuiteVersionType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #versionAsString}.
     * </p>
     * 
     * @return The version of the robot software suite.
     * @see RobotSoftwareSuiteVersionType
     */
    public RobotSoftwareSuiteVersionType version() {
        return RobotSoftwareSuiteVersionType.fromValue(version);
    }

    /**
     * <p>
     * The version of the robot software suite.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #version} will
     * return {@link RobotSoftwareSuiteVersionType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #versionAsString}.
     * </p>
     * 
     * @return The version of the robot software suite.
     * @see RobotSoftwareSuiteVersionType
     */
    public String versionAsString() {
        return version;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(nameAsString());
        hashCode = 31 * hashCode + Objects.hashCode(versionAsString());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RobotSoftwareSuite)) {
            return false;
        }
        RobotSoftwareSuite other = (RobotSoftwareSuite) obj;
        return Objects.equals(nameAsString(), other.nameAsString()) && Objects.equals(versionAsString(), other.versionAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("RobotSoftwareSuite").add("Name", nameAsString()).add("Version", versionAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "name":
            return Optional.ofNullable(clazz.cast(nameAsString()));
        case "version":
            return Optional.ofNullable(clazz.cast(versionAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RobotSoftwareSuite, T> g) {
        return obj -> g.apply((RobotSoftwareSuite) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RobotSoftwareSuite> {
        /**
         * <p>
         * The name of the robot software suite.
         * </p>
         * 
         * @param name
         *        The name of the robot software suite.
         * @see RobotSoftwareSuiteType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RobotSoftwareSuiteType
         */
        Builder name(String name);

        /**
         * <p>
         * The name of the robot software suite.
         * </p>
         * 
         * @param name
         *        The name of the robot software suite.
         * @see RobotSoftwareSuiteType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RobotSoftwareSuiteType
         */
        Builder name(RobotSoftwareSuiteType name);

        /**
         * <p>
         * The version of the robot software suite.
         * </p>
         * 
         * @param version
         *        The version of the robot software suite.
         * @see RobotSoftwareSuiteVersionType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RobotSoftwareSuiteVersionType
         */
        Builder version(String version);

        /**
         * <p>
         * The version of the robot software suite.
         * </p>
         * 
         * @param version
         *        The version of the robot software suite.
         * @see RobotSoftwareSuiteVersionType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RobotSoftwareSuiteVersionType
         */
        Builder version(RobotSoftwareSuiteVersionType version);
    }

    static final class BuilderImpl implements Builder {
        private String name;

        private String version;

        private BuilderImpl() {
        }

        private BuilderImpl(RobotSoftwareSuite model) {
            name(model.name);
            version(model.version);
        }

        public final String getNameAsString() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        @Override
        public final Builder name(RobotSoftwareSuiteType name) {
            this.name(name == null ? null : name.toString());
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getVersionAsString() {
            return version;
        }

        @Override
        public final Builder version(String version) {
            this.version = version;
            return this;
        }

        @Override
        public final Builder version(RobotSoftwareSuiteVersionType version) {
            this.version(version == null ? null : version.toString());
            return this;
        }

        public final void setVersion(String version) {
            this.version = version;
        }

        @Override
        public RobotSoftwareSuite build() {
            return new RobotSoftwareSuite(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
