/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.robomaker.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListRobotApplicationsResponse extends RoboMakerResponse implements
        ToCopyableBuilder<ListRobotApplicationsResponse.Builder, ListRobotApplicationsResponse> {
    private static final SdkField<List<RobotApplicationSummary>> ROBOT_APPLICATION_SUMMARIES_FIELD = SdkField
            .<List<RobotApplicationSummary>> builder(MarshallingType.LIST)
            .getter(getter(ListRobotApplicationsResponse::robotApplicationSummaries))
            .setter(setter(Builder::robotApplicationSummaries))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("robotApplicationSummaries").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<RobotApplicationSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(RobotApplicationSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ListRobotApplicationsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            ROBOT_APPLICATION_SUMMARIES_FIELD, NEXT_TOKEN_FIELD));

    private final List<RobotApplicationSummary> robotApplicationSummaries;

    private final String nextToken;

    private ListRobotApplicationsResponse(BuilderImpl builder) {
        super(builder);
        this.robotApplicationSummaries = builder.robotApplicationSummaries;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * A list of robot application summaries that meet the criteria of the request.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return A list of robot application summaries that meet the criteria of the request.
     */
    public List<RobotApplicationSummary> robotApplicationSummaries() {
        return robotApplicationSummaries;
    }

    /**
     * <p>
     * The <code>nextToken</code> value to include in a future <code>ListRobotApplications</code> request. When the
     * results of a <code>ListRobotApplications</code> request exceed <code>maxResults</code>, this value can be used to
     * retrieve the next page of results. This value is <code>null</code> when there are no more results to return.
     * </p>
     * 
     * @return The <code>nextToken</code> value to include in a future <code>ListRobotApplications</code> request. When
     *         the results of a <code>ListRobotApplications</code> request exceed <code>maxResults</code>, this value
     *         can be used to retrieve the next page of results. This value is <code>null</code> when there are no more
     *         results to return.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(robotApplicationSummaries());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListRobotApplicationsResponse)) {
            return false;
        }
        ListRobotApplicationsResponse other = (ListRobotApplicationsResponse) obj;
        return Objects.equals(robotApplicationSummaries(), other.robotApplicationSummaries())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ListRobotApplicationsResponse").add("RobotApplicationSummaries", robotApplicationSummaries())
                .add("NextToken", nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "robotApplicationSummaries":
            return Optional.ofNullable(clazz.cast(robotApplicationSummaries()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListRobotApplicationsResponse, T> g) {
        return obj -> g.apply((ListRobotApplicationsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends RoboMakerResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListRobotApplicationsResponse> {
        /**
         * <p>
         * A list of robot application summaries that meet the criteria of the request.
         * </p>
         * 
         * @param robotApplicationSummaries
         *        A list of robot application summaries that meet the criteria of the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder robotApplicationSummaries(Collection<RobotApplicationSummary> robotApplicationSummaries);

        /**
         * <p>
         * A list of robot application summaries that meet the criteria of the request.
         * </p>
         * 
         * @param robotApplicationSummaries
         *        A list of robot application summaries that meet the criteria of the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder robotApplicationSummaries(RobotApplicationSummary... robotApplicationSummaries);

        /**
         * <p>
         * A list of robot application summaries that meet the criteria of the request.
         * </p>
         * This is a convenience that creates an instance of the {@link List<RobotApplicationSummary>.Builder} avoiding
         * the need to create one manually via {@link List<RobotApplicationSummary>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<RobotApplicationSummary>.Builder#build()} is called
         * immediately and its result is passed to {@link #robotApplicationSummaries(List<RobotApplicationSummary>)}.
         * 
         * @param robotApplicationSummaries
         *        a consumer that will call methods on {@link List<RobotApplicationSummary>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #robotApplicationSummaries(List<RobotApplicationSummary>)
         */
        Builder robotApplicationSummaries(Consumer<RobotApplicationSummary.Builder>... robotApplicationSummaries);

        /**
         * <p>
         * The <code>nextToken</code> value to include in a future <code>ListRobotApplications</code> request. When the
         * results of a <code>ListRobotApplications</code> request exceed <code>maxResults</code>, this value can be
         * used to retrieve the next page of results. This value is <code>null</code> when there are no more results to
         * return.
         * </p>
         * 
         * @param nextToken
         *        The <code>nextToken</code> value to include in a future <code>ListRobotApplications</code> request.
         *        When the results of a <code>ListRobotApplications</code> request exceed <code>maxResults</code>, this
         *        value can be used to retrieve the next page of results. This value is <code>null</code> when there are
         *        no more results to return.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends RoboMakerResponse.BuilderImpl implements Builder {
        private List<RobotApplicationSummary> robotApplicationSummaries = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListRobotApplicationsResponse model) {
            super(model);
            robotApplicationSummaries(model.robotApplicationSummaries);
            nextToken(model.nextToken);
        }

        public final Collection<RobotApplicationSummary.Builder> getRobotApplicationSummaries() {
            return robotApplicationSummaries != null ? robotApplicationSummaries.stream().map(RobotApplicationSummary::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder robotApplicationSummaries(Collection<RobotApplicationSummary> robotApplicationSummaries) {
            this.robotApplicationSummaries = RobotApplicationSummariesCopier.copy(robotApplicationSummaries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder robotApplicationSummaries(RobotApplicationSummary... robotApplicationSummaries) {
            robotApplicationSummaries(Arrays.asList(robotApplicationSummaries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder robotApplicationSummaries(Consumer<RobotApplicationSummary.Builder>... robotApplicationSummaries) {
            robotApplicationSummaries(Stream.of(robotApplicationSummaries)
                    .map(c -> RobotApplicationSummary.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setRobotApplicationSummaries(Collection<RobotApplicationSummary.BuilderImpl> robotApplicationSummaries) {
            this.robotApplicationSummaries = RobotApplicationSummariesCopier.copyFromBuilder(robotApplicationSummaries);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListRobotApplicationsResponse build() {
            return new ListRobotApplicationsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
