/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.robomaker.model;

import static java.util.stream.Collectors.toList;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;

@Generated("software.amazon.awssdk:codegen")
final class SimulationApplicationSummariesCopier {
    static List<SimulationApplicationSummary> copy(Collection<SimulationApplicationSummary> simulationApplicationSummariesParam) {
        if (simulationApplicationSummariesParam == null || simulationApplicationSummariesParam instanceof SdkAutoConstructList) {
            return DefaultSdkAutoConstructList.getInstance();
        }
        List<SimulationApplicationSummary> simulationApplicationSummariesParamCopy = new ArrayList<>(
                simulationApplicationSummariesParam);
        return Collections.unmodifiableList(simulationApplicationSummariesParamCopy);
    }

    static List<SimulationApplicationSummary> copyFromBuilder(
            Collection<? extends SimulationApplicationSummary.Builder> simulationApplicationSummariesParam) {
        if (simulationApplicationSummariesParam == null) {
            return null;
        }
        return copy(simulationApplicationSummariesParam.stream().map(SimulationApplicationSummary.Builder::build)
                .collect(toList()));
    }
}
