/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.robomaker.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateWorldExportJobRequest extends RoboMakerRequest implements
        ToCopyableBuilder<CreateWorldExportJobRequest.Builder, CreateWorldExportJobRequest> {
    private static final SdkField<String> CLIENT_REQUEST_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(CreateWorldExportJobRequest::clientRequestToken))
            .setter(setter(Builder::clientRequestToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientRequestToken").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final SdkField<List<String>> WORLDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(CreateWorldExportJobRequest::worlds))
            .setter(setter(Builder::worlds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("worlds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<OutputLocation> OUTPUT_LOCATION_FIELD = SdkField
            .<OutputLocation> builder(MarshallingType.SDK_POJO).getter(getter(CreateWorldExportJobRequest::outputLocation))
            .setter(setter(Builder::outputLocation)).constructor(OutputLocation::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("outputLocation").build()).build();

    private static final SdkField<String> IAM_ROLE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateWorldExportJobRequest::iamRole)).setter(setter(Builder::iamRole))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("iamRole").build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .getter(getter(CreateWorldExportJobRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLIENT_REQUEST_TOKEN_FIELD,
            WORLDS_FIELD, OUTPUT_LOCATION_FIELD, IAM_ROLE_FIELD, TAGS_FIELD));

    private final String clientRequestToken;

    private final List<String> worlds;

    private final OutputLocation outputLocation;

    private final String iamRole;

    private final Map<String, String> tags;

    private CreateWorldExportJobRequest(BuilderImpl builder) {
        super(builder);
        this.clientRequestToken = builder.clientRequestToken;
        this.worlds = builder.worlds;
        this.outputLocation = builder.outputLocation;
        this.iamRole = builder.iamRole;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * Unique, case-sensitive identifier that you provide to ensure the idempotency of the request.
     * </p>
     * 
     * @return Unique, case-sensitive identifier that you provide to ensure the idempotency of the request.
     */
    public String clientRequestToken() {
        return clientRequestToken;
    }

    /**
     * Returns true if the Worlds property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasWorlds() {
        return worlds != null && !(worlds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of Amazon Resource Names (arns) that correspond to worlds to export.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasWorlds()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list of Amazon Resource Names (arns) that correspond to worlds to export.
     */
    public List<String> worlds() {
        return worlds;
    }

    /**
     * Returns the value of the OutputLocation property for this object.
     * 
     * @return The value of the OutputLocation property for this object.
     */
    public OutputLocation outputLocation() {
        return outputLocation;
    }

    /**
     * <p>
     * The IAM role that the world export process uses to access the Amazon S3 bucket and put the export.
     * </p>
     * 
     * @return The IAM role that the world export process uses to access the Amazon S3 bucket and put the export.
     */
    public String iamRole() {
        return iamRole;
    }

    /**
     * Returns true if the Tags property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * A map that contains tag keys and tag values that are attached to the world export job.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasTags()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A map that contains tag keys and tag values that are attached to the world export job.
     */
    public Map<String, String> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(clientRequestToken());
        hashCode = 31 * hashCode + Objects.hashCode(worlds());
        hashCode = 31 * hashCode + Objects.hashCode(outputLocation());
        hashCode = 31 * hashCode + Objects.hashCode(iamRole());
        hashCode = 31 * hashCode + Objects.hashCode(tags());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateWorldExportJobRequest)) {
            return false;
        }
        CreateWorldExportJobRequest other = (CreateWorldExportJobRequest) obj;
        return Objects.equals(clientRequestToken(), other.clientRequestToken()) && Objects.equals(worlds(), other.worlds())
                && Objects.equals(outputLocation(), other.outputLocation()) && Objects.equals(iamRole(), other.iamRole())
                && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("CreateWorldExportJobRequest").add("ClientRequestToken", clientRequestToken())
                .add("Worlds", worlds()).add("OutputLocation", outputLocation()).add("IamRole", iamRole()).add("Tags", tags())
                .build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "clientRequestToken":
            return Optional.ofNullable(clazz.cast(clientRequestToken()));
        case "worlds":
            return Optional.ofNullable(clazz.cast(worlds()));
        case "outputLocation":
            return Optional.ofNullable(clazz.cast(outputLocation()));
        case "iamRole":
            return Optional.ofNullable(clazz.cast(iamRole()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateWorldExportJobRequest, T> g) {
        return obj -> g.apply((CreateWorldExportJobRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends RoboMakerRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateWorldExportJobRequest> {
        /**
         * <p>
         * Unique, case-sensitive identifier that you provide to ensure the idempotency of the request.
         * </p>
         * 
         * @param clientRequestToken
         *        Unique, case-sensitive identifier that you provide to ensure the idempotency of the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientRequestToken(String clientRequestToken);

        /**
         * <p>
         * A list of Amazon Resource Names (arns) that correspond to worlds to export.
         * </p>
         * 
         * @param worlds
         *        A list of Amazon Resource Names (arns) that correspond to worlds to export.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder worlds(Collection<String> worlds);

        /**
         * <p>
         * A list of Amazon Resource Names (arns) that correspond to worlds to export.
         * </p>
         * 
         * @param worlds
         *        A list of Amazon Resource Names (arns) that correspond to worlds to export.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder worlds(String... worlds);

        /**
         * Sets the value of the OutputLocation property for this object.
         *
         * @param outputLocation
         *        The new value for the OutputLocation property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outputLocation(OutputLocation outputLocation);

        /**
         * Sets the value of the OutputLocation property for this object.
         *
         * This is a convenience that creates an instance of the {@link OutputLocation.Builder} avoiding the need to
         * create one manually via {@link OutputLocation#builder()}.
         *
         * When the {@link Consumer} completes, {@link OutputLocation.Builder#build()} is called immediately and its
         * result is passed to {@link #outputLocation(OutputLocation)}.
         * 
         * @param outputLocation
         *        a consumer that will call methods on {@link OutputLocation.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #outputLocation(OutputLocation)
         */
        default Builder outputLocation(Consumer<OutputLocation.Builder> outputLocation) {
            return outputLocation(OutputLocation.builder().applyMutation(outputLocation).build());
        }

        /**
         * <p>
         * The IAM role that the world export process uses to access the Amazon S3 bucket and put the export.
         * </p>
         * 
         * @param iamRole
         *        The IAM role that the world export process uses to access the Amazon S3 bucket and put the export.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder iamRole(String iamRole);

        /**
         * <p>
         * A map that contains tag keys and tag values that are attached to the world export job.
         * </p>
         * 
         * @param tags
         *        A map that contains tag keys and tag values that are attached to the world export job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends RoboMakerRequest.BuilderImpl implements Builder {
        private String clientRequestToken;

        private List<String> worlds = DefaultSdkAutoConstructList.getInstance();

        private OutputLocation outputLocation;

        private String iamRole;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateWorldExportJobRequest model) {
            super(model);
            clientRequestToken(model.clientRequestToken);
            worlds(model.worlds);
            outputLocation(model.outputLocation);
            iamRole(model.iamRole);
            tags(model.tags);
        }

        public final String getClientRequestToken() {
            return clientRequestToken;
        }

        @Override
        public final Builder clientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
            return this;
        }

        public final void setClientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
        }

        public final Collection<String> getWorlds() {
            return worlds;
        }

        @Override
        public final Builder worlds(Collection<String> worlds) {
            this.worlds = ArnsCopier.copy(worlds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder worlds(String... worlds) {
            worlds(Arrays.asList(worlds));
            return this;
        }

        public final void setWorlds(Collection<String> worlds) {
            this.worlds = ArnsCopier.copy(worlds);
        }

        public final OutputLocation.Builder getOutputLocation() {
            return outputLocation != null ? outputLocation.toBuilder() : null;
        }

        @Override
        public final Builder outputLocation(OutputLocation outputLocation) {
            this.outputLocation = outputLocation;
            return this;
        }

        public final void setOutputLocation(OutputLocation.BuilderImpl outputLocation) {
            this.outputLocation = outputLocation != null ? outputLocation.build() : null;
        }

        public final String getIamRole() {
            return iamRole;
        }

        @Override
        public final Builder iamRole(String iamRole) {
            this.iamRole = iamRole;
            return this;
        }

        public final void setIamRole(String iamRole) {
            this.iamRole = iamRole;
        }

        public final Map<String, String> getTags() {
            return tags;
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateWorldExportJobRequest build() {
            return new CreateWorldExportJobRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
