/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.robomaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about worlds that failed.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class FailureSummary implements SdkPojo, Serializable, ToCopyableBuilder<FailureSummary.Builder, FailureSummary> {
    private static final SdkField<Integer> TOTAL_FAILURE_COUNT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(FailureSummary::totalFailureCount)).setter(setter(Builder::totalFailureCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("totalFailureCount").build()).build();

    private static final SdkField<List<WorldFailure>> FAILURES_FIELD = SdkField
            .<List<WorldFailure>> builder(MarshallingType.LIST)
            .getter(getter(FailureSummary::failures))
            .setter(setter(Builder::failures))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("failures").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<WorldFailure> builder(MarshallingType.SDK_POJO)
                                            .constructor(WorldFailure::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TOTAL_FAILURE_COUNT_FIELD,
            FAILURES_FIELD));

    private static final long serialVersionUID = 1L;

    private final Integer totalFailureCount;

    private final List<WorldFailure> failures;

    private FailureSummary(BuilderImpl builder) {
        this.totalFailureCount = builder.totalFailureCount;
        this.failures = builder.failures;
    }

    /**
     * <p>
     * The total number of failures.
     * </p>
     * 
     * @return The total number of failures.
     */
    public Integer totalFailureCount() {
        return totalFailureCount;
    }

    /**
     * Returns true if the Failures property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasFailures() {
        return failures != null && !(failures instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The worlds that failed.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasFailures()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The worlds that failed.
     */
    public List<WorldFailure> failures() {
        return failures;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(totalFailureCount());
        hashCode = 31 * hashCode + Objects.hashCode(failures());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FailureSummary)) {
            return false;
        }
        FailureSummary other = (FailureSummary) obj;
        return Objects.equals(totalFailureCount(), other.totalFailureCount()) && Objects.equals(failures(), other.failures());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("FailureSummary").add("TotalFailureCount", totalFailureCount()).add("Failures", failures())
                .build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "totalFailureCount":
            return Optional.ofNullable(clazz.cast(totalFailureCount()));
        case "failures":
            return Optional.ofNullable(clazz.cast(failures()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<FailureSummary, T> g) {
        return obj -> g.apply((FailureSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, FailureSummary> {
        /**
         * <p>
         * The total number of failures.
         * </p>
         * 
         * @param totalFailureCount
         *        The total number of failures.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder totalFailureCount(Integer totalFailureCount);

        /**
         * <p>
         * The worlds that failed.
         * </p>
         * 
         * @param failures
         *        The worlds that failed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder failures(Collection<WorldFailure> failures);

        /**
         * <p>
         * The worlds that failed.
         * </p>
         * 
         * @param failures
         *        The worlds that failed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder failures(WorldFailure... failures);

        /**
         * <p>
         * The worlds that failed.
         * </p>
         * This is a convenience that creates an instance of the {@link List<WorldFailure>.Builder} avoiding the need to
         * create one manually via {@link List<WorldFailure>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<WorldFailure>.Builder#build()} is called immediately and its
         * result is passed to {@link #failures(List<WorldFailure>)}.
         * 
         * @param failures
         *        a consumer that will call methods on {@link List<WorldFailure>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #failures(List<WorldFailure>)
         */
        Builder failures(Consumer<WorldFailure.Builder>... failures);
    }

    static final class BuilderImpl implements Builder {
        private Integer totalFailureCount;

        private List<WorldFailure> failures = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(FailureSummary model) {
            totalFailureCount(model.totalFailureCount);
            failures(model.failures);
        }

        public final Integer getTotalFailureCount() {
            return totalFailureCount;
        }

        @Override
        public final Builder totalFailureCount(Integer totalFailureCount) {
            this.totalFailureCount = totalFailureCount;
            return this;
        }

        public final void setTotalFailureCount(Integer totalFailureCount) {
            this.totalFailureCount = totalFailureCount;
        }

        public final Collection<WorldFailure.Builder> getFailures() {
            return failures != null ? failures.stream().map(WorldFailure::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder failures(Collection<WorldFailure> failures) {
            this.failures = WorldFailuresCopier.copy(failures);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder failures(WorldFailure... failures) {
            failures(Arrays.asList(failures));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder failures(Consumer<WorldFailure.Builder>... failures) {
            failures(Stream.of(failures).map(c -> WorldFailure.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setFailures(Collection<WorldFailure.BuilderImpl> failures) {
            this.failures = WorldFailuresCopier.copyFromBuilder(failures);
        }

        @Override
        public FailureSummary build() {
            return new FailureSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
