/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.robomaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about a simulation application configuration.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SimulationApplicationConfig implements SdkPojo, Serializable,
        ToCopyableBuilder<SimulationApplicationConfig.Builder, SimulationApplicationConfig> {
    private static final SdkField<String> APPLICATION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(SimulationApplicationConfig::application)).setter(setter(Builder::application))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("application").build()).build();

    private static final SdkField<String> APPLICATION_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(SimulationApplicationConfig::applicationVersion)).setter(setter(Builder::applicationVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("applicationVersion").build())
            .build();

    private static final SdkField<LaunchConfig> LAUNCH_CONFIG_FIELD = SdkField.<LaunchConfig> builder(MarshallingType.SDK_POJO)
            .getter(getter(SimulationApplicationConfig::launchConfig)).setter(setter(Builder::launchConfig))
            .constructor(LaunchConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("launchConfig").build()).build();

    private static final SdkField<List<WorldConfig>> WORLD_CONFIGS_FIELD = SdkField
            .<List<WorldConfig>> builder(MarshallingType.LIST)
            .getter(getter(SimulationApplicationConfig::worldConfigs))
            .setter(setter(Builder::worldConfigs))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("worldConfigs").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<WorldConfig> builder(MarshallingType.SDK_POJO)
                                            .constructor(WorldConfig::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPLICATION_FIELD,
            APPLICATION_VERSION_FIELD, LAUNCH_CONFIG_FIELD, WORLD_CONFIGS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String application;

    private final String applicationVersion;

    private final LaunchConfig launchConfig;

    private final List<WorldConfig> worldConfigs;

    private SimulationApplicationConfig(BuilderImpl builder) {
        this.application = builder.application;
        this.applicationVersion = builder.applicationVersion;
        this.launchConfig = builder.launchConfig;
        this.worldConfigs = builder.worldConfigs;
    }

    /**
     * <p>
     * The application information for the simulation application.
     * </p>
     * 
     * @return The application information for the simulation application.
     */
    public String application() {
        return application;
    }

    /**
     * <p>
     * The version of the simulation application.
     * </p>
     * 
     * @return The version of the simulation application.
     */
    public String applicationVersion() {
        return applicationVersion;
    }

    /**
     * <p>
     * The launch configuration for the simulation application.
     * </p>
     * 
     * @return The launch configuration for the simulation application.
     */
    public LaunchConfig launchConfig() {
        return launchConfig;
    }

    /**
     * Returns true if the WorldConfigs property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasWorldConfigs() {
        return worldConfigs != null && !(worldConfigs instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of world configurations.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasWorldConfigs()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list of world configurations.
     */
    public List<WorldConfig> worldConfigs() {
        return worldConfigs;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(application());
        hashCode = 31 * hashCode + Objects.hashCode(applicationVersion());
        hashCode = 31 * hashCode + Objects.hashCode(launchConfig());
        hashCode = 31 * hashCode + Objects.hashCode(worldConfigs());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SimulationApplicationConfig)) {
            return false;
        }
        SimulationApplicationConfig other = (SimulationApplicationConfig) obj;
        return Objects.equals(application(), other.application())
                && Objects.equals(applicationVersion(), other.applicationVersion())
                && Objects.equals(launchConfig(), other.launchConfig()) && Objects.equals(worldConfigs(), other.worldConfigs());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("SimulationApplicationConfig").add("Application", application())
                .add("ApplicationVersion", applicationVersion()).add("LaunchConfig", launchConfig())
                .add("WorldConfigs", worldConfigs()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "application":
            return Optional.ofNullable(clazz.cast(application()));
        case "applicationVersion":
            return Optional.ofNullable(clazz.cast(applicationVersion()));
        case "launchConfig":
            return Optional.ofNullable(clazz.cast(launchConfig()));
        case "worldConfigs":
            return Optional.ofNullable(clazz.cast(worldConfigs()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SimulationApplicationConfig, T> g) {
        return obj -> g.apply((SimulationApplicationConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SimulationApplicationConfig> {
        /**
         * <p>
         * The application information for the simulation application.
         * </p>
         * 
         * @param application
         *        The application information for the simulation application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder application(String application);

        /**
         * <p>
         * The version of the simulation application.
         * </p>
         * 
         * @param applicationVersion
         *        The version of the simulation application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applicationVersion(String applicationVersion);

        /**
         * <p>
         * The launch configuration for the simulation application.
         * </p>
         * 
         * @param launchConfig
         *        The launch configuration for the simulation application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder launchConfig(LaunchConfig launchConfig);

        /**
         * <p>
         * The launch configuration for the simulation application.
         * </p>
         * This is a convenience that creates an instance of the {@link LaunchConfig.Builder} avoiding the need to
         * create one manually via {@link LaunchConfig#builder()}.
         *
         * When the {@link Consumer} completes, {@link LaunchConfig.Builder#build()} is called immediately and its
         * result is passed to {@link #launchConfig(LaunchConfig)}.
         * 
         * @param launchConfig
         *        a consumer that will call methods on {@link LaunchConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #launchConfig(LaunchConfig)
         */
        default Builder launchConfig(Consumer<LaunchConfig.Builder> launchConfig) {
            return launchConfig(LaunchConfig.builder().applyMutation(launchConfig).build());
        }

        /**
         * <p>
         * A list of world configurations.
         * </p>
         * 
         * @param worldConfigs
         *        A list of world configurations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder worldConfigs(Collection<WorldConfig> worldConfigs);

        /**
         * <p>
         * A list of world configurations.
         * </p>
         * 
         * @param worldConfigs
         *        A list of world configurations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder worldConfigs(WorldConfig... worldConfigs);

        /**
         * <p>
         * A list of world configurations.
         * </p>
         * This is a convenience that creates an instance of the {@link List<WorldConfig>.Builder} avoiding the need to
         * create one manually via {@link List<WorldConfig>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<WorldConfig>.Builder#build()} is called immediately and its
         * result is passed to {@link #worldConfigs(List<WorldConfig>)}.
         * 
         * @param worldConfigs
         *        a consumer that will call methods on {@link List<WorldConfig>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #worldConfigs(List<WorldConfig>)
         */
        Builder worldConfigs(Consumer<WorldConfig.Builder>... worldConfigs);
    }

    static final class BuilderImpl implements Builder {
        private String application;

        private String applicationVersion;

        private LaunchConfig launchConfig;

        private List<WorldConfig> worldConfigs = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(SimulationApplicationConfig model) {
            application(model.application);
            applicationVersion(model.applicationVersion);
            launchConfig(model.launchConfig);
            worldConfigs(model.worldConfigs);
        }

        public final String getApplication() {
            return application;
        }

        @Override
        public final Builder application(String application) {
            this.application = application;
            return this;
        }

        public final void setApplication(String application) {
            this.application = application;
        }

        public final String getApplicationVersion() {
            return applicationVersion;
        }

        @Override
        public final Builder applicationVersion(String applicationVersion) {
            this.applicationVersion = applicationVersion;
            return this;
        }

        public final void setApplicationVersion(String applicationVersion) {
            this.applicationVersion = applicationVersion;
        }

        public final LaunchConfig.Builder getLaunchConfig() {
            return launchConfig != null ? launchConfig.toBuilder() : null;
        }

        @Override
        public final Builder launchConfig(LaunchConfig launchConfig) {
            this.launchConfig = launchConfig;
            return this;
        }

        public final void setLaunchConfig(LaunchConfig.BuilderImpl launchConfig) {
            this.launchConfig = launchConfig != null ? launchConfig.build() : null;
        }

        public final Collection<WorldConfig.Builder> getWorldConfigs() {
            return worldConfigs != null ? worldConfigs.stream().map(WorldConfig::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder worldConfigs(Collection<WorldConfig> worldConfigs) {
            this.worldConfigs = WorldConfigsCopier.copy(worldConfigs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder worldConfigs(WorldConfig... worldConfigs) {
            worldConfigs(Arrays.asList(worldConfigs));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder worldConfigs(Consumer<WorldConfig.Builder>... worldConfigs) {
            worldConfigs(Stream.of(worldConfigs).map(c -> WorldConfig.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setWorldConfigs(Collection<WorldConfig.BuilderImpl> worldConfigs) {
            this.worldConfigs = WorldConfigsCopier.copyFromBuilder(worldConfigs);
        }

        @Override
        public SimulationApplicationConfig build() {
            return new SimulationApplicationConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
