/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.robomaker;

import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.SdkClient;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.regions.ServiceMetadata;
import software.amazon.awssdk.services.robomaker.model.BatchDeleteWorldsRequest;
import software.amazon.awssdk.services.robomaker.model.BatchDeleteWorldsResponse;
import software.amazon.awssdk.services.robomaker.model.BatchDescribeSimulationJobRequest;
import software.amazon.awssdk.services.robomaker.model.BatchDescribeSimulationJobResponse;
import software.amazon.awssdk.services.robomaker.model.CancelDeploymentJobRequest;
import software.amazon.awssdk.services.robomaker.model.CancelDeploymentJobResponse;
import software.amazon.awssdk.services.robomaker.model.CancelSimulationJobBatchRequest;
import software.amazon.awssdk.services.robomaker.model.CancelSimulationJobBatchResponse;
import software.amazon.awssdk.services.robomaker.model.CancelSimulationJobRequest;
import software.amazon.awssdk.services.robomaker.model.CancelSimulationJobResponse;
import software.amazon.awssdk.services.robomaker.model.CancelWorldExportJobRequest;
import software.amazon.awssdk.services.robomaker.model.CancelWorldExportJobResponse;
import software.amazon.awssdk.services.robomaker.model.CancelWorldGenerationJobRequest;
import software.amazon.awssdk.services.robomaker.model.CancelWorldGenerationJobResponse;
import software.amazon.awssdk.services.robomaker.model.ConcurrentDeploymentException;
import software.amazon.awssdk.services.robomaker.model.CreateDeploymentJobRequest;
import software.amazon.awssdk.services.robomaker.model.CreateDeploymentJobResponse;
import software.amazon.awssdk.services.robomaker.model.CreateFleetRequest;
import software.amazon.awssdk.services.robomaker.model.CreateFleetResponse;
import software.amazon.awssdk.services.robomaker.model.CreateRobotApplicationRequest;
import software.amazon.awssdk.services.robomaker.model.CreateRobotApplicationResponse;
import software.amazon.awssdk.services.robomaker.model.CreateRobotApplicationVersionRequest;
import software.amazon.awssdk.services.robomaker.model.CreateRobotApplicationVersionResponse;
import software.amazon.awssdk.services.robomaker.model.CreateRobotRequest;
import software.amazon.awssdk.services.robomaker.model.CreateRobotResponse;
import software.amazon.awssdk.services.robomaker.model.CreateSimulationApplicationRequest;
import software.amazon.awssdk.services.robomaker.model.CreateSimulationApplicationResponse;
import software.amazon.awssdk.services.robomaker.model.CreateSimulationApplicationVersionRequest;
import software.amazon.awssdk.services.robomaker.model.CreateSimulationApplicationVersionResponse;
import software.amazon.awssdk.services.robomaker.model.CreateSimulationJobRequest;
import software.amazon.awssdk.services.robomaker.model.CreateSimulationJobResponse;
import software.amazon.awssdk.services.robomaker.model.CreateWorldExportJobRequest;
import software.amazon.awssdk.services.robomaker.model.CreateWorldExportJobResponse;
import software.amazon.awssdk.services.robomaker.model.CreateWorldGenerationJobRequest;
import software.amazon.awssdk.services.robomaker.model.CreateWorldGenerationJobResponse;
import software.amazon.awssdk.services.robomaker.model.CreateWorldTemplateRequest;
import software.amazon.awssdk.services.robomaker.model.CreateWorldTemplateResponse;
import software.amazon.awssdk.services.robomaker.model.DeleteFleetRequest;
import software.amazon.awssdk.services.robomaker.model.DeleteFleetResponse;
import software.amazon.awssdk.services.robomaker.model.DeleteRobotApplicationRequest;
import software.amazon.awssdk.services.robomaker.model.DeleteRobotApplicationResponse;
import software.amazon.awssdk.services.robomaker.model.DeleteRobotRequest;
import software.amazon.awssdk.services.robomaker.model.DeleteRobotResponse;
import software.amazon.awssdk.services.robomaker.model.DeleteSimulationApplicationRequest;
import software.amazon.awssdk.services.robomaker.model.DeleteSimulationApplicationResponse;
import software.amazon.awssdk.services.robomaker.model.DeleteWorldTemplateRequest;
import software.amazon.awssdk.services.robomaker.model.DeleteWorldTemplateResponse;
import software.amazon.awssdk.services.robomaker.model.DeregisterRobotRequest;
import software.amazon.awssdk.services.robomaker.model.DeregisterRobotResponse;
import software.amazon.awssdk.services.robomaker.model.DescribeDeploymentJobRequest;
import software.amazon.awssdk.services.robomaker.model.DescribeDeploymentJobResponse;
import software.amazon.awssdk.services.robomaker.model.DescribeFleetRequest;
import software.amazon.awssdk.services.robomaker.model.DescribeFleetResponse;
import software.amazon.awssdk.services.robomaker.model.DescribeRobotApplicationRequest;
import software.amazon.awssdk.services.robomaker.model.DescribeRobotApplicationResponse;
import software.amazon.awssdk.services.robomaker.model.DescribeRobotRequest;
import software.amazon.awssdk.services.robomaker.model.DescribeRobotResponse;
import software.amazon.awssdk.services.robomaker.model.DescribeSimulationApplicationRequest;
import software.amazon.awssdk.services.robomaker.model.DescribeSimulationApplicationResponse;
import software.amazon.awssdk.services.robomaker.model.DescribeSimulationJobBatchRequest;
import software.amazon.awssdk.services.robomaker.model.DescribeSimulationJobBatchResponse;
import software.amazon.awssdk.services.robomaker.model.DescribeSimulationJobRequest;
import software.amazon.awssdk.services.robomaker.model.DescribeSimulationJobResponse;
import software.amazon.awssdk.services.robomaker.model.DescribeWorldExportJobRequest;
import software.amazon.awssdk.services.robomaker.model.DescribeWorldExportJobResponse;
import software.amazon.awssdk.services.robomaker.model.DescribeWorldGenerationJobRequest;
import software.amazon.awssdk.services.robomaker.model.DescribeWorldGenerationJobResponse;
import software.amazon.awssdk.services.robomaker.model.DescribeWorldRequest;
import software.amazon.awssdk.services.robomaker.model.DescribeWorldResponse;
import software.amazon.awssdk.services.robomaker.model.DescribeWorldTemplateRequest;
import software.amazon.awssdk.services.robomaker.model.DescribeWorldTemplateResponse;
import software.amazon.awssdk.services.robomaker.model.GetWorldTemplateBodyRequest;
import software.amazon.awssdk.services.robomaker.model.GetWorldTemplateBodyResponse;
import software.amazon.awssdk.services.robomaker.model.IdempotentParameterMismatchException;
import software.amazon.awssdk.services.robomaker.model.InternalServerException;
import software.amazon.awssdk.services.robomaker.model.InvalidParameterException;
import software.amazon.awssdk.services.robomaker.model.LimitExceededException;
import software.amazon.awssdk.services.robomaker.model.ListDeploymentJobsRequest;
import software.amazon.awssdk.services.robomaker.model.ListDeploymentJobsResponse;
import software.amazon.awssdk.services.robomaker.model.ListFleetsRequest;
import software.amazon.awssdk.services.robomaker.model.ListFleetsResponse;
import software.amazon.awssdk.services.robomaker.model.ListRobotApplicationsRequest;
import software.amazon.awssdk.services.robomaker.model.ListRobotApplicationsResponse;
import software.amazon.awssdk.services.robomaker.model.ListRobotsRequest;
import software.amazon.awssdk.services.robomaker.model.ListRobotsResponse;
import software.amazon.awssdk.services.robomaker.model.ListSimulationApplicationsRequest;
import software.amazon.awssdk.services.robomaker.model.ListSimulationApplicationsResponse;
import software.amazon.awssdk.services.robomaker.model.ListSimulationJobBatchesRequest;
import software.amazon.awssdk.services.robomaker.model.ListSimulationJobBatchesResponse;
import software.amazon.awssdk.services.robomaker.model.ListSimulationJobsRequest;
import software.amazon.awssdk.services.robomaker.model.ListSimulationJobsResponse;
import software.amazon.awssdk.services.robomaker.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.robomaker.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.robomaker.model.ListWorldExportJobsRequest;
import software.amazon.awssdk.services.robomaker.model.ListWorldExportJobsResponse;
import software.amazon.awssdk.services.robomaker.model.ListWorldGenerationJobsRequest;
import software.amazon.awssdk.services.robomaker.model.ListWorldGenerationJobsResponse;
import software.amazon.awssdk.services.robomaker.model.ListWorldTemplatesRequest;
import software.amazon.awssdk.services.robomaker.model.ListWorldTemplatesResponse;
import software.amazon.awssdk.services.robomaker.model.ListWorldsRequest;
import software.amazon.awssdk.services.robomaker.model.ListWorldsResponse;
import software.amazon.awssdk.services.robomaker.model.RegisterRobotRequest;
import software.amazon.awssdk.services.robomaker.model.RegisterRobotResponse;
import software.amazon.awssdk.services.robomaker.model.ResourceAlreadyExistsException;
import software.amazon.awssdk.services.robomaker.model.ResourceNotFoundException;
import software.amazon.awssdk.services.robomaker.model.RestartSimulationJobRequest;
import software.amazon.awssdk.services.robomaker.model.RestartSimulationJobResponse;
import software.amazon.awssdk.services.robomaker.model.RoboMakerException;
import software.amazon.awssdk.services.robomaker.model.ServiceUnavailableException;
import software.amazon.awssdk.services.robomaker.model.StartSimulationJobBatchRequest;
import software.amazon.awssdk.services.robomaker.model.StartSimulationJobBatchResponse;
import software.amazon.awssdk.services.robomaker.model.SyncDeploymentJobRequest;
import software.amazon.awssdk.services.robomaker.model.SyncDeploymentJobResponse;
import software.amazon.awssdk.services.robomaker.model.TagResourceRequest;
import software.amazon.awssdk.services.robomaker.model.TagResourceResponse;
import software.amazon.awssdk.services.robomaker.model.ThrottlingException;
import software.amazon.awssdk.services.robomaker.model.UntagResourceRequest;
import software.amazon.awssdk.services.robomaker.model.UntagResourceResponse;
import software.amazon.awssdk.services.robomaker.model.UpdateRobotApplicationRequest;
import software.amazon.awssdk.services.robomaker.model.UpdateRobotApplicationResponse;
import software.amazon.awssdk.services.robomaker.model.UpdateSimulationApplicationRequest;
import software.amazon.awssdk.services.robomaker.model.UpdateSimulationApplicationResponse;
import software.amazon.awssdk.services.robomaker.model.UpdateWorldTemplateRequest;
import software.amazon.awssdk.services.robomaker.model.UpdateWorldTemplateResponse;
import software.amazon.awssdk.services.robomaker.paginators.ListDeploymentJobsIterable;
import software.amazon.awssdk.services.robomaker.paginators.ListFleetsIterable;
import software.amazon.awssdk.services.robomaker.paginators.ListRobotApplicationsIterable;
import software.amazon.awssdk.services.robomaker.paginators.ListRobotsIterable;
import software.amazon.awssdk.services.robomaker.paginators.ListSimulationApplicationsIterable;
import software.amazon.awssdk.services.robomaker.paginators.ListSimulationJobBatchesIterable;
import software.amazon.awssdk.services.robomaker.paginators.ListSimulationJobsIterable;
import software.amazon.awssdk.services.robomaker.paginators.ListWorldExportJobsIterable;
import software.amazon.awssdk.services.robomaker.paginators.ListWorldGenerationJobsIterable;
import software.amazon.awssdk.services.robomaker.paginators.ListWorldTemplatesIterable;
import software.amazon.awssdk.services.robomaker.paginators.ListWorldsIterable;

/**
 * Service client for accessing RoboMaker. This can be created using the static {@link #builder()} method.
 *
 * <p>
 * This section provides documentation for the AWS RoboMaker API operations.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public interface RoboMakerClient extends SdkClient {
    String SERVICE_NAME = "robomaker";

    /**
     * Create a {@link RoboMakerClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static RoboMakerClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link RoboMakerClient}.
     */
    static RoboMakerClientBuilder builder() {
        return new DefaultRoboMakerClientBuilder();
    }

    /**
     * <p>
     * Deletes one or more worlds in a batch operation.
     * </p>
     *
     * @param batchDeleteWorldsRequest
     * @return Result of the BatchDeleteWorlds operation returned by the service.
     * @throws InvalidParameterException
     *         A parameter specified in a request is not valid, is unsupported, or cannot be used. The returned message
     *         provides an explanation of the error value.
     * @throws ThrottlingException
     *         AWS RoboMaker is temporarily unable to process the request. Try your call again.
     * @throws InternalServerException
     *         AWS RoboMaker experienced a service issue. Try your call again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RoboMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RoboMakerClient.BatchDeleteWorlds
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/BatchDeleteWorlds" target="_top">AWS
     *      API Documentation</a>
     */
    default BatchDeleteWorldsResponse batchDeleteWorlds(BatchDeleteWorldsRequest batchDeleteWorldsRequest)
            throws InvalidParameterException, ThrottlingException, InternalServerException, AwsServiceException,
            SdkClientException, RoboMakerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes one or more worlds in a batch operation.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link BatchDeleteWorldsRequest.Builder} avoiding the need
     * to create one manually via {@link BatchDeleteWorldsRequest#builder()}
     * </p>
     *
     * @param batchDeleteWorldsRequest
     *        A {@link Consumer} that will call methods on {@link BatchDeleteWorldsRequest.Builder} to create a request.
     * @return Result of the BatchDeleteWorlds operation returned by the service.
     * @throws InvalidParameterException
     *         A parameter specified in a request is not valid, is unsupported, or cannot be used. The returned message
     *         provides an explanation of the error value.
     * @throws ThrottlingException
     *         AWS RoboMaker is temporarily unable to process the request. Try your call again.
     * @throws InternalServerException
     *         AWS RoboMaker experienced a service issue. Try your call again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RoboMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RoboMakerClient.BatchDeleteWorlds
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/BatchDeleteWorlds" target="_top">AWS
     *      API Documentation</a>
     */
    default BatchDeleteWorldsResponse batchDeleteWorlds(Consumer<BatchDeleteWorldsRequest.Builder> batchDeleteWorldsRequest)
            throws InvalidParameterException, ThrottlingException, InternalServerException, AwsServiceException,
            SdkClientException, RoboMakerException {
        return batchDeleteWorlds(BatchDeleteWorldsRequest.builder().applyMutation(batchDeleteWorldsRequest).build());
    }

    /**
     * <p>
     * Describes one or more simulation jobs.
     * </p>
     *
     * @param batchDescribeSimulationJobRequest
     * @return Result of the BatchDescribeSimulationJob operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws InvalidParameterException
     *         A parameter specified in a request is not valid, is unsupported, or cannot be used. The returned message
     *         provides an explanation of the error value.
     * @throws InternalServerException
     *         AWS RoboMaker experienced a service issue. Try your call again.
     * @throws ThrottlingException
     *         AWS RoboMaker is temporarily unable to process the request. Try your call again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RoboMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RoboMakerClient.BatchDescribeSimulationJob
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/BatchDescribeSimulationJob"
     *      target="_top">AWS API Documentation</a>
     */
    default BatchDescribeSimulationJobResponse batchDescribeSimulationJob(
            BatchDescribeSimulationJobRequest batchDescribeSimulationJobRequest) throws ResourceNotFoundException,
            InvalidParameterException, InternalServerException, ThrottlingException, AwsServiceException, SdkClientException,
            RoboMakerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes one or more simulation jobs.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link BatchDescribeSimulationJobRequest.Builder} avoiding
     * the need to create one manually via {@link BatchDescribeSimulationJobRequest#builder()}
     * </p>
     *
     * @param batchDescribeSimulationJobRequest
     *        A {@link Consumer} that will call methods on {@link BatchDescribeSimulationJobRequest.Builder} to create a
     *        request.
     * @return Result of the BatchDescribeSimulationJob operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws InvalidParameterException
     *         A parameter specified in a request is not valid, is unsupported, or cannot be used. The returned message
     *         provides an explanation of the error value.
     * @throws InternalServerException
     *         AWS RoboMaker experienced a service issue. Try your call again.
     * @throws ThrottlingException
     *         AWS RoboMaker is temporarily unable to process the request. Try your call again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RoboMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RoboMakerClient.BatchDescribeSimulationJob
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/BatchDescribeSimulationJob"
     *      target="_top">AWS API Documentation</a>
     */
    default BatchDescribeSimulationJobResponse batchDescribeSimulationJob(
            Consumer<BatchDescribeSimulationJobRequest.Builder> batchDescribeSimulationJobRequest)
            throws ResourceNotFoundException, InvalidParameterException, InternalServerException, ThrottlingException,
            AwsServiceException, SdkClientException, RoboMakerException {
        return batchDescribeSimulationJob(BatchDescribeSimulationJobRequest.builder()
                .applyMutation(batchDescribeSimulationJobRequest).build());
    }

    /**
     * <p>
     * Cancels the specified deployment job.
     * </p>
     *
     * @param cancelDeploymentJobRequest
     * @return Result of the CancelDeploymentJob operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws InvalidParameterException
     *         A parameter specified in a request is not valid, is unsupported, or cannot be used. The returned message
     *         provides an explanation of the error value.
     * @throws InternalServerException
     *         AWS RoboMaker experienced a service issue. Try your call again.
     * @throws ThrottlingException
     *         AWS RoboMaker is temporarily unable to process the request. Try your call again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RoboMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RoboMakerClient.CancelDeploymentJob
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/CancelDeploymentJob" target="_top">AWS
     *      API Documentation</a>
     */
    default CancelDeploymentJobResponse cancelDeploymentJob(CancelDeploymentJobRequest cancelDeploymentJobRequest)
            throws ResourceNotFoundException, InvalidParameterException, InternalServerException, ThrottlingException,
            AwsServiceException, SdkClientException, RoboMakerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Cancels the specified deployment job.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CancelDeploymentJobRequest.Builder} avoiding the
     * need to create one manually via {@link CancelDeploymentJobRequest#builder()}
     * </p>
     *
     * @param cancelDeploymentJobRequest
     *        A {@link Consumer} that will call methods on {@link CancelDeploymentJobRequest.Builder} to create a
     *        request.
     * @return Result of the CancelDeploymentJob operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws InvalidParameterException
     *         A parameter specified in a request is not valid, is unsupported, or cannot be used. The returned message
     *         provides an explanation of the error value.
     * @throws InternalServerException
     *         AWS RoboMaker experienced a service issue. Try your call again.
     * @throws ThrottlingException
     *         AWS RoboMaker is temporarily unable to process the request. Try your call again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RoboMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RoboMakerClient.CancelDeploymentJob
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/CancelDeploymentJob" target="_top">AWS
     *      API Documentation</a>
     */
    default CancelDeploymentJobResponse cancelDeploymentJob(
            Consumer<CancelDeploymentJobRequest.Builder> cancelDeploymentJobRequest) throws ResourceNotFoundException,
            InvalidParameterException, InternalServerException, ThrottlingException, AwsServiceException, SdkClientException,
            RoboMakerException {
        return cancelDeploymentJob(CancelDeploymentJobRequest.builder().applyMutation(cancelDeploymentJobRequest).build());
    }

    /**
     * <p>
     * Cancels the specified simulation job.
     * </p>
     *
     * @param cancelSimulationJobRequest
     * @return Result of the CancelSimulationJob operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws InvalidParameterException
     *         A parameter specified in a request is not valid, is unsupported, or cannot be used. The returned message
     *         provides an explanation of the error value.
     * @throws InternalServerException
     *         AWS RoboMaker experienced a service issue. Try your call again.
     * @throws ThrottlingException
     *         AWS RoboMaker is temporarily unable to process the request. Try your call again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RoboMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RoboMakerClient.CancelSimulationJob
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/CancelSimulationJob" target="_top">AWS
     *      API Documentation</a>
     */
    default CancelSimulationJobResponse cancelSimulationJob(CancelSimulationJobRequest cancelSimulationJobRequest)
            throws ResourceNotFoundException, InvalidParameterException, InternalServerException, ThrottlingException,
            AwsServiceException, SdkClientException, RoboMakerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Cancels the specified simulation job.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CancelSimulationJobRequest.Builder} avoiding the
     * need to create one manually via {@link CancelSimulationJobRequest#builder()}
     * </p>
     *
     * @param cancelSimulationJobRequest
     *        A {@link Consumer} that will call methods on {@link CancelSimulationJobRequest.Builder} to create a
     *        request.
     * @return Result of the CancelSimulationJob operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws InvalidParameterException
     *         A parameter specified in a request is not valid, is unsupported, or cannot be used. The returned message
     *         provides an explanation of the error value.
     * @throws InternalServerException
     *         AWS RoboMaker experienced a service issue. Try your call again.
     * @throws ThrottlingException
     *         AWS RoboMaker is temporarily unable to process the request. Try your call again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RoboMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RoboMakerClient.CancelSimulationJob
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/CancelSimulationJob" target="_top">AWS
     *      API Documentation</a>
     */
    default CancelSimulationJobResponse cancelSimulationJob(
            Consumer<CancelSimulationJobRequest.Builder> cancelSimulationJobRequest) throws ResourceNotFoundException,
            InvalidParameterException, InternalServerException, ThrottlingException, AwsServiceException, SdkClientException,
            RoboMakerException {
        return cancelSimulationJob(CancelSimulationJobRequest.builder().applyMutation(cancelSimulationJobRequest).build());
    }

    /**
     * <p>
     * Cancels a simulation job batch. When you cancel a simulation job batch, you are also cancelling all of the active
     * simulation jobs created as part of the batch.
     * </p>
     *
     * @param cancelSimulationJobBatchRequest
     * @return Result of the CancelSimulationJobBatch operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws InvalidParameterException
     *         A parameter specified in a request is not valid, is unsupported, or cannot be used. The returned message
     *         provides an explanation of the error value.
     * @throws InternalServerException
     *         AWS RoboMaker experienced a service issue. Try your call again.
     * @throws ThrottlingException
     *         AWS RoboMaker is temporarily unable to process the request. Try your call again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RoboMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RoboMakerClient.CancelSimulationJobBatch
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/CancelSimulationJobBatch"
     *      target="_top">AWS API Documentation</a>
     */
    default CancelSimulationJobBatchResponse cancelSimulationJobBatch(
            CancelSimulationJobBatchRequest cancelSimulationJobBatchRequest) throws ResourceNotFoundException,
            InvalidParameterException, InternalServerException, ThrottlingException, AwsServiceException, SdkClientException,
            RoboMakerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Cancels a simulation job batch. When you cancel a simulation job batch, you are also cancelling all of the active
     * simulation jobs created as part of the batch.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CancelSimulationJobBatchRequest.Builder} avoiding
     * the need to create one manually via {@link CancelSimulationJobBatchRequest#builder()}
     * </p>
     *
     * @param cancelSimulationJobBatchRequest
     *        A {@link Consumer} that will call methods on {@link CancelSimulationJobBatchRequest.Builder} to create a
     *        request.
     * @return Result of the CancelSimulationJobBatch operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws InvalidParameterException
     *         A parameter specified in a request is not valid, is unsupported, or cannot be used. The returned message
     *         provides an explanation of the error value.
     * @throws InternalServerException
     *         AWS RoboMaker experienced a service issue. Try your call again.
     * @throws ThrottlingException
     *         AWS RoboMaker is temporarily unable to process the request. Try your call again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RoboMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RoboMakerClient.CancelSimulationJobBatch
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/CancelSimulationJobBatch"
     *      target="_top">AWS API Documentation</a>
     */
    default CancelSimulationJobBatchResponse cancelSimulationJobBatch(
            Consumer<CancelSimulationJobBatchRequest.Builder> cancelSimulationJobBatchRequest) throws ResourceNotFoundException,
            InvalidParameterException, InternalServerException, ThrottlingException, AwsServiceException, SdkClientException,
            RoboMakerException {
        return cancelSimulationJobBatch(CancelSimulationJobBatchRequest.builder().applyMutation(cancelSimulationJobBatchRequest)
                .build());
    }

    /**
     * <p>
     * Cancels the specified export job.
     * </p>
     *
     * @param cancelWorldExportJobRequest
     * @return Result of the CancelWorldExportJob operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws InvalidParameterException
     *         A parameter specified in a request is not valid, is unsupported, or cannot be used. The returned message
     *         provides an explanation of the error value.
     * @throws InternalServerException
     *         AWS RoboMaker experienced a service issue. Try your call again.
     * @throws ThrottlingException
     *         AWS RoboMaker is temporarily unable to process the request. Try your call again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RoboMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RoboMakerClient.CancelWorldExportJob
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/CancelWorldExportJob" target="_top">AWS
     *      API Documentation</a>
     */
    default CancelWorldExportJobResponse cancelWorldExportJob(CancelWorldExportJobRequest cancelWorldExportJobRequest)
            throws ResourceNotFoundException, InvalidParameterException, InternalServerException, ThrottlingException,
            AwsServiceException, SdkClientException, RoboMakerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Cancels the specified export job.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CancelWorldExportJobRequest.Builder} avoiding the
     * need to create one manually via {@link CancelWorldExportJobRequest#builder()}
     * </p>
     *
     * @param cancelWorldExportJobRequest
     *        A {@link Consumer} that will call methods on {@link CancelWorldExportJobRequest.Builder} to create a
     *        request.
     * @return Result of the CancelWorldExportJob operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws InvalidParameterException
     *         A parameter specified in a request is not valid, is unsupported, or cannot be used. The returned message
     *         provides an explanation of the error value.
     * @throws InternalServerException
     *         AWS RoboMaker experienced a service issue. Try your call again.
     * @throws ThrottlingException
     *         AWS RoboMaker is temporarily unable to process the request. Try your call again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RoboMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RoboMakerClient.CancelWorldExportJob
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/CancelWorldExportJob" target="_top">AWS
     *      API Documentation</a>
     */
    default CancelWorldExportJobResponse cancelWorldExportJob(
            Consumer<CancelWorldExportJobRequest.Builder> cancelWorldExportJobRequest) throws ResourceNotFoundException,
            InvalidParameterException, InternalServerException, ThrottlingException, AwsServiceException, SdkClientException,
            RoboMakerException {
        return cancelWorldExportJob(CancelWorldExportJobRequest.builder().applyMutation(cancelWorldExportJobRequest).build());
    }

    /**
     * <p>
     * Cancels the specified world generator job.
     * </p>
     *
     * @param cancelWorldGenerationJobRequest
     * @return Result of the CancelWorldGenerationJob operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws InvalidParameterException
     *         A parameter specified in a request is not valid, is unsupported, or cannot be used. The returned message
     *         provides an explanation of the error value.
     * @throws InternalServerException
     *         AWS RoboMaker experienced a service issue. Try your call again.
     * @throws ThrottlingException
     *         AWS RoboMaker is temporarily unable to process the request. Try your call again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RoboMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RoboMakerClient.CancelWorldGenerationJob
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/CancelWorldGenerationJob"
     *      target="_top">AWS API Documentation</a>
     */
    default CancelWorldGenerationJobResponse cancelWorldGenerationJob(
            CancelWorldGenerationJobRequest cancelWorldGenerationJobRequest) throws ResourceNotFoundException,
            InvalidParameterException, InternalServerException, ThrottlingException, AwsServiceException, SdkClientException,
            RoboMakerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Cancels the specified world generator job.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CancelWorldGenerationJobRequest.Builder} avoiding
     * the need to create one manually via {@link CancelWorldGenerationJobRequest#builder()}
     * </p>
     *
     * @param cancelWorldGenerationJobRequest
     *        A {@link Consumer} that will call methods on {@link CancelWorldGenerationJobRequest.Builder} to create a
     *        request.
     * @return Result of the CancelWorldGenerationJob operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws InvalidParameterException
     *         A parameter specified in a request is not valid, is unsupported, or cannot be used. The returned message
     *         provides an explanation of the error value.
     * @throws InternalServerException
     *         AWS RoboMaker experienced a service issue. Try your call again.
     * @throws ThrottlingException
     *         AWS RoboMaker is temporarily unable to process the request. Try your call again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RoboMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RoboMakerClient.CancelWorldGenerationJob
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/CancelWorldGenerationJob"
     *      target="_top">AWS API Documentation</a>
     */
    default CancelWorldGenerationJobResponse cancelWorldGenerationJob(
            Consumer<CancelWorldGenerationJobRequest.Builder> cancelWorldGenerationJobRequest) throws ResourceNotFoundException,
            InvalidParameterException, InternalServerException, ThrottlingException, AwsServiceException, SdkClientException,
            RoboMakerException {
        return cancelWorldGenerationJob(CancelWorldGenerationJobRequest.builder().applyMutation(cancelWorldGenerationJobRequest)
                .build());
    }

    /**
     * <p>
     * Deploys a specific version of a robot application to robots in a fleet.
     * </p>
     * <p>
     * The robot application must have a numbered <code>applicationVersion</code> for consistency reasons. To create a
     * new version, use <code>CreateRobotApplicationVersion</code> or see <a
     * href="https://docs.aws.amazon.com/robomaker/latest/dg/create-robot-application-version.html">Creating a Robot
     * Application Version</a>.
     * </p>
     * <note>
     * <p>
     * After 90 days, deployment jobs expire and will be deleted. They will no longer be accessible.
     * </p>
     * </note>
     *
     * @param createDeploymentJobRequest
     * @return Result of the CreateDeploymentJob operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws InvalidParameterException
     *         A parameter specified in a request is not valid, is unsupported, or cannot be used. The returned message
     *         provides an explanation of the error value.
     * @throws InternalServerException
     *         AWS RoboMaker experienced a service issue. Try your call again.
     * @throws ThrottlingException
     *         AWS RoboMaker is temporarily unable to process the request. Try your call again.
     * @throws LimitExceededException
     *         The requested resource exceeds the maximum number allowed, or the number of concurrent stream requests
     *         exceeds the maximum number allowed.
     * @throws ConcurrentDeploymentException
     *         The failure percentage threshold percentage was met.
     * @throws IdempotentParameterMismatchException
     *         The request uses the same client token as a previous, but non-identical request. Do not reuse a client
     *         token with different requests, unless the requests are identical.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RoboMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RoboMakerClient.CreateDeploymentJob
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/CreateDeploymentJob" target="_top">AWS
     *      API Documentation</a>
     */
    default CreateDeploymentJobResponse createDeploymentJob(CreateDeploymentJobRequest createDeploymentJobRequest)
            throws ResourceNotFoundException, InvalidParameterException, InternalServerException, ThrottlingException,
            LimitExceededException, ConcurrentDeploymentException, IdempotentParameterMismatchException, AwsServiceException,
            SdkClientException, RoboMakerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deploys a specific version of a robot application to robots in a fleet.
     * </p>
     * <p>
     * The robot application must have a numbered <code>applicationVersion</code> for consistency reasons. To create a
     * new version, use <code>CreateRobotApplicationVersion</code> or see <a
     * href="https://docs.aws.amazon.com/robomaker/latest/dg/create-robot-application-version.html">Creating a Robot
     * Application Version</a>.
     * </p>
     * <note>
     * <p>
     * After 90 days, deployment jobs expire and will be deleted. They will no longer be accessible.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateDeploymentJobRequest.Builder} avoiding the
     * need to create one manually via {@link CreateDeploymentJobRequest#builder()}
     * </p>
     *
     * @param createDeploymentJobRequest
     *        A {@link Consumer} that will call methods on {@link CreateDeploymentJobRequest.Builder} to create a
     *        request.
     * @return Result of the CreateDeploymentJob operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws InvalidParameterException
     *         A parameter specified in a request is not valid, is unsupported, or cannot be used. The returned message
     *         provides an explanation of the error value.
     * @throws InternalServerException
     *         AWS RoboMaker experienced a service issue. Try your call again.
     * @throws ThrottlingException
     *         AWS RoboMaker is temporarily unable to process the request. Try your call again.
     * @throws LimitExceededException
     *         The requested resource exceeds the maximum number allowed, or the number of concurrent stream requests
     *         exceeds the maximum number allowed.
     * @throws ConcurrentDeploymentException
     *         The failure percentage threshold percentage was met.
     * @throws IdempotentParameterMismatchException
     *         The request uses the same client token as a previous, but non-identical request. Do not reuse a client
     *         token with different requests, unless the requests are identical.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RoboMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RoboMakerClient.CreateDeploymentJob
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/CreateDeploymentJob" target="_top">AWS
     *      API Documentation</a>
     */
    default CreateDeploymentJobResponse createDeploymentJob(
            Consumer<CreateDeploymentJobRequest.Builder> createDeploymentJobRequest) throws ResourceNotFoundException,
            InvalidParameterException, InternalServerException, ThrottlingException, LimitExceededException,
            ConcurrentDeploymentException, IdempotentParameterMismatchException, AwsServiceException, SdkClientException,
            RoboMakerException {
        return createDeploymentJob(CreateDeploymentJobRequest.builder().applyMutation(createDeploymentJobRequest).build());
    }

    /**
     * <p>
     * Creates a fleet, a logical group of robots running the same robot application.
     * </p>
     *
     * @param createFleetRequest
     * @return Result of the CreateFleet operation returned by the service.
     * @throws InvalidParameterException
     *         A parameter specified in a request is not valid, is unsupported, or cannot be used. The returned message
     *         provides an explanation of the error value.
     * @throws InternalServerException
     *         AWS RoboMaker experienced a service issue. Try your call again.
     * @throws ThrottlingException
     *         AWS RoboMaker is temporarily unable to process the request. Try your call again.
     * @throws LimitExceededException
     *         The requested resource exceeds the maximum number allowed, or the number of concurrent stream requests
     *         exceeds the maximum number allowed.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RoboMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RoboMakerClient.CreateFleet
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/CreateFleet" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateFleetResponse createFleet(CreateFleetRequest createFleetRequest) throws InvalidParameterException,
            InternalServerException, ThrottlingException, LimitExceededException, AwsServiceException, SdkClientException,
            RoboMakerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a fleet, a logical group of robots running the same robot application.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateFleetRequest.Builder} avoiding the need to
     * create one manually via {@link CreateFleetRequest#builder()}
     * </p>
     *
     * @param createFleetRequest
     *        A {@link Consumer} that will call methods on {@link CreateFleetRequest.Builder} to create a request.
     * @return Result of the CreateFleet operation returned by the service.
     * @throws InvalidParameterException
     *         A parameter specified in a request is not valid, is unsupported, or cannot be used. The returned message
     *         provides an explanation of the error value.
     * @throws InternalServerException
     *         AWS RoboMaker experienced a service issue. Try your call again.
     * @throws ThrottlingException
     *         AWS RoboMaker is temporarily unable to process the request. Try your call again.
     * @throws LimitExceededException
     *         The requested resource exceeds the maximum number allowed, or the number of concurrent stream requests
     *         exceeds the maximum number allowed.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RoboMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RoboMakerClient.CreateFleet
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/CreateFleet" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateFleetResponse createFleet(Consumer<CreateFleetRequest.Builder> createFleetRequest)
            throws InvalidParameterException, InternalServerException, ThrottlingException, LimitExceededException,
            AwsServiceException, SdkClientException, RoboMakerException {
        return createFleet(CreateFleetRequest.builder().applyMutation(createFleetRequest).build());
    }

    /**
     * <p>
     * Creates a robot.
     * </p>
     *
     * @param createRobotRequest
     * @return Result of the CreateRobot operation returned by the service.
     * @throws InvalidParameterException
     *         A parameter specified in a request is not valid, is unsupported, or cannot be used. The returned message
     *         provides an explanation of the error value.
     * @throws InternalServerException
     *         AWS RoboMaker experienced a service issue. Try your call again.
     * @throws ThrottlingException
     *         AWS RoboMaker is temporarily unable to process the request. Try your call again.
     * @throws LimitExceededException
     *         The requested resource exceeds the maximum number allowed, or the number of concurrent stream requests
     *         exceeds the maximum number allowed.
     * @throws ResourceAlreadyExistsException
     *         The specified resource already exists.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RoboMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RoboMakerClient.CreateRobot
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/CreateRobot" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateRobotResponse createRobot(CreateRobotRequest createRobotRequest) throws InvalidParameterException,
            InternalServerException, ThrottlingException, LimitExceededException, ResourceAlreadyExistsException,
            AwsServiceException, SdkClientException, RoboMakerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a robot.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateRobotRequest.Builder} avoiding the need to
     * create one manually via {@link CreateRobotRequest#builder()}
     * </p>
     *
     * @param createRobotRequest
     *        A {@link Consumer} that will call methods on {@link CreateRobotRequest.Builder} to create a request.
     * @return Result of the CreateRobot operation returned by the service.
     * @throws InvalidParameterException
     *         A parameter specified in a request is not valid, is unsupported, or cannot be used. The returned message
     *         provides an explanation of the error value.
     * @throws InternalServerException
     *         AWS RoboMaker experienced a service issue. Try your call again.
     * @throws ThrottlingException
     *         AWS RoboMaker is temporarily unable to process the request. Try your call again.
     * @throws LimitExceededException
     *         The requested resource exceeds the maximum number allowed, or the number of concurrent stream requests
     *         exceeds the maximum number allowed.
     * @throws ResourceAlreadyExistsException
     *         The specified resource already exists.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RoboMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RoboMakerClient.CreateRobot
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/CreateRobot" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateRobotResponse createRobot(Consumer<CreateRobotRequest.Builder> createRobotRequest)
            throws InvalidParameterException, InternalServerException, ThrottlingException, LimitExceededException,
            ResourceAlreadyExistsException, AwsServiceException, SdkClientException, RoboMakerException {
        return createRobot(CreateRobotRequest.builder().applyMutation(createRobotRequest).build());
    }

    /**
     * <p>
     * Creates a robot application.
     * </p>
     *
     * @param createRobotApplicationRequest
     * @return Result of the CreateRobotApplication operation returned by the service.
     * @throws InvalidParameterException
     *         A parameter specified in a request is not valid, is unsupported, or cannot be used. The returned message
     *         provides an explanation of the error value.
     * @throws ResourceAlreadyExistsException
     *         The specified resource already exists.
     * @throws LimitExceededException
     *         The requested resource exceeds the maximum number allowed, or the number of concurrent stream requests
     *         exceeds the maximum number allowed.
     * @throws ThrottlingException
     *         AWS RoboMaker is temporarily unable to process the request. Try your call again.
     * @throws InternalServerException
     *         AWS RoboMaker experienced a service issue. Try your call again.
     * @throws IdempotentParameterMismatchException
     *         The request uses the same client token as a previous, but non-identical request. Do not reuse a client
     *         token with different requests, unless the requests are identical.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RoboMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RoboMakerClient.CreateRobotApplication
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/CreateRobotApplication"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateRobotApplicationResponse createRobotApplication(CreateRobotApplicationRequest createRobotApplicationRequest)
            throws InvalidParameterException, ResourceAlreadyExistsException, LimitExceededException, ThrottlingException,
            InternalServerException, IdempotentParameterMismatchException, AwsServiceException, SdkClientException,
            RoboMakerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a robot application.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateRobotApplicationRequest.Builder} avoiding the
     * need to create one manually via {@link CreateRobotApplicationRequest#builder()}
     * </p>
     *
     * @param createRobotApplicationRequest
     *        A {@link Consumer} that will call methods on {@link CreateRobotApplicationRequest.Builder} to create a
     *        request.
     * @return Result of the CreateRobotApplication operation returned by the service.
     * @throws InvalidParameterException
     *         A parameter specified in a request is not valid, is unsupported, or cannot be used. The returned message
     *         provides an explanation of the error value.
     * @throws ResourceAlreadyExistsException
     *         The specified resource already exists.
     * @throws LimitExceededException
     *         The requested resource exceeds the maximum number allowed, or the number of concurrent stream requests
     *         exceeds the maximum number allowed.
     * @throws ThrottlingException
     *         AWS RoboMaker is temporarily unable to process the request. Try your call again.
     * @throws InternalServerException
     *         AWS RoboMaker experienced a service issue. Try your call again.
     * @throws IdempotentParameterMismatchException
     *         The request uses the same client token as a previous, but non-identical request. Do not reuse a client
     *         token with different requests, unless the requests are identical.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RoboMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RoboMakerClient.CreateRobotApplication
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/CreateRobotApplication"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateRobotApplicationResponse createRobotApplication(
            Consumer<CreateRobotApplicationRequest.Builder> createRobotApplicationRequest) throws InvalidParameterException,
            ResourceAlreadyExistsException, LimitExceededException, ThrottlingException, InternalServerException,
            IdempotentParameterMismatchException, AwsServiceException, SdkClientException, RoboMakerException {
        return createRobotApplication(CreateRobotApplicationRequest.builder().applyMutation(createRobotApplicationRequest)
                .build());
    }

    /**
     * <p>
     * Creates a version of a robot application.
     * </p>
     *
     * @param createRobotApplicationVersionRequest
     * @return Result of the CreateRobotApplicationVersion operation returned by the service.
     * @throws InvalidParameterException
     *         A parameter specified in a request is not valid, is unsupported, or cannot be used. The returned message
     *         provides an explanation of the error value.
     * @throws IdempotentParameterMismatchException
     *         The request uses the same client token as a previous, but non-identical request. Do not reuse a client
     *         token with different requests, unless the requests are identical.
     * @throws LimitExceededException
     *         The requested resource exceeds the maximum number allowed, or the number of concurrent stream requests
     *         exceeds the maximum number allowed.
     * @throws ThrottlingException
     *         AWS RoboMaker is temporarily unable to process the request. Try your call again.
     * @throws InternalServerException
     *         AWS RoboMaker experienced a service issue. Try your call again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RoboMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RoboMakerClient.CreateRobotApplicationVersion
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/CreateRobotApplicationVersion"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateRobotApplicationVersionResponse createRobotApplicationVersion(
            CreateRobotApplicationVersionRequest createRobotApplicationVersionRequest) throws InvalidParameterException,
            IdempotentParameterMismatchException, LimitExceededException, ThrottlingException, InternalServerException,
            AwsServiceException, SdkClientException, RoboMakerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a version of a robot application.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateRobotApplicationVersionRequest.Builder}
     * avoiding the need to create one manually via {@link CreateRobotApplicationVersionRequest#builder()}
     * </p>
     *
     * @param createRobotApplicationVersionRequest
     *        A {@link Consumer} that will call methods on {@link CreateRobotApplicationVersionRequest.Builder} to
     *        create a request.
     * @return Result of the CreateRobotApplicationVersion operation returned by the service.
     * @throws InvalidParameterException
     *         A parameter specified in a request is not valid, is unsupported, or cannot be used. The returned message
     *         provides an explanation of the error value.
     * @throws IdempotentParameterMismatchException
     *         The request uses the same client token as a previous, but non-identical request. Do not reuse a client
     *         token with different requests, unless the requests are identical.
     * @throws LimitExceededException
     *         The requested resource exceeds the maximum number allowed, or the number of concurrent stream requests
     *         exceeds the maximum number allowed.
     * @throws ThrottlingException
     *         AWS RoboMaker is temporarily unable to process the request. Try your call again.
     * @throws InternalServerException
     *         AWS RoboMaker experienced a service issue. Try your call again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RoboMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RoboMakerClient.CreateRobotApplicationVersion
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/CreateRobotApplicationVersion"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateRobotApplicationVersionResponse createRobotApplicationVersion(
            Consumer<CreateRobotApplicationVersionRequest.Builder> createRobotApplicationVersionRequest)
            throws InvalidParameterException, IdempotentParameterMismatchException, LimitExceededException, ThrottlingException,
            InternalServerException, AwsServiceException, SdkClientException, RoboMakerException {
        return createRobotApplicationVersion(CreateRobotApplicationVersionRequest.builder()
                .applyMutation(createRobotApplicationVersionRequest).build());
    }

    /**
     * <p>
     * Creates a simulation application.
     * </p>
     *
     * @param createSimulationApplicationRequest
     * @return Result of the CreateSimulationApplication operation returned by the service.
     * @throws InvalidParameterException
     *         A parameter specified in a request is not valid, is unsupported, or cannot be used. The returned message
     *         provides an explanation of the error value.
     * @throws ResourceAlreadyExistsException
     *         The specified resource already exists.
     * @throws LimitExceededException
     *         The requested resource exceeds the maximum number allowed, or the number of concurrent stream requests
     *         exceeds the maximum number allowed.
     * @throws ThrottlingException
     *         AWS RoboMaker is temporarily unable to process the request. Try your call again.
     * @throws InternalServerException
     *         AWS RoboMaker experienced a service issue. Try your call again.
     * @throws IdempotentParameterMismatchException
     *         The request uses the same client token as a previous, but non-identical request. Do not reuse a client
     *         token with different requests, unless the requests are identical.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RoboMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RoboMakerClient.CreateSimulationApplication
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/CreateSimulationApplication"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateSimulationApplicationResponse createSimulationApplication(
            CreateSimulationApplicationRequest createSimulationApplicationRequest) throws InvalidParameterException,
            ResourceAlreadyExistsException, LimitExceededException, ThrottlingException, InternalServerException,
            IdempotentParameterMismatchException, AwsServiceException, SdkClientException, RoboMakerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a simulation application.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateSimulationApplicationRequest.Builder}
     * avoiding the need to create one manually via {@link CreateSimulationApplicationRequest#builder()}
     * </p>
     *
     * @param createSimulationApplicationRequest
     *        A {@link Consumer} that will call methods on {@link CreateSimulationApplicationRequest.Builder} to create
     *        a request.
     * @return Result of the CreateSimulationApplication operation returned by the service.
     * @throws InvalidParameterException
     *         A parameter specified in a request is not valid, is unsupported, or cannot be used. The returned message
     *         provides an explanation of the error value.
     * @throws ResourceAlreadyExistsException
     *         The specified resource already exists.
     * @throws LimitExceededException
     *         The requested resource exceeds the maximum number allowed, or the number of concurrent stream requests
     *         exceeds the maximum number allowed.
     * @throws ThrottlingException
     *         AWS RoboMaker is temporarily unable to process the request. Try your call again.
     * @throws InternalServerException
     *         AWS RoboMaker experienced a service issue. Try your call again.
     * @throws IdempotentParameterMismatchException
     *         The request uses the same client token as a previous, but non-identical request. Do not reuse a client
     *         token with different requests, unless the requests are identical.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RoboMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RoboMakerClient.CreateSimulationApplication
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/CreateSimulationApplication"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateSimulationApplicationResponse createSimulationApplication(
            Consumer<CreateSimulationApplicationRequest.Builder> createSimulationApplicationRequest)
            throws InvalidParameterException, ResourceAlreadyExistsException, LimitExceededException, ThrottlingException,
            InternalServerException, IdempotentParameterMismatchException, AwsServiceException, SdkClientException,
            RoboMakerException {
        return createSimulationApplication(CreateSimulationApplicationRequest.builder()
                .applyMutation(createSimulationApplicationRequest).build());
    }

    /**
     * <p>
     * Creates a simulation application with a specific revision id.
     * </p>
     *
     * @param createSimulationApplicationVersionRequest
     * @return Result of the CreateSimulationApplicationVersion operation returned by the service.
     * @throws InvalidParameterException
     *         A parameter specified in a request is not valid, is unsupported, or cannot be used. The returned message
     *         provides an explanation of the error value.
     * @throws IdempotentParameterMismatchException
     *         The request uses the same client token as a previous, but non-identical request. Do not reuse a client
     *         token with different requests, unless the requests are identical.
     * @throws LimitExceededException
     *         The requested resource exceeds the maximum number allowed, or the number of concurrent stream requests
     *         exceeds the maximum number allowed.
     * @throws ThrottlingException
     *         AWS RoboMaker is temporarily unable to process the request. Try your call again.
     * @throws InternalServerException
     *         AWS RoboMaker experienced a service issue. Try your call again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RoboMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RoboMakerClient.CreateSimulationApplicationVersion
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/CreateSimulationApplicationVersion"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateSimulationApplicationVersionResponse createSimulationApplicationVersion(
            CreateSimulationApplicationVersionRequest createSimulationApplicationVersionRequest)
            throws InvalidParameterException, IdempotentParameterMismatchException, LimitExceededException, ThrottlingException,
            InternalServerException, AwsServiceException, SdkClientException, RoboMakerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a simulation application with a specific revision id.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateSimulationApplicationVersionRequest.Builder}
     * avoiding the need to create one manually via {@link CreateSimulationApplicationVersionRequest#builder()}
     * </p>
     *
     * @param createSimulationApplicationVersionRequest
     *        A {@link Consumer} that will call methods on {@link CreateSimulationApplicationVersionRequest.Builder} to
     *        create a request.
     * @return Result of the CreateSimulationApplicationVersion operation returned by the service.
     * @throws InvalidParameterException
     *         A parameter specified in a request is not valid, is unsupported, or cannot be used. The returned message
     *         provides an explanation of the error value.
     * @throws IdempotentParameterMismatchException
     *         The request uses the same client token as a previous, but non-identical request. Do not reuse a client
     *         token with different requests, unless the requests are identical.
     * @throws LimitExceededException
     *         The requested resource exceeds the maximum number allowed, or the number of concurrent stream requests
     *         exceeds the maximum number allowed.
     * @throws ThrottlingException
     *         AWS RoboMaker is temporarily unable to process the request. Try your call again.
     * @throws InternalServerException
     *         AWS RoboMaker experienced a service issue. Try your call again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RoboMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RoboMakerClient.CreateSimulationApplicationVersion
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/CreateSimulationApplicationVersion"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateSimulationApplicationVersionResponse createSimulationApplicationVersion(
            Consumer<CreateSimulationApplicationVersionRequest.Builder> createSimulationApplicationVersionRequest)
            throws InvalidParameterException, IdempotentParameterMismatchException, LimitExceededException, ThrottlingException,
            InternalServerException, AwsServiceException, SdkClientException, RoboMakerException {
        return createSimulationApplicationVersion(CreateSimulationApplicationVersionRequest.builder()
                .applyMutation(createSimulationApplicationVersionRequest).build());
    }

    /**
     * <p>
     * Creates a simulation job.
     * </p>
     * <note>
     * <p>
     * After 90 days, simulation jobs expire and will be deleted. They will no longer be accessible.
     * </p>
     * </note>
     *
     * @param createSimulationJobRequest
     * @return Result of the CreateSimulationJob operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws InvalidParameterException
     *         A parameter specified in a request is not valid, is unsupported, or cannot be used. The returned message
     *         provides an explanation of the error value.
     * @throws InternalServerException
     *         AWS RoboMaker experienced a service issue. Try your call again.
     * @throws ThrottlingException
     *         AWS RoboMaker is temporarily unable to process the request. Try your call again.
     * @throws LimitExceededException
     *         The requested resource exceeds the maximum number allowed, or the number of concurrent stream requests
     *         exceeds the maximum number allowed.
     * @throws IdempotentParameterMismatchException
     *         The request uses the same client token as a previous, but non-identical request. Do not reuse a client
     *         token with different requests, unless the requests are identical.
     * @throws ServiceUnavailableException
     *         The request has failed due to a temporary failure of the server.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RoboMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RoboMakerClient.CreateSimulationJob
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/CreateSimulationJob" target="_top">AWS
     *      API Documentation</a>
     */
    default CreateSimulationJobResponse createSimulationJob(CreateSimulationJobRequest createSimulationJobRequest)
            throws ResourceNotFoundException, InvalidParameterException, InternalServerException, ThrottlingException,
            LimitExceededException, IdempotentParameterMismatchException, ServiceUnavailableException, AwsServiceException,
            SdkClientException, RoboMakerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a simulation job.
     * </p>
     * <note>
     * <p>
     * After 90 days, simulation jobs expire and will be deleted. They will no longer be accessible.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateSimulationJobRequest.Builder} avoiding the
     * need to create one manually via {@link CreateSimulationJobRequest#builder()}
     * </p>
     *
     * @param createSimulationJobRequest
     *        A {@link Consumer} that will call methods on {@link CreateSimulationJobRequest.Builder} to create a
     *        request.
     * @return Result of the CreateSimulationJob operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws InvalidParameterException
     *         A parameter specified in a request is not valid, is unsupported, or cannot be used. The returned message
     *         provides an explanation of the error value.
     * @throws InternalServerException
     *         AWS RoboMaker experienced a service issue. Try your call again.
     * @throws ThrottlingException
     *         AWS RoboMaker is temporarily unable to process the request. Try your call again.
     * @throws LimitExceededException
     *         The requested resource exceeds the maximum number allowed, or the number of concurrent stream requests
     *         exceeds the maximum number allowed.
     * @throws IdempotentParameterMismatchException
     *         The request uses the same client token as a previous, but non-identical request. Do not reuse a client
     *         token with different requests, unless the requests are identical.
     * @throws ServiceUnavailableException
     *         The request has failed due to a temporary failure of the server.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RoboMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RoboMakerClient.CreateSimulationJob
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/CreateSimulationJob" target="_top">AWS
     *      API Documentation</a>
     */
    default CreateSimulationJobResponse createSimulationJob(
            Consumer<CreateSimulationJobRequest.Builder> createSimulationJobRequest) throws ResourceNotFoundException,
            InvalidParameterException, InternalServerException, ThrottlingException, LimitExceededException,
            IdempotentParameterMismatchException, ServiceUnavailableException, AwsServiceException, SdkClientException,
            RoboMakerException {
        return createSimulationJob(CreateSimulationJobRequest.builder().applyMutation(createSimulationJobRequest).build());
    }

    /**
     * <p>
     * Creates a world export job.
     * </p>
     *
     * @param createWorldExportJobRequest
     * @return Result of the CreateWorldExportJob operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws InvalidParameterException
     *         A parameter specified in a request is not valid, is unsupported, or cannot be used. The returned message
     *         provides an explanation of the error value.
     * @throws InternalServerException
     *         AWS RoboMaker experienced a service issue. Try your call again.
     * @throws ThrottlingException
     *         AWS RoboMaker is temporarily unable to process the request. Try your call again.
     * @throws IdempotentParameterMismatchException
     *         The request uses the same client token as a previous, but non-identical request. Do not reuse a client
     *         token with different requests, unless the requests are identical.
     * @throws ServiceUnavailableException
     *         The request has failed due to a temporary failure of the server.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RoboMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RoboMakerClient.CreateWorldExportJob
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/CreateWorldExportJob" target="_top">AWS
     *      API Documentation</a>
     */
    default CreateWorldExportJobResponse createWorldExportJob(CreateWorldExportJobRequest createWorldExportJobRequest)
            throws ResourceNotFoundException, InvalidParameterException, InternalServerException, ThrottlingException,
            IdempotentParameterMismatchException, ServiceUnavailableException, AwsServiceException, SdkClientException,
            RoboMakerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a world export job.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateWorldExportJobRequest.Builder} avoiding the
     * need to create one manually via {@link CreateWorldExportJobRequest#builder()}
     * </p>
     *
     * @param createWorldExportJobRequest
     *        A {@link Consumer} that will call methods on {@link CreateWorldExportJobRequest.Builder} to create a
     *        request.
     * @return Result of the CreateWorldExportJob operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws InvalidParameterException
     *         A parameter specified in a request is not valid, is unsupported, or cannot be used. The returned message
     *         provides an explanation of the error value.
     * @throws InternalServerException
     *         AWS RoboMaker experienced a service issue. Try your call again.
     * @throws ThrottlingException
     *         AWS RoboMaker is temporarily unable to process the request. Try your call again.
     * @throws IdempotentParameterMismatchException
     *         The request uses the same client token as a previous, but non-identical request. Do not reuse a client
     *         token with different requests, unless the requests are identical.
     * @throws ServiceUnavailableException
     *         The request has failed due to a temporary failure of the server.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RoboMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RoboMakerClient.CreateWorldExportJob
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/CreateWorldExportJob" target="_top">AWS
     *      API Documentation</a>
     */
    default CreateWorldExportJobResponse createWorldExportJob(
            Consumer<CreateWorldExportJobRequest.Builder> createWorldExportJobRequest) throws ResourceNotFoundException,
            InvalidParameterException, InternalServerException, ThrottlingException, IdempotentParameterMismatchException,
            ServiceUnavailableException, AwsServiceException, SdkClientException, RoboMakerException {
        return createWorldExportJob(CreateWorldExportJobRequest.builder().applyMutation(createWorldExportJobRequest).build());
    }

    /**
     * <p>
     * Creates worlds using the specified template.
     * </p>
     *
     * @param createWorldGenerationJobRequest
     * @return Result of the CreateWorldGenerationJob operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws InvalidParameterException
     *         A parameter specified in a request is not valid, is unsupported, or cannot be used. The returned message
     *         provides an explanation of the error value.
     * @throws InternalServerException
     *         AWS RoboMaker experienced a service issue. Try your call again.
     * @throws ThrottlingException
     *         AWS RoboMaker is temporarily unable to process the request. Try your call again.
     * @throws LimitExceededException
     *         The requested resource exceeds the maximum number allowed, or the number of concurrent stream requests
     *         exceeds the maximum number allowed.
     * @throws IdempotentParameterMismatchException
     *         The request uses the same client token as a previous, but non-identical request. Do not reuse a client
     *         token with different requests, unless the requests are identical.
     * @throws ServiceUnavailableException
     *         The request has failed due to a temporary failure of the server.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RoboMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RoboMakerClient.CreateWorldGenerationJob
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/CreateWorldGenerationJob"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateWorldGenerationJobResponse createWorldGenerationJob(
            CreateWorldGenerationJobRequest createWorldGenerationJobRequest) throws ResourceNotFoundException,
            InvalidParameterException, InternalServerException, ThrottlingException, LimitExceededException,
            IdempotentParameterMismatchException, ServiceUnavailableException, AwsServiceException, SdkClientException,
            RoboMakerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates worlds using the specified template.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateWorldGenerationJobRequest.Builder} avoiding
     * the need to create one manually via {@link CreateWorldGenerationJobRequest#builder()}
     * </p>
     *
     * @param createWorldGenerationJobRequest
     *        A {@link Consumer} that will call methods on {@link CreateWorldGenerationJobRequest.Builder} to create a
     *        request.
     * @return Result of the CreateWorldGenerationJob operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws InvalidParameterException
     *         A parameter specified in a request is not valid, is unsupported, or cannot be used. The returned message
     *         provides an explanation of the error value.
     * @throws InternalServerException
     *         AWS RoboMaker experienced a service issue. Try your call again.
     * @throws ThrottlingException
     *         AWS RoboMaker is temporarily unable to process the request. Try your call again.
     * @throws LimitExceededException
     *         The requested resource exceeds the maximum number allowed, or the number of concurrent stream requests
     *         exceeds the maximum number allowed.
     * @throws IdempotentParameterMismatchException
     *         The request uses the same client token as a previous, but non-identical request. Do not reuse a client
     *         token with different requests, unless the requests are identical.
     * @throws ServiceUnavailableException
     *         The request has failed due to a temporary failure of the server.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RoboMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RoboMakerClient.CreateWorldGenerationJob
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/CreateWorldGenerationJob"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateWorldGenerationJobResponse createWorldGenerationJob(
            Consumer<CreateWorldGenerationJobRequest.Builder> createWorldGenerationJobRequest) throws ResourceNotFoundException,
            InvalidParameterException, InternalServerException, ThrottlingException, LimitExceededException,
            IdempotentParameterMismatchException, ServiceUnavailableException, AwsServiceException, SdkClientException,
            RoboMakerException {
        return createWorldGenerationJob(CreateWorldGenerationJobRequest.builder().applyMutation(createWorldGenerationJobRequest)
                .build());
    }

    /**
     * <p>
     * Creates a world template.
     * </p>
     *
     * @param createWorldTemplateRequest
     * @return Result of the CreateWorldTemplate operation returned by the service.
     * @throws InvalidParameterException
     *         A parameter specified in a request is not valid, is unsupported, or cannot be used. The returned message
     *         provides an explanation of the error value.
     * @throws ResourceAlreadyExistsException
     *         The specified resource already exists.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws LimitExceededException
     *         The requested resource exceeds the maximum number allowed, or the number of concurrent stream requests
     *         exceeds the maximum number allowed.
     * @throws ThrottlingException
     *         AWS RoboMaker is temporarily unable to process the request. Try your call again.
     * @throws InternalServerException
     *         AWS RoboMaker experienced a service issue. Try your call again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RoboMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RoboMakerClient.CreateWorldTemplate
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/CreateWorldTemplate" target="_top">AWS
     *      API Documentation</a>
     */
    default CreateWorldTemplateResponse createWorldTemplate(CreateWorldTemplateRequest createWorldTemplateRequest)
            throws InvalidParameterException, ResourceAlreadyExistsException, ResourceNotFoundException, LimitExceededException,
            ThrottlingException, InternalServerException, AwsServiceException, SdkClientException, RoboMakerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a world template.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateWorldTemplateRequest.Builder} avoiding the
     * need to create one manually via {@link CreateWorldTemplateRequest#builder()}
     * </p>
     *
     * @param createWorldTemplateRequest
     *        A {@link Consumer} that will call methods on {@link CreateWorldTemplateRequest.Builder} to create a
     *        request.
     * @return Result of the CreateWorldTemplate operation returned by the service.
     * @throws InvalidParameterException
     *         A parameter specified in a request is not valid, is unsupported, or cannot be used. The returned message
     *         provides an explanation of the error value.
     * @throws ResourceAlreadyExistsException
     *         The specified resource already exists.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws LimitExceededException
     *         The requested resource exceeds the maximum number allowed, or the number of concurrent stream requests
     *         exceeds the maximum number allowed.
     * @throws ThrottlingException
     *         AWS RoboMaker is temporarily unable to process the request. Try your call again.
     * @throws InternalServerException
     *         AWS RoboMaker experienced a service issue. Try your call again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RoboMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RoboMakerClient.CreateWorldTemplate
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/CreateWorldTemplate" target="_top">AWS
     *      API Documentation</a>
     */
    default CreateWorldTemplateResponse createWorldTemplate(
            Consumer<CreateWorldTemplateRequest.Builder> createWorldTemplateRequest) throws InvalidParameterException,
            ResourceAlreadyExistsException, ResourceNotFoundException, LimitExceededException, ThrottlingException,
            InternalServerException, AwsServiceException, SdkClientException, RoboMakerException {
        return createWorldTemplate(CreateWorldTemplateRequest.builder().applyMutation(createWorldTemplateRequest).build());
    }

    /**
     * <p>
     * Deletes a fleet.
     * </p>
     *
     * @param deleteFleetRequest
     * @return Result of the DeleteFleet operation returned by the service.
     * @throws InvalidParameterException
     *         A parameter specified in a request is not valid, is unsupported, or cannot be used. The returned message
     *         provides an explanation of the error value.
     * @throws InternalServerException
     *         AWS RoboMaker experienced a service issue. Try your call again.
     * @throws ThrottlingException
     *         AWS RoboMaker is temporarily unable to process the request. Try your call again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RoboMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RoboMakerClient.DeleteFleet
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/DeleteFleet" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteFleetResponse deleteFleet(DeleteFleetRequest deleteFleetRequest) throws InvalidParameterException,
            InternalServerException, ThrottlingException, AwsServiceException, SdkClientException, RoboMakerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a fleet.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteFleetRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteFleetRequest#builder()}
     * </p>
     *
     * @param deleteFleetRequest
     *        A {@link Consumer} that will call methods on {@link DeleteFleetRequest.Builder} to create a request.
     * @return Result of the DeleteFleet operation returned by the service.
     * @throws InvalidParameterException
     *         A parameter specified in a request is not valid, is unsupported, or cannot be used. The returned message
     *         provides an explanation of the error value.
     * @throws InternalServerException
     *         AWS RoboMaker experienced a service issue. Try your call again.
     * @throws ThrottlingException
     *         AWS RoboMaker is temporarily unable to process the request. Try your call again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RoboMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RoboMakerClient.DeleteFleet
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/DeleteFleet" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteFleetResponse deleteFleet(Consumer<DeleteFleetRequest.Builder> deleteFleetRequest)
            throws InvalidParameterException, InternalServerException, ThrottlingException, AwsServiceException,
            SdkClientException, RoboMakerException {
        return deleteFleet(DeleteFleetRequest.builder().applyMutation(deleteFleetRequest).build());
    }

    /**
     * <p>
     * Deletes a robot.
     * </p>
     *
     * @param deleteRobotRequest
     * @return Result of the DeleteRobot operation returned by the service.
     * @throws InvalidParameterException
     *         A parameter specified in a request is not valid, is unsupported, or cannot be used. The returned message
     *         provides an explanation of the error value.
     * @throws InternalServerException
     *         AWS RoboMaker experienced a service issue. Try your call again.
     * @throws ThrottlingException
     *         AWS RoboMaker is temporarily unable to process the request. Try your call again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RoboMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RoboMakerClient.DeleteRobot
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/DeleteRobot" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteRobotResponse deleteRobot(DeleteRobotRequest deleteRobotRequest) throws InvalidParameterException,
            InternalServerException, ThrottlingException, AwsServiceException, SdkClientException, RoboMakerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a robot.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteRobotRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteRobotRequest#builder()}
     * </p>
     *
     * @param deleteRobotRequest
     *        A {@link Consumer} that will call methods on {@link DeleteRobotRequest.Builder} to create a request.
     * @return Result of the DeleteRobot operation returned by the service.
     * @throws InvalidParameterException
     *         A parameter specified in a request is not valid, is unsupported, or cannot be used. The returned message
     *         provides an explanation of the error value.
     * @throws InternalServerException
     *         AWS RoboMaker experienced a service issue. Try your call again.
     * @throws ThrottlingException
     *         AWS RoboMaker is temporarily unable to process the request. Try your call again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RoboMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RoboMakerClient.DeleteRobot
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/DeleteRobot" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteRobotResponse deleteRobot(Consumer<DeleteRobotRequest.Builder> deleteRobotRequest)
            throws InvalidParameterException, InternalServerException, ThrottlingException, AwsServiceException,
            SdkClientException, RoboMakerException {
        return deleteRobot(DeleteRobotRequest.builder().applyMutation(deleteRobotRequest).build());
    }

    /**
     * <p>
     * Deletes a robot application.
     * </p>
     *
     * @param deleteRobotApplicationRequest
     * @return Result of the DeleteRobotApplication operation returned by the service.
     * @throws InvalidParameterException
     *         A parameter specified in a request is not valid, is unsupported, or cannot be used. The returned message
     *         provides an explanation of the error value.
     * @throws ThrottlingException
     *         AWS RoboMaker is temporarily unable to process the request. Try your call again.
     * @throws InternalServerException
     *         AWS RoboMaker experienced a service issue. Try your call again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RoboMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RoboMakerClient.DeleteRobotApplication
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/DeleteRobotApplication"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteRobotApplicationResponse deleteRobotApplication(DeleteRobotApplicationRequest deleteRobotApplicationRequest)
            throws InvalidParameterException, ThrottlingException, InternalServerException, AwsServiceException,
            SdkClientException, RoboMakerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a robot application.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteRobotApplicationRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteRobotApplicationRequest#builder()}
     * </p>
     *
     * @param deleteRobotApplicationRequest
     *        A {@link Consumer} that will call methods on {@link DeleteRobotApplicationRequest.Builder} to create a
     *        request.
     * @return Result of the DeleteRobotApplication operation returned by the service.
     * @throws InvalidParameterException
     *         A parameter specified in a request is not valid, is unsupported, or cannot be used. The returned message
     *         provides an explanation of the error value.
     * @throws ThrottlingException
     *         AWS RoboMaker is temporarily unable to process the request. Try your call again.
     * @throws InternalServerException
     *         AWS RoboMaker experienced a service issue. Try your call again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RoboMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RoboMakerClient.DeleteRobotApplication
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/DeleteRobotApplication"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteRobotApplicationResponse deleteRobotApplication(
            Consumer<DeleteRobotApplicationRequest.Builder> deleteRobotApplicationRequest) throws InvalidParameterException,
            ThrottlingException, InternalServerException, AwsServiceException, SdkClientException, RoboMakerException {
        return deleteRobotApplication(DeleteRobotApplicationRequest.builder().applyMutation(deleteRobotApplicationRequest)
                .build());
    }

    /**
     * <p>
     * Deletes a simulation application.
     * </p>
     *
     * @param deleteSimulationApplicationRequest
     * @return Result of the DeleteSimulationApplication operation returned by the service.
     * @throws InvalidParameterException
     *         A parameter specified in a request is not valid, is unsupported, or cannot be used. The returned message
     *         provides an explanation of the error value.
     * @throws ThrottlingException
     *         AWS RoboMaker is temporarily unable to process the request. Try your call again.
     * @throws InternalServerException
     *         AWS RoboMaker experienced a service issue. Try your call again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RoboMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RoboMakerClient.DeleteSimulationApplication
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/DeleteSimulationApplication"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteSimulationApplicationResponse deleteSimulationApplication(
            DeleteSimulationApplicationRequest deleteSimulationApplicationRequest) throws InvalidParameterException,
            ThrottlingException, InternalServerException, AwsServiceException, SdkClientException, RoboMakerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a simulation application.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteSimulationApplicationRequest.Builder}
     * avoiding the need to create one manually via {@link DeleteSimulationApplicationRequest#builder()}
     * </p>
     *
     * @param deleteSimulationApplicationRequest
     *        A {@link Consumer} that will call methods on {@link DeleteSimulationApplicationRequest.Builder} to create
     *        a request.
     * @return Result of the DeleteSimulationApplication operation returned by the service.
     * @throws InvalidParameterException
     *         A parameter specified in a request is not valid, is unsupported, or cannot be used. The returned message
     *         provides an explanation of the error value.
     * @throws ThrottlingException
     *         AWS RoboMaker is temporarily unable to process the request. Try your call again.
     * @throws InternalServerException
     *         AWS RoboMaker experienced a service issue. Try your call again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RoboMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RoboMakerClient.DeleteSimulationApplication
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/DeleteSimulationApplication"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteSimulationApplicationResponse deleteSimulationApplication(
            Consumer<DeleteSimulationApplicationRequest.Builder> deleteSimulationApplicationRequest)
            throws InvalidParameterException, ThrottlingException, InternalServerException, AwsServiceException,
            SdkClientException, RoboMakerException {
        return deleteSimulationApplication(DeleteSimulationApplicationRequest.builder()
                .applyMutation(deleteSimulationApplicationRequest).build());
    }

    /**
     * <p>
     * Deletes a world template.
     * </p>
     *
     * @param deleteWorldTemplateRequest
     * @return Result of the DeleteWorldTemplate operation returned by the service.
     * @throws InvalidParameterException
     *         A parameter specified in a request is not valid, is unsupported, or cannot be used. The returned message
     *         provides an explanation of the error value.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws ThrottlingException
     *         AWS RoboMaker is temporarily unable to process the request. Try your call again.
     * @throws InternalServerException
     *         AWS RoboMaker experienced a service issue. Try your call again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RoboMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RoboMakerClient.DeleteWorldTemplate
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/DeleteWorldTemplate" target="_top">AWS
     *      API Documentation</a>
     */
    default DeleteWorldTemplateResponse deleteWorldTemplate(DeleteWorldTemplateRequest deleteWorldTemplateRequest)
            throws InvalidParameterException, ResourceNotFoundException, ThrottlingException, InternalServerException,
            AwsServiceException, SdkClientException, RoboMakerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a world template.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteWorldTemplateRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteWorldTemplateRequest#builder()}
     * </p>
     *
     * @param deleteWorldTemplateRequest
     *        A {@link Consumer} that will call methods on {@link DeleteWorldTemplateRequest.Builder} to create a
     *        request.
     * @return Result of the DeleteWorldTemplate operation returned by the service.
     * @throws InvalidParameterException
     *         A parameter specified in a request is not valid, is unsupported, or cannot be used. The returned message
     *         provides an explanation of the error value.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws ThrottlingException
     *         AWS RoboMaker is temporarily unable to process the request. Try your call again.
     * @throws InternalServerException
     *         AWS RoboMaker experienced a service issue. Try your call again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RoboMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RoboMakerClient.DeleteWorldTemplate
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/DeleteWorldTemplate" target="_top">AWS
     *      API Documentation</a>
     */
    default DeleteWorldTemplateResponse deleteWorldTemplate(
            Consumer<DeleteWorldTemplateRequest.Builder> deleteWorldTemplateRequest) throws InvalidParameterException,
            ResourceNotFoundException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException,
            RoboMakerException {
        return deleteWorldTemplate(DeleteWorldTemplateRequest.builder().applyMutation(deleteWorldTemplateRequest).build());
    }

    /**
     * <p>
     * Deregisters a robot.
     * </p>
     *
     * @param deregisterRobotRequest
     * @return Result of the DeregisterRobot operation returned by the service.
     * @throws InvalidParameterException
     *         A parameter specified in a request is not valid, is unsupported, or cannot be used. The returned message
     *         provides an explanation of the error value.
     * @throws InternalServerException
     *         AWS RoboMaker experienced a service issue. Try your call again.
     * @throws ThrottlingException
     *         AWS RoboMaker is temporarily unable to process the request. Try your call again.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RoboMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RoboMakerClient.DeregisterRobot
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/DeregisterRobot" target="_top">AWS API
     *      Documentation</a>
     */
    default DeregisterRobotResponse deregisterRobot(DeregisterRobotRequest deregisterRobotRequest)
            throws InvalidParameterException, InternalServerException, ThrottlingException, ResourceNotFoundException,
            AwsServiceException, SdkClientException, RoboMakerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deregisters a robot.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeregisterRobotRequest.Builder} avoiding the need
     * to create one manually via {@link DeregisterRobotRequest#builder()}
     * </p>
     *
     * @param deregisterRobotRequest
     *        A {@link Consumer} that will call methods on {@link DeregisterRobotRequest.Builder} to create a request.
     * @return Result of the DeregisterRobot operation returned by the service.
     * @throws InvalidParameterException
     *         A parameter specified in a request is not valid, is unsupported, or cannot be used. The returned message
     *         provides an explanation of the error value.
     * @throws InternalServerException
     *         AWS RoboMaker experienced a service issue. Try your call again.
     * @throws ThrottlingException
     *         AWS RoboMaker is temporarily unable to process the request. Try your call again.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RoboMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RoboMakerClient.DeregisterRobot
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/DeregisterRobot" target="_top">AWS API
     *      Documentation</a>
     */
    default DeregisterRobotResponse deregisterRobot(Consumer<DeregisterRobotRequest.Builder> deregisterRobotRequest)
            throws InvalidParameterException, InternalServerException, ThrottlingException, ResourceNotFoundException,
            AwsServiceException, SdkClientException, RoboMakerException {
        return deregisterRobot(DeregisterRobotRequest.builder().applyMutation(deregisterRobotRequest).build());
    }

    /**
     * <p>
     * Describes a deployment job.
     * </p>
     *
     * @param describeDeploymentJobRequest
     * @return Result of the DescribeDeploymentJob operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws InvalidParameterException
     *         A parameter specified in a request is not valid, is unsupported, or cannot be used. The returned message
     *         provides an explanation of the error value.
     * @throws InternalServerException
     *         AWS RoboMaker experienced a service issue. Try your call again.
     * @throws ThrottlingException
     *         AWS RoboMaker is temporarily unable to process the request. Try your call again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RoboMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RoboMakerClient.DescribeDeploymentJob
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/DescribeDeploymentJob"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeDeploymentJobResponse describeDeploymentJob(DescribeDeploymentJobRequest describeDeploymentJobRequest)
            throws ResourceNotFoundException, InvalidParameterException, InternalServerException, ThrottlingException,
            AwsServiceException, SdkClientException, RoboMakerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes a deployment job.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeDeploymentJobRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeDeploymentJobRequest#builder()}
     * </p>
     *
     * @param describeDeploymentJobRequest
     *        A {@link Consumer} that will call methods on {@link DescribeDeploymentJobRequest.Builder} to create a
     *        request.
     * @return Result of the DescribeDeploymentJob operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws InvalidParameterException
     *         A parameter specified in a request is not valid, is unsupported, or cannot be used. The returned message
     *         provides an explanation of the error value.
     * @throws InternalServerException
     *         AWS RoboMaker experienced a service issue. Try your call again.
     * @throws ThrottlingException
     *         AWS RoboMaker is temporarily unable to process the request. Try your call again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RoboMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RoboMakerClient.DescribeDeploymentJob
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/DescribeDeploymentJob"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeDeploymentJobResponse describeDeploymentJob(
            Consumer<DescribeDeploymentJobRequest.Builder> describeDeploymentJobRequest) throws ResourceNotFoundException,
            InvalidParameterException, InternalServerException, ThrottlingException, AwsServiceException, SdkClientException,
            RoboMakerException {
        return describeDeploymentJob(DescribeDeploymentJobRequest.builder().applyMutation(describeDeploymentJobRequest).build());
    }

    /**
     * <p>
     * Describes a fleet.
     * </p>
     *
     * @param describeFleetRequest
     * @return Result of the DescribeFleet operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws InvalidParameterException
     *         A parameter specified in a request is not valid, is unsupported, or cannot be used. The returned message
     *         provides an explanation of the error value.
     * @throws InternalServerException
     *         AWS RoboMaker experienced a service issue. Try your call again.
     * @throws ThrottlingException
     *         AWS RoboMaker is temporarily unable to process the request. Try your call again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RoboMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RoboMakerClient.DescribeFleet
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/DescribeFleet" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeFleetResponse describeFleet(DescribeFleetRequest describeFleetRequest) throws ResourceNotFoundException,
            InvalidParameterException, InternalServerException, ThrottlingException, AwsServiceException, SdkClientException,
            RoboMakerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes a fleet.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeFleetRequest.Builder} avoiding the need to
     * create one manually via {@link DescribeFleetRequest#builder()}
     * </p>
     *
     * @param describeFleetRequest
     *        A {@link Consumer} that will call methods on {@link DescribeFleetRequest.Builder} to create a request.
     * @return Result of the DescribeFleet operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws InvalidParameterException
     *         A parameter specified in a request is not valid, is unsupported, or cannot be used. The returned message
     *         provides an explanation of the error value.
     * @throws InternalServerException
     *         AWS RoboMaker experienced a service issue. Try your call again.
     * @throws ThrottlingException
     *         AWS RoboMaker is temporarily unable to process the request. Try your call again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RoboMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RoboMakerClient.DescribeFleet
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/DescribeFleet" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeFleetResponse describeFleet(Consumer<DescribeFleetRequest.Builder> describeFleetRequest)
            throws ResourceNotFoundException, InvalidParameterException, InternalServerException, ThrottlingException,
            AwsServiceException, SdkClientException, RoboMakerException {
        return describeFleet(DescribeFleetRequest.builder().applyMutation(describeFleetRequest).build());
    }

    /**
     * <p>
     * Describes a robot.
     * </p>
     *
     * @param describeRobotRequest
     * @return Result of the DescribeRobot operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws InvalidParameterException
     *         A parameter specified in a request is not valid, is unsupported, or cannot be used. The returned message
     *         provides an explanation of the error value.
     * @throws InternalServerException
     *         AWS RoboMaker experienced a service issue. Try your call again.
     * @throws ThrottlingException
     *         AWS RoboMaker is temporarily unable to process the request. Try your call again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RoboMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RoboMakerClient.DescribeRobot
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/DescribeRobot" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeRobotResponse describeRobot(DescribeRobotRequest describeRobotRequest) throws ResourceNotFoundException,
            InvalidParameterException, InternalServerException, ThrottlingException, AwsServiceException, SdkClientException,
            RoboMakerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes a robot.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeRobotRequest.Builder} avoiding the need to
     * create one manually via {@link DescribeRobotRequest#builder()}
     * </p>
     *
     * @param describeRobotRequest
     *        A {@link Consumer} that will call methods on {@link DescribeRobotRequest.Builder} to create a request.
     * @return Result of the DescribeRobot operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws InvalidParameterException
     *         A parameter specified in a request is not valid, is unsupported, or cannot be used. The returned message
     *         provides an explanation of the error value.
     * @throws InternalServerException
     *         AWS RoboMaker experienced a service issue. Try your call again.
     * @throws ThrottlingException
     *         AWS RoboMaker is temporarily unable to process the request. Try your call again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RoboMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RoboMakerClient.DescribeRobot
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/DescribeRobot" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeRobotResponse describeRobot(Consumer<DescribeRobotRequest.Builder> describeRobotRequest)
            throws ResourceNotFoundException, InvalidParameterException, InternalServerException, ThrottlingException,
            AwsServiceException, SdkClientException, RoboMakerException {
        return describeRobot(DescribeRobotRequest.builder().applyMutation(describeRobotRequest).build());
    }

    /**
     * <p>
     * Describes a robot application.
     * </p>
     *
     * @param describeRobotApplicationRequest
     * @return Result of the DescribeRobotApplication operation returned by the service.
     * @throws InvalidParameterException
     *         A parameter specified in a request is not valid, is unsupported, or cannot be used. The returned message
     *         provides an explanation of the error value.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws ThrottlingException
     *         AWS RoboMaker is temporarily unable to process the request. Try your call again.
     * @throws InternalServerException
     *         AWS RoboMaker experienced a service issue. Try your call again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RoboMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RoboMakerClient.DescribeRobotApplication
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/DescribeRobotApplication"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeRobotApplicationResponse describeRobotApplication(
            DescribeRobotApplicationRequest describeRobotApplicationRequest) throws InvalidParameterException,
            ResourceNotFoundException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException,
            RoboMakerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes a robot application.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeRobotApplicationRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeRobotApplicationRequest#builder()}
     * </p>
     *
     * @param describeRobotApplicationRequest
     *        A {@link Consumer} that will call methods on {@link DescribeRobotApplicationRequest.Builder} to create a
     *        request.
     * @return Result of the DescribeRobotApplication operation returned by the service.
     * @throws InvalidParameterException
     *         A parameter specified in a request is not valid, is unsupported, or cannot be used. The returned message
     *         provides an explanation of the error value.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws ThrottlingException
     *         AWS RoboMaker is temporarily unable to process the request. Try your call again.
     * @throws InternalServerException
     *         AWS RoboMaker experienced a service issue. Try your call again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RoboMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RoboMakerClient.DescribeRobotApplication
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/DescribeRobotApplication"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeRobotApplicationResponse describeRobotApplication(
            Consumer<DescribeRobotApplicationRequest.Builder> describeRobotApplicationRequest) throws InvalidParameterException,
            ResourceNotFoundException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException,
            RoboMakerException {
        return describeRobotApplication(DescribeRobotApplicationRequest.builder().applyMutation(describeRobotApplicationRequest)
                .build());
    }

    /**
     * <p>
     * Describes a simulation application.
     * </p>
     *
     * @param describeSimulationApplicationRequest
     * @return Result of the DescribeSimulationApplication operation returned by the service.
     * @throws InvalidParameterException
     *         A parameter specified in a request is not valid, is unsupported, or cannot be used. The returned message
     *         provides an explanation of the error value.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws ThrottlingException
     *         AWS RoboMaker is temporarily unable to process the request. Try your call again.
     * @throws InternalServerException
     *         AWS RoboMaker experienced a service issue. Try your call again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RoboMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RoboMakerClient.DescribeSimulationApplication
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/DescribeSimulationApplication"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeSimulationApplicationResponse describeSimulationApplication(
            DescribeSimulationApplicationRequest describeSimulationApplicationRequest) throws InvalidParameterException,
            ResourceNotFoundException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException,
            RoboMakerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes a simulation application.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeSimulationApplicationRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeSimulationApplicationRequest#builder()}
     * </p>
     *
     * @param describeSimulationApplicationRequest
     *        A {@link Consumer} that will call methods on {@link DescribeSimulationApplicationRequest.Builder} to
     *        create a request.
     * @return Result of the DescribeSimulationApplication operation returned by the service.
     * @throws InvalidParameterException
     *         A parameter specified in a request is not valid, is unsupported, or cannot be used. The returned message
     *         provides an explanation of the error value.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws ThrottlingException
     *         AWS RoboMaker is temporarily unable to process the request. Try your call again.
     * @throws InternalServerException
     *         AWS RoboMaker experienced a service issue. Try your call again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RoboMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RoboMakerClient.DescribeSimulationApplication
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/DescribeSimulationApplication"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeSimulationApplicationResponse describeSimulationApplication(
            Consumer<DescribeSimulationApplicationRequest.Builder> describeSimulationApplicationRequest)
            throws InvalidParameterException, ResourceNotFoundException, ThrottlingException, InternalServerException,
            AwsServiceException, SdkClientException, RoboMakerException {
        return describeSimulationApplication(DescribeSimulationApplicationRequest.builder()
                .applyMutation(describeSimulationApplicationRequest).build());
    }

    /**
     * <p>
     * Describes a simulation job.
     * </p>
     *
     * @param describeSimulationJobRequest
     * @return Result of the DescribeSimulationJob operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws InvalidParameterException
     *         A parameter specified in a request is not valid, is unsupported, or cannot be used. The returned message
     *         provides an explanation of the error value.
     * @throws InternalServerException
     *         AWS RoboMaker experienced a service issue. Try your call again.
     * @throws ThrottlingException
     *         AWS RoboMaker is temporarily unable to process the request. Try your call again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RoboMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RoboMakerClient.DescribeSimulationJob
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/DescribeSimulationJob"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeSimulationJobResponse describeSimulationJob(DescribeSimulationJobRequest describeSimulationJobRequest)
            throws ResourceNotFoundException, InvalidParameterException, InternalServerException, ThrottlingException,
            AwsServiceException, SdkClientException, RoboMakerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes a simulation job.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeSimulationJobRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeSimulationJobRequest#builder()}
     * </p>
     *
     * @param describeSimulationJobRequest
     *        A {@link Consumer} that will call methods on {@link DescribeSimulationJobRequest.Builder} to create a
     *        request.
     * @return Result of the DescribeSimulationJob operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws InvalidParameterException
     *         A parameter specified in a request is not valid, is unsupported, or cannot be used. The returned message
     *         provides an explanation of the error value.
     * @throws InternalServerException
     *         AWS RoboMaker experienced a service issue. Try your call again.
     * @throws ThrottlingException
     *         AWS RoboMaker is temporarily unable to process the request. Try your call again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RoboMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RoboMakerClient.DescribeSimulationJob
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/DescribeSimulationJob"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeSimulationJobResponse describeSimulationJob(
            Consumer<DescribeSimulationJobRequest.Builder> describeSimulationJobRequest) throws ResourceNotFoundException,
            InvalidParameterException, InternalServerException, ThrottlingException, AwsServiceException, SdkClientException,
            RoboMakerException {
        return describeSimulationJob(DescribeSimulationJobRequest.builder().applyMutation(describeSimulationJobRequest).build());
    }

    /**
     * <p>
     * Describes a simulation job batch.
     * </p>
     *
     * @param describeSimulationJobBatchRequest
     * @return Result of the DescribeSimulationJobBatch operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws InvalidParameterException
     *         A parameter specified in a request is not valid, is unsupported, or cannot be used. The returned message
     *         provides an explanation of the error value.
     * @throws InternalServerException
     *         AWS RoboMaker experienced a service issue. Try your call again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RoboMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RoboMakerClient.DescribeSimulationJobBatch
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/DescribeSimulationJobBatch"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeSimulationJobBatchResponse describeSimulationJobBatch(
            DescribeSimulationJobBatchRequest describeSimulationJobBatchRequest) throws ResourceNotFoundException,
            InvalidParameterException, InternalServerException, AwsServiceException, SdkClientException, RoboMakerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes a simulation job batch.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeSimulationJobBatchRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeSimulationJobBatchRequest#builder()}
     * </p>
     *
     * @param describeSimulationJobBatchRequest
     *        A {@link Consumer} that will call methods on {@link DescribeSimulationJobBatchRequest.Builder} to create a
     *        request.
     * @return Result of the DescribeSimulationJobBatch operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws InvalidParameterException
     *         A parameter specified in a request is not valid, is unsupported, or cannot be used. The returned message
     *         provides an explanation of the error value.
     * @throws InternalServerException
     *         AWS RoboMaker experienced a service issue. Try your call again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RoboMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RoboMakerClient.DescribeSimulationJobBatch
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/DescribeSimulationJobBatch"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeSimulationJobBatchResponse describeSimulationJobBatch(
            Consumer<DescribeSimulationJobBatchRequest.Builder> describeSimulationJobBatchRequest)
            throws ResourceNotFoundException, InvalidParameterException, InternalServerException, AwsServiceException,
            SdkClientException, RoboMakerException {
        return describeSimulationJobBatch(DescribeSimulationJobBatchRequest.builder()
                .applyMutation(describeSimulationJobBatchRequest).build());
    }

    /**
     * <p>
     * Describes a world.
     * </p>
     *
     * @param describeWorldRequest
     * @return Result of the DescribeWorld operation returned by the service.
     * @throws InvalidParameterException
     *         A parameter specified in a request is not valid, is unsupported, or cannot be used. The returned message
     *         provides an explanation of the error value.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws ThrottlingException
     *         AWS RoboMaker is temporarily unable to process the request. Try your call again.
     * @throws InternalServerException
     *         AWS RoboMaker experienced a service issue. Try your call again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RoboMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RoboMakerClient.DescribeWorld
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/DescribeWorld" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeWorldResponse describeWorld(DescribeWorldRequest describeWorldRequest) throws InvalidParameterException,
            ResourceNotFoundException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException,
            RoboMakerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes a world.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeWorldRequest.Builder} avoiding the need to
     * create one manually via {@link DescribeWorldRequest#builder()}
     * </p>
     *
     * @param describeWorldRequest
     *        A {@link Consumer} that will call methods on {@link DescribeWorldRequest.Builder} to create a request.
     * @return Result of the DescribeWorld operation returned by the service.
     * @throws InvalidParameterException
     *         A parameter specified in a request is not valid, is unsupported, or cannot be used. The returned message
     *         provides an explanation of the error value.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws ThrottlingException
     *         AWS RoboMaker is temporarily unable to process the request. Try your call again.
     * @throws InternalServerException
     *         AWS RoboMaker experienced a service issue. Try your call again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RoboMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RoboMakerClient.DescribeWorld
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/DescribeWorld" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeWorldResponse describeWorld(Consumer<DescribeWorldRequest.Builder> describeWorldRequest)
            throws InvalidParameterException, ResourceNotFoundException, ThrottlingException, InternalServerException,
            AwsServiceException, SdkClientException, RoboMakerException {
        return describeWorld(DescribeWorldRequest.builder().applyMutation(describeWorldRequest).build());
    }

    /**
     * <p>
     * Describes a world export job.
     * </p>
     *
     * @param describeWorldExportJobRequest
     * @return Result of the DescribeWorldExportJob operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws InvalidParameterException
     *         A parameter specified in a request is not valid, is unsupported, or cannot be used. The returned message
     *         provides an explanation of the error value.
     * @throws InternalServerException
     *         AWS RoboMaker experienced a service issue. Try your call again.
     * @throws ThrottlingException
     *         AWS RoboMaker is temporarily unable to process the request. Try your call again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RoboMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RoboMakerClient.DescribeWorldExportJob
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/DescribeWorldExportJob"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeWorldExportJobResponse describeWorldExportJob(DescribeWorldExportJobRequest describeWorldExportJobRequest)
            throws ResourceNotFoundException, InvalidParameterException, InternalServerException, ThrottlingException,
            AwsServiceException, SdkClientException, RoboMakerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes a world export job.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeWorldExportJobRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeWorldExportJobRequest#builder()}
     * </p>
     *
     * @param describeWorldExportJobRequest
     *        A {@link Consumer} that will call methods on {@link DescribeWorldExportJobRequest.Builder} to create a
     *        request.
     * @return Result of the DescribeWorldExportJob operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws InvalidParameterException
     *         A parameter specified in a request is not valid, is unsupported, or cannot be used. The returned message
     *         provides an explanation of the error value.
     * @throws InternalServerException
     *         AWS RoboMaker experienced a service issue. Try your call again.
     * @throws ThrottlingException
     *         AWS RoboMaker is temporarily unable to process the request. Try your call again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RoboMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RoboMakerClient.DescribeWorldExportJob
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/DescribeWorldExportJob"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeWorldExportJobResponse describeWorldExportJob(
            Consumer<DescribeWorldExportJobRequest.Builder> describeWorldExportJobRequest) throws ResourceNotFoundException,
            InvalidParameterException, InternalServerException, ThrottlingException, AwsServiceException, SdkClientException,
            RoboMakerException {
        return describeWorldExportJob(DescribeWorldExportJobRequest.builder().applyMutation(describeWorldExportJobRequest)
                .build());
    }

    /**
     * <p>
     * Describes a world generation job.
     * </p>
     *
     * @param describeWorldGenerationJobRequest
     * @return Result of the DescribeWorldGenerationJob operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws InvalidParameterException
     *         A parameter specified in a request is not valid, is unsupported, or cannot be used. The returned message
     *         provides an explanation of the error value.
     * @throws InternalServerException
     *         AWS RoboMaker experienced a service issue. Try your call again.
     * @throws ThrottlingException
     *         AWS RoboMaker is temporarily unable to process the request. Try your call again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RoboMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RoboMakerClient.DescribeWorldGenerationJob
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/DescribeWorldGenerationJob"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeWorldGenerationJobResponse describeWorldGenerationJob(
            DescribeWorldGenerationJobRequest describeWorldGenerationJobRequest) throws ResourceNotFoundException,
            InvalidParameterException, InternalServerException, ThrottlingException, AwsServiceException, SdkClientException,
            RoboMakerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes a world generation job.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeWorldGenerationJobRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeWorldGenerationJobRequest#builder()}
     * </p>
     *
     * @param describeWorldGenerationJobRequest
     *        A {@link Consumer} that will call methods on {@link DescribeWorldGenerationJobRequest.Builder} to create a
     *        request.
     * @return Result of the DescribeWorldGenerationJob operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws InvalidParameterException
     *         A parameter specified in a request is not valid, is unsupported, or cannot be used. The returned message
     *         provides an explanation of the error value.
     * @throws InternalServerException
     *         AWS RoboMaker experienced a service issue. Try your call again.
     * @throws ThrottlingException
     *         AWS RoboMaker is temporarily unable to process the request. Try your call again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RoboMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RoboMakerClient.DescribeWorldGenerationJob
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/DescribeWorldGenerationJob"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeWorldGenerationJobResponse describeWorldGenerationJob(
            Consumer<DescribeWorldGenerationJobRequest.Builder> describeWorldGenerationJobRequest)
            throws ResourceNotFoundException, InvalidParameterException, InternalServerException, ThrottlingException,
            AwsServiceException, SdkClientException, RoboMakerException {
        return describeWorldGenerationJob(DescribeWorldGenerationJobRequest.builder()
                .applyMutation(describeWorldGenerationJobRequest).build());
    }

    /**
     * <p>
     * Describes a world template.
     * </p>
     *
     * @param describeWorldTemplateRequest
     * @return Result of the DescribeWorldTemplate operation returned by the service.
     * @throws InvalidParameterException
     *         A parameter specified in a request is not valid, is unsupported, or cannot be used. The returned message
     *         provides an explanation of the error value.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws ThrottlingException
     *         AWS RoboMaker is temporarily unable to process the request. Try your call again.
     * @throws InternalServerException
     *         AWS RoboMaker experienced a service issue. Try your call again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RoboMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RoboMakerClient.DescribeWorldTemplate
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/DescribeWorldTemplate"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeWorldTemplateResponse describeWorldTemplate(DescribeWorldTemplateRequest describeWorldTemplateRequest)
            throws InvalidParameterException, ResourceNotFoundException, ThrottlingException, InternalServerException,
            AwsServiceException, SdkClientException, RoboMakerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes a world template.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeWorldTemplateRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeWorldTemplateRequest#builder()}
     * </p>
     *
     * @param describeWorldTemplateRequest
     *        A {@link Consumer} that will call methods on {@link DescribeWorldTemplateRequest.Builder} to create a
     *        request.
     * @return Result of the DescribeWorldTemplate operation returned by the service.
     * @throws InvalidParameterException
     *         A parameter specified in a request is not valid, is unsupported, or cannot be used. The returned message
     *         provides an explanation of the error value.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws ThrottlingException
     *         AWS RoboMaker is temporarily unable to process the request. Try your call again.
     * @throws InternalServerException
     *         AWS RoboMaker experienced a service issue. Try your call again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RoboMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RoboMakerClient.DescribeWorldTemplate
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/DescribeWorldTemplate"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeWorldTemplateResponse describeWorldTemplate(
            Consumer<DescribeWorldTemplateRequest.Builder> describeWorldTemplateRequest) throws InvalidParameterException,
            ResourceNotFoundException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException,
            RoboMakerException {
        return describeWorldTemplate(DescribeWorldTemplateRequest.builder().applyMutation(describeWorldTemplateRequest).build());
    }

    /**
     * <p>
     * Gets the world template body.
     * </p>
     *
     * @param getWorldTemplateBodyRequest
     * @return Result of the GetWorldTemplateBody operation returned by the service.
     * @throws InvalidParameterException
     *         A parameter specified in a request is not valid, is unsupported, or cannot be used. The returned message
     *         provides an explanation of the error value.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws ThrottlingException
     *         AWS RoboMaker is temporarily unable to process the request. Try your call again.
     * @throws InternalServerException
     *         AWS RoboMaker experienced a service issue. Try your call again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RoboMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RoboMakerClient.GetWorldTemplateBody
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/GetWorldTemplateBody" target="_top">AWS
     *      API Documentation</a>
     */
    default GetWorldTemplateBodyResponse getWorldTemplateBody(GetWorldTemplateBodyRequest getWorldTemplateBodyRequest)
            throws InvalidParameterException, ResourceNotFoundException, ThrottlingException, InternalServerException,
            AwsServiceException, SdkClientException, RoboMakerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets the world template body.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetWorldTemplateBodyRequest.Builder} avoiding the
     * need to create one manually via {@link GetWorldTemplateBodyRequest#builder()}
     * </p>
     *
     * @param getWorldTemplateBodyRequest
     *        A {@link Consumer} that will call methods on {@link GetWorldTemplateBodyRequest.Builder} to create a
     *        request.
     * @return Result of the GetWorldTemplateBody operation returned by the service.
     * @throws InvalidParameterException
     *         A parameter specified in a request is not valid, is unsupported, or cannot be used. The returned message
     *         provides an explanation of the error value.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws ThrottlingException
     *         AWS RoboMaker is temporarily unable to process the request. Try your call again.
     * @throws InternalServerException
     *         AWS RoboMaker experienced a service issue. Try your call again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RoboMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RoboMakerClient.GetWorldTemplateBody
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/GetWorldTemplateBody" target="_top">AWS
     *      API Documentation</a>
     */
    default GetWorldTemplateBodyResponse getWorldTemplateBody(
            Consumer<GetWorldTemplateBodyRequest.Builder> getWorldTemplateBodyRequest) throws InvalidParameterException,
            ResourceNotFoundException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException,
            RoboMakerException {
        return getWorldTemplateBody(GetWorldTemplateBodyRequest.builder().applyMutation(getWorldTemplateBodyRequest).build());
    }

    /**
     * <p>
     * Returns a list of deployment jobs for a fleet. You can optionally provide filters to retrieve specific deployment
     * jobs.
     * </p>
     *
     * @return Result of the ListDeploymentJobs operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws InvalidParameterException
     *         A parameter specified in a request is not valid, is unsupported, or cannot be used. The returned message
     *         provides an explanation of the error value.
     * @throws InternalServerException
     *         AWS RoboMaker experienced a service issue. Try your call again.
     * @throws ThrottlingException
     *         AWS RoboMaker is temporarily unable to process the request. Try your call again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RoboMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RoboMakerClient.ListDeploymentJobs
     * @see #listDeploymentJobs(ListDeploymentJobsRequest)
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/ListDeploymentJobs" target="_top">AWS
     *      API Documentation</a>
     */
    default ListDeploymentJobsResponse listDeploymentJobs() throws ResourceNotFoundException, InvalidParameterException,
            InternalServerException, ThrottlingException, AwsServiceException, SdkClientException, RoboMakerException {
        return listDeploymentJobs(ListDeploymentJobsRequest.builder().build());
    }

    /**
     * <p>
     * Returns a list of deployment jobs for a fleet. You can optionally provide filters to retrieve specific deployment
     * jobs.
     * </p>
     *
     * @param listDeploymentJobsRequest
     * @return Result of the ListDeploymentJobs operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws InvalidParameterException
     *         A parameter specified in a request is not valid, is unsupported, or cannot be used. The returned message
     *         provides an explanation of the error value.
     * @throws InternalServerException
     *         AWS RoboMaker experienced a service issue. Try your call again.
     * @throws ThrottlingException
     *         AWS RoboMaker is temporarily unable to process the request. Try your call again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RoboMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RoboMakerClient.ListDeploymentJobs
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/ListDeploymentJobs" target="_top">AWS
     *      API Documentation</a>
     */
    default ListDeploymentJobsResponse listDeploymentJobs(ListDeploymentJobsRequest listDeploymentJobsRequest)
            throws ResourceNotFoundException, InvalidParameterException, InternalServerException, ThrottlingException,
            AwsServiceException, SdkClientException, RoboMakerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of deployment jobs for a fleet. You can optionally provide filters to retrieve specific deployment
     * jobs.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListDeploymentJobsRequest.Builder} avoiding the
     * need to create one manually via {@link ListDeploymentJobsRequest#builder()}
     * </p>
     *
     * @param listDeploymentJobsRequest
     *        A {@link Consumer} that will call methods on {@link ListDeploymentJobsRequest.Builder} to create a
     *        request.
     * @return Result of the ListDeploymentJobs operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws InvalidParameterException
     *         A parameter specified in a request is not valid, is unsupported, or cannot be used. The returned message
     *         provides an explanation of the error value.
     * @throws InternalServerException
     *         AWS RoboMaker experienced a service issue. Try your call again.
     * @throws ThrottlingException
     *         AWS RoboMaker is temporarily unable to process the request. Try your call again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RoboMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RoboMakerClient.ListDeploymentJobs
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/ListDeploymentJobs" target="_top">AWS
     *      API Documentation</a>
     */
    default ListDeploymentJobsResponse listDeploymentJobs(Consumer<ListDeploymentJobsRequest.Builder> listDeploymentJobsRequest)
            throws ResourceNotFoundException, InvalidParameterException, InternalServerException, ThrottlingException,
            AwsServiceException, SdkClientException, RoboMakerException {
        return listDeploymentJobs(ListDeploymentJobsRequest.builder().applyMutation(listDeploymentJobsRequest).build());
    }

    /**
     * <p>
     * Returns a list of deployment jobs for a fleet. You can optionally provide filters to retrieve specific deployment
     * jobs.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listDeploymentJobs(software.amazon.awssdk.services.robomaker.model.ListDeploymentJobsRequest)} operation.
     * The return type is a custom iterable that can be used to iterate through all the pages. SDK will internally
     * handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.robomaker.paginators.ListDeploymentJobsIterable responses = client.listDeploymentJobsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.robomaker.paginators.ListDeploymentJobsIterable responses = client
     *             .listDeploymentJobsPaginator(request);
     *     for (software.amazon.awssdk.services.robomaker.model.ListDeploymentJobsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.robomaker.paginators.ListDeploymentJobsIterable responses = client.listDeploymentJobsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listDeploymentJobs(software.amazon.awssdk.services.robomaker.model.ListDeploymentJobsRequest)}
     * operation.</b>
     * </p>
     *
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws InvalidParameterException
     *         A parameter specified in a request is not valid, is unsupported, or cannot be used. The returned message
     *         provides an explanation of the error value.
     * @throws InternalServerException
     *         AWS RoboMaker experienced a service issue. Try your call again.
     * @throws ThrottlingException
     *         AWS RoboMaker is temporarily unable to process the request. Try your call again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RoboMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RoboMakerClient.ListDeploymentJobs
     * @see #listDeploymentJobsPaginator(ListDeploymentJobsRequest)
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/ListDeploymentJobs" target="_top">AWS
     *      API Documentation</a>
     */
    default ListDeploymentJobsIterable listDeploymentJobsPaginator() throws ResourceNotFoundException, InvalidParameterException,
            InternalServerException, ThrottlingException, AwsServiceException, SdkClientException, RoboMakerException {
        return listDeploymentJobsPaginator(ListDeploymentJobsRequest.builder().build());
    }

    /**
     * <p>
     * Returns a list of deployment jobs for a fleet. You can optionally provide filters to retrieve specific deployment
     * jobs.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listDeploymentJobs(software.amazon.awssdk.services.robomaker.model.ListDeploymentJobsRequest)} operation.
     * The return type is a custom iterable that can be used to iterate through all the pages. SDK will internally
     * handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.robomaker.paginators.ListDeploymentJobsIterable responses = client.listDeploymentJobsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.robomaker.paginators.ListDeploymentJobsIterable responses = client
     *             .listDeploymentJobsPaginator(request);
     *     for (software.amazon.awssdk.services.robomaker.model.ListDeploymentJobsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.robomaker.paginators.ListDeploymentJobsIterable responses = client.listDeploymentJobsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listDeploymentJobs(software.amazon.awssdk.services.robomaker.model.ListDeploymentJobsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listDeploymentJobsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws InvalidParameterException
     *         A parameter specified in a request is not valid, is unsupported, or cannot be used. The returned message
     *         provides an explanation of the error value.
     * @throws InternalServerException
     *         AWS RoboMaker experienced a service issue. Try your call again.
     * @throws ThrottlingException
     *         AWS RoboMaker is temporarily unable to process the request. Try your call again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RoboMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RoboMakerClient.ListDeploymentJobs
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/ListDeploymentJobs" target="_top">AWS
     *      API Documentation</a>
     */
    default ListDeploymentJobsIterable listDeploymentJobsPaginator(ListDeploymentJobsRequest listDeploymentJobsRequest)
            throws ResourceNotFoundException, InvalidParameterException, InternalServerException, ThrottlingException,
            AwsServiceException, SdkClientException, RoboMakerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of deployment jobs for a fleet. You can optionally provide filters to retrieve specific deployment
     * jobs.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listDeploymentJobs(software.amazon.awssdk.services.robomaker.model.ListDeploymentJobsRequest)} operation.
     * The return type is a custom iterable that can be used to iterate through all the pages. SDK will internally
     * handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.robomaker.paginators.ListDeploymentJobsIterable responses = client.listDeploymentJobsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.robomaker.paginators.ListDeploymentJobsIterable responses = client
     *             .listDeploymentJobsPaginator(request);
     *     for (software.amazon.awssdk.services.robomaker.model.ListDeploymentJobsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.robomaker.paginators.ListDeploymentJobsIterable responses = client.listDeploymentJobsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listDeploymentJobs(software.amazon.awssdk.services.robomaker.model.ListDeploymentJobsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListDeploymentJobsRequest.Builder} avoiding the
     * need to create one manually via {@link ListDeploymentJobsRequest#builder()}
     * </p>
     *
     * @param listDeploymentJobsRequest
     *        A {@link Consumer} that will call methods on {@link ListDeploymentJobsRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws InvalidParameterException
     *         A parameter specified in a request is not valid, is unsupported, or cannot be used. The returned message
     *         provides an explanation of the error value.
     * @throws InternalServerException
     *         AWS RoboMaker experienced a service issue. Try your call again.
     * @throws ThrottlingException
     *         AWS RoboMaker is temporarily unable to process the request. Try your call again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RoboMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RoboMakerClient.ListDeploymentJobs
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/ListDeploymentJobs" target="_top">AWS
     *      API Documentation</a>
     */
    default ListDeploymentJobsIterable listDeploymentJobsPaginator(
            Consumer<ListDeploymentJobsRequest.Builder> listDeploymentJobsRequest) throws ResourceNotFoundException,
            InvalidParameterException, InternalServerException, ThrottlingException, AwsServiceException, SdkClientException,
            RoboMakerException {
        return listDeploymentJobsPaginator(ListDeploymentJobsRequest.builder().applyMutation(listDeploymentJobsRequest).build());
    }

    /**
     * <p>
     * Returns a list of fleets. You can optionally provide filters to retrieve specific fleets.
     * </p>
     *
     * @return Result of the ListFleets operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws InvalidParameterException
     *         A parameter specified in a request is not valid, is unsupported, or cannot be used. The returned message
     *         provides an explanation of the error value.
     * @throws InternalServerException
     *         AWS RoboMaker experienced a service issue. Try your call again.
     * @throws ThrottlingException
     *         AWS RoboMaker is temporarily unable to process the request. Try your call again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RoboMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RoboMakerClient.ListFleets
     * @see #listFleets(ListFleetsRequest)
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/ListFleets" target="_top">AWS API
     *      Documentation</a>
     */
    default ListFleetsResponse listFleets() throws ResourceNotFoundException, InvalidParameterException, InternalServerException,
            ThrottlingException, AwsServiceException, SdkClientException, RoboMakerException {
        return listFleets(ListFleetsRequest.builder().build());
    }

    /**
     * <p>
     * Returns a list of fleets. You can optionally provide filters to retrieve specific fleets.
     * </p>
     *
     * @param listFleetsRequest
     * @return Result of the ListFleets operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws InvalidParameterException
     *         A parameter specified in a request is not valid, is unsupported, or cannot be used. The returned message
     *         provides an explanation of the error value.
     * @throws InternalServerException
     *         AWS RoboMaker experienced a service issue. Try your call again.
     * @throws ThrottlingException
     *         AWS RoboMaker is temporarily unable to process the request. Try your call again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RoboMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RoboMakerClient.ListFleets
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/ListFleets" target="_top">AWS API
     *      Documentation</a>
     */
    default ListFleetsResponse listFleets(ListFleetsRequest listFleetsRequest) throws ResourceNotFoundException,
            InvalidParameterException, InternalServerException, ThrottlingException, AwsServiceException, SdkClientException,
            RoboMakerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of fleets. You can optionally provide filters to retrieve specific fleets.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListFleetsRequest.Builder} avoiding the need to
     * create one manually via {@link ListFleetsRequest#builder()}
     * </p>
     *
     * @param listFleetsRequest
     *        A {@link Consumer} that will call methods on {@link ListFleetsRequest.Builder} to create a request.
     * @return Result of the ListFleets operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws InvalidParameterException
     *         A parameter specified in a request is not valid, is unsupported, or cannot be used. The returned message
     *         provides an explanation of the error value.
     * @throws InternalServerException
     *         AWS RoboMaker experienced a service issue. Try your call again.
     * @throws ThrottlingException
     *         AWS RoboMaker is temporarily unable to process the request. Try your call again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RoboMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RoboMakerClient.ListFleets
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/ListFleets" target="_top">AWS API
     *      Documentation</a>
     */
    default ListFleetsResponse listFleets(Consumer<ListFleetsRequest.Builder> listFleetsRequest)
            throws ResourceNotFoundException, InvalidParameterException, InternalServerException, ThrottlingException,
            AwsServiceException, SdkClientException, RoboMakerException {
        return listFleets(ListFleetsRequest.builder().applyMutation(listFleetsRequest).build());
    }

    /**
     * <p>
     * Returns a list of fleets. You can optionally provide filters to retrieve specific fleets.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listFleets(software.amazon.awssdk.services.robomaker.model.ListFleetsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.robomaker.paginators.ListFleetsIterable responses = client.listFleetsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.robomaker.paginators.ListFleetsIterable responses = client.listFleetsPaginator(request);
     *     for (software.amazon.awssdk.services.robomaker.model.ListFleetsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.robomaker.paginators.ListFleetsIterable responses = client.listFleetsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listFleets(software.amazon.awssdk.services.robomaker.model.ListFleetsRequest)} operation.</b>
     * </p>
     *
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws InvalidParameterException
     *         A parameter specified in a request is not valid, is unsupported, or cannot be used. The returned message
     *         provides an explanation of the error value.
     * @throws InternalServerException
     *         AWS RoboMaker experienced a service issue. Try your call again.
     * @throws ThrottlingException
     *         AWS RoboMaker is temporarily unable to process the request. Try your call again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RoboMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RoboMakerClient.ListFleets
     * @see #listFleetsPaginator(ListFleetsRequest)
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/ListFleets" target="_top">AWS API
     *      Documentation</a>
     */
    default ListFleetsIterable listFleetsPaginator() throws ResourceNotFoundException, InvalidParameterException,
            InternalServerException, ThrottlingException, AwsServiceException, SdkClientException, RoboMakerException {
        return listFleetsPaginator(ListFleetsRequest.builder().build());
    }

    /**
     * <p>
     * Returns a list of fleets. You can optionally provide filters to retrieve specific fleets.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listFleets(software.amazon.awssdk.services.robomaker.model.ListFleetsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.robomaker.paginators.ListFleetsIterable responses = client.listFleetsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.robomaker.paginators.ListFleetsIterable responses = client.listFleetsPaginator(request);
     *     for (software.amazon.awssdk.services.robomaker.model.ListFleetsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.robomaker.paginators.ListFleetsIterable responses = client.listFleetsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listFleets(software.amazon.awssdk.services.robomaker.model.ListFleetsRequest)} operation.</b>
     * </p>
     *
     * @param listFleetsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws InvalidParameterException
     *         A parameter specified in a request is not valid, is unsupported, or cannot be used. The returned message
     *         provides an explanation of the error value.
     * @throws InternalServerException
     *         AWS RoboMaker experienced a service issue. Try your call again.
     * @throws ThrottlingException
     *         AWS RoboMaker is temporarily unable to process the request. Try your call again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RoboMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RoboMakerClient.ListFleets
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/ListFleets" target="_top">AWS API
     *      Documentation</a>
     */
    default ListFleetsIterable listFleetsPaginator(ListFleetsRequest listFleetsRequest) throws ResourceNotFoundException,
            InvalidParameterException, InternalServerException, ThrottlingException, AwsServiceException, SdkClientException,
            RoboMakerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of fleets. You can optionally provide filters to retrieve specific fleets.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listFleets(software.amazon.awssdk.services.robomaker.model.ListFleetsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.robomaker.paginators.ListFleetsIterable responses = client.listFleetsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.robomaker.paginators.ListFleetsIterable responses = client.listFleetsPaginator(request);
     *     for (software.amazon.awssdk.services.robomaker.model.ListFleetsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.robomaker.paginators.ListFleetsIterable responses = client.listFleetsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listFleets(software.amazon.awssdk.services.robomaker.model.ListFleetsRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListFleetsRequest.Builder} avoiding the need to
     * create one manually via {@link ListFleetsRequest#builder()}
     * </p>
     *
     * @param listFleetsRequest
     *        A {@link Consumer} that will call methods on {@link ListFleetsRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws InvalidParameterException
     *         A parameter specified in a request is not valid, is unsupported, or cannot be used. The returned message
     *         provides an explanation of the error value.
     * @throws InternalServerException
     *         AWS RoboMaker experienced a service issue. Try your call again.
     * @throws ThrottlingException
     *         AWS RoboMaker is temporarily unable to process the request. Try your call again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RoboMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RoboMakerClient.ListFleets
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/ListFleets" target="_top">AWS API
     *      Documentation</a>
     */
    default ListFleetsIterable listFleetsPaginator(Consumer<ListFleetsRequest.Builder> listFleetsRequest)
            throws ResourceNotFoundException, InvalidParameterException, InternalServerException, ThrottlingException,
            AwsServiceException, SdkClientException, RoboMakerException {
        return listFleetsPaginator(ListFleetsRequest.builder().applyMutation(listFleetsRequest).build());
    }

    /**
     * <p>
     * Returns a list of robot application. You can optionally provide filters to retrieve specific robot applications.
     * </p>
     *
     * @return Result of the ListRobotApplications operation returned by the service.
     * @throws InvalidParameterException
     *         A parameter specified in a request is not valid, is unsupported, or cannot be used. The returned message
     *         provides an explanation of the error value.
     * @throws ThrottlingException
     *         AWS RoboMaker is temporarily unable to process the request. Try your call again.
     * @throws InternalServerException
     *         AWS RoboMaker experienced a service issue. Try your call again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RoboMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RoboMakerClient.ListRobotApplications
     * @see #listRobotApplications(ListRobotApplicationsRequest)
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/ListRobotApplications"
     *      target="_top">AWS API Documentation</a>
     */
    default ListRobotApplicationsResponse listRobotApplications() throws InvalidParameterException, ThrottlingException,
            InternalServerException, AwsServiceException, SdkClientException, RoboMakerException {
        return listRobotApplications(ListRobotApplicationsRequest.builder().build());
    }

    /**
     * <p>
     * Returns a list of robot application. You can optionally provide filters to retrieve specific robot applications.
     * </p>
     *
     * @param listRobotApplicationsRequest
     * @return Result of the ListRobotApplications operation returned by the service.
     * @throws InvalidParameterException
     *         A parameter specified in a request is not valid, is unsupported, or cannot be used. The returned message
     *         provides an explanation of the error value.
     * @throws ThrottlingException
     *         AWS RoboMaker is temporarily unable to process the request. Try your call again.
     * @throws InternalServerException
     *         AWS RoboMaker experienced a service issue. Try your call again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RoboMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RoboMakerClient.ListRobotApplications
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/ListRobotApplications"
     *      target="_top">AWS API Documentation</a>
     */
    default ListRobotApplicationsResponse listRobotApplications(ListRobotApplicationsRequest listRobotApplicationsRequest)
            throws InvalidParameterException, ThrottlingException, InternalServerException, AwsServiceException,
            SdkClientException, RoboMakerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of robot application. You can optionally provide filters to retrieve specific robot applications.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListRobotApplicationsRequest.Builder} avoiding the
     * need to create one manually via {@link ListRobotApplicationsRequest#builder()}
     * </p>
     *
     * @param listRobotApplicationsRequest
     *        A {@link Consumer} that will call methods on {@link ListRobotApplicationsRequest.Builder} to create a
     *        request.
     * @return Result of the ListRobotApplications operation returned by the service.
     * @throws InvalidParameterException
     *         A parameter specified in a request is not valid, is unsupported, or cannot be used. The returned message
     *         provides an explanation of the error value.
     * @throws ThrottlingException
     *         AWS RoboMaker is temporarily unable to process the request. Try your call again.
     * @throws InternalServerException
     *         AWS RoboMaker experienced a service issue. Try your call again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RoboMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RoboMakerClient.ListRobotApplications
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/ListRobotApplications"
     *      target="_top">AWS API Documentation</a>
     */
    default ListRobotApplicationsResponse listRobotApplications(
            Consumer<ListRobotApplicationsRequest.Builder> listRobotApplicationsRequest) throws InvalidParameterException,
            ThrottlingException, InternalServerException, AwsServiceException, SdkClientException, RoboMakerException {
        return listRobotApplications(ListRobotApplicationsRequest.builder().applyMutation(listRobotApplicationsRequest).build());
    }

    /**
     * <p>
     * Returns a list of robot application. You can optionally provide filters to retrieve specific robot applications.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listRobotApplications(software.amazon.awssdk.services.robomaker.model.ListRobotApplicationsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.robomaker.paginators.ListRobotApplicationsIterable responses = client.listRobotApplicationsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.robomaker.paginators.ListRobotApplicationsIterable responses = client
     *             .listRobotApplicationsPaginator(request);
     *     for (software.amazon.awssdk.services.robomaker.model.ListRobotApplicationsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.robomaker.paginators.ListRobotApplicationsIterable responses = client.listRobotApplicationsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listRobotApplications(software.amazon.awssdk.services.robomaker.model.ListRobotApplicationsRequest)}
     * operation.</b>
     * </p>
     *
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidParameterException
     *         A parameter specified in a request is not valid, is unsupported, or cannot be used. The returned message
     *         provides an explanation of the error value.
     * @throws ThrottlingException
     *         AWS RoboMaker is temporarily unable to process the request. Try your call again.
     * @throws InternalServerException
     *         AWS RoboMaker experienced a service issue. Try your call again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RoboMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RoboMakerClient.ListRobotApplications
     * @see #listRobotApplicationsPaginator(ListRobotApplicationsRequest)
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/ListRobotApplications"
     *      target="_top">AWS API Documentation</a>
     */
    default ListRobotApplicationsIterable listRobotApplicationsPaginator() throws InvalidParameterException, ThrottlingException,
            InternalServerException, AwsServiceException, SdkClientException, RoboMakerException {
        return listRobotApplicationsPaginator(ListRobotApplicationsRequest.builder().build());
    }

    /**
     * <p>
     * Returns a list of robot application. You can optionally provide filters to retrieve specific robot applications.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listRobotApplications(software.amazon.awssdk.services.robomaker.model.ListRobotApplicationsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.robomaker.paginators.ListRobotApplicationsIterable responses = client.listRobotApplicationsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.robomaker.paginators.ListRobotApplicationsIterable responses = client
     *             .listRobotApplicationsPaginator(request);
     *     for (software.amazon.awssdk.services.robomaker.model.ListRobotApplicationsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.robomaker.paginators.ListRobotApplicationsIterable responses = client.listRobotApplicationsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listRobotApplications(software.amazon.awssdk.services.robomaker.model.ListRobotApplicationsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listRobotApplicationsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidParameterException
     *         A parameter specified in a request is not valid, is unsupported, or cannot be used. The returned message
     *         provides an explanation of the error value.
     * @throws ThrottlingException
     *         AWS RoboMaker is temporarily unable to process the request. Try your call again.
     * @throws InternalServerException
     *         AWS RoboMaker experienced a service issue. Try your call again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RoboMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RoboMakerClient.ListRobotApplications
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/ListRobotApplications"
     *      target="_top">AWS API Documentation</a>
     */
    default ListRobotApplicationsIterable listRobotApplicationsPaginator(ListRobotApplicationsRequest listRobotApplicationsRequest)
            throws InvalidParameterException, ThrottlingException, InternalServerException, AwsServiceException,
            SdkClientException, RoboMakerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of robot application. You can optionally provide filters to retrieve specific robot applications.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listRobotApplications(software.amazon.awssdk.services.robomaker.model.ListRobotApplicationsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.robomaker.paginators.ListRobotApplicationsIterable responses = client.listRobotApplicationsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.robomaker.paginators.ListRobotApplicationsIterable responses = client
     *             .listRobotApplicationsPaginator(request);
     *     for (software.amazon.awssdk.services.robomaker.model.ListRobotApplicationsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.robomaker.paginators.ListRobotApplicationsIterable responses = client.listRobotApplicationsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listRobotApplications(software.amazon.awssdk.services.robomaker.model.ListRobotApplicationsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListRobotApplicationsRequest.Builder} avoiding the
     * need to create one manually via {@link ListRobotApplicationsRequest#builder()}
     * </p>
     *
     * @param listRobotApplicationsRequest
     *        A {@link Consumer} that will call methods on {@link ListRobotApplicationsRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidParameterException
     *         A parameter specified in a request is not valid, is unsupported, or cannot be used. The returned message
     *         provides an explanation of the error value.
     * @throws ThrottlingException
     *         AWS RoboMaker is temporarily unable to process the request. Try your call again.
     * @throws InternalServerException
     *         AWS RoboMaker experienced a service issue. Try your call again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RoboMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RoboMakerClient.ListRobotApplications
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/ListRobotApplications"
     *      target="_top">AWS API Documentation</a>
     */
    default ListRobotApplicationsIterable listRobotApplicationsPaginator(
            Consumer<ListRobotApplicationsRequest.Builder> listRobotApplicationsRequest) throws InvalidParameterException,
            ThrottlingException, InternalServerException, AwsServiceException, SdkClientException, RoboMakerException {
        return listRobotApplicationsPaginator(ListRobotApplicationsRequest.builder().applyMutation(listRobotApplicationsRequest)
                .build());
    }

    /**
     * <p>
     * Returns a list of robots. You can optionally provide filters to retrieve specific robots.
     * </p>
     *
     * @return Result of the ListRobots operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws InvalidParameterException
     *         A parameter specified in a request is not valid, is unsupported, or cannot be used. The returned message
     *         provides an explanation of the error value.
     * @throws InternalServerException
     *         AWS RoboMaker experienced a service issue. Try your call again.
     * @throws ThrottlingException
     *         AWS RoboMaker is temporarily unable to process the request. Try your call again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RoboMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RoboMakerClient.ListRobots
     * @see #listRobots(ListRobotsRequest)
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/ListRobots" target="_top">AWS API
     *      Documentation</a>
     */
    default ListRobotsResponse listRobots() throws ResourceNotFoundException, InvalidParameterException, InternalServerException,
            ThrottlingException, AwsServiceException, SdkClientException, RoboMakerException {
        return listRobots(ListRobotsRequest.builder().build());
    }

    /**
     * <p>
     * Returns a list of robots. You can optionally provide filters to retrieve specific robots.
     * </p>
     *
     * @param listRobotsRequest
     * @return Result of the ListRobots operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws InvalidParameterException
     *         A parameter specified in a request is not valid, is unsupported, or cannot be used. The returned message
     *         provides an explanation of the error value.
     * @throws InternalServerException
     *         AWS RoboMaker experienced a service issue. Try your call again.
     * @throws ThrottlingException
     *         AWS RoboMaker is temporarily unable to process the request. Try your call again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RoboMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RoboMakerClient.ListRobots
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/ListRobots" target="_top">AWS API
     *      Documentation</a>
     */
    default ListRobotsResponse listRobots(ListRobotsRequest listRobotsRequest) throws ResourceNotFoundException,
            InvalidParameterException, InternalServerException, ThrottlingException, AwsServiceException, SdkClientException,
            RoboMakerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of robots. You can optionally provide filters to retrieve specific robots.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListRobotsRequest.Builder} avoiding the need to
     * create one manually via {@link ListRobotsRequest#builder()}
     * </p>
     *
     * @param listRobotsRequest
     *        A {@link Consumer} that will call methods on {@link ListRobotsRequest.Builder} to create a request.
     * @return Result of the ListRobots operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws InvalidParameterException
     *         A parameter specified in a request is not valid, is unsupported, or cannot be used. The returned message
     *         provides an explanation of the error value.
     * @throws InternalServerException
     *         AWS RoboMaker experienced a service issue. Try your call again.
     * @throws ThrottlingException
     *         AWS RoboMaker is temporarily unable to process the request. Try your call again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RoboMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RoboMakerClient.ListRobots
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/ListRobots" target="_top">AWS API
     *      Documentation</a>
     */
    default ListRobotsResponse listRobots(Consumer<ListRobotsRequest.Builder> listRobotsRequest)
            throws ResourceNotFoundException, InvalidParameterException, InternalServerException, ThrottlingException,
            AwsServiceException, SdkClientException, RoboMakerException {
        return listRobots(ListRobotsRequest.builder().applyMutation(listRobotsRequest).build());
    }

    /**
     * <p>
     * Returns a list of robots. You can optionally provide filters to retrieve specific robots.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listRobots(software.amazon.awssdk.services.robomaker.model.ListRobotsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.robomaker.paginators.ListRobotsIterable responses = client.listRobotsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.robomaker.paginators.ListRobotsIterable responses = client.listRobotsPaginator(request);
     *     for (software.amazon.awssdk.services.robomaker.model.ListRobotsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.robomaker.paginators.ListRobotsIterable responses = client.listRobotsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listRobots(software.amazon.awssdk.services.robomaker.model.ListRobotsRequest)} operation.</b>
     * </p>
     *
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws InvalidParameterException
     *         A parameter specified in a request is not valid, is unsupported, or cannot be used. The returned message
     *         provides an explanation of the error value.
     * @throws InternalServerException
     *         AWS RoboMaker experienced a service issue. Try your call again.
     * @throws ThrottlingException
     *         AWS RoboMaker is temporarily unable to process the request. Try your call again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RoboMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RoboMakerClient.ListRobots
     * @see #listRobotsPaginator(ListRobotsRequest)
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/ListRobots" target="_top">AWS API
     *      Documentation</a>
     */
    default ListRobotsIterable listRobotsPaginator() throws ResourceNotFoundException, InvalidParameterException,
            InternalServerException, ThrottlingException, AwsServiceException, SdkClientException, RoboMakerException {
        return listRobotsPaginator(ListRobotsRequest.builder().build());
    }

    /**
     * <p>
     * Returns a list of robots. You can optionally provide filters to retrieve specific robots.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listRobots(software.amazon.awssdk.services.robomaker.model.ListRobotsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.robomaker.paginators.ListRobotsIterable responses = client.listRobotsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.robomaker.paginators.ListRobotsIterable responses = client.listRobotsPaginator(request);
     *     for (software.amazon.awssdk.services.robomaker.model.ListRobotsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.robomaker.paginators.ListRobotsIterable responses = client.listRobotsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listRobots(software.amazon.awssdk.services.robomaker.model.ListRobotsRequest)} operation.</b>
     * </p>
     *
     * @param listRobotsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws InvalidParameterException
     *         A parameter specified in a request is not valid, is unsupported, or cannot be used. The returned message
     *         provides an explanation of the error value.
     * @throws InternalServerException
     *         AWS RoboMaker experienced a service issue. Try your call again.
     * @throws ThrottlingException
     *         AWS RoboMaker is temporarily unable to process the request. Try your call again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RoboMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RoboMakerClient.ListRobots
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/ListRobots" target="_top">AWS API
     *      Documentation</a>
     */
    default ListRobotsIterable listRobotsPaginator(ListRobotsRequest listRobotsRequest) throws ResourceNotFoundException,
            InvalidParameterException, InternalServerException, ThrottlingException, AwsServiceException, SdkClientException,
            RoboMakerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of robots. You can optionally provide filters to retrieve specific robots.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listRobots(software.amazon.awssdk.services.robomaker.model.ListRobotsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.robomaker.paginators.ListRobotsIterable responses = client.listRobotsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.robomaker.paginators.ListRobotsIterable responses = client.listRobotsPaginator(request);
     *     for (software.amazon.awssdk.services.robomaker.model.ListRobotsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.robomaker.paginators.ListRobotsIterable responses = client.listRobotsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listRobots(software.amazon.awssdk.services.robomaker.model.ListRobotsRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListRobotsRequest.Builder} avoiding the need to
     * create one manually via {@link ListRobotsRequest#builder()}
     * </p>
     *
     * @param listRobotsRequest
     *        A {@link Consumer} that will call methods on {@link ListRobotsRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws InvalidParameterException
     *         A parameter specified in a request is not valid, is unsupported, or cannot be used. The returned message
     *         provides an explanation of the error value.
     * @throws InternalServerException
     *         AWS RoboMaker experienced a service issue. Try your call again.
     * @throws ThrottlingException
     *         AWS RoboMaker is temporarily unable to process the request. Try your call again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RoboMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RoboMakerClient.ListRobots
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/ListRobots" target="_top">AWS API
     *      Documentation</a>
     */
    default ListRobotsIterable listRobotsPaginator(Consumer<ListRobotsRequest.Builder> listRobotsRequest)
            throws ResourceNotFoundException, InvalidParameterException, InternalServerException, ThrottlingException,
            AwsServiceException, SdkClientException, RoboMakerException {
        return listRobotsPaginator(ListRobotsRequest.builder().applyMutation(listRobotsRequest).build());
    }

    /**
     * <p>
     * Returns a list of simulation applications. You can optionally provide filters to retrieve specific simulation
     * applications.
     * </p>
     *
     * @return Result of the ListSimulationApplications operation returned by the service.
     * @throws InvalidParameterException
     *         A parameter specified in a request is not valid, is unsupported, or cannot be used. The returned message
     *         provides an explanation of the error value.
     * @throws ThrottlingException
     *         AWS RoboMaker is temporarily unable to process the request. Try your call again.
     * @throws InternalServerException
     *         AWS RoboMaker experienced a service issue. Try your call again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RoboMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RoboMakerClient.ListSimulationApplications
     * @see #listSimulationApplications(ListSimulationApplicationsRequest)
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/ListSimulationApplications"
     *      target="_top">AWS API Documentation</a>
     */
    default ListSimulationApplicationsResponse listSimulationApplications() throws InvalidParameterException,
            ThrottlingException, InternalServerException, AwsServiceException, SdkClientException, RoboMakerException {
        return listSimulationApplications(ListSimulationApplicationsRequest.builder().build());
    }

    /**
     * <p>
     * Returns a list of simulation applications. You can optionally provide filters to retrieve specific simulation
     * applications.
     * </p>
     *
     * @param listSimulationApplicationsRequest
     * @return Result of the ListSimulationApplications operation returned by the service.
     * @throws InvalidParameterException
     *         A parameter specified in a request is not valid, is unsupported, or cannot be used. The returned message
     *         provides an explanation of the error value.
     * @throws ThrottlingException
     *         AWS RoboMaker is temporarily unable to process the request. Try your call again.
     * @throws InternalServerException
     *         AWS RoboMaker experienced a service issue. Try your call again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RoboMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RoboMakerClient.ListSimulationApplications
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/ListSimulationApplications"
     *      target="_top">AWS API Documentation</a>
     */
    default ListSimulationApplicationsResponse listSimulationApplications(
            ListSimulationApplicationsRequest listSimulationApplicationsRequest) throws InvalidParameterException,
            ThrottlingException, InternalServerException, AwsServiceException, SdkClientException, RoboMakerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of simulation applications. You can optionally provide filters to retrieve specific simulation
     * applications.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListSimulationApplicationsRequest.Builder} avoiding
     * the need to create one manually via {@link ListSimulationApplicationsRequest#builder()}
     * </p>
     *
     * @param listSimulationApplicationsRequest
     *        A {@link Consumer} that will call methods on {@link ListSimulationApplicationsRequest.Builder} to create a
     *        request.
     * @return Result of the ListSimulationApplications operation returned by the service.
     * @throws InvalidParameterException
     *         A parameter specified in a request is not valid, is unsupported, or cannot be used. The returned message
     *         provides an explanation of the error value.
     * @throws ThrottlingException
     *         AWS RoboMaker is temporarily unable to process the request. Try your call again.
     * @throws InternalServerException
     *         AWS RoboMaker experienced a service issue. Try your call again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RoboMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RoboMakerClient.ListSimulationApplications
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/ListSimulationApplications"
     *      target="_top">AWS API Documentation</a>
     */
    default ListSimulationApplicationsResponse listSimulationApplications(
            Consumer<ListSimulationApplicationsRequest.Builder> listSimulationApplicationsRequest)
            throws InvalidParameterException, ThrottlingException, InternalServerException, AwsServiceException,
            SdkClientException, RoboMakerException {
        return listSimulationApplications(ListSimulationApplicationsRequest.builder()
                .applyMutation(listSimulationApplicationsRequest).build());
    }

    /**
     * <p>
     * Returns a list of simulation applications. You can optionally provide filters to retrieve specific simulation
     * applications.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listSimulationApplications(software.amazon.awssdk.services.robomaker.model.ListSimulationApplicationsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.robomaker.paginators.ListSimulationApplicationsIterable responses = client.listSimulationApplicationsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.robomaker.paginators.ListSimulationApplicationsIterable responses = client
     *             .listSimulationApplicationsPaginator(request);
     *     for (software.amazon.awssdk.services.robomaker.model.ListSimulationApplicationsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.robomaker.paginators.ListSimulationApplicationsIterable responses = client.listSimulationApplicationsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listSimulationApplications(software.amazon.awssdk.services.robomaker.model.ListSimulationApplicationsRequest)}
     * operation.</b>
     * </p>
     *
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidParameterException
     *         A parameter specified in a request is not valid, is unsupported, or cannot be used. The returned message
     *         provides an explanation of the error value.
     * @throws ThrottlingException
     *         AWS RoboMaker is temporarily unable to process the request. Try your call again.
     * @throws InternalServerException
     *         AWS RoboMaker experienced a service issue. Try your call again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RoboMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RoboMakerClient.ListSimulationApplications
     * @see #listSimulationApplicationsPaginator(ListSimulationApplicationsRequest)
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/ListSimulationApplications"
     *      target="_top">AWS API Documentation</a>
     */
    default ListSimulationApplicationsIterable listSimulationApplicationsPaginator() throws InvalidParameterException,
            ThrottlingException, InternalServerException, AwsServiceException, SdkClientException, RoboMakerException {
        return listSimulationApplicationsPaginator(ListSimulationApplicationsRequest.builder().build());
    }

    /**
     * <p>
     * Returns a list of simulation applications. You can optionally provide filters to retrieve specific simulation
     * applications.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listSimulationApplications(software.amazon.awssdk.services.robomaker.model.ListSimulationApplicationsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.robomaker.paginators.ListSimulationApplicationsIterable responses = client.listSimulationApplicationsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.robomaker.paginators.ListSimulationApplicationsIterable responses = client
     *             .listSimulationApplicationsPaginator(request);
     *     for (software.amazon.awssdk.services.robomaker.model.ListSimulationApplicationsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.robomaker.paginators.ListSimulationApplicationsIterable responses = client.listSimulationApplicationsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listSimulationApplications(software.amazon.awssdk.services.robomaker.model.ListSimulationApplicationsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listSimulationApplicationsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidParameterException
     *         A parameter specified in a request is not valid, is unsupported, or cannot be used. The returned message
     *         provides an explanation of the error value.
     * @throws ThrottlingException
     *         AWS RoboMaker is temporarily unable to process the request. Try your call again.
     * @throws InternalServerException
     *         AWS RoboMaker experienced a service issue. Try your call again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RoboMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RoboMakerClient.ListSimulationApplications
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/ListSimulationApplications"
     *      target="_top">AWS API Documentation</a>
     */
    default ListSimulationApplicationsIterable listSimulationApplicationsPaginator(
            ListSimulationApplicationsRequest listSimulationApplicationsRequest) throws InvalidParameterException,
            ThrottlingException, InternalServerException, AwsServiceException, SdkClientException, RoboMakerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of simulation applications. You can optionally provide filters to retrieve specific simulation
     * applications.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listSimulationApplications(software.amazon.awssdk.services.robomaker.model.ListSimulationApplicationsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.robomaker.paginators.ListSimulationApplicationsIterable responses = client.listSimulationApplicationsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.robomaker.paginators.ListSimulationApplicationsIterable responses = client
     *             .listSimulationApplicationsPaginator(request);
     *     for (software.amazon.awssdk.services.robomaker.model.ListSimulationApplicationsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.robomaker.paginators.ListSimulationApplicationsIterable responses = client.listSimulationApplicationsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listSimulationApplications(software.amazon.awssdk.services.robomaker.model.ListSimulationApplicationsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListSimulationApplicationsRequest.Builder} avoiding
     * the need to create one manually via {@link ListSimulationApplicationsRequest#builder()}
     * </p>
     *
     * @param listSimulationApplicationsRequest
     *        A {@link Consumer} that will call methods on {@link ListSimulationApplicationsRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidParameterException
     *         A parameter specified in a request is not valid, is unsupported, or cannot be used. The returned message
     *         provides an explanation of the error value.
     * @throws ThrottlingException
     *         AWS RoboMaker is temporarily unable to process the request. Try your call again.
     * @throws InternalServerException
     *         AWS RoboMaker experienced a service issue. Try your call again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RoboMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RoboMakerClient.ListSimulationApplications
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/ListSimulationApplications"
     *      target="_top">AWS API Documentation</a>
     */
    default ListSimulationApplicationsIterable listSimulationApplicationsPaginator(
            Consumer<ListSimulationApplicationsRequest.Builder> listSimulationApplicationsRequest)
            throws InvalidParameterException, ThrottlingException, InternalServerException, AwsServiceException,
            SdkClientException, RoboMakerException {
        return listSimulationApplicationsPaginator(ListSimulationApplicationsRequest.builder()
                .applyMutation(listSimulationApplicationsRequest).build());
    }

    /**
     * <p>
     * Returns a list simulation job batches. You can optionally provide filters to retrieve specific simulation batch
     * jobs.
     * </p>
     *
     * @param listSimulationJobBatchesRequest
     * @return Result of the ListSimulationJobBatches operation returned by the service.
     * @throws InvalidParameterException
     *         A parameter specified in a request is not valid, is unsupported, or cannot be used. The returned message
     *         provides an explanation of the error value.
     * @throws InternalServerException
     *         AWS RoboMaker experienced a service issue. Try your call again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RoboMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RoboMakerClient.ListSimulationJobBatches
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/ListSimulationJobBatches"
     *      target="_top">AWS API Documentation</a>
     */
    default ListSimulationJobBatchesResponse listSimulationJobBatches(
            ListSimulationJobBatchesRequest listSimulationJobBatchesRequest) throws InvalidParameterException,
            InternalServerException, AwsServiceException, SdkClientException, RoboMakerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list simulation job batches. You can optionally provide filters to retrieve specific simulation batch
     * jobs.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListSimulationJobBatchesRequest.Builder} avoiding
     * the need to create one manually via {@link ListSimulationJobBatchesRequest#builder()}
     * </p>
     *
     * @param listSimulationJobBatchesRequest
     *        A {@link Consumer} that will call methods on {@link ListSimulationJobBatchesRequest.Builder} to create a
     *        request.
     * @return Result of the ListSimulationJobBatches operation returned by the service.
     * @throws InvalidParameterException
     *         A parameter specified in a request is not valid, is unsupported, or cannot be used. The returned message
     *         provides an explanation of the error value.
     * @throws InternalServerException
     *         AWS RoboMaker experienced a service issue. Try your call again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RoboMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RoboMakerClient.ListSimulationJobBatches
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/ListSimulationJobBatches"
     *      target="_top">AWS API Documentation</a>
     */
    default ListSimulationJobBatchesResponse listSimulationJobBatches(
            Consumer<ListSimulationJobBatchesRequest.Builder> listSimulationJobBatchesRequest) throws InvalidParameterException,
            InternalServerException, AwsServiceException, SdkClientException, RoboMakerException {
        return listSimulationJobBatches(ListSimulationJobBatchesRequest.builder().applyMutation(listSimulationJobBatchesRequest)
                .build());
    }

    /**
     * <p>
     * Returns a list simulation job batches. You can optionally provide filters to retrieve specific simulation batch
     * jobs.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listSimulationJobBatches(software.amazon.awssdk.services.robomaker.model.ListSimulationJobBatchesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.robomaker.paginators.ListSimulationJobBatchesIterable responses = client.listSimulationJobBatchesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.robomaker.paginators.ListSimulationJobBatchesIterable responses = client
     *             .listSimulationJobBatchesPaginator(request);
     *     for (software.amazon.awssdk.services.robomaker.model.ListSimulationJobBatchesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.robomaker.paginators.ListSimulationJobBatchesIterable responses = client.listSimulationJobBatchesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listSimulationJobBatches(software.amazon.awssdk.services.robomaker.model.ListSimulationJobBatchesRequest)}
     * operation.</b>
     * </p>
     *
     * @param listSimulationJobBatchesRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidParameterException
     *         A parameter specified in a request is not valid, is unsupported, or cannot be used. The returned message
     *         provides an explanation of the error value.
     * @throws InternalServerException
     *         AWS RoboMaker experienced a service issue. Try your call again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RoboMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RoboMakerClient.ListSimulationJobBatches
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/ListSimulationJobBatches"
     *      target="_top">AWS API Documentation</a>
     */
    default ListSimulationJobBatchesIterable listSimulationJobBatchesPaginator(
            ListSimulationJobBatchesRequest listSimulationJobBatchesRequest) throws InvalidParameterException,
            InternalServerException, AwsServiceException, SdkClientException, RoboMakerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list simulation job batches. You can optionally provide filters to retrieve specific simulation batch
     * jobs.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listSimulationJobBatches(software.amazon.awssdk.services.robomaker.model.ListSimulationJobBatchesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.robomaker.paginators.ListSimulationJobBatchesIterable responses = client.listSimulationJobBatchesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.robomaker.paginators.ListSimulationJobBatchesIterable responses = client
     *             .listSimulationJobBatchesPaginator(request);
     *     for (software.amazon.awssdk.services.robomaker.model.ListSimulationJobBatchesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.robomaker.paginators.ListSimulationJobBatchesIterable responses = client.listSimulationJobBatchesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listSimulationJobBatches(software.amazon.awssdk.services.robomaker.model.ListSimulationJobBatchesRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListSimulationJobBatchesRequest.Builder} avoiding
     * the need to create one manually via {@link ListSimulationJobBatchesRequest#builder()}
     * </p>
     *
     * @param listSimulationJobBatchesRequest
     *        A {@link Consumer} that will call methods on {@link ListSimulationJobBatchesRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidParameterException
     *         A parameter specified in a request is not valid, is unsupported, or cannot be used. The returned message
     *         provides an explanation of the error value.
     * @throws InternalServerException
     *         AWS RoboMaker experienced a service issue. Try your call again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RoboMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RoboMakerClient.ListSimulationJobBatches
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/ListSimulationJobBatches"
     *      target="_top">AWS API Documentation</a>
     */
    default ListSimulationJobBatchesIterable listSimulationJobBatchesPaginator(
            Consumer<ListSimulationJobBatchesRequest.Builder> listSimulationJobBatchesRequest) throws InvalidParameterException,
            InternalServerException, AwsServiceException, SdkClientException, RoboMakerException {
        return listSimulationJobBatchesPaginator(ListSimulationJobBatchesRequest.builder()
                .applyMutation(listSimulationJobBatchesRequest).build());
    }

    /**
     * <p>
     * Returns a list of simulation jobs. You can optionally provide filters to retrieve specific simulation jobs.
     * </p>
     *
     * @return Result of the ListSimulationJobs operation returned by the service.
     * @throws InvalidParameterException
     *         A parameter specified in a request is not valid, is unsupported, or cannot be used. The returned message
     *         provides an explanation of the error value.
     * @throws InternalServerException
     *         AWS RoboMaker experienced a service issue. Try your call again.
     * @throws ThrottlingException
     *         AWS RoboMaker is temporarily unable to process the request. Try your call again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RoboMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RoboMakerClient.ListSimulationJobs
     * @see #listSimulationJobs(ListSimulationJobsRequest)
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/ListSimulationJobs" target="_top">AWS
     *      API Documentation</a>
     */
    default ListSimulationJobsResponse listSimulationJobs() throws InvalidParameterException, InternalServerException,
            ThrottlingException, AwsServiceException, SdkClientException, RoboMakerException {
        return listSimulationJobs(ListSimulationJobsRequest.builder().build());
    }

    /**
     * <p>
     * Returns a list of simulation jobs. You can optionally provide filters to retrieve specific simulation jobs.
     * </p>
     *
     * @param listSimulationJobsRequest
     * @return Result of the ListSimulationJobs operation returned by the service.
     * @throws InvalidParameterException
     *         A parameter specified in a request is not valid, is unsupported, or cannot be used. The returned message
     *         provides an explanation of the error value.
     * @throws InternalServerException
     *         AWS RoboMaker experienced a service issue. Try your call again.
     * @throws ThrottlingException
     *         AWS RoboMaker is temporarily unable to process the request. Try your call again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RoboMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RoboMakerClient.ListSimulationJobs
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/ListSimulationJobs" target="_top">AWS
     *      API Documentation</a>
     */
    default ListSimulationJobsResponse listSimulationJobs(ListSimulationJobsRequest listSimulationJobsRequest)
            throws InvalidParameterException, InternalServerException, ThrottlingException, AwsServiceException,
            SdkClientException, RoboMakerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of simulation jobs. You can optionally provide filters to retrieve specific simulation jobs.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListSimulationJobsRequest.Builder} avoiding the
     * need to create one manually via {@link ListSimulationJobsRequest#builder()}
     * </p>
     *
     * @param listSimulationJobsRequest
     *        A {@link Consumer} that will call methods on {@link ListSimulationJobsRequest.Builder} to create a
     *        request.
     * @return Result of the ListSimulationJobs operation returned by the service.
     * @throws InvalidParameterException
     *         A parameter specified in a request is not valid, is unsupported, or cannot be used. The returned message
     *         provides an explanation of the error value.
     * @throws InternalServerException
     *         AWS RoboMaker experienced a service issue. Try your call again.
     * @throws ThrottlingException
     *         AWS RoboMaker is temporarily unable to process the request. Try your call again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RoboMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RoboMakerClient.ListSimulationJobs
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/ListSimulationJobs" target="_top">AWS
     *      API Documentation</a>
     */
    default ListSimulationJobsResponse listSimulationJobs(Consumer<ListSimulationJobsRequest.Builder> listSimulationJobsRequest)
            throws InvalidParameterException, InternalServerException, ThrottlingException, AwsServiceException,
            SdkClientException, RoboMakerException {
        return listSimulationJobs(ListSimulationJobsRequest.builder().applyMutation(listSimulationJobsRequest).build());
    }

    /**
     * <p>
     * Returns a list of simulation jobs. You can optionally provide filters to retrieve specific simulation jobs.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listSimulationJobs(software.amazon.awssdk.services.robomaker.model.ListSimulationJobsRequest)} operation.
     * The return type is a custom iterable that can be used to iterate through all the pages. SDK will internally
     * handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.robomaker.paginators.ListSimulationJobsIterable responses = client.listSimulationJobsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.robomaker.paginators.ListSimulationJobsIterable responses = client
     *             .listSimulationJobsPaginator(request);
     *     for (software.amazon.awssdk.services.robomaker.model.ListSimulationJobsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.robomaker.paginators.ListSimulationJobsIterable responses = client.listSimulationJobsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listSimulationJobs(software.amazon.awssdk.services.robomaker.model.ListSimulationJobsRequest)}
     * operation.</b>
     * </p>
     *
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidParameterException
     *         A parameter specified in a request is not valid, is unsupported, or cannot be used. The returned message
     *         provides an explanation of the error value.
     * @throws InternalServerException
     *         AWS RoboMaker experienced a service issue. Try your call again.
     * @throws ThrottlingException
     *         AWS RoboMaker is temporarily unable to process the request. Try your call again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RoboMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RoboMakerClient.ListSimulationJobs
     * @see #listSimulationJobsPaginator(ListSimulationJobsRequest)
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/ListSimulationJobs" target="_top">AWS
     *      API Documentation</a>
     */
    default ListSimulationJobsIterable listSimulationJobsPaginator() throws InvalidParameterException, InternalServerException,
            ThrottlingException, AwsServiceException, SdkClientException, RoboMakerException {
        return listSimulationJobsPaginator(ListSimulationJobsRequest.builder().build());
    }

    /**
     * <p>
     * Returns a list of simulation jobs. You can optionally provide filters to retrieve specific simulation jobs.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listSimulationJobs(software.amazon.awssdk.services.robomaker.model.ListSimulationJobsRequest)} operation.
     * The return type is a custom iterable that can be used to iterate through all the pages. SDK will internally
     * handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.robomaker.paginators.ListSimulationJobsIterable responses = client.listSimulationJobsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.robomaker.paginators.ListSimulationJobsIterable responses = client
     *             .listSimulationJobsPaginator(request);
     *     for (software.amazon.awssdk.services.robomaker.model.ListSimulationJobsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.robomaker.paginators.ListSimulationJobsIterable responses = client.listSimulationJobsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listSimulationJobs(software.amazon.awssdk.services.robomaker.model.ListSimulationJobsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listSimulationJobsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidParameterException
     *         A parameter specified in a request is not valid, is unsupported, or cannot be used. The returned message
     *         provides an explanation of the error value.
     * @throws InternalServerException
     *         AWS RoboMaker experienced a service issue. Try your call again.
     * @throws ThrottlingException
     *         AWS RoboMaker is temporarily unable to process the request. Try your call again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RoboMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RoboMakerClient.ListSimulationJobs
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/ListSimulationJobs" target="_top">AWS
     *      API Documentation</a>
     */
    default ListSimulationJobsIterable listSimulationJobsPaginator(ListSimulationJobsRequest listSimulationJobsRequest)
            throws InvalidParameterException, InternalServerException, ThrottlingException, AwsServiceException,
            SdkClientException, RoboMakerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of simulation jobs. You can optionally provide filters to retrieve specific simulation jobs.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listSimulationJobs(software.amazon.awssdk.services.robomaker.model.ListSimulationJobsRequest)} operation.
     * The return type is a custom iterable that can be used to iterate through all the pages. SDK will internally
     * handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.robomaker.paginators.ListSimulationJobsIterable responses = client.listSimulationJobsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.robomaker.paginators.ListSimulationJobsIterable responses = client
     *             .listSimulationJobsPaginator(request);
     *     for (software.amazon.awssdk.services.robomaker.model.ListSimulationJobsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.robomaker.paginators.ListSimulationJobsIterable responses = client.listSimulationJobsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listSimulationJobs(software.amazon.awssdk.services.robomaker.model.ListSimulationJobsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListSimulationJobsRequest.Builder} avoiding the
     * need to create one manually via {@link ListSimulationJobsRequest#builder()}
     * </p>
     *
     * @param listSimulationJobsRequest
     *        A {@link Consumer} that will call methods on {@link ListSimulationJobsRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidParameterException
     *         A parameter specified in a request is not valid, is unsupported, or cannot be used. The returned message
     *         provides an explanation of the error value.
     * @throws InternalServerException
     *         AWS RoboMaker experienced a service issue. Try your call again.
     * @throws ThrottlingException
     *         AWS RoboMaker is temporarily unable to process the request. Try your call again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RoboMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RoboMakerClient.ListSimulationJobs
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/ListSimulationJobs" target="_top">AWS
     *      API Documentation</a>
     */
    default ListSimulationJobsIterable listSimulationJobsPaginator(
            Consumer<ListSimulationJobsRequest.Builder> listSimulationJobsRequest) throws InvalidParameterException,
            InternalServerException, ThrottlingException, AwsServiceException, SdkClientException, RoboMakerException {
        return listSimulationJobsPaginator(ListSimulationJobsRequest.builder().applyMutation(listSimulationJobsRequest).build());
    }

    /**
     * <p>
     * Lists all tags on a AWS RoboMaker resource.
     * </p>
     *
     * @param listTagsForResourceRequest
     * @return Result of the ListTagsForResource operation returned by the service.
     * @throws InternalServerException
     *         AWS RoboMaker experienced a service issue. Try your call again.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws InvalidParameterException
     *         A parameter specified in a request is not valid, is unsupported, or cannot be used. The returned message
     *         provides an explanation of the error value.
     * @throws ThrottlingException
     *         AWS RoboMaker is temporarily unable to process the request. Try your call again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RoboMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RoboMakerClient.ListTagsForResource
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/ListTagsForResource" target="_top">AWS
     *      API Documentation</a>
     */
    default ListTagsForResourceResponse listTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest)
            throws InternalServerException, ResourceNotFoundException, InvalidParameterException, ThrottlingException,
            AwsServiceException, SdkClientException, RoboMakerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all tags on a AWS RoboMaker resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTagsForResourceRequest.Builder} avoiding the
     * need to create one manually via {@link ListTagsForResourceRequest#builder()}
     * </p>
     *
     * @param listTagsForResourceRequest
     *        A {@link Consumer} that will call methods on {@link ListTagsForResourceRequest.Builder} to create a
     *        request.
     * @return Result of the ListTagsForResource operation returned by the service.
     * @throws InternalServerException
     *         AWS RoboMaker experienced a service issue. Try your call again.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws InvalidParameterException
     *         A parameter specified in a request is not valid, is unsupported, or cannot be used. The returned message
     *         provides an explanation of the error value.
     * @throws ThrottlingException
     *         AWS RoboMaker is temporarily unable to process the request. Try your call again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RoboMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RoboMakerClient.ListTagsForResource
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/ListTagsForResource" target="_top">AWS
     *      API Documentation</a>
     */
    default ListTagsForResourceResponse listTagsForResource(
            Consumer<ListTagsForResourceRequest.Builder> listTagsForResourceRequest) throws InternalServerException,
            ResourceNotFoundException, InvalidParameterException, ThrottlingException, AwsServiceException, SdkClientException,
            RoboMakerException {
        return listTagsForResource(ListTagsForResourceRequest.builder().applyMutation(listTagsForResourceRequest).build());
    }

    /**
     * <p>
     * Lists world export jobs.
     * </p>
     *
     * @param listWorldExportJobsRequest
     * @return Result of the ListWorldExportJobs operation returned by the service.
     * @throws InvalidParameterException
     *         A parameter specified in a request is not valid, is unsupported, or cannot be used. The returned message
     *         provides an explanation of the error value.
     * @throws InternalServerException
     *         AWS RoboMaker experienced a service issue. Try your call again.
     * @throws ThrottlingException
     *         AWS RoboMaker is temporarily unable to process the request. Try your call again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RoboMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RoboMakerClient.ListWorldExportJobs
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/ListWorldExportJobs" target="_top">AWS
     *      API Documentation</a>
     */
    default ListWorldExportJobsResponse listWorldExportJobs(ListWorldExportJobsRequest listWorldExportJobsRequest)
            throws InvalidParameterException, InternalServerException, ThrottlingException, AwsServiceException,
            SdkClientException, RoboMakerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists world export jobs.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListWorldExportJobsRequest.Builder} avoiding the
     * need to create one manually via {@link ListWorldExportJobsRequest#builder()}
     * </p>
     *
     * @param listWorldExportJobsRequest
     *        A {@link Consumer} that will call methods on {@link ListWorldExportJobsRequest.Builder} to create a
     *        request.
     * @return Result of the ListWorldExportJobs operation returned by the service.
     * @throws InvalidParameterException
     *         A parameter specified in a request is not valid, is unsupported, or cannot be used. The returned message
     *         provides an explanation of the error value.
     * @throws InternalServerException
     *         AWS RoboMaker experienced a service issue. Try your call again.
     * @throws ThrottlingException
     *         AWS RoboMaker is temporarily unable to process the request. Try your call again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RoboMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RoboMakerClient.ListWorldExportJobs
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/ListWorldExportJobs" target="_top">AWS
     *      API Documentation</a>
     */
    default ListWorldExportJobsResponse listWorldExportJobs(
            Consumer<ListWorldExportJobsRequest.Builder> listWorldExportJobsRequest) throws InvalidParameterException,
            InternalServerException, ThrottlingException, AwsServiceException, SdkClientException, RoboMakerException {
        return listWorldExportJobs(ListWorldExportJobsRequest.builder().applyMutation(listWorldExportJobsRequest).build());
    }

    /**
     * <p>
     * Lists world export jobs.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listWorldExportJobs(software.amazon.awssdk.services.robomaker.model.ListWorldExportJobsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.robomaker.paginators.ListWorldExportJobsIterable responses = client.listWorldExportJobsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.robomaker.paginators.ListWorldExportJobsIterable responses = client
     *             .listWorldExportJobsPaginator(request);
     *     for (software.amazon.awssdk.services.robomaker.model.ListWorldExportJobsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.robomaker.paginators.ListWorldExportJobsIterable responses = client.listWorldExportJobsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listWorldExportJobs(software.amazon.awssdk.services.robomaker.model.ListWorldExportJobsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listWorldExportJobsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidParameterException
     *         A parameter specified in a request is not valid, is unsupported, or cannot be used. The returned message
     *         provides an explanation of the error value.
     * @throws InternalServerException
     *         AWS RoboMaker experienced a service issue. Try your call again.
     * @throws ThrottlingException
     *         AWS RoboMaker is temporarily unable to process the request. Try your call again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RoboMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RoboMakerClient.ListWorldExportJobs
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/ListWorldExportJobs" target="_top">AWS
     *      API Documentation</a>
     */
    default ListWorldExportJobsIterable listWorldExportJobsPaginator(ListWorldExportJobsRequest listWorldExportJobsRequest)
            throws InvalidParameterException, InternalServerException, ThrottlingException, AwsServiceException,
            SdkClientException, RoboMakerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists world export jobs.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listWorldExportJobs(software.amazon.awssdk.services.robomaker.model.ListWorldExportJobsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.robomaker.paginators.ListWorldExportJobsIterable responses = client.listWorldExportJobsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.robomaker.paginators.ListWorldExportJobsIterable responses = client
     *             .listWorldExportJobsPaginator(request);
     *     for (software.amazon.awssdk.services.robomaker.model.ListWorldExportJobsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.robomaker.paginators.ListWorldExportJobsIterable responses = client.listWorldExportJobsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listWorldExportJobs(software.amazon.awssdk.services.robomaker.model.ListWorldExportJobsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListWorldExportJobsRequest.Builder} avoiding the
     * need to create one manually via {@link ListWorldExportJobsRequest#builder()}
     * </p>
     *
     * @param listWorldExportJobsRequest
     *        A {@link Consumer} that will call methods on {@link ListWorldExportJobsRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidParameterException
     *         A parameter specified in a request is not valid, is unsupported, or cannot be used. The returned message
     *         provides an explanation of the error value.
     * @throws InternalServerException
     *         AWS RoboMaker experienced a service issue. Try your call again.
     * @throws ThrottlingException
     *         AWS RoboMaker is temporarily unable to process the request. Try your call again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RoboMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RoboMakerClient.ListWorldExportJobs
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/ListWorldExportJobs" target="_top">AWS
     *      API Documentation</a>
     */
    default ListWorldExportJobsIterable listWorldExportJobsPaginator(
            Consumer<ListWorldExportJobsRequest.Builder> listWorldExportJobsRequest) throws InvalidParameterException,
            InternalServerException, ThrottlingException, AwsServiceException, SdkClientException, RoboMakerException {
        return listWorldExportJobsPaginator(ListWorldExportJobsRequest.builder().applyMutation(listWorldExportJobsRequest)
                .build());
    }

    /**
     * <p>
     * Lists world generator jobs.
     * </p>
     *
     * @param listWorldGenerationJobsRequest
     * @return Result of the ListWorldGenerationJobs operation returned by the service.
     * @throws InvalidParameterException
     *         A parameter specified in a request is not valid, is unsupported, or cannot be used. The returned message
     *         provides an explanation of the error value.
     * @throws InternalServerException
     *         AWS RoboMaker experienced a service issue. Try your call again.
     * @throws ThrottlingException
     *         AWS RoboMaker is temporarily unable to process the request. Try your call again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RoboMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RoboMakerClient.ListWorldGenerationJobs
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/ListWorldGenerationJobs"
     *      target="_top">AWS API Documentation</a>
     */
    default ListWorldGenerationJobsResponse listWorldGenerationJobs(ListWorldGenerationJobsRequest listWorldGenerationJobsRequest)
            throws InvalidParameterException, InternalServerException, ThrottlingException, AwsServiceException,
            SdkClientException, RoboMakerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists world generator jobs.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListWorldGenerationJobsRequest.Builder} avoiding
     * the need to create one manually via {@link ListWorldGenerationJobsRequest#builder()}
     * </p>
     *
     * @param listWorldGenerationJobsRequest
     *        A {@link Consumer} that will call methods on {@link ListWorldGenerationJobsRequest.Builder} to create a
     *        request.
     * @return Result of the ListWorldGenerationJobs operation returned by the service.
     * @throws InvalidParameterException
     *         A parameter specified in a request is not valid, is unsupported, or cannot be used. The returned message
     *         provides an explanation of the error value.
     * @throws InternalServerException
     *         AWS RoboMaker experienced a service issue. Try your call again.
     * @throws ThrottlingException
     *         AWS RoboMaker is temporarily unable to process the request. Try your call again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RoboMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RoboMakerClient.ListWorldGenerationJobs
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/ListWorldGenerationJobs"
     *      target="_top">AWS API Documentation</a>
     */
    default ListWorldGenerationJobsResponse listWorldGenerationJobs(
            Consumer<ListWorldGenerationJobsRequest.Builder> listWorldGenerationJobsRequest) throws InvalidParameterException,
            InternalServerException, ThrottlingException, AwsServiceException, SdkClientException, RoboMakerException {
        return listWorldGenerationJobs(ListWorldGenerationJobsRequest.builder().applyMutation(listWorldGenerationJobsRequest)
                .build());
    }

    /**
     * <p>
     * Lists world generator jobs.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listWorldGenerationJobs(software.amazon.awssdk.services.robomaker.model.ListWorldGenerationJobsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.robomaker.paginators.ListWorldGenerationJobsIterable responses = client.listWorldGenerationJobsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.robomaker.paginators.ListWorldGenerationJobsIterable responses = client
     *             .listWorldGenerationJobsPaginator(request);
     *     for (software.amazon.awssdk.services.robomaker.model.ListWorldGenerationJobsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.robomaker.paginators.ListWorldGenerationJobsIterable responses = client.listWorldGenerationJobsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listWorldGenerationJobs(software.amazon.awssdk.services.robomaker.model.ListWorldGenerationJobsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listWorldGenerationJobsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidParameterException
     *         A parameter specified in a request is not valid, is unsupported, or cannot be used. The returned message
     *         provides an explanation of the error value.
     * @throws InternalServerException
     *         AWS RoboMaker experienced a service issue. Try your call again.
     * @throws ThrottlingException
     *         AWS RoboMaker is temporarily unable to process the request. Try your call again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RoboMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RoboMakerClient.ListWorldGenerationJobs
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/ListWorldGenerationJobs"
     *      target="_top">AWS API Documentation</a>
     */
    default ListWorldGenerationJobsIterable listWorldGenerationJobsPaginator(
            ListWorldGenerationJobsRequest listWorldGenerationJobsRequest) throws InvalidParameterException,
            InternalServerException, ThrottlingException, AwsServiceException, SdkClientException, RoboMakerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists world generator jobs.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listWorldGenerationJobs(software.amazon.awssdk.services.robomaker.model.ListWorldGenerationJobsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.robomaker.paginators.ListWorldGenerationJobsIterable responses = client.listWorldGenerationJobsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.robomaker.paginators.ListWorldGenerationJobsIterable responses = client
     *             .listWorldGenerationJobsPaginator(request);
     *     for (software.amazon.awssdk.services.robomaker.model.ListWorldGenerationJobsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.robomaker.paginators.ListWorldGenerationJobsIterable responses = client.listWorldGenerationJobsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listWorldGenerationJobs(software.amazon.awssdk.services.robomaker.model.ListWorldGenerationJobsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListWorldGenerationJobsRequest.Builder} avoiding
     * the need to create one manually via {@link ListWorldGenerationJobsRequest#builder()}
     * </p>
     *
     * @param listWorldGenerationJobsRequest
     *        A {@link Consumer} that will call methods on {@link ListWorldGenerationJobsRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidParameterException
     *         A parameter specified in a request is not valid, is unsupported, or cannot be used. The returned message
     *         provides an explanation of the error value.
     * @throws InternalServerException
     *         AWS RoboMaker experienced a service issue. Try your call again.
     * @throws ThrottlingException
     *         AWS RoboMaker is temporarily unable to process the request. Try your call again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RoboMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RoboMakerClient.ListWorldGenerationJobs
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/ListWorldGenerationJobs"
     *      target="_top">AWS API Documentation</a>
     */
    default ListWorldGenerationJobsIterable listWorldGenerationJobsPaginator(
            Consumer<ListWorldGenerationJobsRequest.Builder> listWorldGenerationJobsRequest) throws InvalidParameterException,
            InternalServerException, ThrottlingException, AwsServiceException, SdkClientException, RoboMakerException {
        return listWorldGenerationJobsPaginator(ListWorldGenerationJobsRequest.builder()
                .applyMutation(listWorldGenerationJobsRequest).build());
    }

    /**
     * <p>
     * Lists world templates.
     * </p>
     *
     * @param listWorldTemplatesRequest
     * @return Result of the ListWorldTemplates operation returned by the service.
     * @throws InvalidParameterException
     *         A parameter specified in a request is not valid, is unsupported, or cannot be used. The returned message
     *         provides an explanation of the error value.
     * @throws ThrottlingException
     *         AWS RoboMaker is temporarily unable to process the request. Try your call again.
     * @throws InternalServerException
     *         AWS RoboMaker experienced a service issue. Try your call again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RoboMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RoboMakerClient.ListWorldTemplates
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/ListWorldTemplates" target="_top">AWS
     *      API Documentation</a>
     */
    default ListWorldTemplatesResponse listWorldTemplates(ListWorldTemplatesRequest listWorldTemplatesRequest)
            throws InvalidParameterException, ThrottlingException, InternalServerException, AwsServiceException,
            SdkClientException, RoboMakerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists world templates.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListWorldTemplatesRequest.Builder} avoiding the
     * need to create one manually via {@link ListWorldTemplatesRequest#builder()}
     * </p>
     *
     * @param listWorldTemplatesRequest
     *        A {@link Consumer} that will call methods on {@link ListWorldTemplatesRequest.Builder} to create a
     *        request.
     * @return Result of the ListWorldTemplates operation returned by the service.
     * @throws InvalidParameterException
     *         A parameter specified in a request is not valid, is unsupported, or cannot be used. The returned message
     *         provides an explanation of the error value.
     * @throws ThrottlingException
     *         AWS RoboMaker is temporarily unable to process the request. Try your call again.
     * @throws InternalServerException
     *         AWS RoboMaker experienced a service issue. Try your call again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RoboMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RoboMakerClient.ListWorldTemplates
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/ListWorldTemplates" target="_top">AWS
     *      API Documentation</a>
     */
    default ListWorldTemplatesResponse listWorldTemplates(Consumer<ListWorldTemplatesRequest.Builder> listWorldTemplatesRequest)
            throws InvalidParameterException, ThrottlingException, InternalServerException, AwsServiceException,
            SdkClientException, RoboMakerException {
        return listWorldTemplates(ListWorldTemplatesRequest.builder().applyMutation(listWorldTemplatesRequest).build());
    }

    /**
     * <p>
     * Lists world templates.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listWorldTemplates(software.amazon.awssdk.services.robomaker.model.ListWorldTemplatesRequest)} operation.
     * The return type is a custom iterable that can be used to iterate through all the pages. SDK will internally
     * handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.robomaker.paginators.ListWorldTemplatesIterable responses = client.listWorldTemplatesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.robomaker.paginators.ListWorldTemplatesIterable responses = client
     *             .listWorldTemplatesPaginator(request);
     *     for (software.amazon.awssdk.services.robomaker.model.ListWorldTemplatesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.robomaker.paginators.ListWorldTemplatesIterable responses = client.listWorldTemplatesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listWorldTemplates(software.amazon.awssdk.services.robomaker.model.ListWorldTemplatesRequest)}
     * operation.</b>
     * </p>
     *
     * @param listWorldTemplatesRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidParameterException
     *         A parameter specified in a request is not valid, is unsupported, or cannot be used. The returned message
     *         provides an explanation of the error value.
     * @throws ThrottlingException
     *         AWS RoboMaker is temporarily unable to process the request. Try your call again.
     * @throws InternalServerException
     *         AWS RoboMaker experienced a service issue. Try your call again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RoboMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RoboMakerClient.ListWorldTemplates
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/ListWorldTemplates" target="_top">AWS
     *      API Documentation</a>
     */
    default ListWorldTemplatesIterable listWorldTemplatesPaginator(ListWorldTemplatesRequest listWorldTemplatesRequest)
            throws InvalidParameterException, ThrottlingException, InternalServerException, AwsServiceException,
            SdkClientException, RoboMakerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists world templates.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listWorldTemplates(software.amazon.awssdk.services.robomaker.model.ListWorldTemplatesRequest)} operation.
     * The return type is a custom iterable that can be used to iterate through all the pages. SDK will internally
     * handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.robomaker.paginators.ListWorldTemplatesIterable responses = client.listWorldTemplatesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.robomaker.paginators.ListWorldTemplatesIterable responses = client
     *             .listWorldTemplatesPaginator(request);
     *     for (software.amazon.awssdk.services.robomaker.model.ListWorldTemplatesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.robomaker.paginators.ListWorldTemplatesIterable responses = client.listWorldTemplatesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listWorldTemplates(software.amazon.awssdk.services.robomaker.model.ListWorldTemplatesRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListWorldTemplatesRequest.Builder} avoiding the
     * need to create one manually via {@link ListWorldTemplatesRequest#builder()}
     * </p>
     *
     * @param listWorldTemplatesRequest
     *        A {@link Consumer} that will call methods on {@link ListWorldTemplatesRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidParameterException
     *         A parameter specified in a request is not valid, is unsupported, or cannot be used. The returned message
     *         provides an explanation of the error value.
     * @throws ThrottlingException
     *         AWS RoboMaker is temporarily unable to process the request. Try your call again.
     * @throws InternalServerException
     *         AWS RoboMaker experienced a service issue. Try your call again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RoboMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RoboMakerClient.ListWorldTemplates
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/ListWorldTemplates" target="_top">AWS
     *      API Documentation</a>
     */
    default ListWorldTemplatesIterable listWorldTemplatesPaginator(
            Consumer<ListWorldTemplatesRequest.Builder> listWorldTemplatesRequest) throws InvalidParameterException,
            ThrottlingException, InternalServerException, AwsServiceException, SdkClientException, RoboMakerException {
        return listWorldTemplatesPaginator(ListWorldTemplatesRequest.builder().applyMutation(listWorldTemplatesRequest).build());
    }

    /**
     * <p>
     * Lists worlds.
     * </p>
     *
     * @param listWorldsRequest
     * @return Result of the ListWorlds operation returned by the service.
     * @throws InvalidParameterException
     *         A parameter specified in a request is not valid, is unsupported, or cannot be used. The returned message
     *         provides an explanation of the error value.
     * @throws ThrottlingException
     *         AWS RoboMaker is temporarily unable to process the request. Try your call again.
     * @throws InternalServerException
     *         AWS RoboMaker experienced a service issue. Try your call again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RoboMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RoboMakerClient.ListWorlds
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/ListWorlds" target="_top">AWS API
     *      Documentation</a>
     */
    default ListWorldsResponse listWorlds(ListWorldsRequest listWorldsRequest) throws InvalidParameterException,
            ThrottlingException, InternalServerException, AwsServiceException, SdkClientException, RoboMakerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists worlds.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListWorldsRequest.Builder} avoiding the need to
     * create one manually via {@link ListWorldsRequest#builder()}
     * </p>
     *
     * @param listWorldsRequest
     *        A {@link Consumer} that will call methods on {@link ListWorldsRequest.Builder} to create a request.
     * @return Result of the ListWorlds operation returned by the service.
     * @throws InvalidParameterException
     *         A parameter specified in a request is not valid, is unsupported, or cannot be used. The returned message
     *         provides an explanation of the error value.
     * @throws ThrottlingException
     *         AWS RoboMaker is temporarily unable to process the request. Try your call again.
     * @throws InternalServerException
     *         AWS RoboMaker experienced a service issue. Try your call again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RoboMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RoboMakerClient.ListWorlds
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/ListWorlds" target="_top">AWS API
     *      Documentation</a>
     */
    default ListWorldsResponse listWorlds(Consumer<ListWorldsRequest.Builder> listWorldsRequest)
            throws InvalidParameterException, ThrottlingException, InternalServerException, AwsServiceException,
            SdkClientException, RoboMakerException {
        return listWorlds(ListWorldsRequest.builder().applyMutation(listWorldsRequest).build());
    }

    /**
     * <p>
     * Lists worlds.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listWorlds(software.amazon.awssdk.services.robomaker.model.ListWorldsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.robomaker.paginators.ListWorldsIterable responses = client.listWorldsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.robomaker.paginators.ListWorldsIterable responses = client.listWorldsPaginator(request);
     *     for (software.amazon.awssdk.services.robomaker.model.ListWorldsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.robomaker.paginators.ListWorldsIterable responses = client.listWorldsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listWorlds(software.amazon.awssdk.services.robomaker.model.ListWorldsRequest)} operation.</b>
     * </p>
     *
     * @param listWorldsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidParameterException
     *         A parameter specified in a request is not valid, is unsupported, or cannot be used. The returned message
     *         provides an explanation of the error value.
     * @throws ThrottlingException
     *         AWS RoboMaker is temporarily unable to process the request. Try your call again.
     * @throws InternalServerException
     *         AWS RoboMaker experienced a service issue. Try your call again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RoboMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RoboMakerClient.ListWorlds
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/ListWorlds" target="_top">AWS API
     *      Documentation</a>
     */
    default ListWorldsIterable listWorldsPaginator(ListWorldsRequest listWorldsRequest) throws InvalidParameterException,
            ThrottlingException, InternalServerException, AwsServiceException, SdkClientException, RoboMakerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists worlds.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listWorlds(software.amazon.awssdk.services.robomaker.model.ListWorldsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.robomaker.paginators.ListWorldsIterable responses = client.listWorldsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.robomaker.paginators.ListWorldsIterable responses = client.listWorldsPaginator(request);
     *     for (software.amazon.awssdk.services.robomaker.model.ListWorldsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.robomaker.paginators.ListWorldsIterable responses = client.listWorldsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listWorlds(software.amazon.awssdk.services.robomaker.model.ListWorldsRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListWorldsRequest.Builder} avoiding the need to
     * create one manually via {@link ListWorldsRequest#builder()}
     * </p>
     *
     * @param listWorldsRequest
     *        A {@link Consumer} that will call methods on {@link ListWorldsRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidParameterException
     *         A parameter specified in a request is not valid, is unsupported, or cannot be used. The returned message
     *         provides an explanation of the error value.
     * @throws ThrottlingException
     *         AWS RoboMaker is temporarily unable to process the request. Try your call again.
     * @throws InternalServerException
     *         AWS RoboMaker experienced a service issue. Try your call again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RoboMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RoboMakerClient.ListWorlds
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/ListWorlds" target="_top">AWS API
     *      Documentation</a>
     */
    default ListWorldsIterable listWorldsPaginator(Consumer<ListWorldsRequest.Builder> listWorldsRequest)
            throws InvalidParameterException, ThrottlingException, InternalServerException, AwsServiceException,
            SdkClientException, RoboMakerException {
        return listWorldsPaginator(ListWorldsRequest.builder().applyMutation(listWorldsRequest).build());
    }

    /**
     * <p>
     * Registers a robot with a fleet.
     * </p>
     *
     * @param registerRobotRequest
     * @return Result of the RegisterRobot operation returned by the service.
     * @throws InvalidParameterException
     *         A parameter specified in a request is not valid, is unsupported, or cannot be used. The returned message
     *         provides an explanation of the error value.
     * @throws InternalServerException
     *         AWS RoboMaker experienced a service issue. Try your call again.
     * @throws ThrottlingException
     *         AWS RoboMaker is temporarily unable to process the request. Try your call again.
     * @throws LimitExceededException
     *         The requested resource exceeds the maximum number allowed, or the number of concurrent stream requests
     *         exceeds the maximum number allowed.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RoboMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RoboMakerClient.RegisterRobot
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/RegisterRobot" target="_top">AWS API
     *      Documentation</a>
     */
    default RegisterRobotResponse registerRobot(RegisterRobotRequest registerRobotRequest) throws InvalidParameterException,
            InternalServerException, ThrottlingException, LimitExceededException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, RoboMakerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Registers a robot with a fleet.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link RegisterRobotRequest.Builder} avoiding the need to
     * create one manually via {@link RegisterRobotRequest#builder()}
     * </p>
     *
     * @param registerRobotRequest
     *        A {@link Consumer} that will call methods on {@link RegisterRobotRequest.Builder} to create a request.
     * @return Result of the RegisterRobot operation returned by the service.
     * @throws InvalidParameterException
     *         A parameter specified in a request is not valid, is unsupported, or cannot be used. The returned message
     *         provides an explanation of the error value.
     * @throws InternalServerException
     *         AWS RoboMaker experienced a service issue. Try your call again.
     * @throws ThrottlingException
     *         AWS RoboMaker is temporarily unable to process the request. Try your call again.
     * @throws LimitExceededException
     *         The requested resource exceeds the maximum number allowed, or the number of concurrent stream requests
     *         exceeds the maximum number allowed.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RoboMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RoboMakerClient.RegisterRobot
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/RegisterRobot" target="_top">AWS API
     *      Documentation</a>
     */
    default RegisterRobotResponse registerRobot(Consumer<RegisterRobotRequest.Builder> registerRobotRequest)
            throws InvalidParameterException, InternalServerException, ThrottlingException, LimitExceededException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, RoboMakerException {
        return registerRobot(RegisterRobotRequest.builder().applyMutation(registerRobotRequest).build());
    }

    /**
     * <p>
     * Restarts a running simulation job.
     * </p>
     *
     * @param restartSimulationJobRequest
     * @return Result of the RestartSimulationJob operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws ThrottlingException
     *         AWS RoboMaker is temporarily unable to process the request. Try your call again.
     * @throws LimitExceededException
     *         The requested resource exceeds the maximum number allowed, or the number of concurrent stream requests
     *         exceeds the maximum number allowed.
     * @throws InvalidParameterException
     *         A parameter specified in a request is not valid, is unsupported, or cannot be used. The returned message
     *         provides an explanation of the error value.
     * @throws InternalServerException
     *         AWS RoboMaker experienced a service issue. Try your call again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RoboMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RoboMakerClient.RestartSimulationJob
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/RestartSimulationJob" target="_top">AWS
     *      API Documentation</a>
     */
    default RestartSimulationJobResponse restartSimulationJob(RestartSimulationJobRequest restartSimulationJobRequest)
            throws ResourceNotFoundException, ThrottlingException, LimitExceededException, InvalidParameterException,
            InternalServerException, AwsServiceException, SdkClientException, RoboMakerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Restarts a running simulation job.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link RestartSimulationJobRequest.Builder} avoiding the
     * need to create one manually via {@link RestartSimulationJobRequest#builder()}
     * </p>
     *
     * @param restartSimulationJobRequest
     *        A {@link Consumer} that will call methods on {@link RestartSimulationJobRequest.Builder} to create a
     *        request.
     * @return Result of the RestartSimulationJob operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws ThrottlingException
     *         AWS RoboMaker is temporarily unable to process the request. Try your call again.
     * @throws LimitExceededException
     *         The requested resource exceeds the maximum number allowed, or the number of concurrent stream requests
     *         exceeds the maximum number allowed.
     * @throws InvalidParameterException
     *         A parameter specified in a request is not valid, is unsupported, or cannot be used. The returned message
     *         provides an explanation of the error value.
     * @throws InternalServerException
     *         AWS RoboMaker experienced a service issue. Try your call again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RoboMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RoboMakerClient.RestartSimulationJob
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/RestartSimulationJob" target="_top">AWS
     *      API Documentation</a>
     */
    default RestartSimulationJobResponse restartSimulationJob(
            Consumer<RestartSimulationJobRequest.Builder> restartSimulationJobRequest) throws ResourceNotFoundException,
            ThrottlingException, LimitExceededException, InvalidParameterException, InternalServerException, AwsServiceException,
            SdkClientException, RoboMakerException {
        return restartSimulationJob(RestartSimulationJobRequest.builder().applyMutation(restartSimulationJobRequest).build());
    }

    /**
     * <p>
     * Starts a new simulation job batch. The batch is defined using one or more <code>SimulationJobRequest</code>
     * objects.
     * </p>
     *
     * @param startSimulationJobBatchRequest
     * @return Result of the StartSimulationJobBatch operation returned by the service.
     * @throws InvalidParameterException
     *         A parameter specified in a request is not valid, is unsupported, or cannot be used. The returned message
     *         provides an explanation of the error value.
     * @throws LimitExceededException
     *         The requested resource exceeds the maximum number allowed, or the number of concurrent stream requests
     *         exceeds the maximum number allowed.
     * @throws ThrottlingException
     *         AWS RoboMaker is temporarily unable to process the request. Try your call again.
     * @throws IdempotentParameterMismatchException
     *         The request uses the same client token as a previous, but non-identical request. Do not reuse a client
     *         token with different requests, unless the requests are identical.
     * @throws InternalServerException
     *         AWS RoboMaker experienced a service issue. Try your call again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RoboMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RoboMakerClient.StartSimulationJobBatch
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/StartSimulationJobBatch"
     *      target="_top">AWS API Documentation</a>
     */
    default StartSimulationJobBatchResponse startSimulationJobBatch(StartSimulationJobBatchRequest startSimulationJobBatchRequest)
            throws InvalidParameterException, LimitExceededException, ThrottlingException, IdempotentParameterMismatchException,
            InternalServerException, AwsServiceException, SdkClientException, RoboMakerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Starts a new simulation job batch. The batch is defined using one or more <code>SimulationJobRequest</code>
     * objects.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StartSimulationJobBatchRequest.Builder} avoiding
     * the need to create one manually via {@link StartSimulationJobBatchRequest#builder()}
     * </p>
     *
     * @param startSimulationJobBatchRequest
     *        A {@link Consumer} that will call methods on {@link StartSimulationJobBatchRequest.Builder} to create a
     *        request.
     * @return Result of the StartSimulationJobBatch operation returned by the service.
     * @throws InvalidParameterException
     *         A parameter specified in a request is not valid, is unsupported, or cannot be used. The returned message
     *         provides an explanation of the error value.
     * @throws LimitExceededException
     *         The requested resource exceeds the maximum number allowed, or the number of concurrent stream requests
     *         exceeds the maximum number allowed.
     * @throws ThrottlingException
     *         AWS RoboMaker is temporarily unable to process the request. Try your call again.
     * @throws IdempotentParameterMismatchException
     *         The request uses the same client token as a previous, but non-identical request. Do not reuse a client
     *         token with different requests, unless the requests are identical.
     * @throws InternalServerException
     *         AWS RoboMaker experienced a service issue. Try your call again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RoboMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RoboMakerClient.StartSimulationJobBatch
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/StartSimulationJobBatch"
     *      target="_top">AWS API Documentation</a>
     */
    default StartSimulationJobBatchResponse startSimulationJobBatch(
            Consumer<StartSimulationJobBatchRequest.Builder> startSimulationJobBatchRequest) throws InvalidParameterException,
            LimitExceededException, ThrottlingException, IdempotentParameterMismatchException, InternalServerException,
            AwsServiceException, SdkClientException, RoboMakerException {
        return startSimulationJobBatch(StartSimulationJobBatchRequest.builder().applyMutation(startSimulationJobBatchRequest)
                .build());
    }

    /**
     * <p>
     * Syncrhonizes robots in a fleet to the latest deployment. This is helpful if robots were added after a deployment.
     * </p>
     *
     * @param syncDeploymentJobRequest
     * @return Result of the SyncDeploymentJob operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws InvalidParameterException
     *         A parameter specified in a request is not valid, is unsupported, or cannot be used. The returned message
     *         provides an explanation of the error value.
     * @throws InternalServerException
     *         AWS RoboMaker experienced a service issue. Try your call again.
     * @throws ThrottlingException
     *         AWS RoboMaker is temporarily unable to process the request. Try your call again.
     * @throws LimitExceededException
     *         The requested resource exceeds the maximum number allowed, or the number of concurrent stream requests
     *         exceeds the maximum number allowed.
     * @throws ConcurrentDeploymentException
     *         The failure percentage threshold percentage was met.
     * @throws IdempotentParameterMismatchException
     *         The request uses the same client token as a previous, but non-identical request. Do not reuse a client
     *         token with different requests, unless the requests are identical.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RoboMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RoboMakerClient.SyncDeploymentJob
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/SyncDeploymentJob" target="_top">AWS
     *      API Documentation</a>
     */
    default SyncDeploymentJobResponse syncDeploymentJob(SyncDeploymentJobRequest syncDeploymentJobRequest)
            throws ResourceNotFoundException, InvalidParameterException, InternalServerException, ThrottlingException,
            LimitExceededException, ConcurrentDeploymentException, IdempotentParameterMismatchException, AwsServiceException,
            SdkClientException, RoboMakerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Syncrhonizes robots in a fleet to the latest deployment. This is helpful if robots were added after a deployment.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link SyncDeploymentJobRequest.Builder} avoiding the need
     * to create one manually via {@link SyncDeploymentJobRequest#builder()}
     * </p>
     *
     * @param syncDeploymentJobRequest
     *        A {@link Consumer} that will call methods on {@link SyncDeploymentJobRequest.Builder} to create a request.
     * @return Result of the SyncDeploymentJob operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws InvalidParameterException
     *         A parameter specified in a request is not valid, is unsupported, or cannot be used. The returned message
     *         provides an explanation of the error value.
     * @throws InternalServerException
     *         AWS RoboMaker experienced a service issue. Try your call again.
     * @throws ThrottlingException
     *         AWS RoboMaker is temporarily unable to process the request. Try your call again.
     * @throws LimitExceededException
     *         The requested resource exceeds the maximum number allowed, or the number of concurrent stream requests
     *         exceeds the maximum number allowed.
     * @throws ConcurrentDeploymentException
     *         The failure percentage threshold percentage was met.
     * @throws IdempotentParameterMismatchException
     *         The request uses the same client token as a previous, but non-identical request. Do not reuse a client
     *         token with different requests, unless the requests are identical.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RoboMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RoboMakerClient.SyncDeploymentJob
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/SyncDeploymentJob" target="_top">AWS
     *      API Documentation</a>
     */
    default SyncDeploymentJobResponse syncDeploymentJob(Consumer<SyncDeploymentJobRequest.Builder> syncDeploymentJobRequest)
            throws ResourceNotFoundException, InvalidParameterException, InternalServerException, ThrottlingException,
            LimitExceededException, ConcurrentDeploymentException, IdempotentParameterMismatchException, AwsServiceException,
            SdkClientException, RoboMakerException {
        return syncDeploymentJob(SyncDeploymentJobRequest.builder().applyMutation(syncDeploymentJobRequest).build());
    }

    /**
     * <p>
     * Adds or edits tags for a AWS RoboMaker resource.
     * </p>
     * <p>
     * Each tag consists of a tag key and a tag value. Tag keys and tag values are both required, but tag values can be
     * empty strings.
     * </p>
     * <p>
     * For information about the rules that apply to tag keys and tag values, see <a
     * href="https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/allocation-tag-restrictions.html">User-Defined
     * Tag Restrictions</a> in the <i>AWS Billing and Cost Management User Guide</i>.
     * </p>
     *
     * @param tagResourceRequest
     * @return Result of the TagResource operation returned by the service.
     * @throws InternalServerException
     *         AWS RoboMaker experienced a service issue. Try your call again.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws InvalidParameterException
     *         A parameter specified in a request is not valid, is unsupported, or cannot be used. The returned message
     *         provides an explanation of the error value.
     * @throws ThrottlingException
     *         AWS RoboMaker is temporarily unable to process the request. Try your call again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RoboMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RoboMakerClient.TagResource
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default TagResourceResponse tagResource(TagResourceRequest tagResourceRequest) throws InternalServerException,
            ResourceNotFoundException, InvalidParameterException, ThrottlingException, AwsServiceException, SdkClientException,
            RoboMakerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Adds or edits tags for a AWS RoboMaker resource.
     * </p>
     * <p>
     * Each tag consists of a tag key and a tag value. Tag keys and tag values are both required, but tag values can be
     * empty strings.
     * </p>
     * <p>
     * For information about the rules that apply to tag keys and tag values, see <a
     * href="https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/allocation-tag-restrictions.html">User-Defined
     * Tag Restrictions</a> in the <i>AWS Billing and Cost Management User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link TagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link TagResourceRequest#builder()}
     * </p>
     *
     * @param tagResourceRequest
     *        A {@link Consumer} that will call methods on {@link TagResourceRequest.Builder} to create a request.
     * @return Result of the TagResource operation returned by the service.
     * @throws InternalServerException
     *         AWS RoboMaker experienced a service issue. Try your call again.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws InvalidParameterException
     *         A parameter specified in a request is not valid, is unsupported, or cannot be used. The returned message
     *         provides an explanation of the error value.
     * @throws ThrottlingException
     *         AWS RoboMaker is temporarily unable to process the request. Try your call again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RoboMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RoboMakerClient.TagResource
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default TagResourceResponse tagResource(Consumer<TagResourceRequest.Builder> tagResourceRequest)
            throws InternalServerException, ResourceNotFoundException, InvalidParameterException, ThrottlingException,
            AwsServiceException, SdkClientException, RoboMakerException {
        return tagResource(TagResourceRequest.builder().applyMutation(tagResourceRequest).build());
    }

    /**
     * <p>
     * Removes the specified tags from the specified AWS RoboMaker resource.
     * </p>
     * <p>
     * To remove a tag, specify the tag key. To change the tag value of an existing tag key, use <a
     * href="https://docs.aws.amazon.com/robomaker/latest/dg/API_TagResource.html"> <code>TagResource</code> </a>.
     * </p>
     *
     * @param untagResourceRequest
     * @return Result of the UntagResource operation returned by the service.
     * @throws InternalServerException
     *         AWS RoboMaker experienced a service issue. Try your call again.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws InvalidParameterException
     *         A parameter specified in a request is not valid, is unsupported, or cannot be used. The returned message
     *         provides an explanation of the error value.
     * @throws ThrottlingException
     *         AWS RoboMaker is temporarily unable to process the request. Try your call again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RoboMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RoboMakerClient.UntagResource
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/UntagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default UntagResourceResponse untagResource(UntagResourceRequest untagResourceRequest) throws InternalServerException,
            ResourceNotFoundException, InvalidParameterException, ThrottlingException, AwsServiceException, SdkClientException,
            RoboMakerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes the specified tags from the specified AWS RoboMaker resource.
     * </p>
     * <p>
     * To remove a tag, specify the tag key. To change the tag value of an existing tag key, use <a
     * href="https://docs.aws.amazon.com/robomaker/latest/dg/API_TagResource.html"> <code>TagResource</code> </a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UntagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link UntagResourceRequest#builder()}
     * </p>
     *
     * @param untagResourceRequest
     *        A {@link Consumer} that will call methods on {@link UntagResourceRequest.Builder} to create a request.
     * @return Result of the UntagResource operation returned by the service.
     * @throws InternalServerException
     *         AWS RoboMaker experienced a service issue. Try your call again.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws InvalidParameterException
     *         A parameter specified in a request is not valid, is unsupported, or cannot be used. The returned message
     *         provides an explanation of the error value.
     * @throws ThrottlingException
     *         AWS RoboMaker is temporarily unable to process the request. Try your call again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RoboMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RoboMakerClient.UntagResource
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/UntagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default UntagResourceResponse untagResource(Consumer<UntagResourceRequest.Builder> untagResourceRequest)
            throws InternalServerException, ResourceNotFoundException, InvalidParameterException, ThrottlingException,
            AwsServiceException, SdkClientException, RoboMakerException {
        return untagResource(UntagResourceRequest.builder().applyMutation(untagResourceRequest).build());
    }

    /**
     * <p>
     * Updates a robot application.
     * </p>
     *
     * @param updateRobotApplicationRequest
     * @return Result of the UpdateRobotApplication operation returned by the service.
     * @throws InvalidParameterException
     *         A parameter specified in a request is not valid, is unsupported, or cannot be used. The returned message
     *         provides an explanation of the error value.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws LimitExceededException
     *         The requested resource exceeds the maximum number allowed, or the number of concurrent stream requests
     *         exceeds the maximum number allowed.
     * @throws ThrottlingException
     *         AWS RoboMaker is temporarily unable to process the request. Try your call again.
     * @throws InternalServerException
     *         AWS RoboMaker experienced a service issue. Try your call again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RoboMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RoboMakerClient.UpdateRobotApplication
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/UpdateRobotApplication"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateRobotApplicationResponse updateRobotApplication(UpdateRobotApplicationRequest updateRobotApplicationRequest)
            throws InvalidParameterException, ResourceNotFoundException, LimitExceededException, ThrottlingException,
            InternalServerException, AwsServiceException, SdkClientException, RoboMakerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates a robot application.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateRobotApplicationRequest.Builder} avoiding the
     * need to create one manually via {@link UpdateRobotApplicationRequest#builder()}
     * </p>
     *
     * @param updateRobotApplicationRequest
     *        A {@link Consumer} that will call methods on {@link UpdateRobotApplicationRequest.Builder} to create a
     *        request.
     * @return Result of the UpdateRobotApplication operation returned by the service.
     * @throws InvalidParameterException
     *         A parameter specified in a request is not valid, is unsupported, or cannot be used. The returned message
     *         provides an explanation of the error value.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws LimitExceededException
     *         The requested resource exceeds the maximum number allowed, or the number of concurrent stream requests
     *         exceeds the maximum number allowed.
     * @throws ThrottlingException
     *         AWS RoboMaker is temporarily unable to process the request. Try your call again.
     * @throws InternalServerException
     *         AWS RoboMaker experienced a service issue. Try your call again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RoboMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RoboMakerClient.UpdateRobotApplication
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/UpdateRobotApplication"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateRobotApplicationResponse updateRobotApplication(
            Consumer<UpdateRobotApplicationRequest.Builder> updateRobotApplicationRequest) throws InvalidParameterException,
            ResourceNotFoundException, LimitExceededException, ThrottlingException, InternalServerException, AwsServiceException,
            SdkClientException, RoboMakerException {
        return updateRobotApplication(UpdateRobotApplicationRequest.builder().applyMutation(updateRobotApplicationRequest)
                .build());
    }

    /**
     * <p>
     * Updates a simulation application.
     * </p>
     *
     * @param updateSimulationApplicationRequest
     * @return Result of the UpdateSimulationApplication operation returned by the service.
     * @throws InvalidParameterException
     *         A parameter specified in a request is not valid, is unsupported, or cannot be used. The returned message
     *         provides an explanation of the error value.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws LimitExceededException
     *         The requested resource exceeds the maximum number allowed, or the number of concurrent stream requests
     *         exceeds the maximum number allowed.
     * @throws ThrottlingException
     *         AWS RoboMaker is temporarily unable to process the request. Try your call again.
     * @throws InternalServerException
     *         AWS RoboMaker experienced a service issue. Try your call again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RoboMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RoboMakerClient.UpdateSimulationApplication
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/UpdateSimulationApplication"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateSimulationApplicationResponse updateSimulationApplication(
            UpdateSimulationApplicationRequest updateSimulationApplicationRequest) throws InvalidParameterException,
            ResourceNotFoundException, LimitExceededException, ThrottlingException, InternalServerException, AwsServiceException,
            SdkClientException, RoboMakerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates a simulation application.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateSimulationApplicationRequest.Builder}
     * avoiding the need to create one manually via {@link UpdateSimulationApplicationRequest#builder()}
     * </p>
     *
     * @param updateSimulationApplicationRequest
     *        A {@link Consumer} that will call methods on {@link UpdateSimulationApplicationRequest.Builder} to create
     *        a request.
     * @return Result of the UpdateSimulationApplication operation returned by the service.
     * @throws InvalidParameterException
     *         A parameter specified in a request is not valid, is unsupported, or cannot be used. The returned message
     *         provides an explanation of the error value.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws LimitExceededException
     *         The requested resource exceeds the maximum number allowed, or the number of concurrent stream requests
     *         exceeds the maximum number allowed.
     * @throws ThrottlingException
     *         AWS RoboMaker is temporarily unable to process the request. Try your call again.
     * @throws InternalServerException
     *         AWS RoboMaker experienced a service issue. Try your call again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RoboMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RoboMakerClient.UpdateSimulationApplication
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/UpdateSimulationApplication"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateSimulationApplicationResponse updateSimulationApplication(
            Consumer<UpdateSimulationApplicationRequest.Builder> updateSimulationApplicationRequest)
            throws InvalidParameterException, ResourceNotFoundException, LimitExceededException, ThrottlingException,
            InternalServerException, AwsServiceException, SdkClientException, RoboMakerException {
        return updateSimulationApplication(UpdateSimulationApplicationRequest.builder()
                .applyMutation(updateSimulationApplicationRequest).build());
    }

    /**
     * <p>
     * Updates a world template.
     * </p>
     *
     * @param updateWorldTemplateRequest
     * @return Result of the UpdateWorldTemplate operation returned by the service.
     * @throws InvalidParameterException
     *         A parameter specified in a request is not valid, is unsupported, or cannot be used. The returned message
     *         provides an explanation of the error value.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws ThrottlingException
     *         AWS RoboMaker is temporarily unable to process the request. Try your call again.
     * @throws InternalServerException
     *         AWS RoboMaker experienced a service issue. Try your call again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RoboMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RoboMakerClient.UpdateWorldTemplate
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/UpdateWorldTemplate" target="_top">AWS
     *      API Documentation</a>
     */
    default UpdateWorldTemplateResponse updateWorldTemplate(UpdateWorldTemplateRequest updateWorldTemplateRequest)
            throws InvalidParameterException, ResourceNotFoundException, ThrottlingException, InternalServerException,
            AwsServiceException, SdkClientException, RoboMakerException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates a world template.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateWorldTemplateRequest.Builder} avoiding the
     * need to create one manually via {@link UpdateWorldTemplateRequest#builder()}
     * </p>
     *
     * @param updateWorldTemplateRequest
     *        A {@link Consumer} that will call methods on {@link UpdateWorldTemplateRequest.Builder} to create a
     *        request.
     * @return Result of the UpdateWorldTemplate operation returned by the service.
     * @throws InvalidParameterException
     *         A parameter specified in a request is not valid, is unsupported, or cannot be used. The returned message
     *         provides an explanation of the error value.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws ThrottlingException
     *         AWS RoboMaker is temporarily unable to process the request. Try your call again.
     * @throws InternalServerException
     *         AWS RoboMaker experienced a service issue. Try your call again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RoboMakerException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RoboMakerClient.UpdateWorldTemplate
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/UpdateWorldTemplate" target="_top">AWS
     *      API Documentation</a>
     */
    default UpdateWorldTemplateResponse updateWorldTemplate(
            Consumer<UpdateWorldTemplateRequest.Builder> updateWorldTemplateRequest) throws InvalidParameterException,
            ResourceNotFoundException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException,
            RoboMakerException {
        return updateWorldTemplate(UpdateWorldTemplateRequest.builder().applyMutation(updateWorldTemplateRequest).build());
    }

    static ServiceMetadata serviceMetadata() {
        return ServiceMetadata.of("robomaker");
    }
}
