/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.robomaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The logging configuration.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class LoggingConfig implements SdkPojo, Serializable, ToCopyableBuilder<LoggingConfig.Builder, LoggingConfig> {
    private static final SdkField<Boolean> RECORD_ALL_ROS_TOPICS_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("recordAllRosTopics").getter(getter(LoggingConfig::recordAllRosTopics))
            .setter(setter(Builder::recordAllRosTopics))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("recordAllRosTopics").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RECORD_ALL_ROS_TOPICS_FIELD));

    private static final long serialVersionUID = 1L;

    private final Boolean recordAllRosTopics;

    private LoggingConfig(BuilderImpl builder) {
        this.recordAllRosTopics = builder.recordAllRosTopics;
    }

    /**
     * <p>
     * A boolean indicating whether to record all ROS topics.
     * </p>
     * 
     * @return A boolean indicating whether to record all ROS topics.
     */
    public Boolean recordAllRosTopics() {
        return recordAllRosTopics;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(recordAllRosTopics());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LoggingConfig)) {
            return false;
        }
        LoggingConfig other = (LoggingConfig) obj;
        return Objects.equals(recordAllRosTopics(), other.recordAllRosTopics());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("LoggingConfig").add("RecordAllRosTopics", recordAllRosTopics()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "recordAllRosTopics":
            return Optional.ofNullable(clazz.cast(recordAllRosTopics()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<LoggingConfig, T> g) {
        return obj -> g.apply((LoggingConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, LoggingConfig> {
        /**
         * <p>
         * A boolean indicating whether to record all ROS topics.
         * </p>
         * 
         * @param recordAllRosTopics
         *        A boolean indicating whether to record all ROS topics.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder recordAllRosTopics(Boolean recordAllRosTopics);
    }

    static final class BuilderImpl implements Builder {
        private Boolean recordAllRosTopics;

        private BuilderImpl() {
        }

        private BuilderImpl(LoggingConfig model) {
            recordAllRosTopics(model.recordAllRosTopics);
        }

        public final Boolean getRecordAllRosTopics() {
            return recordAllRosTopics;
        }

        @Override
        public final Builder recordAllRosTopics(Boolean recordAllRosTopics) {
            this.recordAllRosTopics = recordAllRosTopics;
            return this;
        }

        public final void setRecordAllRosTopics(Boolean recordAllRosTopics) {
            this.recordAllRosTopics = recordAllRosTopics;
        }

        @Override
        public LoggingConfig build() {
            return new LoggingConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
