/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.robomaker.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateDeploymentJobResponse extends RoboMakerResponse implements
        ToCopyableBuilder<CreateDeploymentJobResponse.Builder, CreateDeploymentJobResponse> {
    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("arn")
            .getter(getter(CreateDeploymentJobResponse::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()).build();

    private static final SdkField<String> FLEET_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("fleet")
            .getter(getter(CreateDeploymentJobResponse::fleet)).setter(setter(Builder::fleet))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fleet").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(CreateDeploymentJobResponse::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<List<DeploymentApplicationConfig>> DEPLOYMENT_APPLICATION_CONFIGS_FIELD = SdkField
            .<List<DeploymentApplicationConfig>> builder(MarshallingType.LIST)
            .memberName("deploymentApplicationConfigs")
            .getter(getter(CreateDeploymentJobResponse::deploymentApplicationConfigs))
            .setter(setter(Builder::deploymentApplicationConfigs))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deploymentApplicationConfigs")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<DeploymentApplicationConfig> builder(MarshallingType.SDK_POJO)
                                            .constructor(DeploymentApplicationConfig::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> FAILURE_REASON_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("failureReason").getter(getter(CreateDeploymentJobResponse::failureReason))
            .setter(setter(Builder::failureReason))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("failureReason").build()).build();

    private static final SdkField<String> FAILURE_CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("failureCode").getter(getter(CreateDeploymentJobResponse::failureCodeAsString))
            .setter(setter(Builder::failureCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("failureCode").build()).build();

    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("createdAt").getter(getter(CreateDeploymentJobResponse::createdAt)).setter(setter(Builder::createdAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build()).build();

    private static final SdkField<DeploymentConfig> DEPLOYMENT_CONFIG_FIELD = SdkField
            .<DeploymentConfig> builder(MarshallingType.SDK_POJO).memberName("deploymentConfig")
            .getter(getter(CreateDeploymentJobResponse::deploymentConfig)).setter(setter(Builder::deploymentConfig))
            .constructor(DeploymentConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deploymentConfig").build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("tags")
            .getter(getter(CreateDeploymentJobResponse::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, FLEET_FIELD,
            STATUS_FIELD, DEPLOYMENT_APPLICATION_CONFIGS_FIELD, FAILURE_REASON_FIELD, FAILURE_CODE_FIELD, CREATED_AT_FIELD,
            DEPLOYMENT_CONFIG_FIELD, TAGS_FIELD));

    private final String arn;

    private final String fleet;

    private final String status;

    private final List<DeploymentApplicationConfig> deploymentApplicationConfigs;

    private final String failureReason;

    private final String failureCode;

    private final Instant createdAt;

    private final DeploymentConfig deploymentConfig;

    private final Map<String, String> tags;

    private CreateDeploymentJobResponse(BuilderImpl builder) {
        super(builder);
        this.arn = builder.arn;
        this.fleet = builder.fleet;
        this.status = builder.status;
        this.deploymentApplicationConfigs = builder.deploymentApplicationConfigs;
        this.failureReason = builder.failureReason;
        this.failureCode = builder.failureCode;
        this.createdAt = builder.createdAt;
        this.deploymentConfig = builder.deploymentConfig;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the deployment job.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the deployment job.
     */
    public String arn() {
        return arn;
    }

    /**
     * <p>
     * The target fleet for the deployment job.
     * </p>
     * 
     * @return The target fleet for the deployment job.
     */
    public String fleet() {
        return fleet;
    }

    /**
     * <p>
     * The status of the deployment job.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link DeploymentStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the deployment job.
     * @see DeploymentStatus
     */
    public DeploymentStatus status() {
        return DeploymentStatus.fromValue(status);
    }

    /**
     * <p>
     * The status of the deployment job.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link DeploymentStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the deployment job.
     * @see DeploymentStatus
     */
    public String statusAsString() {
        return status;
    }

    /**
     * Returns true if the DeploymentApplicationConfigs property was specified by the sender (it may be empty), or false
     * if the sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the
     * AWS service.
     */
    public boolean hasDeploymentApplicationConfigs() {
        return deploymentApplicationConfigs != null && !(deploymentApplicationConfigs instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The deployment application configuration.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasDeploymentApplicationConfigs()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The deployment application configuration.
     */
    public List<DeploymentApplicationConfig> deploymentApplicationConfigs() {
        return deploymentApplicationConfigs;
    }

    /**
     * <p>
     * The failure reason of the deployment job if it failed.
     * </p>
     * 
     * @return The failure reason of the deployment job if it failed.
     */
    public String failureReason() {
        return failureReason;
    }

    /**
     * <p>
     * The failure code of the simulation job if it failed:
     * </p>
     * <dl>
     * <dt>BadPermissionError</dt>
     * <dd>
     * <p>
     * AWS Greengrass requires a service-level role permission to access other services. The role must include the <a
     * href=
     * "https://console.aws.amazon.com/iam/home?#/policies/arn:aws:iam::aws:policy/service-role/AWSGreengrassResourceAccessRolePolicy$jsonEditor"
     * > <code>AWSGreengrassResourceAccessRolePolicy</code> managed policy</a>.
     * </p>
     * </dd>
     * <dt>ExtractingBundleFailure</dt>
     * <dd>
     * <p>
     * The robot application could not be extracted from the bundle.
     * </p>
     * </dd>
     * <dt>FailureThresholdBreached</dt>
     * <dd>
     * <p>
     * The percentage of robots that could not be updated exceeded the percentage set for the deployment.
     * </p>
     * </dd>
     * <dt>GreengrassDeploymentFailed</dt>
     * <dd>
     * <p>
     * The robot application could not be deployed to the robot.
     * </p>
     * </dd>
     * <dt>GreengrassGroupVersionDoesNotExist</dt>
     * <dd>
     * <p>
     * The AWS Greengrass group or version associated with a robot is missing.
     * </p>
     * </dd>
     * <dt>InternalServerError</dt>
     * <dd>
     * <p>
     * An internal error has occurred. Retry your request, but if the problem persists, contact us with details.
     * </p>
     * </dd>
     * <dt>MissingRobotApplicationArchitecture</dt>
     * <dd>
     * <p>
     * The robot application does not have a source that matches the architecture of the robot.
     * </p>
     * </dd>
     * <dt>MissingRobotDeploymentResource</dt>
     * <dd>
     * <p>
     * One or more of the resources specified for the robot application are missing. For example, does the robot
     * application have the correct launch package and launch file?
     * </p>
     * </dd>
     * <dt>PostLaunchFileFailure</dt>
     * <dd>
     * <p>
     * The post-launch script failed.
     * </p>
     * </dd>
     * <dt>PreLaunchFileFailure</dt>
     * <dd>
     * <p>
     * The pre-launch script failed.
     * </p>
     * </dd>
     * <dt>ResourceNotFound</dt>
     * <dd>
     * <p>
     * One or more deployment resources are missing. For example, do robot application source bundles still exist?
     * </p>
     * </dd>
     * <dt>RobotDeploymentNoResponse</dt>
     * <dd>
     * <p>
     * There is no response from the robot. It might not be powered on or connected to the internet.
     * </p>
     * </dd>
     * </dl>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #failureCode} will
     * return {@link DeploymentJobErrorCode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #failureCodeAsString}.
     * </p>
     * 
     * @return The failure code of the simulation job if it failed:</p>
     *         <dl>
     *         <dt>BadPermissionError</dt>
     *         <dd>
     *         <p>
     *         AWS Greengrass requires a service-level role permission to access other services. The role must include
     *         the <a href=
     *         "https://console.aws.amazon.com/iam/home?#/policies/arn:aws:iam::aws:policy/service-role/AWSGreengrassResourceAccessRolePolicy$jsonEditor"
     *         > <code>AWSGreengrassResourceAccessRolePolicy</code> managed policy</a>.
     *         </p>
     *         </dd>
     *         <dt>ExtractingBundleFailure</dt>
     *         <dd>
     *         <p>
     *         The robot application could not be extracted from the bundle.
     *         </p>
     *         </dd>
     *         <dt>FailureThresholdBreached</dt>
     *         <dd>
     *         <p>
     *         The percentage of robots that could not be updated exceeded the percentage set for the deployment.
     *         </p>
     *         </dd>
     *         <dt>GreengrassDeploymentFailed</dt>
     *         <dd>
     *         <p>
     *         The robot application could not be deployed to the robot.
     *         </p>
     *         </dd>
     *         <dt>GreengrassGroupVersionDoesNotExist</dt>
     *         <dd>
     *         <p>
     *         The AWS Greengrass group or version associated with a robot is missing.
     *         </p>
     *         </dd>
     *         <dt>InternalServerError</dt>
     *         <dd>
     *         <p>
     *         An internal error has occurred. Retry your request, but if the problem persists, contact us with details.
     *         </p>
     *         </dd>
     *         <dt>MissingRobotApplicationArchitecture</dt>
     *         <dd>
     *         <p>
     *         The robot application does not have a source that matches the architecture of the robot.
     *         </p>
     *         </dd>
     *         <dt>MissingRobotDeploymentResource</dt>
     *         <dd>
     *         <p>
     *         One or more of the resources specified for the robot application are missing. For example, does the robot
     *         application have the correct launch package and launch file?
     *         </p>
     *         </dd>
     *         <dt>PostLaunchFileFailure</dt>
     *         <dd>
     *         <p>
     *         The post-launch script failed.
     *         </p>
     *         </dd>
     *         <dt>PreLaunchFileFailure</dt>
     *         <dd>
     *         <p>
     *         The pre-launch script failed.
     *         </p>
     *         </dd>
     *         <dt>ResourceNotFound</dt>
     *         <dd>
     *         <p>
     *         One or more deployment resources are missing. For example, do robot application source bundles still
     *         exist?
     *         </p>
     *         </dd>
     *         <dt>RobotDeploymentNoResponse</dt>
     *         <dd>
     *         <p>
     *         There is no response from the robot. It might not be powered on or connected to the internet.
     *         </p>
     *         </dd>
     * @see DeploymentJobErrorCode
     */
    public DeploymentJobErrorCode failureCode() {
        return DeploymentJobErrorCode.fromValue(failureCode);
    }

    /**
     * <p>
     * The failure code of the simulation job if it failed:
     * </p>
     * <dl>
     * <dt>BadPermissionError</dt>
     * <dd>
     * <p>
     * AWS Greengrass requires a service-level role permission to access other services. The role must include the <a
     * href=
     * "https://console.aws.amazon.com/iam/home?#/policies/arn:aws:iam::aws:policy/service-role/AWSGreengrassResourceAccessRolePolicy$jsonEditor"
     * > <code>AWSGreengrassResourceAccessRolePolicy</code> managed policy</a>.
     * </p>
     * </dd>
     * <dt>ExtractingBundleFailure</dt>
     * <dd>
     * <p>
     * The robot application could not be extracted from the bundle.
     * </p>
     * </dd>
     * <dt>FailureThresholdBreached</dt>
     * <dd>
     * <p>
     * The percentage of robots that could not be updated exceeded the percentage set for the deployment.
     * </p>
     * </dd>
     * <dt>GreengrassDeploymentFailed</dt>
     * <dd>
     * <p>
     * The robot application could not be deployed to the robot.
     * </p>
     * </dd>
     * <dt>GreengrassGroupVersionDoesNotExist</dt>
     * <dd>
     * <p>
     * The AWS Greengrass group or version associated with a robot is missing.
     * </p>
     * </dd>
     * <dt>InternalServerError</dt>
     * <dd>
     * <p>
     * An internal error has occurred. Retry your request, but if the problem persists, contact us with details.
     * </p>
     * </dd>
     * <dt>MissingRobotApplicationArchitecture</dt>
     * <dd>
     * <p>
     * The robot application does not have a source that matches the architecture of the robot.
     * </p>
     * </dd>
     * <dt>MissingRobotDeploymentResource</dt>
     * <dd>
     * <p>
     * One or more of the resources specified for the robot application are missing. For example, does the robot
     * application have the correct launch package and launch file?
     * </p>
     * </dd>
     * <dt>PostLaunchFileFailure</dt>
     * <dd>
     * <p>
     * The post-launch script failed.
     * </p>
     * </dd>
     * <dt>PreLaunchFileFailure</dt>
     * <dd>
     * <p>
     * The pre-launch script failed.
     * </p>
     * </dd>
     * <dt>ResourceNotFound</dt>
     * <dd>
     * <p>
     * One or more deployment resources are missing. For example, do robot application source bundles still exist?
     * </p>
     * </dd>
     * <dt>RobotDeploymentNoResponse</dt>
     * <dd>
     * <p>
     * There is no response from the robot. It might not be powered on or connected to the internet.
     * </p>
     * </dd>
     * </dl>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #failureCode} will
     * return {@link DeploymentJobErrorCode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #failureCodeAsString}.
     * </p>
     * 
     * @return The failure code of the simulation job if it failed:</p>
     *         <dl>
     *         <dt>BadPermissionError</dt>
     *         <dd>
     *         <p>
     *         AWS Greengrass requires a service-level role permission to access other services. The role must include
     *         the <a href=
     *         "https://console.aws.amazon.com/iam/home?#/policies/arn:aws:iam::aws:policy/service-role/AWSGreengrassResourceAccessRolePolicy$jsonEditor"
     *         > <code>AWSGreengrassResourceAccessRolePolicy</code> managed policy</a>.
     *         </p>
     *         </dd>
     *         <dt>ExtractingBundleFailure</dt>
     *         <dd>
     *         <p>
     *         The robot application could not be extracted from the bundle.
     *         </p>
     *         </dd>
     *         <dt>FailureThresholdBreached</dt>
     *         <dd>
     *         <p>
     *         The percentage of robots that could not be updated exceeded the percentage set for the deployment.
     *         </p>
     *         </dd>
     *         <dt>GreengrassDeploymentFailed</dt>
     *         <dd>
     *         <p>
     *         The robot application could not be deployed to the robot.
     *         </p>
     *         </dd>
     *         <dt>GreengrassGroupVersionDoesNotExist</dt>
     *         <dd>
     *         <p>
     *         The AWS Greengrass group or version associated with a robot is missing.
     *         </p>
     *         </dd>
     *         <dt>InternalServerError</dt>
     *         <dd>
     *         <p>
     *         An internal error has occurred. Retry your request, but if the problem persists, contact us with details.
     *         </p>
     *         </dd>
     *         <dt>MissingRobotApplicationArchitecture</dt>
     *         <dd>
     *         <p>
     *         The robot application does not have a source that matches the architecture of the robot.
     *         </p>
     *         </dd>
     *         <dt>MissingRobotDeploymentResource</dt>
     *         <dd>
     *         <p>
     *         One or more of the resources specified for the robot application are missing. For example, does the robot
     *         application have the correct launch package and launch file?
     *         </p>
     *         </dd>
     *         <dt>PostLaunchFileFailure</dt>
     *         <dd>
     *         <p>
     *         The post-launch script failed.
     *         </p>
     *         </dd>
     *         <dt>PreLaunchFileFailure</dt>
     *         <dd>
     *         <p>
     *         The pre-launch script failed.
     *         </p>
     *         </dd>
     *         <dt>ResourceNotFound</dt>
     *         <dd>
     *         <p>
     *         One or more deployment resources are missing. For example, do robot application source bundles still
     *         exist?
     *         </p>
     *         </dd>
     *         <dt>RobotDeploymentNoResponse</dt>
     *         <dd>
     *         <p>
     *         There is no response from the robot. It might not be powered on or connected to the internet.
     *         </p>
     *         </dd>
     * @see DeploymentJobErrorCode
     */
    public String failureCodeAsString() {
        return failureCode;
    }

    /**
     * <p>
     * The time, in milliseconds since the epoch, when the fleet was created.
     * </p>
     * 
     * @return The time, in milliseconds since the epoch, when the fleet was created.
     */
    public Instant createdAt() {
        return createdAt;
    }

    /**
     * <p>
     * The deployment configuration.
     * </p>
     * 
     * @return The deployment configuration.
     */
    public DeploymentConfig deploymentConfig() {
        return deploymentConfig;
    }

    /**
     * Returns true if the Tags property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The list of all tags added to the deployment job.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasTags()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The list of all tags added to the deployment job.
     */
    public Map<String, String> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(fleet());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasDeploymentApplicationConfigs() ? deploymentApplicationConfigs() : null);
        hashCode = 31 * hashCode + Objects.hashCode(failureReason());
        hashCode = 31 * hashCode + Objects.hashCode(failureCodeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(deploymentConfig());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateDeploymentJobResponse)) {
            return false;
        }
        CreateDeploymentJobResponse other = (CreateDeploymentJobResponse) obj;
        return Objects.equals(arn(), other.arn()) && Objects.equals(fleet(), other.fleet())
                && Objects.equals(statusAsString(), other.statusAsString())
                && hasDeploymentApplicationConfigs() == other.hasDeploymentApplicationConfigs()
                && Objects.equals(deploymentApplicationConfigs(), other.deploymentApplicationConfigs())
                && Objects.equals(failureReason(), other.failureReason())
                && Objects.equals(failureCodeAsString(), other.failureCodeAsString())
                && Objects.equals(createdAt(), other.createdAt()) && Objects.equals(deploymentConfig(), other.deploymentConfig())
                && hasTags() == other.hasTags() && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("CreateDeploymentJobResponse").add("Arn", arn()).add("Fleet", fleet())
                .add("Status", statusAsString())
                .add("DeploymentApplicationConfigs", hasDeploymentApplicationConfigs() ? deploymentApplicationConfigs() : null)
                .add("FailureReason", failureReason()).add("FailureCode", failureCodeAsString()).add("CreatedAt", createdAt())
                .add("DeploymentConfig", deploymentConfig()).add("Tags", hasTags() ? tags() : null).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "fleet":
            return Optional.ofNullable(clazz.cast(fleet()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "deploymentApplicationConfigs":
            return Optional.ofNullable(clazz.cast(deploymentApplicationConfigs()));
        case "failureReason":
            return Optional.ofNullable(clazz.cast(failureReason()));
        case "failureCode":
            return Optional.ofNullable(clazz.cast(failureCodeAsString()));
        case "createdAt":
            return Optional.ofNullable(clazz.cast(createdAt()));
        case "deploymentConfig":
            return Optional.ofNullable(clazz.cast(deploymentConfig()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateDeploymentJobResponse, T> g) {
        return obj -> g.apply((CreateDeploymentJobResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends RoboMakerResponse.Builder, SdkPojo, CopyableBuilder<Builder, CreateDeploymentJobResponse> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the deployment job.
         * </p>
         * 
         * @param arn
         *        The Amazon Resource Name (ARN) of the deployment job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The target fleet for the deployment job.
         * </p>
         * 
         * @param fleet
         *        The target fleet for the deployment job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fleet(String fleet);

        /**
         * <p>
         * The status of the deployment job.
         * </p>
         * 
         * @param status
         *        The status of the deployment job.
         * @see DeploymentStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DeploymentStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status of the deployment job.
         * </p>
         * 
         * @param status
         *        The status of the deployment job.
         * @see DeploymentStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DeploymentStatus
         */
        Builder status(DeploymentStatus status);

        /**
         * <p>
         * The deployment application configuration.
         * </p>
         * 
         * @param deploymentApplicationConfigs
         *        The deployment application configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deploymentApplicationConfigs(Collection<DeploymentApplicationConfig> deploymentApplicationConfigs);

        /**
         * <p>
         * The deployment application configuration.
         * </p>
         * 
         * @param deploymentApplicationConfigs
         *        The deployment application configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deploymentApplicationConfigs(DeploymentApplicationConfig... deploymentApplicationConfigs);

        /**
         * <p>
         * The deployment application configuration.
         * </p>
         * This is a convenience that creates an instance of the {@link List<DeploymentApplicationConfig>.Builder}
         * avoiding the need to create one manually via {@link List<DeploymentApplicationConfig>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<DeploymentApplicationConfig>.Builder#build()} is called
         * immediately and its result is passed to {@link
         * #deploymentApplicationConfigs(List<DeploymentApplicationConfig>)}.
         * 
         * @param deploymentApplicationConfigs
         *        a consumer that will call methods on {@link List<DeploymentApplicationConfig>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #deploymentApplicationConfigs(List<DeploymentApplicationConfig>)
         */
        Builder deploymentApplicationConfigs(Consumer<DeploymentApplicationConfig.Builder>... deploymentApplicationConfigs);

        /**
         * <p>
         * The failure reason of the deployment job if it failed.
         * </p>
         * 
         * @param failureReason
         *        The failure reason of the deployment job if it failed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder failureReason(String failureReason);

        /**
         * <p>
         * The failure code of the simulation job if it failed:
         * </p>
         * <dl>
         * <dt>BadPermissionError</dt>
         * <dd>
         * <p>
         * AWS Greengrass requires a service-level role permission to access other services. The role must include the
         * <a href=
         * "https://console.aws.amazon.com/iam/home?#/policies/arn:aws:iam::aws:policy/service-role/AWSGreengrassResourceAccessRolePolicy$jsonEditor"
         * > <code>AWSGreengrassResourceAccessRolePolicy</code> managed policy</a>.
         * </p>
         * </dd>
         * <dt>ExtractingBundleFailure</dt>
         * <dd>
         * <p>
         * The robot application could not be extracted from the bundle.
         * </p>
         * </dd>
         * <dt>FailureThresholdBreached</dt>
         * <dd>
         * <p>
         * The percentage of robots that could not be updated exceeded the percentage set for the deployment.
         * </p>
         * </dd>
         * <dt>GreengrassDeploymentFailed</dt>
         * <dd>
         * <p>
         * The robot application could not be deployed to the robot.
         * </p>
         * </dd>
         * <dt>GreengrassGroupVersionDoesNotExist</dt>
         * <dd>
         * <p>
         * The AWS Greengrass group or version associated with a robot is missing.
         * </p>
         * </dd>
         * <dt>InternalServerError</dt>
         * <dd>
         * <p>
         * An internal error has occurred. Retry your request, but if the problem persists, contact us with details.
         * </p>
         * </dd>
         * <dt>MissingRobotApplicationArchitecture</dt>
         * <dd>
         * <p>
         * The robot application does not have a source that matches the architecture of the robot.
         * </p>
         * </dd>
         * <dt>MissingRobotDeploymentResource</dt>
         * <dd>
         * <p>
         * One or more of the resources specified for the robot application are missing. For example, does the robot
         * application have the correct launch package and launch file?
         * </p>
         * </dd>
         * <dt>PostLaunchFileFailure</dt>
         * <dd>
         * <p>
         * The post-launch script failed.
         * </p>
         * </dd>
         * <dt>PreLaunchFileFailure</dt>
         * <dd>
         * <p>
         * The pre-launch script failed.
         * </p>
         * </dd>
         * <dt>ResourceNotFound</dt>
         * <dd>
         * <p>
         * One or more deployment resources are missing. For example, do robot application source bundles still exist?
         * </p>
         * </dd>
         * <dt>RobotDeploymentNoResponse</dt>
         * <dd>
         * <p>
         * There is no response from the robot. It might not be powered on or connected to the internet.
         * </p>
         * </dd>
         * </dl>
         * 
         * @param failureCode
         *        The failure code of the simulation job if it failed:</p>
         *        <dl>
         *        <dt>BadPermissionError</dt>
         *        <dd>
         *        <p>
         *        AWS Greengrass requires a service-level role permission to access other services. The role must
         *        include the <a href=
         *        "https://console.aws.amazon.com/iam/home?#/policies/arn:aws:iam::aws:policy/service-role/AWSGreengrassResourceAccessRolePolicy$jsonEditor"
         *        > <code>AWSGreengrassResourceAccessRolePolicy</code> managed policy</a>.
         *        </p>
         *        </dd>
         *        <dt>ExtractingBundleFailure</dt>
         *        <dd>
         *        <p>
         *        The robot application could not be extracted from the bundle.
         *        </p>
         *        </dd>
         *        <dt>FailureThresholdBreached</dt>
         *        <dd>
         *        <p>
         *        The percentage of robots that could not be updated exceeded the percentage set for the deployment.
         *        </p>
         *        </dd>
         *        <dt>GreengrassDeploymentFailed</dt>
         *        <dd>
         *        <p>
         *        The robot application could not be deployed to the robot.
         *        </p>
         *        </dd>
         *        <dt>GreengrassGroupVersionDoesNotExist</dt>
         *        <dd>
         *        <p>
         *        The AWS Greengrass group or version associated with a robot is missing.
         *        </p>
         *        </dd>
         *        <dt>InternalServerError</dt>
         *        <dd>
         *        <p>
         *        An internal error has occurred. Retry your request, but if the problem persists, contact us with
         *        details.
         *        </p>
         *        </dd>
         *        <dt>MissingRobotApplicationArchitecture</dt>
         *        <dd>
         *        <p>
         *        The robot application does not have a source that matches the architecture of the robot.
         *        </p>
         *        </dd>
         *        <dt>MissingRobotDeploymentResource</dt>
         *        <dd>
         *        <p>
         *        One or more of the resources specified for the robot application are missing. For example, does the
         *        robot application have the correct launch package and launch file?
         *        </p>
         *        </dd>
         *        <dt>PostLaunchFileFailure</dt>
         *        <dd>
         *        <p>
         *        The post-launch script failed.
         *        </p>
         *        </dd>
         *        <dt>PreLaunchFileFailure</dt>
         *        <dd>
         *        <p>
         *        The pre-launch script failed.
         *        </p>
         *        </dd>
         *        <dt>ResourceNotFound</dt>
         *        <dd>
         *        <p>
         *        One or more deployment resources are missing. For example, do robot application source bundles still
         *        exist?
         *        </p>
         *        </dd>
         *        <dt>RobotDeploymentNoResponse</dt>
         *        <dd>
         *        <p>
         *        There is no response from the robot. It might not be powered on or connected to the internet.
         *        </p>
         *        </dd>
         * @see DeploymentJobErrorCode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DeploymentJobErrorCode
         */
        Builder failureCode(String failureCode);

        /**
         * <p>
         * The failure code of the simulation job if it failed:
         * </p>
         * <dl>
         * <dt>BadPermissionError</dt>
         * <dd>
         * <p>
         * AWS Greengrass requires a service-level role permission to access other services. The role must include the
         * <a href=
         * "https://console.aws.amazon.com/iam/home?#/policies/arn:aws:iam::aws:policy/service-role/AWSGreengrassResourceAccessRolePolicy$jsonEditor"
         * > <code>AWSGreengrassResourceAccessRolePolicy</code> managed policy</a>.
         * </p>
         * </dd>
         * <dt>ExtractingBundleFailure</dt>
         * <dd>
         * <p>
         * The robot application could not be extracted from the bundle.
         * </p>
         * </dd>
         * <dt>FailureThresholdBreached</dt>
         * <dd>
         * <p>
         * The percentage of robots that could not be updated exceeded the percentage set for the deployment.
         * </p>
         * </dd>
         * <dt>GreengrassDeploymentFailed</dt>
         * <dd>
         * <p>
         * The robot application could not be deployed to the robot.
         * </p>
         * </dd>
         * <dt>GreengrassGroupVersionDoesNotExist</dt>
         * <dd>
         * <p>
         * The AWS Greengrass group or version associated with a robot is missing.
         * </p>
         * </dd>
         * <dt>InternalServerError</dt>
         * <dd>
         * <p>
         * An internal error has occurred. Retry your request, but if the problem persists, contact us with details.
         * </p>
         * </dd>
         * <dt>MissingRobotApplicationArchitecture</dt>
         * <dd>
         * <p>
         * The robot application does not have a source that matches the architecture of the robot.
         * </p>
         * </dd>
         * <dt>MissingRobotDeploymentResource</dt>
         * <dd>
         * <p>
         * One or more of the resources specified for the robot application are missing. For example, does the robot
         * application have the correct launch package and launch file?
         * </p>
         * </dd>
         * <dt>PostLaunchFileFailure</dt>
         * <dd>
         * <p>
         * The post-launch script failed.
         * </p>
         * </dd>
         * <dt>PreLaunchFileFailure</dt>
         * <dd>
         * <p>
         * The pre-launch script failed.
         * </p>
         * </dd>
         * <dt>ResourceNotFound</dt>
         * <dd>
         * <p>
         * One or more deployment resources are missing. For example, do robot application source bundles still exist?
         * </p>
         * </dd>
         * <dt>RobotDeploymentNoResponse</dt>
         * <dd>
         * <p>
         * There is no response from the robot. It might not be powered on or connected to the internet.
         * </p>
         * </dd>
         * </dl>
         * 
         * @param failureCode
         *        The failure code of the simulation job if it failed:</p>
         *        <dl>
         *        <dt>BadPermissionError</dt>
         *        <dd>
         *        <p>
         *        AWS Greengrass requires a service-level role permission to access other services. The role must
         *        include the <a href=
         *        "https://console.aws.amazon.com/iam/home?#/policies/arn:aws:iam::aws:policy/service-role/AWSGreengrassResourceAccessRolePolicy$jsonEditor"
         *        > <code>AWSGreengrassResourceAccessRolePolicy</code> managed policy</a>.
         *        </p>
         *        </dd>
         *        <dt>ExtractingBundleFailure</dt>
         *        <dd>
         *        <p>
         *        The robot application could not be extracted from the bundle.
         *        </p>
         *        </dd>
         *        <dt>FailureThresholdBreached</dt>
         *        <dd>
         *        <p>
         *        The percentage of robots that could not be updated exceeded the percentage set for the deployment.
         *        </p>
         *        </dd>
         *        <dt>GreengrassDeploymentFailed</dt>
         *        <dd>
         *        <p>
         *        The robot application could not be deployed to the robot.
         *        </p>
         *        </dd>
         *        <dt>GreengrassGroupVersionDoesNotExist</dt>
         *        <dd>
         *        <p>
         *        The AWS Greengrass group or version associated with a robot is missing.
         *        </p>
         *        </dd>
         *        <dt>InternalServerError</dt>
         *        <dd>
         *        <p>
         *        An internal error has occurred. Retry your request, but if the problem persists, contact us with
         *        details.
         *        </p>
         *        </dd>
         *        <dt>MissingRobotApplicationArchitecture</dt>
         *        <dd>
         *        <p>
         *        The robot application does not have a source that matches the architecture of the robot.
         *        </p>
         *        </dd>
         *        <dt>MissingRobotDeploymentResource</dt>
         *        <dd>
         *        <p>
         *        One or more of the resources specified for the robot application are missing. For example, does the
         *        robot application have the correct launch package and launch file?
         *        </p>
         *        </dd>
         *        <dt>PostLaunchFileFailure</dt>
         *        <dd>
         *        <p>
         *        The post-launch script failed.
         *        </p>
         *        </dd>
         *        <dt>PreLaunchFileFailure</dt>
         *        <dd>
         *        <p>
         *        The pre-launch script failed.
         *        </p>
         *        </dd>
         *        <dt>ResourceNotFound</dt>
         *        <dd>
         *        <p>
         *        One or more deployment resources are missing. For example, do robot application source bundles still
         *        exist?
         *        </p>
         *        </dd>
         *        <dt>RobotDeploymentNoResponse</dt>
         *        <dd>
         *        <p>
         *        There is no response from the robot. It might not be powered on or connected to the internet.
         *        </p>
         *        </dd>
         * @see DeploymentJobErrorCode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DeploymentJobErrorCode
         */
        Builder failureCode(DeploymentJobErrorCode failureCode);

        /**
         * <p>
         * The time, in milliseconds since the epoch, when the fleet was created.
         * </p>
         * 
         * @param createdAt
         *        The time, in milliseconds since the epoch, when the fleet was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(Instant createdAt);

        /**
         * <p>
         * The deployment configuration.
         * </p>
         * 
         * @param deploymentConfig
         *        The deployment configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deploymentConfig(DeploymentConfig deploymentConfig);

        /**
         * <p>
         * The deployment configuration.
         * </p>
         * This is a convenience that creates an instance of the {@link DeploymentConfig.Builder} avoiding the need to
         * create one manually via {@link DeploymentConfig#builder()}.
         *
         * When the {@link Consumer} completes, {@link DeploymentConfig.Builder#build()} is called immediately and its
         * result is passed to {@link #deploymentConfig(DeploymentConfig)}.
         * 
         * @param deploymentConfig
         *        a consumer that will call methods on {@link DeploymentConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #deploymentConfig(DeploymentConfig)
         */
        default Builder deploymentConfig(Consumer<DeploymentConfig.Builder> deploymentConfig) {
            return deploymentConfig(DeploymentConfig.builder().applyMutation(deploymentConfig).build());
        }

        /**
         * <p>
         * The list of all tags added to the deployment job.
         * </p>
         * 
         * @param tags
         *        The list of all tags added to the deployment job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);
    }

    static final class BuilderImpl extends RoboMakerResponse.BuilderImpl implements Builder {
        private String arn;

        private String fleet;

        private String status;

        private List<DeploymentApplicationConfig> deploymentApplicationConfigs = DefaultSdkAutoConstructList.getInstance();

        private String failureReason;

        private String failureCode;

        private Instant createdAt;

        private DeploymentConfig deploymentConfig;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateDeploymentJobResponse model) {
            super(model);
            arn(model.arn);
            fleet(model.fleet);
            status(model.status);
            deploymentApplicationConfigs(model.deploymentApplicationConfigs);
            failureReason(model.failureReason);
            failureCode(model.failureCode);
            createdAt(model.createdAt);
            deploymentConfig(model.deploymentConfig);
            tags(model.tags);
        }

        public final String getArn() {
            return arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        public final String getFleet() {
            return fleet;
        }

        @Override
        public final Builder fleet(String fleet) {
            this.fleet = fleet;
            return this;
        }

        public final void setFleet(String fleet) {
            this.fleet = fleet;
        }

        public final String getStatus() {
            return status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(DeploymentStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final Collection<DeploymentApplicationConfig.Builder> getDeploymentApplicationConfigs() {
            if (deploymentApplicationConfigs instanceof SdkAutoConstructList) {
                return null;
            }
            return deploymentApplicationConfigs != null ? deploymentApplicationConfigs.stream()
                    .map(DeploymentApplicationConfig::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder deploymentApplicationConfigs(Collection<DeploymentApplicationConfig> deploymentApplicationConfigs) {
            this.deploymentApplicationConfigs = DeploymentApplicationConfigsCopier.copy(deploymentApplicationConfigs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder deploymentApplicationConfigs(DeploymentApplicationConfig... deploymentApplicationConfigs) {
            deploymentApplicationConfigs(Arrays.asList(deploymentApplicationConfigs));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder deploymentApplicationConfigs(
                Consumer<DeploymentApplicationConfig.Builder>... deploymentApplicationConfigs) {
            deploymentApplicationConfigs(Stream.of(deploymentApplicationConfigs)
                    .map(c -> DeploymentApplicationConfig.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setDeploymentApplicationConfigs(
                Collection<DeploymentApplicationConfig.BuilderImpl> deploymentApplicationConfigs) {
            this.deploymentApplicationConfigs = DeploymentApplicationConfigsCopier.copyFromBuilder(deploymentApplicationConfigs);
        }

        public final String getFailureReason() {
            return failureReason;
        }

        @Override
        public final Builder failureReason(String failureReason) {
            this.failureReason = failureReason;
            return this;
        }

        public final void setFailureReason(String failureReason) {
            this.failureReason = failureReason;
        }

        public final String getFailureCode() {
            return failureCode;
        }

        @Override
        public final Builder failureCode(String failureCode) {
            this.failureCode = failureCode;
            return this;
        }

        @Override
        public final Builder failureCode(DeploymentJobErrorCode failureCode) {
            this.failureCode(failureCode == null ? null : failureCode.toString());
            return this;
        }

        public final void setFailureCode(String failureCode) {
            this.failureCode = failureCode;
        }

        public final Instant getCreatedAt() {
            return createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        public final DeploymentConfig.Builder getDeploymentConfig() {
            return deploymentConfig != null ? deploymentConfig.toBuilder() : null;
        }

        @Override
        public final Builder deploymentConfig(DeploymentConfig deploymentConfig) {
            this.deploymentConfig = deploymentConfig;
            return this;
        }

        public final void setDeploymentConfig(DeploymentConfig.BuilderImpl deploymentConfig) {
            this.deploymentConfig = deploymentConfig != null ? deploymentConfig.build() : null;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public CreateDeploymentJobResponse build() {
            return new CreateDeploymentJobResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
