/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.robomaker.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListSimulationJobBatchesResponse extends RoboMakerResponse implements
        ToCopyableBuilder<ListSimulationJobBatchesResponse.Builder, ListSimulationJobBatchesResponse> {
    private static final SdkField<List<SimulationJobBatchSummary>> SIMULATION_JOB_BATCH_SUMMARIES_FIELD = SdkField
            .<List<SimulationJobBatchSummary>> builder(MarshallingType.LIST)
            .memberName("simulationJobBatchSummaries")
            .getter(getter(ListSimulationJobBatchesResponse::simulationJobBatchSummaries))
            .setter(setter(Builder::simulationJobBatchSummaries))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("simulationJobBatchSummaries")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<SimulationJobBatchSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(SimulationJobBatchSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListSimulationJobBatchesResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            SIMULATION_JOB_BATCH_SUMMARIES_FIELD, NEXT_TOKEN_FIELD));

    private final List<SimulationJobBatchSummary> simulationJobBatchSummaries;

    private final String nextToken;

    private ListSimulationJobBatchesResponse(BuilderImpl builder) {
        super(builder);
        this.simulationJobBatchSummaries = builder.simulationJobBatchSummaries;
        this.nextToken = builder.nextToken;
    }

    /**
     * Returns true if the SimulationJobBatchSummaries property was specified by the sender (it may be empty), or false
     * if the sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the
     * AWS service.
     */
    public boolean hasSimulationJobBatchSummaries() {
        return simulationJobBatchSummaries != null && !(simulationJobBatchSummaries instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of simulation job batch summaries.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasSimulationJobBatchSummaries()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list of simulation job batch summaries.
     */
    public List<SimulationJobBatchSummary> simulationJobBatchSummaries() {
        return simulationJobBatchSummaries;
    }

    /**
     * <p>
     * If the previous paginated request did not return all of the remaining results, the response object's
     * <code>nextToken</code> parameter value is set to a token. To retrieve the next set of results, call
     * <code>ListSimulationJobBatches</code> again and assign that token to the request object's <code>nextToken</code>
     * parameter. If there are no remaining results, the previous response object's NextToken parameter is set to null.
     * </p>
     * 
     * @return If the previous paginated request did not return all of the remaining results, the response object's
     *         <code>nextToken</code> parameter value is set to a token. To retrieve the next set of results, call
     *         <code>ListSimulationJobBatches</code> again and assign that token to the request object's
     *         <code>nextToken</code> parameter. If there are no remaining results, the previous response object's
     *         NextToken parameter is set to null.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasSimulationJobBatchSummaries() ? simulationJobBatchSummaries() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListSimulationJobBatchesResponse)) {
            return false;
        }
        ListSimulationJobBatchesResponse other = (ListSimulationJobBatchesResponse) obj;
        return hasSimulationJobBatchSummaries() == other.hasSimulationJobBatchSummaries()
                && Objects.equals(simulationJobBatchSummaries(), other.simulationJobBatchSummaries())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ListSimulationJobBatchesResponse")
                .add("SimulationJobBatchSummaries", hasSimulationJobBatchSummaries() ? simulationJobBatchSummaries() : null)
                .add("NextToken", nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "simulationJobBatchSummaries":
            return Optional.ofNullable(clazz.cast(simulationJobBatchSummaries()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListSimulationJobBatchesResponse, T> g) {
        return obj -> g.apply((ListSimulationJobBatchesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends RoboMakerResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ListSimulationJobBatchesResponse> {
        /**
         * <p>
         * A list of simulation job batch summaries.
         * </p>
         * 
         * @param simulationJobBatchSummaries
         *        A list of simulation job batch summaries.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder simulationJobBatchSummaries(Collection<SimulationJobBatchSummary> simulationJobBatchSummaries);

        /**
         * <p>
         * A list of simulation job batch summaries.
         * </p>
         * 
         * @param simulationJobBatchSummaries
         *        A list of simulation job batch summaries.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder simulationJobBatchSummaries(SimulationJobBatchSummary... simulationJobBatchSummaries);

        /**
         * <p>
         * A list of simulation job batch summaries.
         * </p>
         * This is a convenience that creates an instance of the {@link List<SimulationJobBatchSummary>.Builder}
         * avoiding the need to create one manually via {@link List<SimulationJobBatchSummary>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<SimulationJobBatchSummary>.Builder#build()} is called
         * immediately and its result is passed to {@link #simulationJobBatchSummaries(List<SimulationJobBatchSummary>)}
         * .
         * 
         * @param simulationJobBatchSummaries
         *        a consumer that will call methods on {@link List<SimulationJobBatchSummary>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #simulationJobBatchSummaries(List<SimulationJobBatchSummary>)
         */
        Builder simulationJobBatchSummaries(Consumer<SimulationJobBatchSummary.Builder>... simulationJobBatchSummaries);

        /**
         * <p>
         * If the previous paginated request did not return all of the remaining results, the response object's
         * <code>nextToken</code> parameter value is set to a token. To retrieve the next set of results, call
         * <code>ListSimulationJobBatches</code> again and assign that token to the request object's
         * <code>nextToken</code> parameter. If there are no remaining results, the previous response object's NextToken
         * parameter is set to null.
         * </p>
         * 
         * @param nextToken
         *        If the previous paginated request did not return all of the remaining results, the response object's
         *        <code>nextToken</code> parameter value is set to a token. To retrieve the next set of results, call
         *        <code>ListSimulationJobBatches</code> again and assign that token to the request object's
         *        <code>nextToken</code> parameter. If there are no remaining results, the previous response object's
         *        NextToken parameter is set to null.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends RoboMakerResponse.BuilderImpl implements Builder {
        private List<SimulationJobBatchSummary> simulationJobBatchSummaries = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListSimulationJobBatchesResponse model) {
            super(model);
            simulationJobBatchSummaries(model.simulationJobBatchSummaries);
            nextToken(model.nextToken);
        }

        public final Collection<SimulationJobBatchSummary.Builder> getSimulationJobBatchSummaries() {
            if (simulationJobBatchSummaries instanceof SdkAutoConstructList) {
                return null;
            }
            return simulationJobBatchSummaries != null ? simulationJobBatchSummaries.stream()
                    .map(SimulationJobBatchSummary::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder simulationJobBatchSummaries(Collection<SimulationJobBatchSummary> simulationJobBatchSummaries) {
            this.simulationJobBatchSummaries = SimulationJobBatchSummariesCopier.copy(simulationJobBatchSummaries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder simulationJobBatchSummaries(SimulationJobBatchSummary... simulationJobBatchSummaries) {
            simulationJobBatchSummaries(Arrays.asList(simulationJobBatchSummaries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder simulationJobBatchSummaries(
                Consumer<SimulationJobBatchSummary.Builder>... simulationJobBatchSummaries) {
            simulationJobBatchSummaries(Stream.of(simulationJobBatchSummaries)
                    .map(c -> SimulationJobBatchSummary.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setSimulationJobBatchSummaries(
                Collection<SimulationJobBatchSummary.BuilderImpl> simulationJobBatchSummaries) {
            this.simulationJobBatchSummaries = SimulationJobBatchSummariesCopier.copyFromBuilder(simulationJobBatchSummaries);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListSimulationJobBatchesResponse build() {
            return new ListSimulationJobBatchesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
