/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.robomaker.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateRobotResponse extends RoboMakerResponse implements
        ToCopyableBuilder<CreateRobotResponse.Builder, CreateRobotResponse> {
    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("arn")
            .getter(getter(CreateRobotResponse::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(CreateRobotResponse::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("createdAt").getter(getter(CreateRobotResponse::createdAt)).setter(setter(Builder::createdAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build()).build();

    private static final SdkField<String> GREENGRASS_GROUP_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("greengrassGroupId").getter(getter(CreateRobotResponse::greengrassGroupId))
            .setter(setter(Builder::greengrassGroupId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("greengrassGroupId").build()).build();

    private static final SdkField<String> ARCHITECTURE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("architecture").getter(getter(CreateRobotResponse::architectureAsString))
            .setter(setter(Builder::architecture))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("architecture").build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("tags")
            .getter(getter(CreateRobotResponse::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, NAME_FIELD,
            CREATED_AT_FIELD, GREENGRASS_GROUP_ID_FIELD, ARCHITECTURE_FIELD, TAGS_FIELD));

    private final String arn;

    private final String name;

    private final Instant createdAt;

    private final String greengrassGroupId;

    private final String architecture;

    private final Map<String, String> tags;

    private CreateRobotResponse(BuilderImpl builder) {
        super(builder);
        this.arn = builder.arn;
        this.name = builder.name;
        this.createdAt = builder.createdAt;
        this.greengrassGroupId = builder.greengrassGroupId;
        this.architecture = builder.architecture;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the robot.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the robot.
     */
    public String arn() {
        return arn;
    }

    /**
     * <p>
     * The name of the robot.
     * </p>
     * 
     * @return The name of the robot.
     */
    public String name() {
        return name;
    }

    /**
     * <p>
     * The time, in milliseconds since the epoch, when the robot was created.
     * </p>
     * 
     * @return The time, in milliseconds since the epoch, when the robot was created.
     */
    public Instant createdAt() {
        return createdAt;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the Greengrass group associated with the robot.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the Greengrass group associated with the robot.
     */
    public String greengrassGroupId() {
        return greengrassGroupId;
    }

    /**
     * <p>
     * The target architecture of the robot.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #architecture} will
     * return {@link Architecture#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #architectureAsString}.
     * </p>
     * 
     * @return The target architecture of the robot.
     * @see Architecture
     */
    public Architecture architecture() {
        return Architecture.fromValue(architecture);
    }

    /**
     * <p>
     * The target architecture of the robot.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #architecture} will
     * return {@link Architecture#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #architectureAsString}.
     * </p>
     * 
     * @return The target architecture of the robot.
     * @see Architecture
     */
    public String architectureAsString() {
        return architecture;
    }

    /**
     * Returns true if the Tags property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The list of all tags added to the robot.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasTags()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The list of all tags added to the robot.
     */
    public Map<String, String> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(greengrassGroupId());
        hashCode = 31 * hashCode + Objects.hashCode(architectureAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateRobotResponse)) {
            return false;
        }
        CreateRobotResponse other = (CreateRobotResponse) obj;
        return Objects.equals(arn(), other.arn()) && Objects.equals(name(), other.name())
                && Objects.equals(createdAt(), other.createdAt())
                && Objects.equals(greengrassGroupId(), other.greengrassGroupId())
                && Objects.equals(architectureAsString(), other.architectureAsString()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("CreateRobotResponse").add("Arn", arn()).add("Name", name()).add("CreatedAt", createdAt())
                .add("GreengrassGroupId", greengrassGroupId()).add("Architecture", architectureAsString())
                .add("Tags", hasTags() ? tags() : null).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "createdAt":
            return Optional.ofNullable(clazz.cast(createdAt()));
        case "greengrassGroupId":
            return Optional.ofNullable(clazz.cast(greengrassGroupId()));
        case "architecture":
            return Optional.ofNullable(clazz.cast(architectureAsString()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateRobotResponse, T> g) {
        return obj -> g.apply((CreateRobotResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends RoboMakerResponse.Builder, SdkPojo, CopyableBuilder<Builder, CreateRobotResponse> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the robot.
         * </p>
         * 
         * @param arn
         *        The Amazon Resource Name (ARN) of the robot.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The name of the robot.
         * </p>
         * 
         * @param name
         *        The name of the robot.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The time, in milliseconds since the epoch, when the robot was created.
         * </p>
         * 
         * @param createdAt
         *        The time, in milliseconds since the epoch, when the robot was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(Instant createdAt);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the Greengrass group associated with the robot.
         * </p>
         * 
         * @param greengrassGroupId
         *        The Amazon Resource Name (ARN) of the Greengrass group associated with the robot.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder greengrassGroupId(String greengrassGroupId);

        /**
         * <p>
         * The target architecture of the robot.
         * </p>
         * 
         * @param architecture
         *        The target architecture of the robot.
         * @see Architecture
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Architecture
         */
        Builder architecture(String architecture);

        /**
         * <p>
         * The target architecture of the robot.
         * </p>
         * 
         * @param architecture
         *        The target architecture of the robot.
         * @see Architecture
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Architecture
         */
        Builder architecture(Architecture architecture);

        /**
         * <p>
         * The list of all tags added to the robot.
         * </p>
         * 
         * @param tags
         *        The list of all tags added to the robot.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);
    }

    static final class BuilderImpl extends RoboMakerResponse.BuilderImpl implements Builder {
        private String arn;

        private String name;

        private Instant createdAt;

        private String greengrassGroupId;

        private String architecture;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateRobotResponse model) {
            super(model);
            arn(model.arn);
            name(model.name);
            createdAt(model.createdAt);
            greengrassGroupId(model.greengrassGroupId);
            architecture(model.architecture);
            tags(model.tags);
        }

        public final String getArn() {
            return arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final Instant getCreatedAt() {
            return createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        public final String getGreengrassGroupId() {
            return greengrassGroupId;
        }

        @Override
        public final Builder greengrassGroupId(String greengrassGroupId) {
            this.greengrassGroupId = greengrassGroupId;
            return this;
        }

        public final void setGreengrassGroupId(String greengrassGroupId) {
            this.greengrassGroupId = greengrassGroupId;
        }

        public final String getArchitecture() {
            return architecture;
        }

        @Override
        public final Builder architecture(String architecture) {
            this.architecture = architecture;
            return this;
        }

        @Override
        public final Builder architecture(Architecture architecture) {
            this.architecture(architecture == null ? null : architecture.toString());
            return this;
        }

        public final void setArchitecture(String architecture) {
            this.architecture = architecture;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public CreateRobotResponse build() {
            return new CreateRobotResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
